/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.number;

import java.math.BigDecimal;
import java.math.MathContext;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.AffixPatternProvider;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.CustomSymbolCurrency;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalFormatProperties;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Grouper;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MacroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Padder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.PatternStringParser;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.PatternStringUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.PropertiesAffixPatternProvider;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.RoundingUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.CompactNotation;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.CurrencyPrecision;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.FractionPrecision;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.IntegerWidth;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Notation;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Precision;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.ScientificNotation;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.UnlocalizedNumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CompactDecimalFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Currency;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

final class NumberPropertyMapper {
    NumberPropertyMapper() {
    }

    public static UnlocalizedNumberFormatter create(DecimalFormatProperties decimalFormatProperties, DecimalFormatSymbols decimalFormatSymbols) {
        MacroProps macroProps = NumberPropertyMapper.oldToNew(decimalFormatProperties, decimalFormatSymbols, null);
        return (UnlocalizedNumberFormatter)NumberFormatter.with().macros(macroProps);
    }

    public static UnlocalizedNumberFormatter create(DecimalFormatProperties decimalFormatProperties, DecimalFormatSymbols decimalFormatSymbols, DecimalFormatProperties decimalFormatProperties2) {
        MacroProps macroProps = NumberPropertyMapper.oldToNew(decimalFormatProperties, decimalFormatSymbols, decimalFormatProperties2);
        return (UnlocalizedNumberFormatter)NumberFormatter.with().macros(macroProps);
    }

    public static UnlocalizedNumberFormatter create(String string, DecimalFormatSymbols decimalFormatSymbols) {
        DecimalFormatProperties decimalFormatProperties = PatternStringParser.parseToProperties(string);
        return NumberPropertyMapper.create(decimalFormatProperties, decimalFormatSymbols);
    }

    public static MacroProps oldToNew(DecimalFormatProperties decimalFormatProperties, DecimalFormatSymbols decimalFormatSymbols, DecimalFormatProperties decimalFormatProperties2) {
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl2;
        boolean bl3;
        AffixPatternProvider affixPatternProvider;
        MacroProps macroProps = new MacroProps();
        ULocale uLocale = decimalFormatSymbols.getULocale();
        macroProps.symbols = decimalFormatSymbols;
        PluralRules pluralRules = decimalFormatProperties.getPluralRules();
        if (pluralRules == null && decimalFormatProperties.getCurrencyPluralInfo() != null) {
            pluralRules = decimalFormatProperties.getCurrencyPluralInfo().getPluralRules();
        }
        macroProps.rules = pluralRules;
        macroProps.affixProvider = affixPatternProvider = PropertiesAffixPatternProvider.forProperties(decimalFormatProperties);
        boolean bl4 = decimalFormatProperties.getCurrency() != null || decimalFormatProperties.getCurrencyPluralInfo() != null || decimalFormatProperties.getCurrencyUsage() != null || affixPatternProvider.hasCurrencySign();
        Currency currency = CustomSymbolCurrency.resolve(decimalFormatProperties.getCurrency(), uLocale, decimalFormatSymbols);
        Currency.CurrencyUsage currencyUsage = decimalFormatProperties.getCurrencyUsage();
        boolean bl5 = bl3 = currencyUsage != null;
        if (!bl3) {
            currencyUsage = Currency.CurrencyUsage.STANDARD;
        }
        if (bl4) {
            macroProps.unit = currency;
        }
        int n6 = decimalFormatProperties.getMaximumIntegerDigits();
        int n7 = decimalFormatProperties.getMinimumIntegerDigits();
        int n8 = decimalFormatProperties.getMaximumFractionDigits();
        int n9 = decimalFormatProperties.getMinimumFractionDigits();
        int n10 = decimalFormatProperties.getMinimumSignificantDigits();
        int n11 = decimalFormatProperties.getMaximumSignificantDigits();
        BigDecimal bigDecimal = decimalFormatProperties.getRoundingIncrement();
        MathContext mathContext = RoundingUtils.getMathContextOrUnlimited(decimalFormatProperties);
        boolean bl6 = n9 != -1 || n8 != -1;
        boolean bl7 = bl2 = n10 != -1 || n11 != -1;
        if (bl4) {
            if (n9 == -1 && n8 == -1) {
                n9 = currency.getDefaultFractionDigits(currencyUsage);
                n8 = currency.getDefaultFractionDigits(currencyUsage);
            } else if (n9 == -1) {
                n9 = Math.min(n8, currency.getDefaultFractionDigits(currencyUsage));
            } else if (n8 == -1) {
                n8 = Math.max(n9, currency.getDefaultFractionDigits(currencyUsage));
            }
        }
        if (n7 == 0 && n8 != 0) {
            int n12 = n9 = n9 < 0 || n9 == 0 && n6 == 0 ? 1 : n9;
            n8 = n8 < 0 ? -1 : (n8 < n9 ? n9 : n8);
            n7 = 0;
            n6 = n6 < 0 ? -1 : (n6 > 999 ? -1 : n6);
        } else {
            int n13 = n9 = n9 < 0 ? 0 : n9;
            int n14 = n8 < 0 ? -1 : (n8 = n8 < n9 ? n9 : n8);
            int n15 = n7 <= 0 ? 1 : (n7 = n7 > 999 ? 1 : n7);
            n6 = n6 < 0 ? -1 : (n6 < n7 ? n7 : (n6 > 999 ? -1 : n6));
        }
        Precision precision = null;
        if (bl3) {
            precision = Precision.constructCurrency(currencyUsage).withCurrency(currency);
        } else if (bigDecimal != null) {
            if (PatternStringUtils.ignoreRoundingIncrement(bigDecimal, n8)) {
                precision = Precision.constructFraction(n9, n8);
            } else {
                if (n9 > bigDecimal.scale()) {
                    bigDecimal = bigDecimal.setScale(n9);
                }
                precision = Precision.constructIncrement(bigDecimal);
            }
        } else if (bl2) {
            int n16 = n10 < 1 ? 1 : (n10 = n10 > 999 ? 999 : n10);
            n11 = n11 < 0 ? 999 : (n11 < n10 ? n10 : (n11 > 999 ? 999 : n11));
            precision = Precision.constructSignificant(n10, n11);
        } else if (bl6) {
            precision = Precision.constructFraction(n9, n8);
        } else if (bl4) {
            precision = Precision.constructCurrency(currencyUsage);
        }
        if (precision != null) {
            macroProps.precision = precision = precision.withMode(mathContext);
        }
        macroProps.integerWidth = IntegerWidth.zeroFillTo(n7).truncateAt(n6);
        macroProps.grouping = Grouper.forProperties(decimalFormatProperties);
        if (decimalFormatProperties.getFormatWidth() > 0) {
            macroProps.padder = Padder.forProperties(decimalFormatProperties);
        }
        macroProps.decimal = decimalFormatProperties.getDecimalSeparatorAlwaysShown() ? NumberFormatter.DecimalSeparatorDisplay.ALWAYS : NumberFormatter.DecimalSeparatorDisplay.AUTO;
        NumberFormatter.SignDisplay signDisplay = macroProps.sign = decimalFormatProperties.getSignAlwaysShown() ? NumberFormatter.SignDisplay.ALWAYS : NumberFormatter.SignDisplay.AUTO;
        if (decimalFormatProperties.getMinimumExponentDigits() != -1) {
            if (n6 > 8) {
                n6 = n7;
                macroProps.integerWidth = IntegerWidth.zeroFillTo(n7).truncateAt(n6);
            } else if (n6 > n7 && n7 > 1) {
                n7 = 1;
                macroProps.integerWidth = IntegerWidth.zeroFillTo(n7).truncateAt(n6);
            }
            int n17 = n6 < 0 ? -1 : n6;
            macroProps.notation = new ScientificNotation(n17, n17 == n7, decimalFormatProperties.getMinimumExponentDigits(), decimalFormatProperties.getExponentSignAlwaysShown() ? NumberFormatter.SignDisplay.ALWAYS : NumberFormatter.SignDisplay.AUTO);
            if (macroProps.precision instanceof FractionPrecision) {
                n5 = decimalFormatProperties.getMaximumIntegerDigits();
                n4 = decimalFormatProperties.getMinimumIntegerDigits();
                n3 = decimalFormatProperties.getMinimumFractionDigits();
                n2 = decimalFormatProperties.getMaximumFractionDigits();
                if (n4 == 0 && n2 == 0) {
                    macroProps.precision = Precision.constructInfinite().withMode(mathContext);
                } else if (n4 == 0 && n3 == 0) {
                    macroProps.precision = Precision.constructSignificant(1, n2 + 1).withMode(mathContext);
                } else {
                    int n18 = n4 + n2;
                    if (n5 > n4 && n4 > 1) {
                        n4 = 1;
                    }
                    int n19 = n4 + n3;
                    macroProps.precision = Precision.constructSignificant(n19, n18).withMode(mathContext);
                }
            }
        }
        if (decimalFormatProperties.getCompactStyle() != null) {
            macroProps.notation = decimalFormatProperties.getCompactCustomData() != null ? new CompactNotation(decimalFormatProperties.getCompactCustomData()) : (decimalFormatProperties.getCompactStyle() == CompactDecimalFormat.CompactStyle.LONG ? Notation.compactLong() : Notation.compactShort());
        }
        macroProps.scale = RoundingUtils.scaleFromProperties(decimalFormatProperties);
        if (decimalFormatProperties2 != null) {
            decimalFormatProperties2.setCurrency(currency);
            decimalFormatProperties2.setMathContext(mathContext);
            decimalFormatProperties2.setRoundingMode(mathContext.getRoundingMode());
            decimalFormatProperties2.setMinimumIntegerDigits(n7);
            decimalFormatProperties2.setMaximumIntegerDigits(n6 == -1 ? Integer.MAX_VALUE : n6);
            Precision precision2 = precision instanceof CurrencyPrecision ? ((CurrencyPrecision)precision).withCurrency(currency) : precision;
            n5 = n9;
            n4 = n8;
            n3 = n10;
            n2 = n11;
            BigDecimal bigDecimal2 = null;
            if (precision2 instanceof Precision.FractionRounderImpl) {
                n5 = ((Precision.FractionRounderImpl)precision2).minFrac;
                n4 = ((Precision.FractionRounderImpl)precision2).maxFrac;
            } else if (precision2 instanceof Precision.IncrementRounderImpl) {
                bigDecimal2 = ((Precision.IncrementRounderImpl)precision2).increment;
                n5 = bigDecimal2.scale();
                n4 = bigDecimal2.scale();
            } else if (precision2 instanceof Precision.SignificantRounderImpl) {
                n3 = ((Precision.SignificantRounderImpl)precision2).minSig;
                n2 = ((Precision.SignificantRounderImpl)precision2).maxSig;
            }
            decimalFormatProperties2.setMinimumFractionDigits(n5);
            decimalFormatProperties2.setMaximumFractionDigits(n4);
            decimalFormatProperties2.setMinimumSignificantDigits(n3);
            decimalFormatProperties2.setMaximumSignificantDigits(n2);
            decimalFormatProperties2.setRoundingIncrement(bigDecimal2);
        }
        return macroProps;
    }
}

