/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.number;

import java.text.Format;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedStringBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.LocalizedNumberFormatterAsFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MacroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.FormattedNumber;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatterImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatterSettings;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.UnlocalizedNumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Measure;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MeasureUnit;

public class LocalizedNumberFormatter
extends NumberFormatterSettings<LocalizedNumberFormatter> {
    static final AtomicLongFieldUpdater<LocalizedNumberFormatter> callCount = AtomicLongFieldUpdater.newUpdater(LocalizedNumberFormatter.class, "callCountInternal");
    volatile long callCountInternal;
    volatile LocalizedNumberFormatter savedWithUnit;
    volatile NumberFormatterImpl compiled;

    LocalizedNumberFormatter(NumberFormatterSettings<?> numberFormatterSettings, int n2, Object object) {
        super(numberFormatterSettings, n2, object);
    }

    public FormattedNumber format(long l2) {
        return this.format(new DecimalQuantity_DualStorageBCD(l2));
    }

    public FormattedNumber format(double d2) {
        return this.format(new DecimalQuantity_DualStorageBCD(d2));
    }

    public FormattedNumber format(Number number) {
        return this.format(new DecimalQuantity_DualStorageBCD(number));
    }

    public FormattedNumber format(Measure measure) {
        DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = new DecimalQuantity_DualStorageBCD(measure.getNumber());
        MeasureUnit measureUnit = measure.getUnit();
        FormattedStringBuilder formattedStringBuilder = new FormattedStringBuilder();
        MicroProps microProps = this.formatImpl(decimalQuantity_DualStorageBCD, measureUnit, formattedStringBuilder);
        return new FormattedNumber(formattedStringBuilder, decimalQuantity_DualStorageBCD, microProps.outputUnit, microProps.gender);
    }

    public Format toFormat() {
        return new LocalizedNumberFormatterAsFormat(this, this.resolve().loc);
    }

    public UnlocalizedNumberFormatter withoutLocale() {
        return new UnlocalizedNumberFormatter(this, 1, null);
    }

    private FormattedNumber format(DecimalQuantity decimalQuantity) {
        FormattedStringBuilder formattedStringBuilder = new FormattedStringBuilder();
        MicroProps microProps = this.formatImpl(decimalQuantity, formattedStringBuilder);
        return new FormattedNumber(formattedStringBuilder, decimalQuantity, microProps.outputUnit, microProps.gender);
    }

    @Deprecated
    public MicroProps formatImpl(DecimalQuantity decimalQuantity, FormattedStringBuilder formattedStringBuilder) {
        if (this.computeCompiled()) {
            return this.compiled.format(decimalQuantity, formattedStringBuilder);
        }
        return NumberFormatterImpl.formatStatic(this.resolve(), decimalQuantity, formattedStringBuilder);
    }

    @Deprecated
    public MicroProps formatImpl(DecimalQuantity decimalQuantity, MeasureUnit measureUnit, FormattedStringBuilder formattedStringBuilder) {
        if (Objects.equals(this.resolve().unit, measureUnit)) {
            return this.formatImpl(decimalQuantity, formattedStringBuilder);
        }
        LocalizedNumberFormatter localizedNumberFormatter = this.savedWithUnit;
        if (localizedNumberFormatter == null || !Objects.equals(localizedNumberFormatter.resolve().unit, measureUnit)) {
            this.savedWithUnit = localizedNumberFormatter = new LocalizedNumberFormatter(this, 3, measureUnit);
        }
        return localizedNumberFormatter.formatImpl(decimalQuantity, formattedStringBuilder);
    }

    @Deprecated
    public String getAffixImpl(boolean bl2, boolean bl3) {
        FormattedStringBuilder formattedStringBuilder = new FormattedStringBuilder();
        byte by2 = (byte)(bl3 ? -1 : 1);
        StandardPlural standardPlural = StandardPlural.OTHER;
        int n2 = this.computeCompiled() ? this.compiled.getPrefixSuffix(by2, standardPlural, formattedStringBuilder) : NumberFormatterImpl.getPrefixSuffixStatic(this.resolve(), by2, standardPlural, formattedStringBuilder);
        if (bl2) {
            return formattedStringBuilder.subSequence(0, n2).toString();
        }
        return formattedStringBuilder.subSequence(n2, formattedStringBuilder.length()).toString();
    }

    private boolean computeCompiled() {
        MacroProps macroProps = this.resolve();
        long l2 = callCount.incrementAndGet(this);
        if (l2 == macroProps.threshold) {
            this.compiled = new NumberFormatterImpl(macroProps);
            return true;
        }
        return this.compiled != null;
    }

    @Override
    LocalizedNumberFormatter create(int n2, Object object) {
        return new LocalizedNumberFormatter(this, n2, object);
    }
}

