/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.message2;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.MFDataModel;
import macromedia.jdbc.db2.externals.com.ibm.icu.message2.MFParseException;

class MFDataModelValidator {
    private final MFDataModel.Message message;
    private final Set<String> declaredVars = new HashSet<String>();

    MFDataModelValidator(MFDataModel.Message message) {
        this.message = message;
    }

    boolean validate() throws MFParseException {
        if (this.message instanceof MFDataModel.PatternMessage) {
            this.validateDeclarations(((MFDataModel.PatternMessage)this.message).declarations);
        } else if (this.message instanceof MFDataModel.SelectMessage) {
            MFDataModel.SelectMessage selectMessage = (MFDataModel.SelectMessage)this.message;
            this.validateDeclarations(selectMessage.declarations);
            this.validateSelectors(selectMessage.selectors);
            int n2 = selectMessage.selectors.size();
            this.validateVariants(selectMessage.variants, n2);
        }
        return true;
    }

    private boolean validateVariants(List<MFDataModel.Variant> list, int n2) throws MFParseException {
        if (list == null || list.isEmpty()) {
            this.error("Selection messages must have at least one variant");
        }
        boolean bl2 = false;
        HashSet<String> hashSet = new HashSet<String>();
        for (MFDataModel.Variant variant : list) {
            if (variant.keys == null || variant.keys.isEmpty()) {
                this.error("Selection variants must have at least one key");
            }
            if (variant.keys.size() != n2) {
                this.error("Selection variants must have the same number of variants as the selectors.");
            }
            int n3 = 0;
            StringJoiner stringJoiner = new StringJoiner("<<::>>");
            for (MFDataModel.LiteralOrCatchallKey literalOrCatchallKey : variant.keys) {
                if (literalOrCatchallKey instanceof MFDataModel.CatchallKey) {
                    ++n3;
                    stringJoiner.add("*");
                    continue;
                }
                if (!(literalOrCatchallKey instanceof MFDataModel.Literal)) continue;
                stringJoiner.add(((MFDataModel.Literal)literalOrCatchallKey).value);
            }
            if (hashSet.contains(stringJoiner.toString())) {
                this.error("Dumplicate combination of keys");
            } else {
                hashSet.add(stringJoiner.toString());
            }
            if (n3 != n2) continue;
            bl2 = true;
        }
        if (!bl2) {
            this.error("There must be one variant with all the keys being '*'");
        }
        return true;
    }

    private boolean validateSelectors(List<MFDataModel.Expression> list) throws MFParseException {
        if (list == null || list.isEmpty()) {
            this.error("Selection messages must have selectors");
        }
        return true;
    }

    private boolean validateDeclarations(List<MFDataModel.Declaration> list) throws MFParseException {
        if (list == null || list.isEmpty()) {
            return true;
        }
        for (MFDataModel.Declaration declaration : list) {
            MFDataModel.Declaration declaration2;
            if (declaration instanceof MFDataModel.LocalDeclaration) {
                declaration2 = (MFDataModel.LocalDeclaration)declaration;
                this.validateExpression(declaration2.value, false);
                this.addVariableDeclaration(declaration2.name);
                continue;
            }
            if (!(declaration instanceof MFDataModel.InputDeclaration)) continue;
            declaration2 = (MFDataModel.InputDeclaration)declaration;
            this.validateExpression(((MFDataModel.InputDeclaration)declaration2).value, true);
        }
        return true;
    }

    private void validateExpression(MFDataModel.Expression expression, boolean bl2) throws MFParseException {
        Object object;
        String string = null;
        MFDataModel.Annotation annotation = null;
        if (!(expression instanceof MFDataModel.Literal)) {
            if (expression instanceof MFDataModel.LiteralExpression) {
                object = (MFDataModel.LiteralExpression)expression;
                string = ((MFDataModel.LiteralExpression)object).arg.value;
                annotation = ((MFDataModel.LiteralExpression)object).annotation;
            } else if (expression instanceof MFDataModel.VariableExpression) {
                object = (MFDataModel.VariableExpression)expression;
                string = ((MFDataModel.VariableExpression)object).arg.name;
                annotation = ((MFDataModel.VariableExpression)object).annotation;
            } else if (expression instanceof MFDataModel.FunctionExpression) {
                object = (MFDataModel.FunctionExpression)expression;
                annotation = ((MFDataModel.FunctionExpression)object).annotation;
            }
        }
        if (annotation instanceof MFDataModel.FunctionAnnotation) {
            object = (MFDataModel.FunctionAnnotation)annotation;
            if (((MFDataModel.FunctionAnnotation)object).options != null) {
                for (MFDataModel.Option option : ((MFDataModel.FunctionAnnotation)object).options.values()) {
                    MFDataModel.LiteralOrVariableRef literalOrVariableRef = option.value;
                    if (!(literalOrVariableRef instanceof MFDataModel.VariableRef)) continue;
                    this.addVariableDeclaration(((MFDataModel.VariableRef)literalOrVariableRef).name);
                }
            }
        }
        if (string != null) {
            if (bl2) {
                this.addVariableDeclaration(string);
            } else {
                this.declaredVars.add(string);
            }
        }
    }

    private boolean addVariableDeclaration(String string) throws MFParseException {
        if (this.declaredVars.contains(string)) {
            this.error("Variable '" + string + "' already declared");
            return false;
        }
        this.declaredVars.add(string);
        return true;
    }

    private void error(String string) throws MFParseException {
        throw new MFParseException(string, -1);
    }
}

