/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.math;

import java.io.Serializable;

public final class MathContext
implements Serializable {
    public static final int PLAIN = 0;
    public static final int SCIENTIFIC = 1;
    public static final int ENGINEERING = 2;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_UNNECESSARY = 7;
    public static final int ROUND_UP = 0;
    int digits;
    int form;
    boolean lostDigits;
    int roundingMode;
    private static final int DEFAULT_FORM = 1;
    private static final int DEFAULT_DIGITS = 9;
    private static final boolean DEFAULT_LOSTDIGITS = false;
    private static final int DEFAULT_ROUNDINGMODE = 4;
    private static final int MIN_DIGITS = 0;
    private static final int MAX_DIGITS = 999999999;
    private static final int[] ROUNDS = new int[]{4, 7, 2, 1, 3, 5, 6, 0};
    private static final String[] ROUNDWORDS = new String[]{"ROUND_HALF_UP", "ROUND_UNNECESSARY", "ROUND_CEILING", "ROUND_DOWN", "ROUND_FLOOR", "ROUND_HALF_DOWN", "ROUND_HALF_EVEN", "ROUND_UP"};
    private static final long serialVersionUID = 7163376998892515376L;
    public static final MathContext DEFAULT = new MathContext(9, 1, false, 4);

    public MathContext(int n2) {
        this(n2, 1, false, 4);
    }

    public MathContext(int n2, int n3) {
        this(n2, n3, false, 4);
    }

    public MathContext(int n2, int n3, boolean bl2) {
        this(n2, n3, bl2, 4);
    }

    public MathContext(int n2, int n3, boolean bl2, int n4) {
        if (n2 != 9) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Digits too small: " + n2);
            }
            if (n2 > 999999999) {
                throw new IllegalArgumentException("Digits too large: " + n2);
            }
        }
        if (n3 != 1 && n3 != 2 && n3 != 0) {
            throw new IllegalArgumentException("Bad form value: " + n3);
        }
        if (!MathContext.isValidRound(n4)) {
            throw new IllegalArgumentException("Bad roundingMode value: " + n4);
        }
        this.digits = n2;
        this.form = n3;
        this.lostDigits = bl2;
        this.roundingMode = n4;
    }

    public int getDigits() {
        return this.digits;
    }

    public int getForm() {
        return this.form;
    }

    public boolean getLostDigits() {
        return this.lostDigits;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public String toString() {
        String string = null;
        int n2 = 0;
        String string2 = null;
        string = this.form == 1 ? "SCIENTIFIC" : (this.form == 2 ? "ENGINEERING" : "PLAIN");
        int n3 = ROUNDS.length;
        n2 = 0;
        while (n3 > 0) {
            if (this.roundingMode == ROUNDS[n2]) {
                string2 = ROUNDWORDS[n2];
                break;
            }
            --n3;
            ++n2;
        }
        return "digits=" + this.digits + " form=" + string + " lostDigits=" + (this.lostDigits ? "1" : "0") + " roundingMode=" + string2;
    }

    private static boolean isValidRound(int n2) {
        int n3 = 0;
        int n4 = ROUNDS.length;
        n3 = 0;
        while (n4 > 0) {
            if (n2 == ROUNDS[n3]) {
                return true;
            }
            --n4;
            ++n3;
        }
        return false;
    }
}

