/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.units;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.ConversionRates;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.SingleUnitImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.UnitsData;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BytesTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CharsTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CharsTrieBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUCloneNotSupportedException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MeasureUnit;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.StringTrieBuilder;

public class MeasureUnitImpl {
    private String identifier = null;
    private MeasureUnit.Complexity complexity = MeasureUnit.Complexity.SINGLE;
    private final ArrayList<SingleUnitImpl> singleUnits = new ArrayList();

    public MeasureUnitImpl() {
    }

    public MeasureUnitImpl(SingleUnitImpl singleUnitImpl) {
        this();
        this.appendSingleUnit(singleUnitImpl);
    }

    public static MeasureUnitImpl forIdentifier(String string) {
        return UnitsParser.parseForIdentifier(string);
    }

    public static MeasureUnitImpl forCurrencyCode(String string) {
        MeasureUnitImpl measureUnitImpl = new MeasureUnitImpl();
        measureUnitImpl.identifier = string;
        return measureUnitImpl;
    }

    public MeasureUnitImpl copy() {
        MeasureUnitImpl measureUnitImpl = new MeasureUnitImpl();
        measureUnitImpl.complexity = this.complexity;
        measureUnitImpl.identifier = this.identifier;
        for (SingleUnitImpl singleUnitImpl : this.singleUnits) {
            measureUnitImpl.singleUnits.add(singleUnitImpl.copy());
        }
        return measureUnitImpl;
    }

    public MeasureUnitImpl copyAndSimplify() {
        MeasureUnitImpl measureUnitImpl = new MeasureUnitImpl();
        for (SingleUnitImpl singleUnitImpl : this.getSingleUnits()) {
            boolean bl2 = false;
            for (SingleUnitImpl singleUnitImpl2 : measureUnitImpl.getSingleUnits()) {
                if (singleUnitImpl2.getSimpleUnitID().compareTo(singleUnitImpl.getSimpleUnitID()) != 0 || singleUnitImpl2.getPrefix().getIdentifier().compareTo(singleUnitImpl.getPrefix().getIdentifier()) != 0) continue;
                bl2 = true;
                singleUnitImpl2.setDimensionality(singleUnitImpl2.getDimensionality() + singleUnitImpl.getDimensionality());
                break;
            }
            if (bl2) continue;
            measureUnitImpl.appendSingleUnit(singleUnitImpl);
        }
        return measureUnitImpl;
    }

    public ArrayList<SingleUnitImpl> getSingleUnits() {
        return this.singleUnits;
    }

    public void takeReciprocal() {
        this.identifier = null;
        for (SingleUnitImpl singleUnitImpl : this.singleUnits) {
            singleUnitImpl.setDimensionality(singleUnitImpl.getDimensionality() * -1);
        }
    }

    public ArrayList<MeasureUnitImplWithIndex> extractIndividualUnitsWithIndices() {
        ArrayList<MeasureUnitImplWithIndex> arrayList = new ArrayList<MeasureUnitImplWithIndex>();
        if (this.getComplexity() == MeasureUnit.Complexity.MIXED) {
            int n2 = 0;
            for (SingleUnitImpl singleUnitImpl : this.getSingleUnits()) {
                arrayList.add(new MeasureUnitImplWithIndex(n2++, new MeasureUnitImpl(singleUnitImpl)));
            }
            return arrayList;
        }
        arrayList.add(new MeasureUnitImplWithIndex(0, this.copy()));
        return arrayList;
    }

    public void applyDimensionality(int n2) {
        for (SingleUnitImpl singleUnitImpl : this.singleUnits) {
            singleUnitImpl.setDimensionality(singleUnitImpl.getDimensionality() * n2);
        }
    }

    public boolean appendSingleUnit(SingleUnitImpl singleUnitImpl) {
        this.identifier = null;
        if (singleUnitImpl == null) {
            return false;
        }
        SingleUnitImpl singleUnitImpl2 = null;
        for (SingleUnitImpl singleUnitImpl3 : this.singleUnits) {
            if (!singleUnitImpl3.isCompatibleWith(singleUnitImpl)) continue;
            singleUnitImpl2 = singleUnitImpl3;
            break;
        }
        if (singleUnitImpl2 != null) {
            singleUnitImpl2.setDimensionality(singleUnitImpl2.getDimensionality() + singleUnitImpl.getDimensionality());
            return false;
        }
        this.singleUnits.add(singleUnitImpl.copy());
        if (this.singleUnits.size() > 1 && this.complexity == MeasureUnit.Complexity.SINGLE) {
            this.setComplexity(MeasureUnit.Complexity.COMPOUND);
        }
        return true;
    }

    public MeasureUnit build() {
        return MeasureUnit.fromMeasureUnitImpl(this);
    }

    public SingleUnitImpl getSingleUnitImpl() {
        if (this.singleUnits.size() == 0) {
            return new SingleUnitImpl();
        }
        if (this.singleUnits.size() == 1) {
            return this.singleUnits.get(0).copy();
        }
        throw new UnsupportedOperationException();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public MeasureUnit.Complexity getComplexity() {
        return this.complexity;
    }

    public void setComplexity(MeasureUnit.Complexity complexity) {
        this.complexity = complexity;
    }

    public void serialize() {
        if (this.getSingleUnits().size() == 0) {
            return;
        }
        if (this.complexity == MeasureUnit.Complexity.COMPOUND) {
            Collections.sort(this.getSingleUnits(), new SingleUnitComparator());
        }
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        boolean bl3 = false;
        for (SingleUnitImpl singleUnitImpl : this.getSingleUnits()) {
            if (bl2 && singleUnitImpl.getDimensionality() < 0) {
                bl2 = false;
                bl3 = true;
            } else if (singleUnitImpl.getDimensionality() < 0) {
                bl3 = false;
            }
            if (this.getComplexity() == MeasureUnit.Complexity.MIXED) {
                if (stringBuilder.length() != 0) {
                    stringBuilder.append("-and-");
                }
            } else if (bl3) {
                if (stringBuilder.length() == 0) {
                    stringBuilder.append("per-");
                } else {
                    stringBuilder.append("-per-");
                }
            } else if (stringBuilder.length() != 0) {
                stringBuilder.append("-");
            }
            stringBuilder.append(singleUnitImpl.getNeutralIdentifier());
        }
        this.identifier = stringBuilder.toString();
    }

    public String toString() {
        return "MeasureUnitImpl [" + this.build().getIdentifier() + "]";
    }

    static class SingleUnitComparator
    implements Comparator<SingleUnitImpl> {
        SingleUnitComparator() {
        }

        @Override
        public int compare(SingleUnitImpl singleUnitImpl, SingleUnitImpl singleUnitImpl2) {
            return singleUnitImpl.compareTo(singleUnitImpl2);
        }
    }

    static class MeasureUnitImplWithIndexComparator
    implements Comparator<MeasureUnitImplWithIndex> {
        private MeasureUnitImplComparator measureUnitImplComparator;

        public MeasureUnitImplWithIndexComparator(ConversionRates conversionRates) {
            this.measureUnitImplComparator = new MeasureUnitImplComparator(conversionRates);
        }

        @Override
        public int compare(MeasureUnitImplWithIndex measureUnitImplWithIndex, MeasureUnitImplWithIndex measureUnitImplWithIndex2) {
            return this.measureUnitImplComparator.compare(measureUnitImplWithIndex.unitImpl, measureUnitImplWithIndex2.unitImpl);
        }
    }

    static class MeasureUnitImplComparator
    implements Comparator<MeasureUnitImpl> {
        private final ConversionRates conversionRates;

        public MeasureUnitImplComparator(ConversionRates conversionRates) {
            this.conversionRates = conversionRates;
        }

        @Override
        public int compare(MeasureUnitImpl measureUnitImpl, MeasureUnitImpl measureUnitImpl2) {
            String string = this.conversionRates.getSpecialMappingName(measureUnitImpl);
            String string2 = this.conversionRates.getSpecialMappingName(measureUnitImpl2);
            if (string != null || string2 != null) {
                if (string == null) {
                    return -1;
                }
                if (string2 == null) {
                    return 1;
                }
                return string.compareTo(string2);
            }
            BigDecimal bigDecimal = this.conversionRates.getFactorToBase(measureUnitImpl).getConversionRate();
            BigDecimal bigDecimal2 = this.conversionRates.getFactorToBase(measureUnitImpl2).getConversionRate();
            return bigDecimal.compareTo(bigDecimal2);
        }
    }

    public static class UnitsParser {
        private static volatile CharsTrie savedTrie = null;
        private final CharsTrie trie;
        private final String fSource;
        private int fIndex = 0;
        private boolean fAfterPer = false;
        private boolean fSawAnd = false;
        private static MeasureUnit.MeasurePrefix[] measurePrefixValues = MeasureUnit.MeasurePrefix.values();

        private UnitsParser(String string) {
            this.fSource = string;
            try {
                this.trie = savedTrie.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new ICUCloneNotSupportedException();
            }
        }

        public static MeasureUnitImpl parseForIdentifier(String string) {
            if (string == null || string.isEmpty()) {
                return null;
            }
            UnitsParser unitsParser = new UnitsParser(string);
            return unitsParser.parse();
        }

        private static MeasureUnit.MeasurePrefix getPrefixFromTrieIndex(int n2) {
            return measurePrefixValues[n2 - 64];
        }

        private static int getTrieIndexForPrefix(MeasureUnit.MeasurePrefix measurePrefix) {
            return measurePrefix.ordinal() + 64;
        }

        private MeasureUnitImpl parse() {
            MeasureUnitImpl measureUnitImpl = new MeasureUnitImpl();
            if (this.fSource.isEmpty()) {
                return null;
            }
            while (this.hasNext()) {
                MeasureUnit.Complexity complexity;
                this.fSawAnd = false;
                SingleUnitImpl singleUnitImpl = this.nextSingleUnit();
                boolean bl2 = measureUnitImpl.appendSingleUnit(singleUnitImpl);
                if (this.fSawAnd && !bl2) {
                    throw new IllegalArgumentException("Two similar units are not allowed in a mixed unit.");
                }
                if (measureUnitImpl.singleUnits.size() < 2) continue;
                MeasureUnit.Complexity complexity2 = complexity = this.fSawAnd ? MeasureUnit.Complexity.MIXED : MeasureUnit.Complexity.COMPOUND;
                if (measureUnitImpl.getSingleUnits().size() == 2) {
                    assert (measureUnitImpl.getComplexity() == MeasureUnit.Complexity.COMPOUND);
                    measureUnitImpl.setComplexity(complexity);
                    continue;
                }
                if (measureUnitImpl.getComplexity() == complexity) continue;
                throw new IllegalArgumentException("Can't have mixed compound units");
            }
            return measureUnitImpl;
        }

        private SingleUnitImpl nextSingleUnit() {
            SingleUnitImpl singleUnitImpl = new SingleUnitImpl();
            int n2 = 0;
            boolean bl2 = this.fIndex == 0;
            Token token = this.nextToken();
            if (bl2) {
                if (token.getType() == Token.Type.TYPE_INITIAL_COMPOUND_PART) {
                    assert (token.getInitialCompoundPart() == InitialCompoundPart.INITIAL_COMPOUND_PART_PER);
                    this.fAfterPer = true;
                    singleUnitImpl.setDimensionality(-1);
                    token = this.nextToken();
                }
            } else {
                if (token.getType() != Token.Type.TYPE_COMPOUND_PART) {
                    throw new IllegalArgumentException("token type must be TYPE_COMPOUND_PART");
                }
                CompoundPart compoundPart = CompoundPart.getCompoundPartFromTrieIndex(token.getMatch());
                switch (compoundPart) {
                    case PER: {
                        if (this.fSawAnd) {
                            throw new IllegalArgumentException("Mixed compound units not yet supported");
                        }
                        this.fAfterPer = true;
                        singleUnitImpl.setDimensionality(-1);
                        break;
                    }
                    case TIMES: {
                        if (!this.fAfterPer) break;
                        singleUnitImpl.setDimensionality(-1);
                        break;
                    }
                    case AND: {
                        if (this.fAfterPer) {
                            throw new IllegalArgumentException("Can't start with \"-and-\", and mixed compound units");
                        }
                        this.fSawAnd = true;
                    }
                }
                token = this.nextToken();
            }
            while (true) {
                switch (token.getType()) {
                    case TYPE_POWER_PART: {
                        if (n2 > 0) {
                            throw new IllegalArgumentException();
                        }
                        singleUnitImpl.setDimensionality(singleUnitImpl.getDimensionality() * token.getPower());
                        n2 = 1;
                        break;
                    }
                    case TYPE_PREFIX: {
                        if (n2 > 1) {
                            throw new IllegalArgumentException();
                        }
                        singleUnitImpl.setPrefix(token.getPrefix());
                        n2 = 2;
                        break;
                    }
                    case TYPE_SIMPLE_UNIT: {
                        singleUnitImpl.setSimpleUnit(token.getSimpleUnitIndex(), UnitsData.getSimpleUnits());
                        return singleUnitImpl;
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
                if (!this.hasNext()) {
                    throw new IllegalArgumentException("We ran out of tokens before finding a complete single unit.");
                }
                token = this.nextToken();
            }
        }

        private boolean hasNext() {
            return this.fIndex < this.fSource.length();
        }

        private Token nextToken() {
            BytesTrie.Result result;
            this.trie.reset();
            int n2 = -1;
            int n3 = -1;
            while (this.fIndex < this.fSource.length() && (result = this.trie.next(this.fSource.charAt(this.fIndex++))) != BytesTrie.Result.NO_MATCH) {
                if (result == BytesTrie.Result.NO_VALUE) continue;
                n2 = this.trie.getValue();
                n3 = this.fIndex;
                if (result == BytesTrie.Result.FINAL_VALUE) break;
                if (result == BytesTrie.Result.INTERMEDIATE_VALUE) continue;
                throw new IllegalArgumentException("result must has an intermediate value");
            }
            if (n2 < 0) {
                throw new IllegalArgumentException("Encountered unknown token starting at index " + n3);
            }
            this.fIndex = n3;
            return new Token(n2);
        }

        static {
            CharsTrieBuilder charsTrieBuilder = new CharsTrieBuilder();
            MeasureUnit.MeasurePrefix[] objectArray = measurePrefixValues;
            int n2 = objectArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                MeasureUnit.MeasurePrefix measurePrefix = objectArray[i2];
                charsTrieBuilder.add(measurePrefix.getIdentifier(), UnitsParser.getTrieIndexForPrefix(measurePrefix));
            }
            charsTrieBuilder.add("-per-", CompoundPart.PER.getTrieIndex());
            charsTrieBuilder.add("-", CompoundPart.TIMES.getTrieIndex());
            charsTrieBuilder.add("-and-", CompoundPart.AND.getTrieIndex());
            charsTrieBuilder.add("per-", InitialCompoundPart.INITIAL_COMPOUND_PART_PER.getTrieIndex());
            charsTrieBuilder.add("square-", PowerPart.P2.getTrieIndex());
            charsTrieBuilder.add("cubic-", PowerPart.P3.getTrieIndex());
            charsTrieBuilder.add("pow2-", PowerPart.P2.getTrieIndex());
            charsTrieBuilder.add("pow3-", PowerPart.P3.getTrieIndex());
            charsTrieBuilder.add("pow4-", PowerPart.P4.getTrieIndex());
            charsTrieBuilder.add("pow5-", PowerPart.P5.getTrieIndex());
            charsTrieBuilder.add("pow6-", PowerPart.P6.getTrieIndex());
            charsTrieBuilder.add("pow7-", PowerPart.P7.getTrieIndex());
            charsTrieBuilder.add("pow8-", PowerPart.P8.getTrieIndex());
            charsTrieBuilder.add("pow9-", PowerPart.P9.getTrieIndex());
            charsTrieBuilder.add("pow10-", PowerPart.P10.getTrieIndex());
            charsTrieBuilder.add("pow11-", PowerPart.P11.getTrieIndex());
            charsTrieBuilder.add("pow12-", PowerPart.P12.getTrieIndex());
            charsTrieBuilder.add("pow13-", PowerPart.P13.getTrieIndex());
            charsTrieBuilder.add("pow14-", PowerPart.P14.getTrieIndex());
            charsTrieBuilder.add("pow15-", PowerPart.P15.getTrieIndex());
            String[] stringArray = UnitsData.getSimpleUnits();
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                charsTrieBuilder.add(stringArray[n2], n2 + 512);
            }
            savedTrie = charsTrieBuilder.build(StringTrieBuilder.Option.FAST);
        }

        static class Token {
            private final int fMatch;
            private final Type type;

            public Token(int n2) {
                this.fMatch = n2;
                this.type = this.calculateType(n2);
            }

            public Type getType() {
                return this.type;
            }

            public MeasureUnit.MeasurePrefix getPrefix() {
                assert (this.type == Type.TYPE_PREFIX);
                return UnitsParser.getPrefixFromTrieIndex(this.fMatch);
            }

            public int getMatch() {
                assert (this.getType() == Type.TYPE_COMPOUND_PART);
                return this.fMatch;
            }

            public InitialCompoundPart getInitialCompoundPart() {
                assert (this.type == Type.TYPE_INITIAL_COMPOUND_PART && this.fMatch == InitialCompoundPart.INITIAL_COMPOUND_PART_PER.getTrieIndex());
                return InitialCompoundPart.getInitialCompoundPartFromTrieIndex(this.fMatch);
            }

            public int getPower() {
                assert (this.type == Type.TYPE_POWER_PART);
                return PowerPart.getPowerFromTrieIndex(this.fMatch);
            }

            public int getSimpleUnitIndex() {
                assert (this.type == Type.TYPE_SIMPLE_UNIT);
                return this.fMatch - 512;
            }

            private Type calculateType(int n2) {
                if (n2 <= 0) {
                    throw new AssertionError((Object)"fMatch must have a positive value");
                }
                if (n2 < 128) {
                    return Type.TYPE_PREFIX;
                }
                if (n2 < 192) {
                    return Type.TYPE_COMPOUND_PART;
                }
                if (n2 < 256) {
                    return Type.TYPE_INITIAL_COMPOUND_PART;
                }
                if (n2 < 512) {
                    return Type.TYPE_POWER_PART;
                }
                return Type.TYPE_SIMPLE_UNIT;
            }

            static enum Type {
                TYPE_UNDEFINED,
                TYPE_PREFIX,
                TYPE_COMPOUND_PART,
                TYPE_INITIAL_COMPOUND_PART,
                TYPE_POWER_PART,
                TYPE_SIMPLE_UNIT;

            }
        }
    }

    public static class MeasureUnitImplWithIndex {
        int index;
        MeasureUnitImpl unitImpl;

        MeasureUnitImplWithIndex(int n2, MeasureUnitImpl measureUnitImpl) {
            this.index = n2;
            this.unitImpl = measureUnitImpl;
        }
    }

    public static enum InitialCompoundPart {
        INITIAL_COMPOUND_PART_PER(0);

        private final int index;

        private InitialCompoundPart(int n3) {
            this.index = n3;
        }

        public static InitialCompoundPart getInitialCompoundPartFromTrieIndex(int n2) {
            int n3 = n2 - 192;
            if (n3 == 0) {
                return INITIAL_COMPOUND_PART_PER;
            }
            throw new IllegalArgumentException("Incorrect trieIndex");
        }

        public int getTrieIndex() {
            return this.index + 192;
        }

        public int getValue() {
            return this.index;
        }
    }

    public static enum PowerPart {
        P2(2),
        P3(3),
        P4(4),
        P5(5),
        P6(6),
        P7(7),
        P8(8),
        P9(9),
        P10(10),
        P11(11),
        P12(12),
        P13(13),
        P14(14),
        P15(15);

        private final int power;

        private PowerPart(int n3) {
            this.power = n3;
        }

        public static int getPowerFromTrieIndex(int n2) {
            return n2 - 256;
        }

        public int getTrieIndex() {
            return this.power + 256;
        }

        public int getValue() {
            return this.power;
        }
    }

    public static enum CompoundPart {
        PER(0),
        TIMES(1),
        AND(2);

        private final int index;

        private CompoundPart(int n3) {
            this.index = n3;
        }

        public static CompoundPart getCompoundPartFromTrieIndex(int n2) {
            int n3 = n2 - 128;
            switch (n3) {
                case 0: {
                    return PER;
                }
                case 1: {
                    return TIMES;
                }
                case 2: {
                    return AND;
                }
            }
            throw new AssertionError((Object)"CompoundPart index must be 0, 1 or 2");
        }

        public int getTrieIndex() {
            return this.index + 128;
        }

        public int getValue() {
            return this.index;
        }
    }
}

