/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.units;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.ConversionRates;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.MeasureUnitImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.UnitsConverter;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Precision;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Measure;

public class ComplexUnitsConverter {
    public static final BigDecimal EPSILON = BigDecimal.valueOf(Math.ulp(1.0));
    public static final BigDecimal EPSILON_MULTIPLIER = BigDecimal.valueOf(1L).add(EPSILON);
    public ArrayList<UnitsConverter> unitsConverters_;
    public List<MeasureUnitImpl.MeasureUnitImplWithIndex> units_;
    private MeasureUnitImpl inputUnit_;

    public ComplexUnitsConverter(MeasureUnitImpl measureUnitImpl, ConversionRates conversionRates) {
        this.units_ = measureUnitImpl.extractIndividualUnitsWithIndices();
        assert (!this.units_.isEmpty());
        this.inputUnit_ = this.units_.get((int)0).unitImpl;
        MeasureUnitImpl.MeasureUnitImplComparator measureUnitImplComparator = new MeasureUnitImpl.MeasureUnitImplComparator(conversionRates);
        for (MeasureUnitImpl.MeasureUnitImplWithIndex measureUnitImplWithIndex : this.units_) {
            if (measureUnitImplComparator.compare(measureUnitImplWithIndex.unitImpl, this.inputUnit_) <= 0) continue;
            this.inputUnit_ = measureUnitImplWithIndex.unitImpl;
        }
        this.init(conversionRates);
    }

    public ComplexUnitsConverter(String string, String string2) {
        this(MeasureUnitImpl.forIdentifier(string), MeasureUnitImpl.forIdentifier(string2), new ConversionRates());
    }

    public ComplexUnitsConverter(MeasureUnitImpl measureUnitImpl, MeasureUnitImpl measureUnitImpl2, ConversionRates conversionRates) {
        this.inputUnit_ = measureUnitImpl;
        this.units_ = measureUnitImpl2.extractIndividualUnitsWithIndices();
        assert (!this.units_.isEmpty());
        this.init(conversionRates);
    }

    private void init(ConversionRates conversionRates) {
        Collections.sort(this.units_, Collections.reverseOrder(new MeasureUnitImpl.MeasureUnitImplWithIndexComparator(conversionRates)));
        this.unitsConverters_ = new ArrayList();
        int n2 = this.units_.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 == 0) {
                this.unitsConverters_.add(new UnitsConverter(this.inputUnit_, this.units_.get((int)i2).unitImpl, conversionRates));
                continue;
            }
            this.unitsConverters_.add(new UnitsConverter(this.units_.get((int)(i2 - 1)).unitImpl, this.units_.get((int)i2).unitImpl, conversionRates));
        }
    }

    public boolean greaterThanOrEqual(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        assert (!this.units_.isEmpty());
        return this.unitsConverters_.get(0).convert(bigDecimal).multiply(EPSILON_MULTIPLIER).compareTo(bigDecimal2) >= 0;
    }

    public ComplexConverterResult convert(BigDecimal bigDecimal, Precision precision) {
        BigInteger bigInteger = BigInteger.ONE;
        if (bigDecimal.compareTo(BigDecimal.ZERO) < 0 && this.unitsConverters_.size() > 1) {
            bigDecimal = bigDecimal.abs();
            bigInteger = bigInteger.negate();
        }
        ArrayList<BigInteger> arrayList = new ArrayList<BigInteger>(this.unitsConverters_.size() - 1);
        int n2 = this.unitsConverters_.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            bigDecimal = this.unitsConverters_.get(i2).convert(bigDecimal);
            if (i2 >= n2 - 1) continue;
            BigInteger bigInteger2 = bigDecimal.multiply(EPSILON_MULTIPLIER).setScale(0, RoundingMode.FLOOR).toBigInteger();
            arrayList.add(bigInteger2);
            BigDecimal bigDecimal2 = bigDecimal.subtract(BigDecimal.valueOf(bigInteger2.longValue()));
            bigDecimal = bigDecimal2.compareTo(BigDecimal.ZERO) == -1 ? BigDecimal.ZERO : bigDecimal2;
        }
        bigDecimal = this.applyRounder(arrayList, bigDecimal, precision);
        ArrayList<Measure> arrayList2 = new ArrayList<Measure>(this.unitsConverters_.size());
        for (n2 = 0; n2 < this.unitsConverters_.size(); ++n2) {
            arrayList2.add(null);
        }
        n2 = -1;
        int n3 = this.unitsConverters_.size();
        for (int i3 = 0; i3 < n3; ++i3) {
            Measure measure;
            if (i3 < n3 - 1) {
                measure = new Measure(((BigInteger)arrayList.get(i3)).multiply(bigInteger), this.units_.get((int)i3).unitImpl.build());
                arrayList2.set(this.units_.get((int)i3).index, measure);
                continue;
            }
            n2 = this.units_.get((int)i3).index;
            measure = new Measure(bigDecimal.multiply(BigDecimal.valueOf(bigInteger.longValue())), this.units_.get((int)i3).unitImpl.build());
            arrayList2.set(n2, measure);
        }
        return new ComplexConverterResult(n2, arrayList2);
    }

    private BigDecimal applyRounder(List<BigInteger> list, BigDecimal bigDecimal, Precision precision) {
        if (precision == null) {
            return bigDecimal;
        }
        DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = new DecimalQuantity_DualStorageBCD(bigDecimal);
        precision.apply(decimalQuantity_DualStorageBCD);
        bigDecimal = decimalQuantity_DualStorageBCD.toBigDecimal();
        if (list.size() == 0) {
            return bigDecimal;
        }
        int n2 = this.unitsConverters_.size() - 1;
        BigDecimal bigDecimal2 = this.unitsConverters_.get(n2).convertInverse(bigDecimal).multiply(EPSILON_MULTIPLIER).setScale(0, RoundingMode.FLOOR);
        if (bigDecimal2.compareTo(BigDecimal.ZERO) <= 0) {
            return bigDecimal;
        }
        bigDecimal = bigDecimal.subtract(this.unitsConverters_.get(n2).convert(bigDecimal2));
        list.set(n2 - 1, list.get(n2 - 1).add(bigDecimal2.toBigInteger()));
        for (int i2 = n2 - 1; i2 > 0 && (bigDecimal2 = this.unitsConverters_.get(i2).convertInverse(BigDecimal.valueOf(list.get(i2).longValue())).multiply(EPSILON_MULTIPLIER).setScale(0, RoundingMode.FLOOR)).compareTo(BigDecimal.ZERO) > 0; --i2) {
            list.set(i2, list.get(i2).subtract(this.unitsConverters_.get(i2).convert(bigDecimal2).toBigInteger()));
            list.set(i2 - 1, list.get(i2 - 1).add(bigDecimal2.toBigInteger()));
        }
        return bigDecimal;
    }

    public String toString() {
        return "ComplexUnitsConverter [unitsConverters_=" + this.unitsConverters_ + ", units_=" + this.units_ + "]";
    }

    public static class ComplexConverterResult {
        public final int indexOfQuantity;
        public final List<Measure> measures;

        ComplexConverterResult(int n2, List<Measure> list) {
            this.indexOfQuantity = n2;
            this.measures = list;
        }
    }
}

