/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.personname;

import java.util.Locale;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.personname.PersonNameFormatterImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.BreakIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.CaseMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PersonName;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.SimpleFormatter;

abstract class FieldModifierImpl {
    private static final FieldModifierImpl NOOP_MODIFIER = new FieldModifierImpl(){

        @Override
        public String modifyField(String string) {
            return string;
        }
    };
    private static final FieldModifierImpl NULL_MODIFIER = new FieldModifierImpl(){

        @Override
        public String modifyField(String string) {
            return "";
        }
    };
    private static final FieldModifierImpl MONOGRAM_MODIFIER = new FieldModifierImpl(){

        @Override
        public String modifyField(String string) {
            return FieldModifierImpl.getFirstGrapheme(string);
        }
    };

    FieldModifierImpl() {
    }

    public abstract String modifyField(String var1);

    public static FieldModifierImpl forName(PersonName.FieldModifier fieldModifier, PersonNameFormatterImpl personNameFormatterImpl) {
        switch (fieldModifier) {
            case INFORMAL: {
                return NOOP_MODIFIER;
            }
            case PREFIX: {
                return NULL_MODIFIER;
            }
            case CORE: {
                return NOOP_MODIFIER;
            }
            case ALL_CAPS: {
                return new AllCapsModifier(personNameFormatterImpl.getLocale());
            }
            case INITIAL_CAP: {
                return new InitialCapModifier(personNameFormatterImpl.getLocale());
            }
            case INITIAL: {
                return new InitialModifier(personNameFormatterImpl.getLocale(), personNameFormatterImpl.getInitialPattern(), personNameFormatterImpl.getInitialSequencePattern());
            }
            case RETAIN: {
                return NOOP_MODIFIER;
            }
            case MONOGRAM: {
                return MONOGRAM_MODIFIER;
            }
            case GENITIVE: {
                return NOOP_MODIFIER;
            }
            case VOCATIVE: {
                return NOOP_MODIFIER;
            }
        }
        throw new IllegalArgumentException("Invalid modifier ID " + (Object)((Object)fieldModifier));
    }

    private static String getFirstGrapheme(String string) {
        if (string.isEmpty()) {
            return "";
        }
        BreakIterator breakIterator = BreakIterator.getCharacterInstance(Locale.ROOT);
        breakIterator.setText(string);
        return string.substring(0, breakIterator.next());
    }

    static class InitialModifier
    extends FieldModifierImpl {
        private final Locale locale;
        private final SimpleFormatter initialFormatter;
        private final SimpleFormatter initialSequenceFormatter;
        private boolean retainPunctuation;

        public InitialModifier(Locale locale, String string, String string2) {
            this.locale = locale;
            this.initialFormatter = SimpleFormatter.compile(string);
            this.initialSequenceFormatter = SimpleFormatter.compile(string2);
            this.retainPunctuation = false;
        }

        public void setRetainPunctuation(boolean bl2) {
            this.retainPunctuation = bl2;
        }

        @Override
        public String modifyField(String string) {
            String string2 = "";
            String string3 = null;
            BreakIterator breakIterator = BreakIterator.getWordInstance(this.locale);
            breakIterator.setText(string);
            int n2 = breakIterator.first();
            int n3 = breakIterator.next();
            while (n3 != -1) {
                String string4 = string.substring(n2, n3);
                if (Character.isLetter(string4.charAt(0))) {
                    String string5 = FieldModifierImpl.getFirstGrapheme(string4);
                    if (string3 == null) {
                        string3 = this.initialFormatter.format(string5);
                    } else if (this.retainPunctuation) {
                        string3 = string3 + string2 + this.initialFormatter.format(string5);
                        string2 = "";
                    } else {
                        string3 = this.initialSequenceFormatter.format(string3, this.initialFormatter.format(string5));
                    }
                } else {
                    string2 = Character.isWhitespace(string4.charAt(0)) ? string2 + string4.charAt(0) : string2 + string4;
                }
                n2 = n3;
                n3 = breakIterator.next();
            }
            return string3;
        }
    }

    private static class InitialCapModifier
    extends FieldModifierImpl {
        private final Locale locale;
        private static final CaseMap.Title TO_TITLE_WHOLE_STRING_NO_LOWERCASE = CaseMap.toTitle().wholeString().noLowercase();

        public InitialCapModifier(Locale locale) {
            this.locale = locale;
        }

        @Override
        public String modifyField(String string) {
            return TO_TITLE_WHOLE_STRING_NO_LOWERCASE.apply(this.locale, null, string);
        }
    }

    private static class AllCapsModifier
    extends FieldModifierImpl {
        private final Locale locale;

        public AllCapsModifier(Locale locale) {
            this.locale = locale;
        }

        @Override
        public String modifyField(String string) {
            return UCharacter.toUpperCase(this.locale, string);
        }
    }
}

