/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse;

import java.util.ArrayList;
import java.util.List;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StringSegment;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.NumberParseMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.ParsedNumber;

public class SeriesMatcher
implements NumberParseMatcher {
    protected List<NumberParseMatcher> matchers = null;
    protected boolean frozen = false;

    public void addMatcher(NumberParseMatcher numberParseMatcher) {
        assert (!this.frozen);
        if (this.matchers == null) {
            this.matchers = new ArrayList<NumberParseMatcher>();
        }
        this.matchers.add(numberParseMatcher);
    }

    public void freeze() {
        this.frozen = true;
    }

    public int length() {
        return this.matchers == null ? 0 : this.matchers.size();
    }

    @Override
    public boolean match(StringSegment stringSegment, ParsedNumber parsedNumber) {
        assert (this.frozen);
        if (this.matchers == null) {
            return false;
        }
        ParsedNumber parsedNumber2 = new ParsedNumber();
        parsedNumber2.copyFrom(parsedNumber);
        int n2 = stringSegment.getOffset();
        boolean bl2 = true;
        int n3 = 0;
        while (n3 < this.matchers.size()) {
            NumberParseMatcher numberParseMatcher = this.matchers.get(n3);
            int n4 = stringSegment.getOffset();
            bl2 = stringSegment.length() != 0 ? numberParseMatcher.match(stringSegment, parsedNumber) : true;
            boolean bl3 = stringSegment.getOffset() != n4;
            boolean bl4 = numberParseMatcher instanceof NumberParseMatcher.Flexible;
            if (bl3 && bl4) continue;
            if (bl3) {
                if (++n3 >= this.matchers.size() || stringSegment.getOffset() == parsedNumber.charEnd || parsedNumber.charEnd <= n4) continue;
                stringSegment.setOffset(parsedNumber.charEnd);
                continue;
            }
            if (bl4) {
                ++n3;
                continue;
            }
            stringSegment.setOffset(n2);
            parsedNumber.copyFrom(parsedNumber2);
            return bl2;
        }
        return bl2;
    }

    @Override
    public boolean smokeTest(StringSegment stringSegment) {
        assert (this.frozen);
        if (this.matchers == null) {
            return false;
        }
        assert (!(this.matchers.get(0) instanceof NumberParseMatcher.Flexible));
        return this.matchers.get(0).smokeTest(stringSegment);
    }

    @Override
    public void postProcess(ParsedNumber parsedNumber) {
        assert (this.frozen);
        if (this.matchers == null) {
            return;
        }
        for (int i2 = 0; i2 < this.matchers.size(); ++i2) {
            NumberParseMatcher numberParseMatcher = this.matchers.get(i2);
            numberParseMatcher.postProcess(parsedNumber);
        }
    }

    public String toString() {
        return "<SeriesMatcher " + this.matchers + ">";
    }
}

