/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StaticUnicodeSets;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StringSegment;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Grouper;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.DecimalMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.IgnorablesMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.NumberParseMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.ParsedNumber;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

public class ScientificMatcher
implements NumberParseMatcher {
    private final String exponentSeparatorString;
    private final DecimalMatcher exponentMatcher;
    private final IgnorablesMatcher ignorablesMatcher;
    private final String customMinusSign;
    private final String customPlusSign;

    public static ScientificMatcher getInstance(DecimalFormatSymbols decimalFormatSymbols, Grouper grouper) {
        return new ScientificMatcher(decimalFormatSymbols, grouper);
    }

    private ScientificMatcher(DecimalFormatSymbols decimalFormatSymbols, Grouper grouper) {
        this.exponentSeparatorString = decimalFormatSymbols.getExponentSeparator();
        this.exponentMatcher = DecimalMatcher.getInstance(decimalFormatSymbols, grouper, 48);
        this.ignorablesMatcher = IgnorablesMatcher.getInstance(32768);
        String string = decimalFormatSymbols.getMinusSignString();
        this.customMinusSign = ScientificMatcher.minusSignSet().contains(string) ? null : string;
        String string2 = decimalFormatSymbols.getPlusSignString();
        this.customPlusSign = ScientificMatcher.plusSignSet().contains(string2) ? null : string2;
    }

    private static UnicodeSet minusSignSet() {
        return StaticUnicodeSets.get(StaticUnicodeSets.Key.MINUS_SIGN);
    }

    private static UnicodeSet plusSignSet() {
        return StaticUnicodeSets.get(StaticUnicodeSets.Key.PLUS_SIGN);
    }

    @Override
    public boolean match(StringSegment stringSegment, ParsedNumber parsedNumber) {
        if (!parsedNumber.seenNumber()) {
            return false;
        }
        if (0 != (parsedNumber.flags & 8)) {
            return false;
        }
        int n2 = stringSegment.getOffset();
        int n3 = stringSegment.getCommonPrefixLength(this.exponentSeparatorString);
        if (n3 == this.exponentSeparatorString.length()) {
            boolean bl2;
            if (stringSegment.length() == n3) {
                return true;
            }
            stringSegment.adjustOffset(n3);
            this.ignorablesMatcher.match(stringSegment, null);
            if (stringSegment.length() == 0) {
                stringSegment.setOffset(n2);
                return true;
            }
            int n4 = 1;
            if (stringSegment.startsWith(ScientificMatcher.minusSignSet())) {
                n4 = -1;
                stringSegment.adjustOffsetByCodePoint();
            } else if (stringSegment.startsWith(ScientificMatcher.plusSignSet())) {
                stringSegment.adjustOffsetByCodePoint();
            } else if (stringSegment.startsWith(this.customMinusSign)) {
                n3 = stringSegment.getCommonPrefixLength(this.customMinusSign);
                if (n3 != this.customMinusSign.length()) {
                    stringSegment.setOffset(n2);
                    return true;
                }
                n4 = -1;
                stringSegment.adjustOffset(n3);
            } else if (stringSegment.startsWith(this.customPlusSign)) {
                n3 = stringSegment.getCommonPrefixLength(this.customPlusSign);
                if (n3 != this.customPlusSign.length()) {
                    stringSegment.setOffset(n2);
                    return true;
                }
                stringSegment.adjustOffset(n3);
            }
            if (stringSegment.length() == 0) {
                stringSegment.setOffset(n2);
                return true;
            }
            this.ignorablesMatcher.match(stringSegment, null);
            if (stringSegment.length() == 0) {
                stringSegment.setOffset(n2);
                return true;
            }
            boolean bl3 = bl2 = parsedNumber.quantity == null;
            if (bl2) {
                parsedNumber.quantity = new DecimalQuantity_DualStorageBCD();
            }
            int n5 = stringSegment.getOffset();
            boolean bl4 = this.exponentMatcher.match(stringSegment, parsedNumber, n4);
            if (bl2) {
                parsedNumber.quantity = null;
            }
            if (stringSegment.getOffset() != n5) {
                parsedNumber.flags |= 8;
            } else {
                stringSegment.setOffset(n2);
            }
            return bl4;
        }
        return n3 == stringSegment.length();
    }

    @Override
    public boolean smokeTest(StringSegment stringSegment) {
        return stringSegment.startsWith(this.exponentSeparatorString);
    }

    @Override
    public void postProcess(ParsedNumber parsedNumber) {
    }

    public String toString() {
        return "<ScientificMatcher " + this.exponentSeparatorString + ">";
    }
}

