/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StaticUnicodeSets;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StringSegment;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.ParsedNumber;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.SymbolMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;

public class PlusSignMatcher
extends SymbolMatcher {
    private static final PlusSignMatcher DEFAULT = new PlusSignMatcher(false);
    private static final PlusSignMatcher DEFAULT_ALLOW_TRAILING = new PlusSignMatcher(true);
    private final boolean allowTrailing;

    public static PlusSignMatcher getInstance(DecimalFormatSymbols decimalFormatSymbols, boolean bl2) {
        String string = decimalFormatSymbols.getPlusSignString();
        if (PlusSignMatcher.DEFAULT.uniSet.contains(string)) {
            return bl2 ? DEFAULT_ALLOW_TRAILING : DEFAULT;
        }
        return new PlusSignMatcher(string, bl2);
    }

    private PlusSignMatcher(String string, boolean bl2) {
        super(string, PlusSignMatcher.DEFAULT.uniSet);
        this.allowTrailing = bl2;
    }

    private PlusSignMatcher(boolean bl2) {
        super(StaticUnicodeSets.Key.PLUS_SIGN);
        this.allowTrailing = bl2;
    }

    @Override
    protected boolean isDisabled(ParsedNumber parsedNumber) {
        return !this.allowTrailing && parsedNumber.seenNumber();
    }

    @Override
    protected void accept(StringSegment stringSegment, ParsedNumber parsedNumber) {
        parsedNumber.setCharsConsumed(stringSegment);
    }

    public String toString() {
        return "<PlusSignMatcher>";
    }
}

