/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StaticUnicodeSets;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StringSegment;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Grouper;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.NumberParseMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.ParsedNumber;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

public class DecimalMatcher
implements NumberParseMatcher {
    private final boolean requireGroupingMatch;
    private final boolean groupingDisabled;
    private final boolean integerOnly;
    private final int grouping1;
    private final int grouping2;
    private final String groupingSeparator;
    private final String decimalSeparator;
    private final UnicodeSet groupingUniSet;
    private final UnicodeSet decimalUniSet;
    private final UnicodeSet separatorSet;
    private final UnicodeSet leadSet;
    private final String[] digitStrings;

    public static DecimalMatcher getInstance(DecimalFormatSymbols decimalFormatSymbols, Grouper grouper, int n2) {
        return new DecimalMatcher(decimalFormatSymbols, grouper, n2);
    }

    private DecimalMatcher(DecimalFormatSymbols decimalFormatSymbols, Grouper grouper, int n2) {
        if (0 != (n2 & 2)) {
            this.groupingSeparator = decimalFormatSymbols.getMonetaryGroupingSeparatorString();
            this.decimalSeparator = decimalFormatSymbols.getMonetaryDecimalSeparatorString();
        } else {
            this.groupingSeparator = decimalFormatSymbols.getGroupingSeparatorString();
            this.decimalSeparator = decimalFormatSymbols.getDecimalSeparatorString();
        }
        boolean bl2 = 0 != (n2 & 4);
        StaticUnicodeSets.Key key = bl2 ? StaticUnicodeSets.Key.STRICT_ALL_SEPARATORS : StaticUnicodeSets.Key.ALL_SEPARATORS;
        this.groupingUniSet = StaticUnicodeSets.get(key);
        StaticUnicodeSets.Key key2 = StaticUnicodeSets.chooseFrom(this.decimalSeparator, bl2 ? StaticUnicodeSets.Key.STRICT_COMMA : StaticUnicodeSets.Key.COMMA, bl2 ? StaticUnicodeSets.Key.STRICT_PERIOD : StaticUnicodeSets.Key.PERIOD);
        this.decimalUniSet = key2 != null ? StaticUnicodeSets.get(key2) : (!this.decimalSeparator.isEmpty() ? new UnicodeSet().add(this.decimalSeparator.codePointAt(0)).freeze() : UnicodeSet.EMPTY);
        if (key != null && key2 != null) {
            this.separatorSet = this.groupingUniSet;
            this.leadSet = StaticUnicodeSets.get(bl2 ? StaticUnicodeSets.Key.DIGITS_OR_ALL_SEPARATORS : StaticUnicodeSets.Key.DIGITS_OR_STRICT_ALL_SEPARATORS);
        } else {
            this.separatorSet = new UnicodeSet().addAll(this.groupingUniSet).addAll(this.decimalUniSet).freeze();
            this.leadSet = null;
        }
        int n3 = decimalFormatSymbols.getCodePointZero();
        this.digitStrings = n3 == -1 || !UCharacter.isDigit(n3) || UCharacter.digit(n3) != 0 ? decimalFormatSymbols.getDigitStringsLocal() : null;
        this.requireGroupingMatch = 0 != (n2 & 8);
        this.groupingDisabled = 0 != (n2 & 0x20);
        this.integerOnly = 0 != (n2 & 0x10);
        this.grouping1 = grouper.getPrimary();
        this.grouping2 = grouper.getSecondary();
    }

    @Override
    public boolean match(StringSegment stringSegment, ParsedNumber parsedNumber) {
        return this.match(stringSegment, parsedNumber, 0);
    }

    public boolean match(StringSegment stringSegment, ParsedNumber parsedNumber, int n2) {
        int n3;
        int n4;
        int n5;
        byte by2;
        if (parsedNumber.seenNumber() && n2 == 0) {
            return false;
        }
        if (n2 != 0) assert (parsedNumber.quantity != null);
        int n6 = stringSegment.getOffset();
        boolean bl2 = false;
        DecimalQuantity_DualStorageBCD decimalQuantity_DualStorageBCD = null;
        int n7 = 0;
        String string = null;
        String string2 = null;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        while (stringSegment.length() > 0) {
            int n14;
            bl2 = false;
            by2 = -1;
            n5 = stringSegment.getCodePoint();
            if (UCharacter.isDigit(n5)) {
                stringSegment.adjustOffset(Character.charCount(n5));
                by2 = (byte)UCharacter.digit(n5);
            }
            if (by2 == -1 && this.digitStrings != null) {
                for (n4 = 0; n4 < this.digitStrings.length; ++n4) {
                    String string3 = this.digitStrings[n4];
                    if (string3.isEmpty()) continue;
                    n14 = stringSegment.getCommonPrefixLength(string3);
                    if (n14 == string3.length()) {
                        stringSegment.adjustOffset(n14);
                        by2 = (byte)n4;
                        break;
                    }
                    bl2 = bl2 || n14 == stringSegment.length();
                }
            }
            if (by2 >= 0) {
                if (decimalQuantity_DualStorageBCD == null) {
                    decimalQuantity_DualStorageBCD = new DecimalQuantity_DualStorageBCD();
                }
                decimalQuantity_DualStorageBCD.appendDigit(by2, 0, true);
                ++n10;
                if (string2 == null) continue;
                ++n7;
                continue;
            }
            n4 = 0;
            boolean bl3 = false;
            if (string2 == null && !this.decimalSeparator.isEmpty()) {
                n14 = stringSegment.getCommonPrefixLength(this.decimalSeparator);
                boolean bl4 = bl2 = bl2 || n14 == stringSegment.length();
                if (n14 == this.decimalSeparator.length()) {
                    n4 = 1;
                    string2 = this.decimalSeparator;
                }
            }
            if (string != null) {
                n14 = stringSegment.getCommonPrefixLength(string);
                boolean bl5 = bl2 = bl2 || n14 == stringSegment.length();
                if (n14 == string.length()) {
                    bl3 = true;
                }
            }
            if (!this.groupingDisabled && string == null && string2 == null && !this.groupingSeparator.isEmpty()) {
                n14 = stringSegment.getCommonPrefixLength(this.groupingSeparator);
                boolean bl6 = bl2 = bl2 || n14 == stringSegment.length();
                if (n14 == this.groupingSeparator.length()) {
                    bl3 = true;
                    string = this.groupingSeparator;
                }
            }
            if (!bl3 && string2 == null && this.decimalUniSet.contains(n5)) {
                n4 = 1;
                string2 = UCharacter.toString(n5);
            }
            if (!this.groupingDisabled && string == null && string2 == null && this.groupingUniSet.contains(n5)) {
                bl3 = true;
                string = UCharacter.toString(n5);
            }
            if (n4 == 0 && !bl3 || n4 != 0 && this.integerOnly || n9 == 2 && bl3) break;
            n14 = this.validateGroup(n12, n13, false) ? 1 : 0;
            n3 = this.validateGroup(n9, n10, true);
            if (n14 == 0 || n4 != 0 && n3 == 0) {
                if (bl3 && n10 == 0) {
                    assert (n9 == 1);
                    break;
                }
                if (!this.requireGroupingMatch) break;
                decimalQuantity_DualStorageBCD = null;
                break;
            }
            if (this.requireGroupingMatch && n10 == 0 && n9 == 1) break;
            n11 = n8;
            n13 = n10;
            n12 = n4 != 0 ? -1 : n9;
            if (n10 != 0) {
                n8 = stringSegment.getOffset();
            }
            n9 = bl3 ? 1 : 2;
            n10 = 0;
            if (bl3) {
                stringSegment.adjustOffset(string.length());
                continue;
            }
            stringSegment.adjustOffset(string2.length());
        }
        if (n9 != 2 && n10 == 0) {
            bl2 = true;
            stringSegment.setOffset(n8);
            n8 = n11;
            n9 = n12;
            n10 = n13;
            n11 = -1;
            n12 = 0;
            n13 = 1;
        }
        by2 = (byte)(this.validateGroup(n12, n13, false) ? 1 : 0);
        n5 = this.validateGroup(n9, n10, true) ? 1 : 0;
        if (!this.requireGroupingMatch) {
            n4 = 0;
            if (by2 == 0) {
                stringSegment.setOffset(n11);
                n4 += n13;
                n4 += n10;
            } else if (n5 == 0 && (n12 != 0 || n13 != 0)) {
                bl2 = true;
                stringSegment.setOffset(n8);
                n4 += n10;
            }
            if (n4 != 0) {
                decimalQuantity_DualStorageBCD.adjustMagnitude(-n4);
                decimalQuantity_DualStorageBCD.truncate();
            }
            by2 = 1;
            n5 = 1;
        }
        if (n9 != 2 && (by2 == 0 || n5 == 0)) {
            decimalQuantity_DualStorageBCD = null;
        }
        if (decimalQuantity_DualStorageBCD == null) {
            bl2 = bl2 || stringSegment.length() == 0;
            stringSegment.setOffset(n6);
            return bl2;
        }
        decimalQuantity_DualStorageBCD.adjustMagnitude(-n7);
        if (n2 != 0 && stringSegment.getOffset() != n6) {
            n4 = 0;
            if (decimalQuantity_DualStorageBCD.fitsInLong()) {
                long l2 = decimalQuantity_DualStorageBCD.toLong(false);
                assert (l2 >= 0L);
                if (l2 <= Integer.MAX_VALUE) {
                    n3 = (int)l2;
                    try {
                        parsedNumber.quantity.adjustMagnitude(n2 * n3);
                    }
                    catch (ArithmeticException arithmeticException) {
                        n4 = 1;
                    }
                } else {
                    n4 = 1;
                }
            } else {
                n4 = 1;
            }
            if (n4 != 0) {
                if (n2 == -1) {
                    parsedNumber.quantity.clear();
                } else {
                    parsedNumber.quantity = null;
                    parsedNumber.flags |= 0x80;
                }
            }
        } else {
            parsedNumber.quantity = decimalQuantity_DualStorageBCD;
        }
        if (string2 != null) {
            parsedNumber.flags |= 0x20;
        }
        parsedNumber.setCharsConsumed(stringSegment);
        return stringSegment.length() == 0 || bl2;
    }

    private boolean validateGroup(int n2, int n3, boolean bl2) {
        if (this.requireGroupingMatch) {
            if (n2 == -1) {
                return true;
            }
            if (n2 == 0) {
                if (bl2) {
                    return true;
                }
                return n3 != 0 && n3 <= this.grouping2;
            }
            if (n2 == 1) {
                if (bl2) {
                    return n3 == this.grouping1;
                }
                return n3 == this.grouping2;
            }
            assert (n2 == 2);
            return true;
        }
        if (n2 == 1) {
            return n3 != 1;
        }
        return true;
    }

    @Override
    public boolean smokeTest(StringSegment stringSegment) {
        if (this.digitStrings == null && this.leadSet != null) {
            return stringSegment.startsWith(this.leadSet);
        }
        if (stringSegment.startsWith(this.separatorSet) || UCharacter.isDigit(stringSegment.getCodePoint())) {
            return true;
        }
        if (this.digitStrings == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.digitStrings.length; ++i2) {
            if (!stringSegment.startsWith(this.digitStrings[i2])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void postProcess(ParsedNumber parsedNumber) {
    }

    public String toString() {
        return "<DecimalMatcher>";
    }
}

