/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.AffixUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.AffixTokenMatcherFactory;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.CodePointMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.IgnorablesMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.SeriesMatcher;

public class AffixPatternMatcher
extends SeriesMatcher
implements AffixUtils.TokenConsumer {
    private final String affixPattern;
    private AffixTokenMatcherFactory factory;
    private IgnorablesMatcher ignorables;
    private int lastTypeOrCp;

    private AffixPatternMatcher(String string) {
        this.affixPattern = string;
    }

    public static AffixPatternMatcher fromAffixPattern(String string, AffixTokenMatcherFactory affixTokenMatcherFactory, int n2) {
        if (string.isEmpty()) {
            return null;
        }
        AffixPatternMatcher affixPatternMatcher = new AffixPatternMatcher(string);
        affixPatternMatcher.factory = affixTokenMatcherFactory;
        affixPatternMatcher.ignorables = 0 != (n2 & 0x200) ? null : affixTokenMatcherFactory.ignorables();
        affixPatternMatcher.lastTypeOrCp = 0;
        AffixUtils.iterateWithConsumer(string, affixPatternMatcher);
        affixPatternMatcher.factory = null;
        affixPatternMatcher.ignorables = null;
        affixPatternMatcher.lastTypeOrCp = 0;
        affixPatternMatcher.freeze();
        return affixPatternMatcher;
    }

    @Override
    public void consumeToken(int n2) {
        block10: {
            block9: {
                if (!(this.ignorables == null || this.length() <= 0 || this.lastTypeOrCp >= 0 && this.ignorables.getSet().contains(this.lastTypeOrCp))) {
                    this.addMatcher(this.ignorables);
                }
                if (n2 >= 0) break block9;
                switch (n2) {
                    case -1: {
                        this.addMatcher(this.factory.minusSign());
                        break block10;
                    }
                    case -2: {
                        this.addMatcher(this.factory.plusSign());
                        break block10;
                    }
                    case -4: {
                        this.addMatcher(this.factory.percent());
                        break block10;
                    }
                    case -5: {
                        this.addMatcher(this.factory.permille());
                        break block10;
                    }
                    case -10: 
                    case -9: 
                    case -8: 
                    case -7: 
                    case -6: {
                        this.addMatcher(this.factory.currency());
                        break block10;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
            }
            if (this.ignorables == null || !this.ignorables.getSet().contains(n2)) {
                this.addMatcher(CodePointMatcher.getInstance(n2));
            }
        }
        this.lastTypeOrCp = n2;
    }

    public String getPattern() {
        return this.affixPattern;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AffixPatternMatcher)) {
            return false;
        }
        return this.affixPattern.equals(((AffixPatternMatcher)object).affixPattern);
    }

    public int hashCode() {
        return this.affixPattern.hashCode();
    }

    @Override
    public String toString() {
        return this.affixPattern;
    }
}

