/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StringSegment;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.AffixPatternProvider;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.AffixUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.PatternStringUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.AffixPatternMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.AffixTokenMatcherFactory;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.IgnorablesMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.NumberParseMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.NumberParserImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.parse.ParsedNumber;

public class AffixMatcher
implements NumberParseMatcher {
    private final AffixPatternMatcher prefix;
    private final AffixPatternMatcher suffix;
    private final int flags;
    public static final Comparator<AffixMatcher> COMPARATOR = new Comparator<AffixMatcher>(){

        @Override
        public int compare(AffixMatcher affixMatcher, AffixMatcher affixMatcher2) {
            if (AffixMatcher.length(affixMatcher.prefix) != AffixMatcher.length(affixMatcher2.prefix)) {
                return AffixMatcher.length(affixMatcher.prefix) > AffixMatcher.length(affixMatcher2.prefix) ? -1 : 1;
            }
            if (AffixMatcher.length(affixMatcher.suffix) != AffixMatcher.length(affixMatcher2.suffix)) {
                return AffixMatcher.length(affixMatcher.suffix) > AffixMatcher.length(affixMatcher2.suffix) ? -1 : 1;
            }
            if (!affixMatcher.equals(affixMatcher2)) {
                return affixMatcher.hashCode() > affixMatcher2.hashCode() ? -1 : 1;
            }
            return 0;
        }
    };

    private static boolean isInteresting(AffixPatternProvider affixPatternProvider, IgnorablesMatcher ignorablesMatcher, int n2) {
        String string = affixPatternProvider.getString(256);
        String string2 = affixPatternProvider.getString(0);
        String string3 = null;
        String string4 = null;
        if (affixPatternProvider.hasNegativeSubpattern()) {
            string3 = affixPatternProvider.getString(768);
            string4 = affixPatternProvider.getString(512);
        }
        return 0 != (n2 & 0x100) || !AffixUtils.containsOnlySymbolsAndIgnorables(string, ignorablesMatcher.getSet()) || !AffixUtils.containsOnlySymbolsAndIgnorables(string2, ignorablesMatcher.getSet()) || !AffixUtils.containsOnlySymbolsAndIgnorables(string3, ignorablesMatcher.getSet()) || !AffixUtils.containsOnlySymbolsAndIgnorables(string4, ignorablesMatcher.getSet()) || AffixUtils.containsType(string2, -2) || AffixUtils.containsType(string2, -1) || AffixUtils.containsType(string4, -2) || AffixUtils.containsType(string4, -1);
    }

    public static void createMatchers(AffixPatternProvider affixPatternProvider, NumberParserImpl numberParserImpl, AffixTokenMatcherFactory affixTokenMatcherFactory, IgnorablesMatcher ignorablesMatcher, int n2) {
        if (!AffixMatcher.isInteresting(affixPatternProvider, ignorablesMatcher, n2)) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<AffixMatcher> arrayList = new ArrayList<AffixMatcher>(6);
        boolean bl2 = 0 != (n2 & 0x80);
        AffixPatternMatcher affixPatternMatcher = null;
        AffixPatternMatcher affixPatternMatcher2 = null;
        for (PatternStringUtils.PatternSignType patternSignType : PatternStringUtils.PatternSignType.VALUES) {
            if (patternSignType == PatternStringUtils.PatternSignType.POS && 0 != (n2 & 0x400) || patternSignType == PatternStringUtils.PatternSignType.POS_SIGN && 0 == (n2 & 0x400)) continue;
            PatternStringUtils.patternInfoToStringBuilder(affixPatternProvider, true, patternSignType, false, StandardPlural.OTHER, false, stringBuilder);
            AffixPatternMatcher affixPatternMatcher3 = AffixPatternMatcher.fromAffixPattern(stringBuilder.toString(), affixTokenMatcherFactory, n2);
            PatternStringUtils.patternInfoToStringBuilder(affixPatternProvider, false, patternSignType, false, StandardPlural.OTHER, false, stringBuilder);
            AffixPatternMatcher affixPatternMatcher4 = AffixPatternMatcher.fromAffixPattern(stringBuilder.toString(), affixTokenMatcherFactory, n2);
            if (patternSignType == PatternStringUtils.PatternSignType.POS) {
                affixPatternMatcher = affixPatternMatcher3;
                affixPatternMatcher2 = affixPatternMatcher4;
            } else if (Objects.equals(affixPatternMatcher3, affixPatternMatcher) && Objects.equals(affixPatternMatcher4, affixPatternMatcher2)) continue;
            int n3 = patternSignType == PatternStringUtils.PatternSignType.NEG ? 1 : 0;
            arrayList.add(AffixMatcher.getInstance(affixPatternMatcher3, affixPatternMatcher4, n3));
            if (!bl2 || affixPatternMatcher3 == null || affixPatternMatcher4 == null) continue;
            if (patternSignType == PatternStringUtils.PatternSignType.POS || !Objects.equals(affixPatternMatcher3, affixPatternMatcher)) {
                arrayList.add(AffixMatcher.getInstance(affixPatternMatcher3, null, n3));
            }
            if (patternSignType != PatternStringUtils.PatternSignType.POS && Objects.equals(affixPatternMatcher4, affixPatternMatcher2)) continue;
            arrayList.add(AffixMatcher.getInstance(null, affixPatternMatcher4, n3));
        }
        Collections.sort(arrayList, COMPARATOR);
        numberParserImpl.addMatchers(arrayList);
    }

    private static final AffixMatcher getInstance(AffixPatternMatcher affixPatternMatcher, AffixPatternMatcher affixPatternMatcher2, int n2) {
        return new AffixMatcher(affixPatternMatcher, affixPatternMatcher2, n2);
    }

    private AffixMatcher(AffixPatternMatcher affixPatternMatcher, AffixPatternMatcher affixPatternMatcher2, int n2) {
        this.prefix = affixPatternMatcher;
        this.suffix = affixPatternMatcher2;
        this.flags = n2;
    }

    @Override
    public boolean match(StringSegment stringSegment, ParsedNumber parsedNumber) {
        if (!parsedNumber.seenNumber()) {
            if (parsedNumber.prefix != null || this.prefix == null) {
                return false;
            }
            int n2 = stringSegment.getOffset();
            boolean bl2 = this.prefix.match(stringSegment, parsedNumber);
            if (n2 != stringSegment.getOffset()) {
                parsedNumber.prefix = this.prefix.getPattern();
            }
            return bl2;
        }
        if (parsedNumber.suffix != null || this.suffix == null || !AffixMatcher.matched(this.prefix, parsedNumber.prefix)) {
            return false;
        }
        int n3 = stringSegment.getOffset();
        boolean bl3 = this.suffix.match(stringSegment, parsedNumber);
        if (n3 != stringSegment.getOffset()) {
            parsedNumber.suffix = this.suffix.getPattern();
        }
        return bl3;
    }

    @Override
    public boolean smokeTest(StringSegment stringSegment) {
        return this.prefix != null && this.prefix.smokeTest(stringSegment) || this.suffix != null && this.suffix.smokeTest(stringSegment);
    }

    @Override
    public void postProcess(ParsedNumber parsedNumber) {
        if (AffixMatcher.matched(this.prefix, parsedNumber.prefix) && AffixMatcher.matched(this.suffix, parsedNumber.suffix)) {
            if (parsedNumber.prefix == null) {
                parsedNumber.prefix = "";
            }
            if (parsedNumber.suffix == null) {
                parsedNumber.suffix = "";
            }
            parsedNumber.flags |= this.flags;
            if (this.prefix != null) {
                this.prefix.postProcess(parsedNumber);
            }
            if (this.suffix != null) {
                this.suffix.postProcess(parsedNumber);
            }
        }
    }

    static boolean matched(AffixPatternMatcher affixPatternMatcher, String string) {
        return affixPatternMatcher == null && string == null || affixPatternMatcher != null && affixPatternMatcher.getPattern().equals(string);
    }

    private static int length(AffixPatternMatcher affixPatternMatcher) {
        return affixPatternMatcher == null ? 0 : affixPatternMatcher.getPattern().length();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AffixMatcher)) {
            return false;
        }
        AffixMatcher affixMatcher = (AffixMatcher)object;
        return Objects.equals(this.prefix, affixMatcher.prefix) && Objects.equals(this.suffix, affixMatcher.suffix) && this.flags == affixMatcher.flags;
    }

    public int hashCode() {
        return Objects.hashCode(this.prefix) ^ Objects.hashCode(this.suffix) ^ this.flags;
    }

    public String toString() {
        boolean bl2 = 0 != (this.flags & 1);
        return "<AffixMatcher" + (bl2 ? ":negative " : " ") + this.prefix + "#" + this.suffix + ">";
    }
}

