/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroPropsGenerator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.UsagePrefsHandler;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.ComplexUnitsConverter;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.ConversionRates;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.units.MeasureUnitImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MeasureUnit;

public class UnitConversionHandler
implements MicroPropsGenerator {
    private final MicroPropsGenerator fParent;
    private MeasureUnit fOutputUnit;
    private ComplexUnitsConverter fComplexUnitConverter;

    public UnitConversionHandler(MeasureUnit measureUnit, MicroPropsGenerator microPropsGenerator) {
        this.fOutputUnit = measureUnit;
        this.fParent = microPropsGenerator;
        MeasureUnitImpl measureUnitImpl = MeasureUnitImpl.forIdentifier(measureUnit.getIdentifier());
        this.fComplexUnitConverter = new ComplexUnitsConverter(measureUnitImpl, new ConversionRates());
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity decimalQuantity) {
        MicroProps microProps = this.fParent.processQuantity(decimalQuantity);
        decimalQuantity.roundToInfinity();
        ComplexUnitsConverter.ComplexConverterResult complexConverterResult = this.fComplexUnitConverter.convert(decimalQuantity.toBigDecimal(), microProps.rounder);
        microProps.outputUnit = this.fOutputUnit;
        UsagePrefsHandler.mixedMeasuresToMicros(complexConverterResult, decimalQuantity, microProps);
        return microProps;
    }
}

