/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import java.math.MathContext;
import java.math.RoundingMode;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalFormatProperties;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Precision;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.Scale;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;

public class RoundingUtils {
    public static final int SECTION_LOWER = 1;
    public static final int SECTION_MIDPOINT = 2;
    public static final int SECTION_UPPER = 3;
    public static final RoundingMode DEFAULT_ROUNDING_MODE = RoundingMode.HALF_EVEN;
    public static final int MAX_INT_FRAC_SIG = 999;
    private static final MathContext[] MATH_CONTEXT_BY_ROUNDING_MODE_UNLIMITED = new MathContext[RoundingMode.values().length];
    private static final MathContext[] MATH_CONTEXT_BY_ROUNDING_MODE_34_DIGITS = new MathContext[RoundingMode.values().length];
    public static final MathContext DEFAULT_MATH_CONTEXT_UNLIMITED;
    public static final MathContext DEFAULT_MATH_CONTEXT_34_DIGITS;

    public static boolean getRoundingDirection(boolean bl2, boolean bl3, int n2, int n3, Object object) {
        switch (n3) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return bl3;
            }
            case 3: {
                return !bl3;
            }
            case 4: {
                switch (n2) {
                    case 2: {
                        return false;
                    }
                    case 1: {
                        return true;
                    }
                    case 3: {
                        return false;
                    }
                }
                break;
            }
            case 5: {
                switch (n2) {
                    case 2: {
                        return true;
                    }
                    case 1: {
                        return true;
                    }
                    case 3: {
                        return false;
                    }
                }
                break;
            }
            case 6: {
                switch (n2) {
                    case 2: {
                        return bl2;
                    }
                    case 1: {
                        return true;
                    }
                    case 3: {
                        return false;
                    }
                }
            }
        }
        throw new ArithmeticException("Rounding is required on " + object.toString());
    }

    public static boolean roundsAtMidpoint(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
        }
        return true;
    }

    public static MathContext getMathContextOrUnlimited(DecimalFormatProperties decimalFormatProperties) {
        MathContext mathContext = decimalFormatProperties.getMathContext();
        if (mathContext == null) {
            RoundingMode roundingMode = decimalFormatProperties.getRoundingMode();
            if (roundingMode == null) {
                roundingMode = RoundingMode.HALF_EVEN;
            }
            mathContext = MATH_CONTEXT_BY_ROUNDING_MODE_UNLIMITED[roundingMode.ordinal()];
        }
        return mathContext;
    }

    public static MathContext getMathContextOr34Digits(DecimalFormatProperties decimalFormatProperties) {
        MathContext mathContext = decimalFormatProperties.getMathContext();
        if (mathContext == null) {
            RoundingMode roundingMode = decimalFormatProperties.getRoundingMode();
            if (roundingMode == null) {
                roundingMode = RoundingMode.HALF_EVEN;
            }
            mathContext = MATH_CONTEXT_BY_ROUNDING_MODE_34_DIGITS[roundingMode.ordinal()];
        }
        return mathContext;
    }

    public static MathContext mathContextUnlimited(RoundingMode roundingMode) {
        return MATH_CONTEXT_BY_ROUNDING_MODE_UNLIMITED[roundingMode.ordinal()];
    }

    public static Scale scaleFromProperties(DecimalFormatProperties decimalFormatProperties) {
        MathContext mathContext = RoundingUtils.getMathContextOr34Digits(decimalFormatProperties);
        if (decimalFormatProperties.getMagnitudeMultiplier() != 0) {
            return Scale.powerOfTen(decimalFormatProperties.getMagnitudeMultiplier()).withMathContext(mathContext);
        }
        if (decimalFormatProperties.getMultiplier() != null) {
            return Scale.byBigDecimal(decimalFormatProperties.getMultiplier()).withMathContext(mathContext);
        }
        return null;
    }

    public static StandardPlural getPluralSafe(Precision precision, PluralRules pluralRules, DecimalQuantity decimalQuantity) {
        if (precision == null) {
            return decimalQuantity.getStandardPlural(pluralRules);
        }
        DecimalQuantity decimalQuantity2 = decimalQuantity.createCopy();
        precision.apply(decimalQuantity2);
        return decimalQuantity2.getStandardPlural(pluralRules);
    }

    static {
        for (int i2 = 0; i2 < MATH_CONTEXT_BY_ROUNDING_MODE_34_DIGITS.length; ++i2) {
            RoundingUtils.MATH_CONTEXT_BY_ROUNDING_MODE_UNLIMITED[i2] = new MathContext(0, RoundingMode.valueOf(i2));
            RoundingUtils.MATH_CONTEXT_BY_ROUNDING_MODE_34_DIGITS[i2] = new MathContext(34);
        }
        DEFAULT_MATH_CONTEXT_UNLIMITED = MATH_CONTEXT_BY_ROUNDING_MODE_UNLIMITED[DEFAULT_ROUNDING_MODE.ordinal()];
        DEFAULT_MATH_CONTEXT_34_DIGITS = MATH_CONTEXT_BY_ROUNDING_MODE_34_DIGITS[DEFAULT_ROUNDING_MODE.ordinal()];
    }
}

