/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import java.math.BigDecimal;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.AffixPatternProvider;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalFormatProperties;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Modifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Padder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.PropertiesAffixPatternProvider;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;

public class PatternStringUtils {
    public static boolean ignoreRoundingIncrement(BigDecimal bigDecimal, int n2) {
        double d2 = bigDecimal.doubleValue();
        if (d2 == 0.0) {
            return true;
        }
        if (n2 < 0) {
            return false;
        }
        int n3 = 0;
        d2 *= 2.0;
        for (n3 = 0; n3 <= n2 && d2 <= 1.0; ++n3, d2 *= 10.0) {
        }
        return n3 > n2;
    }

    public static String propertiesToPatternString(DecimalFormatProperties decimalFormatProperties) {
        int n2;
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = 100;
        int n5 = Math.max(0, Math.min(decimalFormatProperties.getGroupingSize(), n4));
        int n6 = Math.max(0, Math.min(decimalFormatProperties.getSecondaryGroupingSize(), n4));
        boolean bl2 = decimalFormatProperties.getGroupingUsed();
        int n7 = Math.min(decimalFormatProperties.getFormatWidth(), n4);
        Padder.PadPosition padPosition = decimalFormatProperties.getPadPosition();
        String string = decimalFormatProperties.getPadString();
        int n8 = Math.max(0, Math.min(decimalFormatProperties.getMinimumIntegerDigits(), n4));
        int n9 = Math.min(decimalFormatProperties.getMaximumIntegerDigits(), n4);
        int n10 = Math.max(0, Math.min(decimalFormatProperties.getMinimumFractionDigits(), n4));
        int n11 = Math.min(decimalFormatProperties.getMaximumFractionDigits(), n4);
        int n12 = Math.min(decimalFormatProperties.getMinimumSignificantDigits(), n4);
        int n13 = Math.min(decimalFormatProperties.getMaximumSignificantDigits(), n4);
        boolean bl3 = decimalFormatProperties.getDecimalSeparatorAlwaysShown();
        boolean bl4 = decimalFormatProperties.getCurrencyAsDecimal();
        int n14 = Math.min(decimalFormatProperties.getMinimumExponentDigits(), n4);
        boolean bl5 = decimalFormatProperties.getExponentSignAlwaysShown();
        AffixPatternProvider affixPatternProvider = PropertiesAffixPatternProvider.forProperties(decimalFormatProperties);
        stringBuilder.append(affixPatternProvider.getString(256));
        int n15 = stringBuilder.length();
        if (!bl2) {
            n5 = 0;
            n6 = 0;
        } else if (n5 == n6) {
            n5 = 0;
        }
        int n16 = n5 + n6 + 1;
        BigDecimal bigDecimal = decimalFormatProperties.getRoundingIncrement();
        StringBuilder stringBuilder2 = new StringBuilder();
        int n17 = 0;
        if (n13 != Math.min(n4, -1)) {
            while (stringBuilder2.length() < n12) {
                stringBuilder2.append('@');
            }
            while (stringBuilder2.length() < n13) {
                stringBuilder2.append('#');
            }
        } else if (bigDecimal != null && !PatternStringUtils.ignoreRoundingIncrement(bigDecimal, n11)) {
            n17 = -bigDecimal.scale();
            String string2 = bigDecimal.scaleByPowerOfTen(bigDecimal.scale()).toPlainString();
            if (string2.charAt(0) == '-') {
                stringBuilder2.append(string2, 1, string2.length());
            } else {
                stringBuilder2.append(string2);
            }
        }
        while (stringBuilder2.length() + n17 < n8) {
            stringBuilder2.insert(0, '0');
        }
        while (-n17 < n10) {
            stringBuilder2.append('0');
            --n17;
        }
        int n18 = Math.max(n16, stringBuilder2.length() + n17);
        n18 = n9 != n4 ? Math.max(n9, n18) - 1 : n18 - 1;
        int n19 = n11 != n4 ? Math.min(-n11, n17) : n17;
        for (n3 = n18; n3 >= n19; --n3) {
            n2 = stringBuilder2.length() + n17 - n3 - 1;
            if (n2 < 0 || n2 >= stringBuilder2.length()) {
                stringBuilder.append('#');
            } else {
                stringBuilder.append(stringBuilder2.charAt(n2));
            }
            if (n3 == 0 && (bl3 || n19 < 0)) {
                if (bl4) {
                    stringBuilder.append('\u00a4');
                } else {
                    stringBuilder.append('.');
                }
            }
            if (!bl2) continue;
            if (n3 > 0 && n3 == n5) {
                stringBuilder.append(',');
            }
            if (n3 <= n5 || n6 <= 0 || (n3 - n5) % n6 != 0) continue;
            stringBuilder.append(',');
        }
        if (n14 != Math.min(n4, -1)) {
            stringBuilder.append('E');
            if (bl5) {
                stringBuilder.append('+');
            }
            for (n3 = 0; n3 < n14; ++n3) {
                stringBuilder.append('0');
            }
        }
        n3 = stringBuilder.length();
        stringBuilder.append(affixPatternProvider.getString(0));
        if (n7 > 0) {
            while (n7 - stringBuilder.length() > 0) {
                stringBuilder.insert(n15, '#');
                ++n3;
            }
            switch (padPosition) {
                case BEFORE_PREFIX: {
                    n2 = PatternStringUtils.escapePaddingString(string, stringBuilder, 0);
                    stringBuilder.insert(0, '*');
                    n15 += n2 + 1;
                    n3 += n2 + 1;
                    break;
                }
                case AFTER_PREFIX: {
                    n2 = PatternStringUtils.escapePaddingString(string, stringBuilder, n15);
                    stringBuilder.insert(n15, '*');
                    n15 += n2 + 1;
                    n3 += n2 + 1;
                    break;
                }
                case BEFORE_SUFFIX: {
                    PatternStringUtils.escapePaddingString(string, stringBuilder, n3);
                    stringBuilder.insert(n3, '*');
                    break;
                }
                case AFTER_SUFFIX: {
                    stringBuilder.append('*');
                    PatternStringUtils.escapePaddingString(string, stringBuilder, stringBuilder.length());
                }
            }
        }
        if (affixPatternProvider.hasNegativeSubpattern()) {
            stringBuilder.append(';');
            stringBuilder.append(affixPatternProvider.getString(768));
            stringBuilder.append(stringBuilder, n15, n3);
            stringBuilder.append(affixPatternProvider.getString(512));
        }
        return stringBuilder.toString();
    }

    private static int escapePaddingString(CharSequence charSequence, StringBuilder stringBuilder, int n2) {
        if (charSequence == null || charSequence.length() == 0) {
            charSequence = " ";
        }
        int n3 = stringBuilder.length();
        if (charSequence.length() == 1) {
            if (charSequence.equals("'")) {
                stringBuilder.insert(n2, "''");
            } else {
                stringBuilder.insert(n2, charSequence);
            }
        } else {
            stringBuilder.insert(n2, '\'');
            int n4 = 1;
            for (int i2 = 0; i2 < charSequence.length(); ++i2) {
                char c2 = charSequence.charAt(i2);
                if (c2 == '\'') {
                    stringBuilder.insert(n2 + n4, "''");
                    n4 += 2;
                    continue;
                }
                stringBuilder.insert(n2 + n4, c2);
                ++n4;
            }
            stringBuilder.insert(n2 + n4, '\'');
        }
        return stringBuilder.length() - n3;
    }

    public static String convertLocalized(String string, DecimalFormatSymbols decimalFormatSymbols, boolean bl2) {
        int n2;
        if (string == null) {
            return null;
        }
        String[][] stringArray = new String[21][2];
        int n3 = bl2 ? 0 : 1;
        int n4 = bl2 ? 1 : 0;
        stringArray[0][n3] = "%";
        stringArray[0][n4] = decimalFormatSymbols.getPercentString();
        stringArray[1][n3] = "\u2030";
        stringArray[1][n4] = decimalFormatSymbols.getPerMillString();
        stringArray[2][n3] = ".";
        stringArray[2][n4] = decimalFormatSymbols.getDecimalSeparatorString();
        stringArray[3][n3] = ",";
        stringArray[3][n4] = decimalFormatSymbols.getGroupingSeparatorString();
        stringArray[4][n3] = "-";
        stringArray[4][n4] = decimalFormatSymbols.getMinusSignString();
        stringArray[5][n3] = "+";
        stringArray[5][n4] = decimalFormatSymbols.getPlusSignString();
        stringArray[6][n3] = ";";
        stringArray[6][n4] = Character.toString(decimalFormatSymbols.getPatternSeparator());
        stringArray[7][n3] = "@";
        stringArray[7][n4] = Character.toString(decimalFormatSymbols.getSignificantDigit());
        stringArray[8][n3] = "E";
        stringArray[8][n4] = decimalFormatSymbols.getExponentSeparator();
        stringArray[9][n3] = "*";
        stringArray[9][n4] = Character.toString(decimalFormatSymbols.getPadEscape());
        stringArray[10][n3] = "#";
        stringArray[10][n4] = Character.toString(decimalFormatSymbols.getDigit());
        for (n2 = 0; n2 < 10; ++n2) {
            stringArray[11 + n2][n3] = Character.toString((char)(48 + n2));
            stringArray[11 + n2][n4] = decimalFormatSymbols.getDigitStringsLocal()[n2];
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            stringArray[n2][n4] = stringArray[n2][n4].replace('\'', '\u2019');
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n5 = 0;
        block2: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\'') {
                if (n5 == 0) {
                    stringBuilder.append('\'');
                    n5 = 1;
                    continue;
                }
                if (n5 == 1) {
                    stringBuilder.append('\'');
                    n5 = 0;
                    continue;
                }
                if (n5 == 2) {
                    n5 = 3;
                    continue;
                }
                if (n5 == 3) {
                    stringBuilder.append('\'');
                    stringBuilder.append('\'');
                    n5 = 1;
                    continue;
                }
                if (n5 == 4) {
                    n5 = 5;
                    continue;
                }
                assert (n5 == 5);
                stringBuilder.append('\'');
                stringBuilder.append('\'');
                n5 = 4;
                continue;
            }
            if (n5 == 0 || n5 == 3 || n5 == 4) {
                for (String[] stringArray2 : stringArray) {
                    if (!string.regionMatches(i2, stringArray2[0], 0, stringArray2[0].length())) continue;
                    i2 += stringArray2[0].length() - 1;
                    if (n5 == 3 || n5 == 4) {
                        stringBuilder.append('\'');
                        n5 = 0;
                    }
                    stringBuilder.append(stringArray2[1]);
                    continue block2;
                }
                for (String[] stringArray2 : stringArray) {
                    if (!string.regionMatches(i2, stringArray2[1], 0, stringArray2[1].length())) continue;
                    if (n5 == 0) {
                        stringBuilder.append('\'');
                        n5 = 4;
                    }
                    stringBuilder.append(c2);
                    continue block2;
                }
                if (n5 == 3 || n5 == 4) {
                    stringBuilder.append('\'');
                    n5 = 0;
                }
                stringBuilder.append(c2);
                continue;
            }
            assert (n5 == 1 || n5 == 2 || n5 == 5);
            stringBuilder.append(c2);
            n5 = 2;
        }
        if (n5 == 3 || n5 == 4) {
            stringBuilder.append('\'');
            n5 = 0;
        }
        if (n5 != 0) {
            throw new IllegalArgumentException("Malformed localized pattern: unterminated quote");
        }
        return stringBuilder.toString();
    }

    public static void patternInfoToStringBuilder(AffixPatternProvider affixPatternProvider, boolean bl2, PatternSignType patternSignType, boolean bl3, StandardPlural standardPlural, boolean bl4, StringBuilder stringBuilder) {
        boolean bl5 = patternSignType == PatternSignType.POS_SIGN && !affixPatternProvider.positiveHasPlusSign();
        boolean bl6 = affixPatternProvider.hasNegativeSubpattern() && (patternSignType == PatternSignType.NEG || affixPatternProvider.negativeHasMinusSign() && (bl5 || bl3));
        int n2 = 0;
        if (bl6) {
            n2 |= 0x200;
        }
        if (bl2) {
            n2 |= 0x100;
        }
        if (standardPlural != null) {
            assert (standardPlural.ordinal() == (0xFF & standardPlural.ordinal()));
            n2 |= standardPlural.ordinal();
        }
        boolean bl7 = !bl2 || bl6 ? false : (patternSignType == PatternSignType.NEG ? true : bl5 || bl3);
        String string = "-";
        if (bl3) {
            string = bl5 ? "~+" : (patternSignType == PatternSignType.NEG ? "~-" : "~");
        } else if (bl5) {
            string = "+";
        }
        int n3 = affixPatternProvider.length(n2) + (bl7 ? 1 : 0);
        stringBuilder.setLength(0);
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = bl7 && i2 == 0 ? 45 : (bl7 ? (int)affixPatternProvider.charAt(n2, i2 - 1) : (int)affixPatternProvider.charAt(n2, i2));
            if (n4 == 45) {
                if (string.length() == 1) {
                    n4 = string.charAt(0);
                } else {
                    stringBuilder.append(string.charAt(0));
                    n4 = string.charAt(1);
                }
            }
            if (bl4 && n4 == 37) {
                n4 = 8240;
            }
            stringBuilder.append((char)n4);
        }
    }

    public static PatternSignType resolveSignDisplay(NumberFormatter.SignDisplay signDisplay, Modifier.Signum signum) {
        switch (signDisplay) {
            case AUTO: 
            case ACCOUNTING: {
                switch (signum) {
                    case NEG: 
                    case NEG_ZERO: {
                        return PatternSignType.NEG;
                    }
                    case POS_ZERO: 
                    case POS: {
                        return PatternSignType.POS;
                    }
                }
                break;
            }
            case ALWAYS: 
            case ACCOUNTING_ALWAYS: {
                switch (signum) {
                    case NEG: 
                    case NEG_ZERO: {
                        return PatternSignType.NEG;
                    }
                    case POS_ZERO: 
                    case POS: {
                        return PatternSignType.POS_SIGN;
                    }
                }
                break;
            }
            case EXCEPT_ZERO: 
            case ACCOUNTING_EXCEPT_ZERO: {
                switch (signum) {
                    case NEG: {
                        return PatternSignType.NEG;
                    }
                    case NEG_ZERO: 
                    case POS_ZERO: {
                        return PatternSignType.POS;
                    }
                    case POS: {
                        return PatternSignType.POS_SIGN;
                    }
                }
                break;
            }
            case NEGATIVE: 
            case ACCOUNTING_NEGATIVE: {
                switch (signum) {
                    case NEG: {
                        return PatternSignType.NEG;
                    }
                    case NEG_ZERO: 
                    case POS_ZERO: 
                    case POS: {
                        return PatternSignType.POS;
                    }
                }
                break;
            }
            case NEVER: {
                return PatternSignType.POS;
            }
        }
        throw new AssertionError((Object)"Unreachable");
    }

    public static enum PatternSignType {
        POS,
        POS_SIGN,
        NEG;

        public static final PatternSignType[] VALUES;

        static {
            VALUES = PatternSignType.values();
        }
    }
}

