/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import java.util.ArrayList;
import java.util.List;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedStringBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleFormatterImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.StandardPlural;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity_DualStorageBCD;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.LongNameHandler;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.LongNameMultiplexer;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroPropsGenerator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Modifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.ModifierStore;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.RoundingUtils;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.SimpleModifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.LocalizedNumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.ListFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.SimpleFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MeasureUnit;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class MixedUnitLongNameHandler
implements LongNameMultiplexer.ParentlessMicroPropsGenerator,
MicroPropsGenerator,
ModifierStore {
    private final PluralRules rules;
    private final MicroPropsGenerator parent;
    private List<String[]> fMixedUnitData;
    private LocalizedNumberFormatter fIntegerFormatter;
    private ListFormatter fListFormatter;

    private MixedUnitLongNameHandler(PluralRules pluralRules, MicroPropsGenerator microPropsGenerator) {
        this.rules = pluralRules;
        this.parent = microPropsGenerator;
    }

    public static MixedUnitLongNameHandler forMeasureUnit(ULocale uLocale, MeasureUnit measureUnit, NumberFormatter.UnitWidth unitWidth, String string, PluralRules pluralRules, MicroPropsGenerator microPropsGenerator) {
        assert (measureUnit.getComplexity() == MeasureUnit.Complexity.MIXED) : "MixedUnitLongNameHandler only supports MIXED units";
        MixedUnitLongNameHandler mixedUnitLongNameHandler = new MixedUnitLongNameHandler(pluralRules, microPropsGenerator);
        List<MeasureUnit> list = measureUnit.splitToSingleUnits();
        mixedUnitLongNameHandler.fMixedUnitData = new ArrayList<String[]>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String[] stringArray = new String[LongNameHandler.ARRAY_LENGTH];
            LongNameHandler.getMeasureData(uLocale, list.get(i2), unitWidth, string, stringArray);
            mixedUnitLongNameHandler.fMixedUnitData.add(stringArray);
        }
        ListFormatter.Width width = ListFormatter.Width.SHORT;
        if (unitWidth == NumberFormatter.UnitWidth.NARROW) {
            width = ListFormatter.Width.NARROW;
        } else if (unitWidth == NumberFormatter.UnitWidth.FULL_NAME) {
            width = ListFormatter.Width.WIDE;
        }
        mixedUnitLongNameHandler.fListFormatter = ListFormatter.getInstance(uLocale, ListFormatter.Type.UNITS, width);
        mixedUnitLongNameHandler.fIntegerFormatter = NumberFormatter.withLocale(uLocale);
        return mixedUnitLongNameHandler;
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity decimalQuantity) {
        assert (this.fMixedUnitData.size() > 1);
        MicroProps microProps = this.parent.processQuantity(decimalQuantity);
        microProps.modOuter = this.getMixedUnitModifier(decimalQuantity, microProps);
        return microProps;
    }

    @Override
    public MicroProps processQuantityWithMicros(DecimalQuantity decimalQuantity, MicroProps microProps) {
        assert (this.fMixedUnitData.size() > 1);
        microProps.modOuter = this.getMixedUnitModifier(decimalQuantity, microProps);
        return microProps;
    }

    @Override
    public Modifier getModifier(Modifier.Signum signum, StandardPlural standardPlural) {
        assert (false) : "should be unreachable";
        return null;
    }

    private Modifier getMixedUnitModifier(DecimalQuantity decimalQuantity, MicroProps microProps) {
        Object object;
        Object object2;
        Object object3;
        if (microProps.mixedMeasures.size() == 0) {
            assert (false) : "Mixed unit: we must have more than one unit value";
            throw new UnsupportedOperationException();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StandardPlural standardPlural = StandardPlural.OTHER;
        for (int i2 = 0; i2 < microProps.mixedMeasures.size(); ++i2) {
            if (i2 == microProps.indexOfQuantity) {
                if (i2 > 0 && decimalQuantity.isNegative()) {
                    decimalQuantity.negate();
                }
                standardPlural = RoundingUtils.getPluralSafe(microProps.rounder, this.rules, decimalQuantity);
                object3 = LongNameHandler.getWithPlural(this.fMixedUnitData.get(i2), standardPlural);
                object2 = SimpleFormatter.compileMinMaxArguments((CharSequence)object3, 0, 1);
                arrayList.add(((SimpleFormatter)object2).format("{0}"));
                continue;
            }
            object3 = new DecimalQuantity_DualStorageBCD(microProps.mixedMeasures.get(i2).getNumber());
            if (i2 > 0 && object3.isNegative()) {
                object3.negate();
            }
            object2 = RoundingUtils.getPluralSafe(microProps.rounder, this.rules, (DecimalQuantity)object3);
            object = LongNameHandler.getWithPlural(this.fMixedUnitData.get(i2), (StandardPlural)((Object)object2));
            SimpleFormatter simpleFormatter = SimpleFormatter.compileMinMaxArguments((CharSequence)object, 0, 1);
            FormattedStringBuilder formattedStringBuilder = new FormattedStringBuilder();
            this.fIntegerFormatter.formatImpl((DecimalQuantity)object3, formattedStringBuilder);
            arrayList.add(simpleFormatter.format(formattedStringBuilder.toString()));
        }
        String string = this.fListFormatter.format(arrayList);
        object3 = new StringBuilder();
        object2 = SimpleFormatterImpl.compileToStringMinMaxArguments(string, (StringBuilder)object3, 0, 1);
        object = new Modifier.Parameters();
        ((Modifier.Parameters)object).obj = this;
        ((Modifier.Parameters)object).signum = Modifier.Signum.POS_ZERO;
        ((Modifier.Parameters)object).plural = standardPlural;
        return new SimpleModifier((String)object2, null, false, (Modifier.Parameters)object);
    }
}

