/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import java.util.ArrayList;
import java.util.List;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.DecimalQuantity;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.LongNameHandler;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MicroPropsGenerator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.MixedUnitLongNameHandler;
import macromedia.jdbc.db2.externals.com.ibm.icu.number.NumberFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.PluralRules;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.MeasureUnit;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class LongNameMultiplexer
implements MicroPropsGenerator {
    private final MicroPropsGenerator fParent;
    private List<ParentlessMicroPropsGenerator> fHandlers;
    private List<MeasureUnit> fMeasureUnits;

    public LongNameMultiplexer(MicroPropsGenerator microPropsGenerator) {
        this.fParent = microPropsGenerator;
    }

    public static LongNameMultiplexer forMeasureUnits(ULocale uLocale, List<MeasureUnit> list, NumberFormatter.UnitWidth unitWidth, String string, PluralRules pluralRules, MicroPropsGenerator microPropsGenerator) {
        LongNameMultiplexer longNameMultiplexer = new LongNameMultiplexer(microPropsGenerator);
        assert (list.size() > 0);
        longNameMultiplexer.fMeasureUnits = new ArrayList<MeasureUnit>();
        longNameMultiplexer.fHandlers = new ArrayList<ParentlessMicroPropsGenerator>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ParentlessMicroPropsGenerator parentlessMicroPropsGenerator;
            MeasureUnit measureUnit = list.get(i2);
            longNameMultiplexer.fMeasureUnits.add(measureUnit);
            if (measureUnit.getComplexity() == MeasureUnit.Complexity.MIXED) {
                parentlessMicroPropsGenerator = MixedUnitLongNameHandler.forMeasureUnit(uLocale, measureUnit, unitWidth, string, pluralRules, null);
                longNameMultiplexer.fHandlers.add(parentlessMicroPropsGenerator);
                continue;
            }
            parentlessMicroPropsGenerator = LongNameHandler.forMeasureUnit(uLocale, measureUnit, unitWidth, string, pluralRules, null);
            longNameMultiplexer.fHandlers.add(parentlessMicroPropsGenerator);
        }
        return longNameMultiplexer;
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity decimalQuantity) {
        MicroProps microProps = this.fParent.processQuantity(decimalQuantity);
        for (int i2 = 0; i2 < this.fHandlers.size(); ++i2) {
            if (!this.fMeasureUnits.get(i2).equals(microProps.outputUnit)) continue;
            ParentlessMicroPropsGenerator parentlessMicroPropsGenerator = this.fHandlers.get(i2);
            return parentlessMicroPropsGenerator.processQuantityWithMicros(decimalQuantity, microProps);
        }
        throw new AssertionError((Object)" We shouldn't receive any outputUnit for which we haven't already got a LongNameHandler");
    }

    public static interface ParentlessMicroPropsGenerator {
        public MicroProps processQuantityWithMicros(DecimalQuantity var1, MicroProps var2);
    }
}

