/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedStringBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.ConstantMultiFieldModifier;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DecimalFormatSymbols;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

public class CurrencySpacingEnabledModifier
extends ConstantMultiFieldModifier {
    private static final UnicodeSet UNISET_DIGIT = new UnicodeSet("[:digit:]").freeze();
    private static final UnicodeSet UNISET_NOTSZ = new UnicodeSet("[[:^S:]&[:^Z:]]").freeze();
    static final byte PREFIX = 0;
    static final byte SUFFIX = 1;
    static final short IN_CURRENCY = 0;
    static final short IN_NUMBER = 1;
    private final UnicodeSet afterPrefixUnicodeSet;
    private final String afterPrefixInsert;
    private final UnicodeSet beforeSuffixUnicodeSet;
    private final String beforeSuffixInsert;

    public CurrencySpacingEnabledModifier(FormattedStringBuilder formattedStringBuilder, FormattedStringBuilder formattedStringBuilder2, boolean bl2, boolean bl3, DecimalFormatSymbols decimalFormatSymbols) {
        super(formattedStringBuilder, formattedStringBuilder2, bl2, bl3);
        UnicodeSet unicodeSet;
        int n2;
        if (formattedStringBuilder.length() > 0 && formattedStringBuilder.fieldAt(formattedStringBuilder.length() - 1) == NumberFormat.Field.CURRENCY) {
            n2 = formattedStringBuilder.getLastCodePoint();
            unicodeSet = CurrencySpacingEnabledModifier.getUnicodeSet(decimalFormatSymbols, (short)0, (byte)0);
            if (unicodeSet.contains(n2)) {
                this.afterPrefixUnicodeSet = CurrencySpacingEnabledModifier.getUnicodeSet(decimalFormatSymbols, (short)1, (byte)0);
                this.afterPrefixUnicodeSet.freeze();
                this.afterPrefixInsert = CurrencySpacingEnabledModifier.getInsertString(decimalFormatSymbols, (byte)0);
            } else {
                this.afterPrefixUnicodeSet = null;
                this.afterPrefixInsert = null;
            }
        } else {
            this.afterPrefixUnicodeSet = null;
            this.afterPrefixInsert = null;
        }
        if (formattedStringBuilder2.length() > 0 && formattedStringBuilder2.fieldAt(0) == NumberFormat.Field.CURRENCY) {
            n2 = formattedStringBuilder2.getFirstCodePoint();
            unicodeSet = CurrencySpacingEnabledModifier.getUnicodeSet(decimalFormatSymbols, (short)0, (byte)1);
            if (unicodeSet.contains(n2)) {
                this.beforeSuffixUnicodeSet = CurrencySpacingEnabledModifier.getUnicodeSet(decimalFormatSymbols, (short)1, (byte)1);
                this.beforeSuffixUnicodeSet.freeze();
                this.beforeSuffixInsert = CurrencySpacingEnabledModifier.getInsertString(decimalFormatSymbols, (byte)1);
            } else {
                this.beforeSuffixUnicodeSet = null;
                this.beforeSuffixInsert = null;
            }
        } else {
            this.beforeSuffixUnicodeSet = null;
            this.beforeSuffixInsert = null;
        }
    }

    @Override
    public int apply(FormattedStringBuilder formattedStringBuilder, int n2, int n3) {
        int n4 = 0;
        if (n3 - n2 > 0 && this.afterPrefixUnicodeSet != null && this.afterPrefixUnicodeSet.contains(formattedStringBuilder.codePointAt(n2))) {
            n4 += formattedStringBuilder.insert(n2, this.afterPrefixInsert, null);
        }
        if (n3 - n2 > 0 && this.beforeSuffixUnicodeSet != null && this.beforeSuffixUnicodeSet.contains(formattedStringBuilder.codePointBefore(n3))) {
            n4 += formattedStringBuilder.insert(n3 + n4, this.beforeSuffixInsert, null);
        }
        n4 += super.apply(formattedStringBuilder, n2, n3 + n4);
        return n4;
    }

    public static int applyCurrencySpacing(FormattedStringBuilder formattedStringBuilder, int n2, int n3, int n4, int n5, DecimalFormatSymbols decimalFormatSymbols) {
        boolean bl2;
        int n6 = 0;
        boolean bl3 = n3 > 0;
        boolean bl4 = n5 > 0;
        boolean bl5 = bl2 = n4 - n2 - n3 > 0;
        if (bl3 && bl2) {
            n6 += CurrencySpacingEnabledModifier.applyCurrencySpacingAffix(formattedStringBuilder, n2 + n3, (byte)0, decimalFormatSymbols);
        }
        if (bl4 && bl2) {
            n6 += CurrencySpacingEnabledModifier.applyCurrencySpacingAffix(formattedStringBuilder, n4 + n6, (byte)1, decimalFormatSymbols);
        }
        return n6;
    }

    private static int applyCurrencySpacingAffix(FormattedStringBuilder formattedStringBuilder, int n2, byte by2, DecimalFormatSymbols decimalFormatSymbols) {
        Object object;
        Object object2 = object = by2 == 0 ? formattedStringBuilder.fieldAt(n2 - 1) : formattedStringBuilder.fieldAt(n2);
        if (object != NumberFormat.Field.CURRENCY) {
            return 0;
        }
        int n3 = by2 == 0 ? formattedStringBuilder.codePointBefore(n2) : formattedStringBuilder.codePointAt(n2);
        UnicodeSet unicodeSet = CurrencySpacingEnabledModifier.getUnicodeSet(decimalFormatSymbols, (short)0, by2);
        if (!unicodeSet.contains(n3)) {
            return 0;
        }
        int n4 = by2 == 0 ? formattedStringBuilder.codePointAt(n2) : formattedStringBuilder.codePointBefore(n2);
        UnicodeSet unicodeSet2 = CurrencySpacingEnabledModifier.getUnicodeSet(decimalFormatSymbols, (short)1, by2);
        if (!unicodeSet2.contains(n4)) {
            return 0;
        }
        String string = CurrencySpacingEnabledModifier.getInsertString(decimalFormatSymbols, by2);
        return formattedStringBuilder.insert(n2, string, null);
    }

    private static UnicodeSet getUnicodeSet(DecimalFormatSymbols decimalFormatSymbols, short s2, byte by2) {
        String string = decimalFormatSymbols.getPatternForCurrencySpacing(s2 == 0 ? 0 : 1, by2 == 1);
        if (string.equals("[:digit:]")) {
            return UNISET_DIGIT;
        }
        if (string.equals("[[:^S:]&[:^Z:]]")) {
            return UNISET_NOTSZ;
        }
        return new UnicodeSet(string);
    }

    private static String getInsertString(DecimalFormatSymbols decimalFormatSymbols, byte by2) {
        return decimalFormatSymbols.getPatternForCurrencySpacing(2, by2 == 1);
    }
}

