/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import java.text.Format;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedStringBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.number.Modifier;

public class ConstantAffixModifier
implements Modifier {
    public static final ConstantAffixModifier EMPTY = new ConstantAffixModifier();
    private final String prefix;
    private final String suffix;
    private final Format.Field field;
    private final boolean strong;

    public ConstantAffixModifier(String string, String string2, Format.Field field, boolean bl2) {
        this.prefix = string == null ? "" : string;
        this.suffix = string2 == null ? "" : string2;
        this.field = field;
        this.strong = bl2;
    }

    public ConstantAffixModifier() {
        this.prefix = "";
        this.suffix = "";
        this.field = null;
        this.strong = false;
    }

    @Override
    public int apply(FormattedStringBuilder formattedStringBuilder, int n2, int n3) {
        int n4 = formattedStringBuilder.insert(n3, this.suffix, this.field);
        return n4 += formattedStringBuilder.insert(n2, this.prefix, this.field);
    }

    @Override
    public int getPrefixLength() {
        return this.prefix.length();
    }

    @Override
    public int getCodePointCount() {
        return this.prefix.codePointCount(0, this.prefix.length()) + this.suffix.codePointCount(0, this.suffix.length());
    }

    @Override
    public boolean isStrong() {
        return this.strong;
    }

    @Override
    public boolean containsField(Format.Field field) {
        assert (false);
        return false;
    }

    @Override
    public Modifier.Parameters getParameters() {
        return null;
    }

    @Override
    public boolean strictEquals(Modifier modifier) {
        if (!(modifier instanceof ConstantAffixModifier)) {
            return false;
        }
        ConstantAffixModifier constantAffixModifier = (ConstantAffixModifier)modifier;
        return this.prefix.equals(constantAffixModifier.prefix) && this.suffix.equals(constantAffixModifier.suffix) && this.field == constantAffixModifier.field && this.strong == constantAffixModifier.strong;
    }

    public String toString() {
        return String.format("<ConstantAffixModifier prefix:'%s' suffix:'%s'>", this.prefix, this.suffix);
    }
}

