/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.number;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.FormattedStringBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.NumberFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

public class AffixUtils {
    private static final int STATE_BASE = 0;
    private static final int STATE_FIRST_QUOTE = 1;
    private static final int STATE_INSIDE_QUOTE = 2;
    private static final int STATE_AFTER_QUOTE = 3;
    private static final int STATE_FIRST_CURR = 4;
    private static final int STATE_SECOND_CURR = 5;
    private static final int STATE_THIRD_CURR = 6;
    private static final int STATE_FOURTH_CURR = 7;
    private static final int STATE_FIFTH_CURR = 8;
    private static final int STATE_OVERFLOW_CURR = 9;
    private static final int TYPE_CODEPOINT = 0;
    public static final int TYPE_MINUS_SIGN = -1;
    public static final int TYPE_PLUS_SIGN = -2;
    public static final int TYPE_APPROXIMATELY_SIGN = -3;
    public static final int TYPE_PERCENT = -4;
    public static final int TYPE_PERMILLE = -5;
    public static final int TYPE_CURRENCY_SINGLE = -6;
    public static final int TYPE_CURRENCY_DOUBLE = -7;
    public static final int TYPE_CURRENCY_TRIPLE = -8;
    public static final int TYPE_CURRENCY_QUAD = -9;
    public static final int TYPE_CURRENCY_QUINT = -10;
    public static final int TYPE_CURRENCY_OVERFLOW = -15;

    public static int estimateLength(CharSequence charSequence) {
        int n2;
        if (charSequence == null) {
            return 0;
        }
        int n3 = 0;
        int n4 = 0;
        block9: for (int i2 = 0; i2 < charSequence.length(); i2 += Character.charCount(n2)) {
            n2 = Character.codePointAt(charSequence, i2);
            switch (n3) {
                case 0: {
                    if (n2 == 39) {
                        n3 = 1;
                        continue block9;
                    }
                    ++n4;
                    continue block9;
                }
                case 1: {
                    if (n2 == 39) {
                        ++n4;
                        n3 = 0;
                        continue block9;
                    }
                    ++n4;
                    n3 = 2;
                    continue block9;
                }
                case 2: {
                    if (n2 == 39) {
                        n3 = 3;
                        continue block9;
                    }
                    ++n4;
                    continue block9;
                }
                case 3: {
                    if (n2 == 39) {
                        ++n4;
                        n3 = 2;
                        continue block9;
                    }
                    ++n4;
                    continue block9;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        switch (n3) {
            case 1: 
            case 2: {
                throw new IllegalArgumentException("Unterminated quote: \"" + charSequence + "\"");
            }
        }
        return n4;
    }

    public static int escape(CharSequence charSequence, StringBuilder stringBuilder) {
        int n2;
        if (charSequence == null) {
            return 0;
        }
        int n3 = 0;
        int n4 = stringBuilder.length();
        block4: for (int i2 = 0; i2 < charSequence.length(); i2 += Character.charCount(n2)) {
            n2 = Character.codePointAt(charSequence, i2);
            switch (n2) {
                case 39: {
                    stringBuilder.append("''");
                    continue block4;
                }
                case 37: 
                case 43: 
                case 45: 
                case 164: 
                case 8240: {
                    if (n3 == 0) {
                        stringBuilder.append('\'');
                        stringBuilder.appendCodePoint(n2);
                        n3 = 2;
                        continue block4;
                    }
                    stringBuilder.appendCodePoint(n2);
                    continue block4;
                }
                default: {
                    if (n3 == 2) {
                        stringBuilder.append('\'');
                        stringBuilder.appendCodePoint(n2);
                        n3 = 0;
                        continue block4;
                    }
                    stringBuilder.appendCodePoint(n2);
                }
            }
        }
        if (n3 == 2) {
            stringBuilder.append('\'');
        }
        return stringBuilder.length() - n4;
    }

    public static String escape(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        AffixUtils.escape(charSequence, stringBuilder);
        return stringBuilder.toString();
    }

    public static final NumberFormat.Field getFieldForType(int n2) {
        switch (n2) {
            case -1: {
                return NumberFormat.Field.SIGN;
            }
            case -2: {
                return NumberFormat.Field.SIGN;
            }
            case -3: {
                return NumberFormat.Field.APPROXIMATELY_SIGN;
            }
            case -4: {
                return NumberFormat.Field.PERCENT;
            }
            case -5: {
                return NumberFormat.Field.PERMILLE;
            }
            case -6: {
                return NumberFormat.Field.CURRENCY;
            }
            case -7: {
                return NumberFormat.Field.CURRENCY;
            }
            case -8: {
                return NumberFormat.Field.CURRENCY;
            }
            case -9: {
                return NumberFormat.Field.CURRENCY;
            }
            case -10: {
                return NumberFormat.Field.CURRENCY;
            }
            case -15: {
                return NumberFormat.Field.CURRENCY;
            }
        }
        throw new AssertionError();
    }

    public static int unescape(CharSequence charSequence, FormattedStringBuilder formattedStringBuilder, int n2, SymbolProvider symbolProvider, NumberFormat.Field field) {
        assert (charSequence != null);
        int n3 = 0;
        long l2 = 0L;
        while (AffixUtils.hasNext(l2, charSequence)) {
            int n4 = AffixUtils.getTypeOrCp(l2 = AffixUtils.nextToken(l2, charSequence));
            if (n4 == -15) {
                n3 += formattedStringBuilder.insertCodePoint(n2 + n3, 65533, NumberFormat.Field.CURRENCY);
                continue;
            }
            if (n4 < 0) {
                n3 += formattedStringBuilder.insert(n2 + n3, symbolProvider.getSymbol(n4), AffixUtils.getFieldForType(n4));
                continue;
            }
            n3 += formattedStringBuilder.insertCodePoint(n2 + n3, n4, field);
        }
        return n3;
    }

    public static int unescapedCount(CharSequence charSequence, boolean bl2, SymbolProvider symbolProvider) {
        int n2 = 0;
        long l2 = 0L;
        while (AffixUtils.hasNext(l2, charSequence)) {
            int n3 = AffixUtils.getTypeOrCp(l2 = AffixUtils.nextToken(l2, charSequence));
            if (n3 == -15) {
                ++n2;
                continue;
            }
            if (n3 < 0) {
                CharSequence charSequence2 = symbolProvider.getSymbol(n3);
                n2 += bl2 ? charSequence2.length() : Character.codePointCount(charSequence2, 0, charSequence2.length());
                continue;
            }
            n2 += bl2 ? Character.charCount(n3) : 1;
        }
        return n2;
    }

    public static boolean containsType(CharSequence charSequence, int n2) {
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        long l2 = 0L;
        while (AffixUtils.hasNext(l2, charSequence)) {
            if (AffixUtils.getTypeOrCp(l2 = AffixUtils.nextToken(l2, charSequence)) != n2) continue;
            return true;
        }
        return false;
    }

    public static boolean hasCurrencySymbols(CharSequence charSequence) {
        if (charSequence == null || charSequence.length() == 0) {
            return false;
        }
        long l2 = 0L;
        while (AffixUtils.hasNext(l2, charSequence)) {
            int n2 = AffixUtils.getTypeOrCp(l2 = AffixUtils.nextToken(l2, charSequence));
            if (n2 >= 0 || AffixUtils.getFieldForType(n2) != NumberFormat.Field.CURRENCY) continue;
            return true;
        }
        return false;
    }

    public static String replaceType(CharSequence charSequence, int n2, char c2) {
        if (charSequence == null || charSequence.length() == 0) {
            return "";
        }
        char[] cArray = charSequence.toString().toCharArray();
        long l2 = 0L;
        while (AffixUtils.hasNext(l2, charSequence)) {
            if (AffixUtils.getTypeOrCp(l2 = AffixUtils.nextToken(l2, charSequence)) != n2) continue;
            int n3 = AffixUtils.getOffset(l2);
            cArray[n3 - 1] = c2;
        }
        return new String(cArray);
    }

    public static boolean containsOnlySymbolsAndIgnorables(CharSequence charSequence, UnicodeSet unicodeSet) {
        if (charSequence == null) {
            return true;
        }
        long l2 = 0L;
        while (AffixUtils.hasNext(l2, charSequence)) {
            int n2 = AffixUtils.getTypeOrCp(l2 = AffixUtils.nextToken(l2, charSequence));
            if (n2 < 0 || unicodeSet.contains(n2)) continue;
            return false;
        }
        return true;
    }

    public static void iterateWithConsumer(CharSequence charSequence, TokenConsumer tokenConsumer) {
        assert (charSequence != null);
        long l2 = 0L;
        while (AffixUtils.hasNext(l2, charSequence)) {
            l2 = AffixUtils.nextToken(l2, charSequence);
            int n2 = AffixUtils.getTypeOrCp(l2);
            tokenConsumer.consumeToken(n2);
        }
    }

    private static long nextToken(long l2, CharSequence charSequence) {
        int n2 = AffixUtils.getOffset(l2);
        int n3 = AffixUtils.getState(l2);
        block32: while (n2 < charSequence.length()) {
            int n4 = Character.codePointAt(charSequence, n2);
            int n5 = Character.charCount(n4);
            switch (n3) {
                case 0: {
                    switch (n4) {
                        case 39: {
                            n3 = 1;
                            n2 += n5;
                            continue block32;
                        }
                        case 45: {
                            return AffixUtils.makeTag(n2 + n5, -1, 0, 0);
                        }
                        case 43: {
                            return AffixUtils.makeTag(n2 + n5, -2, 0, 0);
                        }
                        case 126: {
                            return AffixUtils.makeTag(n2 + n5, -3, 0, 0);
                        }
                        case 37: {
                            return AffixUtils.makeTag(n2 + n5, -4, 0, 0);
                        }
                        case 8240: {
                            return AffixUtils.makeTag(n2 + n5, -5, 0, 0);
                        }
                        case 164: {
                            n3 = 4;
                            n2 += n5;
                            continue block32;
                        }
                    }
                    return AffixUtils.makeTag(n2 + n5, 0, 0, n4);
                }
                case 1: {
                    if (n4 == 39) {
                        return AffixUtils.makeTag(n2 + n5, 0, 0, n4);
                    }
                    return AffixUtils.makeTag(n2 + n5, 0, 2, n4);
                }
                case 2: {
                    if (n4 == 39) {
                        n3 = 3;
                        n2 += n5;
                        continue block32;
                    }
                    return AffixUtils.makeTag(n2 + n5, 0, 2, n4);
                }
                case 3: {
                    if (n4 == 39) {
                        return AffixUtils.makeTag(n2 + n5, 0, 2, n4);
                    }
                    n3 = 0;
                    continue block32;
                }
                case 4: {
                    if (n4 == 164) {
                        n3 = 5;
                        n2 += n5;
                        continue block32;
                    }
                    return AffixUtils.makeTag(n2, -6, 0, 0);
                }
                case 5: {
                    if (n4 == 164) {
                        n3 = 6;
                        n2 += n5;
                        continue block32;
                    }
                    return AffixUtils.makeTag(n2, -7, 0, 0);
                }
                case 6: {
                    if (n4 == 164) {
                        n3 = 7;
                        n2 += n5;
                        continue block32;
                    }
                    return AffixUtils.makeTag(n2, -8, 0, 0);
                }
                case 7: {
                    if (n4 == 164) {
                        n3 = 8;
                        n2 += n5;
                        continue block32;
                    }
                    return AffixUtils.makeTag(n2, -9, 0, 0);
                }
                case 8: {
                    if (n4 == 164) {
                        n3 = 9;
                        n2 += n5;
                        continue block32;
                    }
                    return AffixUtils.makeTag(n2, -10, 0, 0);
                }
                case 9: {
                    if (n4 == 164) {
                        n2 += n5;
                        continue block32;
                    }
                    return AffixUtils.makeTag(n2, -15, 0, 0);
                }
            }
            throw new AssertionError();
        }
        switch (n3) {
            case 0: {
                return -1L;
            }
            case 1: 
            case 2: {
                throw new IllegalArgumentException("Unterminated quote in pattern affix: \"" + charSequence + "\"");
            }
            case 3: {
                return -1L;
            }
            case 4: {
                return AffixUtils.makeTag(n2, -6, 0, 0);
            }
            case 5: {
                return AffixUtils.makeTag(n2, -7, 0, 0);
            }
            case 6: {
                return AffixUtils.makeTag(n2, -8, 0, 0);
            }
            case 7: {
                return AffixUtils.makeTag(n2, -9, 0, 0);
            }
            case 8: {
                return AffixUtils.makeTag(n2, -10, 0, 0);
            }
            case 9: {
                return AffixUtils.makeTag(n2, -15, 0, 0);
            }
        }
        throw new AssertionError();
    }

    private static boolean hasNext(long l2, CharSequence charSequence) {
        assert (l2 >= 0L);
        int n2 = AffixUtils.getState(l2);
        int n3 = AffixUtils.getOffset(l2);
        if (n2 == 2 && n3 == charSequence.length() - 1 && charSequence.charAt(n3) == '\'') {
            return false;
        }
        if (n2 != 0) {
            return true;
        }
        return n3 < charSequence.length();
    }

    private static int getTypeOrCp(long l2) {
        assert (l2 >= 0L);
        int n2 = AffixUtils.getType(l2);
        return n2 == 0 ? AffixUtils.getCodePoint(l2) : -n2;
    }

    private static long makeTag(int n2, int n3, int n4, int n5) {
        long l2 = 0L;
        l2 |= (long)n2;
        l2 |= -((long)n3) << 32;
        l2 |= (long)n4 << 36;
        assert ((l2 |= (long)n5 << 40) >= 0L);
        return l2;
    }

    private static int getOffset(long l2) {
        return (int)(l2 & 0xFFFFFFFFFFFFFFFFL);
    }

    private static int getType(long l2) {
        return (int)(l2 >>> 32 & 0xFL);
    }

    private static int getState(long l2) {
        return (int)(l2 >>> 36 & 0xFL);
    }

    private static int getCodePoint(long l2) {
        return (int)(l2 >>> 40);
    }

    public static interface TokenConsumer {
        public void consumeToken(int var1);
    }

    public static interface SymbolProvider {
        public CharSequence getSymbol(int var1);
    }
}

