/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;

public class XCldrStub {
    public static <T> String join(T[] TArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < TArray.length; ++i2) {
            if (i2 != 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(TArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static <T> String join(Iterable<T> iterable, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = true;
        for (T t2 : iterable) {
            if (!bl2) {
                stringBuilder.append(string);
            } else {
                bl2 = false;
            }
            stringBuilder.append(t2.toString());
        }
        return stringBuilder.toString();
    }

    public static interface Predicate<T> {
        public boolean test(T var1);
    }

    public static class RegexUtilities {
        public static int findMismatch(Matcher matcher, CharSequence charSequence) {
            boolean bl2;
            int n2;
            for (n2 = 1; n2 < charSequence.length() && ((bl2 = matcher.reset(charSequence.subSequence(0, n2)).matches()) || matcher.hitEnd()); ++n2) {
            }
            return n2 - 1;
        }

        public static String showMismatch(Matcher matcher, CharSequence charSequence) {
            int n2 = RegexUtilities.findMismatch(matcher, charSequence);
            String string = charSequence.subSequence(0, n2) + "\u2639" + charSequence.subSequence(n2, charSequence.length());
            return string;
        }
    }

    public static class FileUtilities {
        public static final Charset UTF8 = Charset.forName("utf-8");

        public static BufferedReader openFile(Class<?> clazz, String string) {
            return FileUtilities.openFile(clazz, string, UTF8);
        }

        public static BufferedReader openFile(Class<?> clazz, String string, Charset charset) {
            try {
                InputStream inputStream = clazz.getResourceAsStream(string);
                if (charset == null) {
                    charset = UTF8;
                }
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader, 65536);
                return bufferedReader;
            }
            catch (Exception exception) {
                String string2 = clazz == null ? null : clazz.getCanonicalName();
                String string3 = null;
                try {
                    String string4 = FileUtilities.getRelativeFileName(clazz, "../util/");
                    string3 = new File(string4).getCanonicalPath();
                }
                catch (Exception exception2) {
                    throw new ICUUncheckedIOException("Couldn't open file: " + string + "; relative to class: " + string2, exception);
                }
                throw new ICUUncheckedIOException("Couldn't open file " + string + "; in path " + string3 + "; relative to class: " + string2, exception);
            }
        }

        public static String getRelativeFileName(Class<?> clazz, String string) {
            URL uRL = clazz == null ? FileUtilities.class.getResource(string) : clazz.getResource(string);
            String string2 = uRL.toString();
            if (string2.startsWith("file:")) {
                return string2.substring(5);
            }
            if (string2.startsWith("jar:file:")) {
                return string2.substring(9);
            }
            throw new ICUUncheckedIOException("File not found: " + string2);
        }
    }

    public static class ImmutableMultimap {
        public static <K, V> Multimap<K, V> copyOf(Multimap<K, V> multimap) {
            LinkedHashMap<K, Set<V>> linkedHashMap = new LinkedHashMap<K, Set<V>>();
            for (Map.Entry<K, Set<V>> entry : multimap.asMap().entrySet()) {
                Set<V> set = entry.getValue();
                linkedHashMap.put(entry.getKey(), set.size() == 1 ? Collections.singleton(set.iterator().next()) : Collections.unmodifiableSet(new LinkedHashSet<V>(set)));
            }
            return new Multimap(Collections.unmodifiableMap(linkedHashMap), null);
        }
    }

    public static class ImmutableMap {
        public static <K, V> Map<K, V> copyOf(Map<K, V> map) {
            return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
        }
    }

    public static class ImmutableSet {
        public static <T> Set<T> copyOf(Set<T> set) {
            return Collections.unmodifiableSet(new LinkedHashSet<T>(set));
        }
    }

    public static class Splitter {
        Pattern pattern;
        boolean trimResults = false;

        public Splitter(char c2) {
            this(Pattern.compile("\\Q" + c2 + "\\E"));
        }

        public Splitter(Pattern pattern) {
            this.pattern = pattern;
        }

        public static Splitter on(char c2) {
            return new Splitter(c2);
        }

        public static Splitter on(Pattern pattern) {
            return new Splitter(pattern);
        }

        public List<String> splitToList(String string) {
            String[] stringArray = this.pattern.split(string);
            if (this.trimResults) {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    stringArray[i2] = stringArray[i2].trim();
                }
            }
            return Arrays.asList(stringArray);
        }

        public Splitter trimResults() {
            this.trimResults = true;
            return this;
        }

        public Iterable<String> split(String string) {
            return this.splitToList(string);
        }
    }

    public static class Joiner {
        private final String separator;

        private Joiner(String string) {
            this.separator = string;
        }

        public static final Joiner on(String string) {
            return new Joiner(string);
        }

        public <T> String join(T[] TArray) {
            return XCldrStub.join(TArray, this.separator);
        }

        public <T> String join(Iterable<T> iterable) {
            return XCldrStub.join(iterable, this.separator);
        }
    }

    public static class CollectionUtilities {
        public static <T, U extends Iterable<T>> String join(U u2, String string) {
            return XCldrStub.join(u2, string);
        }
    }

    public static class LinkedHashMultimap<K, V>
    extends Multimap<K, V> {
        private LinkedHashMultimap() {
            super(new LinkedHashMap(), LinkedHashSet.class);
        }

        public static <K, V> LinkedHashMultimap<K, V> create() {
            return new LinkedHashMultimap<K, V>();
        }
    }

    public static class TreeMultimap<K, V>
    extends Multimap<K, V> {
        private TreeMultimap() {
            super(new TreeMap(), TreeSet.class);
        }

        public static <K, V> TreeMultimap<K, V> create() {
            return new TreeMultimap<K, V>();
        }
    }

    public static class HashMultimap<K, V>
    extends Multimap<K, V> {
        private HashMultimap() {
            super(new HashMap(), HashSet.class);
        }

        public static <K, V> HashMultimap<K, V> create() {
            return new HashMultimap<K, V>();
        }
    }

    private static class ReusableEntry<K, V>
    implements Map.Entry<K, V> {
        K key;
        V value;

        private ReusableEntry() {
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v2) {
            throw new UnsupportedOperationException();
        }
    }

    private static class MultimapIterator<K, V>
    implements Iterable<Map.Entry<K, V>>,
    Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, Set<V>>> it1;
        private Iterator<V> it2 = null;
        private final ReusableEntry<K, V> entry = new ReusableEntry();

        private MultimapIterator(Map<K, Set<V>> map) {
            this.it1 = map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.it1.hasNext() || this.it2 != null && this.it2.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            if (this.it2 != null && this.it2.hasNext()) {
                this.entry.value = this.it2.next();
            } else {
                Map.Entry<K, Set<V>> entry = this.it1.next();
                this.entry.key = entry.getKey();
                this.it2 = entry.getValue().iterator();
            }
            return this.entry;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return this;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Multimaps {
        public static <K, V, R extends Multimap<K, V>> R invertFrom(Multimap<V, K> multimap, R r2) {
            for (Map.Entry<V, Set<K>> entry : multimap.asMap().entrySet()) {
                r2.putAll((Collection)entry.getValue(), entry.getKey());
            }
            return r2;
        }

        public static <K, V, R extends Multimap<K, V>> R invertFrom(Map<V, K> map, R r2) {
            for (Map.Entry<V, K> entry : map.entrySet()) {
                r2.put(entry.getValue(), entry.getKey());
            }
            return r2;
        }

        public static <K, V> Map<K, V> forMap(Map<K, V> map) {
            return map;
        }
    }

    public static class Multimap<K, V> {
        private final Map<K, Set<V>> map;
        private final Class<Set<V>> setClass;

        private Multimap(Map<K, Set<V>> map, Class<?> clazz) {
            this.map = map;
            this.setClass = clazz != null ? clazz : HashSet.class;
        }

        @SafeVarargs
        public final Multimap<K, V> putAll(K k2, V ... VArray) {
            if (VArray.length != 0) {
                this.createSetIfMissing(k2).addAll(Arrays.asList(VArray));
            }
            return this;
        }

        public void putAll(K k2, Collection<V> collection) {
            if (!collection.isEmpty()) {
                this.createSetIfMissing(k2).addAll(collection);
            }
        }

        public void putAll(Collection<K> collection, V v2) {
            for (K k2 : collection) {
                this.put(k2, v2);
            }
        }

        public void putAll(Multimap<K, V> multimap) {
            for (Map.Entry<K, Set<V>> entry : multimap.map.entrySet()) {
                this.putAll(entry.getKey(), (Collection)entry.getValue());
            }
        }

        public void put(K k2, V v2) {
            this.createSetIfMissing(k2).add(v2);
        }

        private Set<V> createSetIfMissing(K k2) {
            Set<V> set = this.map.get(k2);
            if (set == null) {
                set = this.getInstance();
                this.map.put(k2, set);
            }
            return set;
        }

        private Set<V> getInstance() {
            try {
                return this.setClass.newInstance();
            }
            catch (Exception exception) {
                throw new ICUException(exception);
            }
        }

        public Set<V> get(K k2) {
            Set<V> set = this.map.get(k2);
            return set;
        }

        public Set<K> keySet() {
            return this.map.keySet();
        }

        public Map<K, Set<V>> asMap() {
            return this.map;
        }

        public Set<V> values() {
            Collection<Set<V>> collection = this.map.values();
            if (collection.size() == 0) {
                return Collections.emptySet();
            }
            Set<V> set = this.getInstance();
            for (Set<V> set2 : collection) {
                set.addAll(set2);
            }
            return set;
        }

        public int size() {
            return this.map.size();
        }

        public Iterable<Map.Entry<K, V>> entries() {
            return new MultimapIterator(this.map);
        }

        public boolean equals(Object object) {
            return this == object || object != null && object.getClass() == this.getClass() && this.map.equals(((Multimap)object).map);
        }

        public int hashCode() {
            return this.map.hashCode();
        }
    }
}

