/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.concurrent.ConcurrentHashMap;

public abstract class LocaleObjectCache<K, V> {
    private ConcurrentHashMap<K, CacheEntry<K, V>> _map;
    private ReferenceQueue<V> _queue = new ReferenceQueue();

    public LocaleObjectCache() {
        this(16, 0.75f, 16);
    }

    public LocaleObjectCache(int n2, float f2, int n3) {
        this._map = new ConcurrentHashMap(n2, f2, n3);
    }

    public V get(K k2) {
        V v2 = null;
        this.cleanStaleEntries();
        CacheEntry<K, V> cacheEntry = this._map.get(k2);
        if (cacheEntry != null) {
            v2 = (V)cacheEntry.get();
        }
        if (v2 == null) {
            k2 = this.normalizeKey(k2);
            V v3 = this.createObject(k2);
            if (k2 == null || v3 == null) {
                return null;
            }
            CacheEntry<K, V> cacheEntry2 = new CacheEntry<K, V>(k2, v3, this._queue);
            while (v2 == null) {
                this.cleanStaleEntries();
                cacheEntry = this._map.putIfAbsent(k2, cacheEntry2);
                if (cacheEntry == null) {
                    v2 = v3;
                    break;
                }
                v2 = (V)cacheEntry.get();
            }
        }
        return v2;
    }

    private void cleanStaleEntries() {
        CacheEntry cacheEntry;
        while ((cacheEntry = (CacheEntry)this._queue.poll()) != null) {
            this._map.remove(cacheEntry.getKey());
        }
    }

    protected abstract V createObject(K var1);

    protected K normalizeKey(K k2) {
        return k2;
    }

    private static class CacheEntry<K, V>
    extends SoftReference<V> {
        private K _key;

        CacheEntry(K k2, V v2, ReferenceQueue<V> referenceQueue) {
            super(v2, referenceQueue);
            this._key = k2;
        }

        K getKey() {
            return this._key;
        }
    }
}

