/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UResource;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.LSR;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.LikelySubtags;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BytesTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.LocaleMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class LocaleDistance {
    public static final int END_OF_SUBTAG = 128;
    public static final int DISTANCE_SKIP_SCRIPT = 128;
    private static final int DISTANCE_IS_FINAL = 256;
    private static final int DISTANCE_IS_FINAL_OR_SKIP_SCRIPT = 384;
    private static final int DISTANCE_SHIFT = 3;
    private static final int DISTANCE_FRACTION_MASK = 7;
    private static final int DISTANCE_INT_SHIFT = 7;
    private static final int INDEX_SHIFT = 10;
    private static final int DISTANCE_MASK = 1023;
    private static final int INDEX_NEG_1 = -1024;
    public static final int IX_DEF_LANG_DISTANCE = 0;
    public static final int IX_DEF_SCRIPT_DISTANCE = 1;
    public static final int IX_DEF_REGION_DISTANCE = 2;
    public static final int IX_MIN_REGION_DISTANCE = 3;
    public static final int IX_LIMIT = 4;
    private static final int ABOVE_THRESHOLD = 100;
    private static final boolean DEBUG_OUTPUT = false;
    private final BytesTrie trie;
    private final byte[] regionToPartitionsIndex;
    private final String[] partitionArrays;
    private final Set<LSR> paradigmLSRs;
    private final int defaultLanguageDistance;
    private final int defaultScriptDistance;
    private final int defaultRegionDistance;
    private final int minRegionDistance;
    private final int defaultDemotionPerDesiredLocale;
    public static final LocaleDistance INSTANCE = new LocaleDistance(Data.load());

    public static final int shiftDistance(int n2) {
        return n2 << 3;
    }

    public static final int getShiftedDistance(int n2) {
        return n2 & 0x3FF;
    }

    public static final double getDistanceDouble(int n2) {
        double d2 = LocaleDistance.getShiftedDistance(n2);
        return d2 / 8.0;
    }

    public static final int getDistanceFloor(int n2) {
        return (n2 & 0x3FF) >> 3;
    }

    public static final int getIndex(int n2) {
        assert (n2 >= 0);
        return n2 >> 10;
    }

    private LocaleDistance(Data data) {
        this.trie = new BytesTrie(data.trie, 0);
        this.regionToPartitionsIndex = data.regionToPartitionsIndex;
        this.partitionArrays = data.partitionArrays;
        this.paradigmLSRs = data.paradigmLSRs;
        this.defaultLanguageDistance = data.distances[0];
        this.defaultScriptDistance = data.distances[1];
        this.defaultRegionDistance = data.distances[2];
        this.minRegionDistance = data.distances[3];
        LSR lSR = new LSR("en", "Latn", "US", 7);
        LSR lSR2 = new LSR("en", "Latn", "GB", 7);
        int n2 = this.getBestIndexAndDistance(lSR, new LSR[]{lSR2}, 1, LocaleDistance.shiftDistance(50), LocaleMatcher.FavorSubtag.LANGUAGE, LocaleMatcher.Direction.WITH_ONE_WAY);
        this.defaultDemotionPerDesiredLocale = LocaleDistance.getDistanceFloor(n2);
    }

    public int testOnlyDistance(ULocale uLocale, ULocale uLocale2, int n2, LocaleMatcher.FavorSubtag favorSubtag) {
        LSR lSR = LikelySubtags.INSTANCE.makeMaximizedLsrFrom(uLocale2, false);
        LSR lSR2 = LikelySubtags.INSTANCE.makeMaximizedLsrFrom(uLocale, false);
        int n3 = this.getBestIndexAndDistance(lSR2, new LSR[]{lSR}, 1, LocaleDistance.shiftDistance(n2), favorSubtag, LocaleMatcher.Direction.WITH_ONE_WAY);
        return LocaleDistance.getDistanceFloor(n3);
    }

    public int getBestIndexAndDistance(LSR lSR, LSR[] lSRArray, int n2, int n3, LocaleMatcher.FavorSubtag favorSubtag, LocaleMatcher.Direction direction) {
        BytesTrie bytesTrie = new BytesTrie(this.trie);
        int n4 = LocaleDistance.trieNext(bytesTrie, lSR.language, false);
        long l2 = n4 >= 0 && n2 > 1 ? bytesTrie.getState64() : 0L;
        int n5 = -1;
        int n6 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n7;
            int n8;
            int n9;
            LSR lSR2 = lSRArray[i2];
            boolean bl2 = false;
            int n10 = n4;
            if (n10 >= 0) {
                assert ((n10 & 0x100) == 0);
                if (i2 != 0) {
                    bytesTrie.resetToState64(l2);
                }
                n10 = LocaleDistance.trieNext(bytesTrie, lSR2.language, true);
            }
            if (n10 >= 0) {
                n9 = n10 & 0x180;
                n10 &= 0xFFFFFE7F;
            } else {
                n10 = lSR.language.equals(lSR2.language) ? 0 : this.defaultLanguageDistance;
                n9 = 0;
                bl2 = true;
            }
            assert (0 <= n10 && n10 <= 100);
            int n11 = n3 + 7 >> 3;
            if (favorSubtag == LocaleMatcher.FavorSubtag.SCRIPT) {
                n10 >>= 2;
            }
            if (n10 > n11) continue;
            if (bl2 || n9 != 0) {
                n8 = lSR.script.equals(lSR2.script) ? 0 : this.defaultScriptDistance;
            } else {
                n8 = LocaleDistance.getDesSuppScriptDistance(bytesTrie, bytesTrie.getState64(), lSR.script, lSR2.script);
                n9 = n8 & 0x100;
                n8 &= 0xFFFFFEFF;
            }
            if ((n10 += n8) > n11) continue;
            if (!lSR.region.equals(lSR2.region)) {
                if (bl2 || (n9 & 0x100) != 0) {
                    n10 += this.defaultRegionDistance;
                } else {
                    n7 = n11 - n10;
                    if (this.minRegionDistance > n7) continue;
                    n10 += LocaleDistance.getRegionPartitionsDistance(bytesTrie, bytesTrie.getState64(), this.partitionsForRegion(lSR), this.partitionsForRegion(lSR2), n7);
                }
            }
            if ((n7 = LocaleDistance.shiftDistance(n10)) == 0) {
                if ((n7 |= lSR.flags ^ lSR2.flags) >= n3 || direction == LocaleMatcher.Direction.ONLY_TWO_WAY && !this.isMatch(lSR2, lSR, n3, favorSubtag)) continue;
                if (n7 == 0) {
                    return i2 << 10;
                }
                n5 = i2;
                n3 = n7;
                n6 = -1;
                continue;
            }
            if (n7 < n3) {
                if (direction == LocaleMatcher.Direction.ONLY_TWO_WAY && !this.isMatch(lSR2, lSR, n3, favorSubtag)) continue;
                n5 = i2;
                n3 = n7;
                n6 = -1;
                continue;
            }
            if (n7 != n3 || n5 < 0 || direction == LocaleMatcher.Direction.ONLY_TWO_WAY && !this.isMatch(lSR2, lSR, n3, favorSubtag) || ((n6 = LikelySubtags.INSTANCE.compareLikely(lSR2, lSRArray[n5], n6)) & 1) == 0) continue;
            n5 = i2;
        }
        return n5 >= 0 ? n5 << 10 | n3 : 0xFFFFFC00 | LocaleDistance.shiftDistance(100);
    }

    private boolean isMatch(LSR lSR, LSR lSR2, int n2, LocaleMatcher.FavorSubtag favorSubtag) {
        return this.getBestIndexAndDistance(lSR, new LSR[]{lSR2}, 1, n2, favorSubtag, null) >= 0;
    }

    private static final int getDesSuppScriptDistance(BytesTrie bytesTrie, long l2, String string, String string2) {
        int n2 = LocaleDistance.trieNext(bytesTrie, string, false);
        if (n2 >= 0) {
            n2 = LocaleDistance.trieNext(bytesTrie, string2, true);
        }
        if (n2 < 0) {
            BytesTrie.Result result = bytesTrie.resetToState64(l2).next(42);
            assert (result.hasValue());
            if (string.equals(string2)) {
                n2 = 0;
            } else {
                n2 = bytesTrie.getValue();
                assert (n2 >= 0);
            }
            if (result == BytesTrie.Result.FINAL_VALUE) {
                n2 |= 0x100;
            }
        }
        return n2;
    }

    private static final int getRegionPartitionsDistance(BytesTrie bytesTrie, long l2, String string, String string2, int n2) {
        int n3 = string.length();
        int n4 = string2.length();
        if (n3 == 1 && n4 == 1) {
            BytesTrie.Result result = bytesTrie.next(string.charAt(0) | 0x80);
            if (result.hasNext() && (result = bytesTrie.next(string2.charAt(0) | 0x80)).hasValue()) {
                return bytesTrie.getValue();
            }
            return LocaleDistance.getFallbackRegionDistance(bytesTrie, l2);
        }
        int n5 = 0;
        boolean bl2 = false;
        int n6 = 0;
        while (true) {
            BytesTrie.Result result;
            if ((result = bytesTrie.next(string.charAt(n6++) | 0x80)).hasNext()) {
                long l3 = n4 > 1 ? bytesTrie.getState64() : 0L;
                int n7 = 0;
                while (true) {
                    int n8;
                    if ((result = bytesTrie.next(string2.charAt(n7++) | 0x80)).hasValue()) {
                        n8 = bytesTrie.getValue();
                    } else if (bl2) {
                        n8 = 0;
                    } else {
                        n8 = LocaleDistance.getFallbackRegionDistance(bytesTrie, l2);
                        bl2 = true;
                    }
                    if (n8 > n2) {
                        return n8;
                    }
                    if (n5 < n8) {
                        n5 = n8;
                    }
                    if (n7 < n4) {
                        bytesTrie.resetToState64(l3);
                        continue;
                    }
                    break;
                }
            } else if (!bl2) {
                int n9 = LocaleDistance.getFallbackRegionDistance(bytesTrie, l2);
                if (n9 > n2) {
                    return n9;
                }
                if (n5 < n9) {
                    n5 = n9;
                }
                bl2 = true;
            }
            if (n6 >= n3) break;
            bytesTrie.resetToState64(l2);
        }
        return n5;
    }

    private static final int getFallbackRegionDistance(BytesTrie bytesTrie, long l2) {
        BytesTrie.Result result = bytesTrie.resetToState64(l2).next(42);
        assert (result.hasValue());
        int n2 = bytesTrie.getValue();
        assert (n2 >= 0);
        return n2;
    }

    private static final int trieNext(BytesTrie bytesTrie, String string, boolean bl2) {
        if (string.isEmpty()) {
            return -1;
        }
        int n2 = 0;
        int n3 = string.length() - 1;
        while (true) {
            char c2 = string.charAt(n2);
            if (n2 < n3) {
                if (!bytesTrie.next(c2).hasNext()) {
                    return -1;
                }
            } else {
                BytesTrie.Result result = bytesTrie.next(c2 | 0x80);
                if (bl2) {
                    if (result.hasValue()) {
                        int n4 = bytesTrie.getValue();
                        if (result == BytesTrie.Result.FINAL_VALUE) {
                            n4 |= 0x100;
                        }
                        return n4;
                    }
                } else if (result.hasNext()) {
                    return 0;
                }
                return -1;
            }
            ++n2;
        }
    }

    public String toString() {
        return this.testOnlyGetDistanceTable().toString();
    }

    private String partitionsForRegion(LSR lSR) {
        byte by2 = this.regionToPartitionsIndex[lSR.regionIndex];
        return this.partitionArrays[by2];
    }

    public boolean isParadigmLSR(LSR lSR) {
        assert (this.paradigmLSRs.size() <= 15);
        for (LSR lSR2 : this.paradigmLSRs) {
            if (!lSR.isEquivalentTo(lSR2)) continue;
            return true;
        }
        return false;
    }

    public int getDefaultScriptDistance() {
        return this.defaultScriptDistance;
    }

    int getDefaultRegionDistance() {
        return this.defaultRegionDistance;
    }

    public int getDefaultDemotionPerDesiredLocale() {
        return this.defaultDemotionPerDesiredLocale;
    }

    public Map<String, Integer> testOnlyGetDistanceTable() {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        StringBuilder stringBuilder = new StringBuilder();
        for (BytesTrie.Entry entry : this.trie) {
            stringBuilder.setLength(0);
            int n2 = entry.bytesLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                byte by2 = entry.byteAt(i2);
                if (by2 == 42) {
                    stringBuilder.append("*-*-");
                    continue;
                }
                if (by2 >= 0) {
                    stringBuilder.append((char)by2);
                    continue;
                }
                stringBuilder.append((char)(by2 & 0x7F)).append('-');
            }
            assert (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == '-');
            stringBuilder.setLength(stringBuilder.length() - 1);
            treeMap.put(stringBuilder.toString(), entry.value);
        }
        return treeMap;
    }

    public void testOnlyPrintDistanceTable() {
        for (Map.Entry<String, Integer> entry : this.testOnlyGetDistanceTable().entrySet()) {
            String string = "";
            int n2 = entry.getValue();
            if ((n2 & 0x80) != 0) {
                n2 &= 0xFFFFFF7F;
                string = " skip script";
            }
            System.out.println(entry.getKey() + '=' + n2 + string);
        }
    }

    public static final class Data {
        public byte[] trie;
        public byte[] regionToPartitionsIndex;
        public String[] partitionArrays;
        public Set<LSR> paradigmLSRs;
        public int[] distances;

        public Data(byte[] byArray, byte[] byArray2, String[] stringArray, Set<LSR> set, int[] nArray) {
            this.trie = byArray;
            this.regionToPartitionsIndex = byArray2;
            this.partitionArrays = stringArray;
            this.paradigmLSRs = set;
            this.distances = nArray;
        }

        private static UResource.Value getValue(UResource.Table table, String string, UResource.Value value) {
            if (!table.findValue(string, value)) {
                throw new MissingResourceException("langInfo.res missing data", "", "match/" + string);
            }
            return value;
        }

        public static Data load() throws MissingResourceException {
            Set<LSR> set;
            Object[] objectArray;
            ICUResourceBundle iCUResourceBundle = ICUResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "langInfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER, ICUResourceBundle.OpenType.DIRECT);
            UResource.Value value = iCUResourceBundle.getValueWithFallback("match");
            UResource.Table table = value.getTable();
            ByteBuffer byteBuffer = Data.getValue(table, "trie", value).getBinary();
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            byteBuffer = Data.getValue(table, "regionToPartitions", value).getBinary();
            byte[] byArray2 = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray2);
            if (byArray2.length < 1677) {
                throw new MissingResourceException("langInfo.res binary data too short", "", "match/regionToPartitions");
            }
            String[] stringArray = Data.getValue(table, "partitions", value).getStringArray();
            if (table.findValue("paradigmnum", value)) {
                objectArray = Data.getValue(iCUResourceBundle.getValueWithFallback("likely").getTable(), "m49", value).getStringArray();
                LSR[] lSRArray = LSR.decodeInts(Data.getValue(table, "paradigmnum", value).getIntVector(), (String[])objectArray);
                set = new LinkedHashSet<LSR>(Arrays.asList(lSRArray));
            } else {
                set = Collections.emptySet();
            }
            objectArray = Data.getValue(table, "distances", value).getIntVector();
            if (objectArray.length < 4) {
                throw new MissingResourceException("langInfo.res intvector too short", "", "match/distances");
            }
            return new Data(byArray, byArray2, stringArray, set, (int[])objectArray);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !this.getClass().equals(object.getClass())) {
                return false;
            }
            Data data = (Data)object;
            return Arrays.equals(this.trie, data.trie) && Arrays.equals(this.regionToPartitionsIndex, data.regionToPartitionsIndex) && Arrays.equals(this.partitionArrays, data.partitionArrays) && this.paradigmLSRs.equals(data.paradigmLSRs) && Arrays.equals(this.distances, data.distances);
        }

        public int hashCode() {
            return 1;
        }
    }
}

