/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TreeMap;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UResource;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale.LSR;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.BytesTrie;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Region;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public final class LikelySubtags {
    private static final String PSEUDO_ACCENTS_PREFIX = "'";
    private static final String PSEUDO_BIDI_PREFIX = "+";
    private static final String PSEUDO_CRACKED_PREFIX = ",";
    public static final int SKIP_SCRIPT = 1;
    private static final boolean DEBUG_OUTPUT = false;
    public static final LikelySubtags INSTANCE = new LikelySubtags(Data.load());
    private final Map<String, String> languageAliases;
    private final Map<String, String> regionAliases;
    private final BytesTrie trie;
    private final long trieUndState;
    private final long trieUndZzzzState;
    private final int defaultLsrIndex;
    private final long[] trieFirstLetterStates = new long[26];
    private final LSR[] lsrs;

    private LikelySubtags(Data data) {
        this.languageAliases = data.languageAliases;
        this.regionAliases = data.regionAliases;
        this.trie = new BytesTrie(data.trie, 0);
        this.lsrs = data.lsrs;
        BytesTrie.Result result = this.trie.next(42);
        assert (result.hasNext());
        this.trieUndState = this.trie.getState64();
        result = this.trie.next(42);
        assert (result.hasNext());
        this.trieUndZzzzState = this.trie.getState64();
        result = this.trie.next(42);
        assert (result.hasValue());
        this.defaultLsrIndex = this.trie.getValue();
        this.trie.reset();
        for (int n2 = 97; n2 <= 122; n2 = (int)((char)(n2 + 1))) {
            result = this.trie.next(n2);
            if (result == BytesTrie.Result.NO_VALUE) {
                this.trieFirstLetterStates[n2 - 97] = this.trie.getState64();
            }
            this.trie.reset();
        }
    }

    public ULocale canonicalize(ULocale uLocale) {
        String string = uLocale.getLanguage();
        String string2 = this.languageAliases.get(string);
        String string3 = uLocale.getCountry();
        String string4 = this.regionAliases.get(string3);
        if (string2 != null || string4 != null) {
            return new ULocale(string2 == null ? string : string2, uLocale.getScript(), string4 == null ? string3 : string4);
        }
        return uLocale;
    }

    private static String getCanonical(Map<String, String> map, String string) {
        String string2 = map.get(string);
        return string2 == null ? string : string2;
    }

    public LSR makeMaximizedLsrFrom(ULocale uLocale, boolean bl2) {
        String string = uLocale.getName();
        if (string.startsWith("@x=")) {
            String string2 = uLocale.toLanguageTag();
            assert (string2.startsWith("und-x-"));
            return new LSR(string2, "", "", 7);
        }
        LSR lSR = this.makeMaximizedLsr(uLocale.getLanguage(), uLocale.getScript(), uLocale.getCountry(), uLocale.getVariant(), bl2);
        if (lSR.language.isEmpty() && lSR.script.isEmpty() && lSR.region.isEmpty()) {
            return new LSR(uLocale.getLanguage(), uLocale.getScript(), uLocale.getCountry(), 7);
        }
        return lSR;
    }

    public LSR makeMaximizedLsrFrom(Locale locale) {
        String string = locale.toLanguageTag();
        if (string.startsWith("x-") || string.startsWith("und-x-")) {
            return new LSR(string, "", "", 7);
        }
        return this.makeMaximizedLsr(locale.getLanguage(), locale.getScript(), locale.getCountry(), locale.getVariant(), false);
    }

    private LSR makeMaximizedLsr(String string, String string2, String string3, String string4, boolean bl2) {
        if (string3.length() == 2 && string3.charAt(0) == 'X') {
            switch (string3.charAt(1)) {
                case 'A': {
                    if (bl2) {
                        return new LSR(string, string2, string3, 7);
                    }
                    return new LSR(PSEUDO_ACCENTS_PREFIX + string, PSEUDO_ACCENTS_PREFIX + string2, string3, 7);
                }
                case 'B': {
                    if (bl2) {
                        return new LSR(string, string2, string3, 7);
                    }
                    return new LSR(PSEUDO_BIDI_PREFIX + string, PSEUDO_BIDI_PREFIX + string2, string3, 7);
                }
                case 'C': {
                    if (bl2) {
                        return new LSR(string, string2, string3, 7);
                    }
                    return new LSR(PSEUDO_CRACKED_PREFIX + string, PSEUDO_CRACKED_PREFIX + string2, string3, 7);
                }
            }
        }
        if (string4.startsWith("PS")) {
            int n2 = string3.isEmpty() ? 6 : 7;
            switch (string4) {
                case "PSACCENT": {
                    return new LSR(PSEUDO_ACCENTS_PREFIX + string, PSEUDO_ACCENTS_PREFIX + string2, string3.isEmpty() ? "XA" : string3, n2);
                }
                case "PSBIDI": {
                    return new LSR(PSEUDO_BIDI_PREFIX + string, PSEUDO_BIDI_PREFIX + string2, string3.isEmpty() ? "XB" : string3, n2);
                }
                case "PSCRACK": {
                    return new LSR(PSEUDO_CRACKED_PREFIX + string, PSEUDO_CRACKED_PREFIX + string2, string3.isEmpty() ? "XC" : string3, n2);
                }
            }
        }
        string = LikelySubtags.getCanonical(this.languageAliases, string);
        string3 = LikelySubtags.getCanonical(this.regionAliases, string3);
        return this.maximize(string, string2, string3, bl2);
    }

    private boolean isMacroregion(String string) {
        Region.RegionType regionType = Region.getInstance(string).getType();
        return regionType == Region.RegionType.WORLD || regionType == Region.RegionType.CONTINENT || regionType == Region.RegionType.SUBCONTINENT;
    }

    private LSR maximize(String string, String string2, String string3, boolean bl2) {
        long l2;
        int n2;
        if (string.equals("und")) {
            string = "";
        }
        if (string2.equals("Zzzz")) {
            string2 = "";
        }
        if (string3.equals("ZZ")) {
            string3 = "";
        }
        if (!(string2.isEmpty() || string3.isEmpty() || string.isEmpty())) {
            return new LSR(string, string2, string3, 7);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        BytesTrie bytesTrie = new BytesTrie(this.trie);
        int n3 = string.length() >= 2 && 0 <= (n2 = string.charAt(0) - 97) && n2 <= 25 && (l2 = this.trieFirstLetterStates[n2]) != 0L ? LikelySubtags.trieNext(bytesTrie.resetToState64(l2), string, 1) : LikelySubtags.trieNext(bytesTrie, string, 0);
        boolean bl6 = n3 >= 0;
        boolean bl7 = false;
        if (n3 >= 0) {
            bl3 = !string.isEmpty();
            l2 = bytesTrie.getState64();
        } else {
            bl3 = true;
            bytesTrie.resetToState64(this.trieUndState);
            l2 = 0L;
        }
        if (n3 >= 0 && !string2.isEmpty()) {
            bl7 = true;
        }
        if (n3 > 0) {
            if (n3 == 1) {
                n3 = 0;
            }
            bl4 = !string2.isEmpty();
        } else {
            n3 = LikelySubtags.trieNext(bytesTrie, string2, 0);
            if (n3 >= 0) {
                bl4 = !string2.isEmpty();
                l2 = bytesTrie.getState64();
            } else {
                bl4 = true;
                if (l2 == 0L) {
                    bytesTrie.resetToState64(this.trieUndZzzzState);
                } else {
                    bytesTrie.resetToState64(l2);
                    n3 = LikelySubtags.trieNext(bytesTrie, "", 0);
                    assert (n3 >= 0);
                    l2 = bytesTrie.getState64();
                }
            }
        }
        boolean bl8 = false;
        if (n3 > 0) {
            bl5 = !string3.isEmpty();
        } else {
            n3 = LikelySubtags.trieNext(bytesTrie, string3, 0);
            if (n3 >= 0) {
                if (!string3.isEmpty() && !this.isMacroregion(string3)) {
                    bl5 = true;
                    bl8 = true;
                }
            } else {
                bl5 = true;
                if (l2 == 0L) {
                    n3 = this.defaultLsrIndex;
                } else {
                    bytesTrie.resetToState64(l2);
                    n3 = LikelySubtags.trieNext(bytesTrie, "", 0);
                    assert (n3 > 0);
                }
            }
        }
        LSR lSR = this.lsrs[n3];
        if (!(!bl2 || bl6 || bl7 || bl8 && string.isEmpty())) {
            return new LSR("", "", "", 7);
        }
        if (string.isEmpty()) {
            string = "und";
        }
        if (!(bl3 || bl4 || bl5)) {
            assert (lSR.flags == 0);
            return lSR;
        }
        if (!bl3) {
            string = lSR.language;
        }
        if (!bl4) {
            string2 = lSR.script;
        }
        if (!bl5) {
            string3 = lSR.region;
        }
        int n4 = (bl3 ? 4 : 0) + (bl4 ? 2 : 0) + (bl5 ? 1 : 0);
        return new LSR(string, string2, string3, n4);
    }

    int compareLikely(LSR lSR, LSR lSR2, int n2) {
        if (!lSR.language.equals(lSR2.language)) {
            return -4;
        }
        if (!lSR.script.equals(lSR2.script)) {
            int n3;
            if (n2 >= 0 && (n2 & 2) == 0) {
                n3 = n2 >> 2;
            } else {
                n3 = this.getLikelyIndex(lSR.language, "");
                n2 = n3 << 2;
            }
            LSR lSR3 = this.lsrs[n3];
            if (lSR.script.equals(lSR3.script)) {
                return n2 | 1;
            }
            return n2 & 0xFFFFFFFE;
        }
        if (!lSR.region.equals(lSR2.region)) {
            int n4;
            if (n2 >= 0 && (n2 & 2) != 0) {
                n4 = n2 >> 2;
            } else {
                n4 = this.getLikelyIndex(lSR.language, lSR.region);
                n2 = n4 << 2 | 2;
            }
            LSR lSR4 = this.lsrs[n4];
            if (lSR.region.equals(lSR4.region)) {
                return n2 | 1;
            }
            return n2 & 0xFFFFFFFE;
        }
        return n2 & 0xFFFFFFFE;
    }

    private int getLikelyIndex(String string, String string2) {
        long l2;
        int n2;
        if (string.equals("und")) {
            string = "";
        }
        if (string2.equals("Zzzz")) {
            string2 = "";
        }
        BytesTrie bytesTrie = new BytesTrie(this.trie);
        int n3 = string.length() >= 2 && 0 <= (n2 = string.charAt(0) - 97) && n2 <= 25 && (l2 = this.trieFirstLetterStates[n2]) != 0L ? LikelySubtags.trieNext(bytesTrie.resetToState64(l2), string, 1) : LikelySubtags.trieNext(bytesTrie, string, 0);
        if (n3 >= 0) {
            l2 = bytesTrie.getState64();
        } else {
            bytesTrie.resetToState64(this.trieUndState);
            l2 = 0L;
        }
        if (n3 > 0) {
            if (n3 == 1) {
                n3 = 0;
            }
        } else {
            n3 = LikelySubtags.trieNext(bytesTrie, string2, 0);
            if (n3 >= 0) {
                l2 = bytesTrie.getState64();
            } else if (l2 == 0L) {
                bytesTrie.resetToState64(this.trieUndZzzzState);
            } else {
                bytesTrie.resetToState64(l2);
                n3 = LikelySubtags.trieNext(bytesTrie, "", 0);
                assert (n3 >= 0);
                l2 = bytesTrie.getState64();
            }
        }
        if (n3 <= 0) {
            n3 = LikelySubtags.trieNext(bytesTrie, "", 0);
            assert (n3 > 0);
        }
        return n3;
    }

    private static final int trieNext(BytesTrie bytesTrie, String string, int n2) {
        BytesTrie.Result result;
        if (string.isEmpty()) {
            result = bytesTrie.next(42);
        } else {
            int n3 = string.length() - 1;
            while (true) {
                char c2 = string.charAt(n2);
                if (n2 >= n3) {
                    result = bytesTrie.next(c2 | 0x80);
                    break;
                }
                if (!bytesTrie.next(c2).hasNext()) {
                    return -1;
                }
                ++n2;
            }
        }
        switch (result) {
            case NO_MATCH: {
                return -1;
            }
            case NO_VALUE: {
                return 0;
            }
            case INTERMEDIATE_VALUE: {
                assert (bytesTrie.getValue() == 1);
                return 1;
            }
            case FINAL_VALUE: {
                return bytesTrie.getValue();
            }
        }
        return -1;
    }

    public LSR minimizeSubtags(String string, String string2, String string3, ULocale.Minimize minimize) {
        LSR lSR = this.maximize(string, string2, string3, true);
        if (lSR.language.isEmpty() && lSR.region.isEmpty() && lSR.script.isEmpty()) {
            return new LSR(string, string2, string3, 7);
        }
        LSR lSR2 = this.maximize(lSR.language, "", "", true);
        if (lSR2.isEquivalentTo(lSR)) {
            return new LSR(lSR.language, "", "", 0);
        }
        if (ULocale.Minimize.FAVOR_REGION == minimize) {
            lSR2 = this.maximize(lSR.language, "", lSR.region, true);
            if (lSR2.isEquivalentTo(lSR)) {
                return new LSR(lSR.language, "", lSR.region, 0);
            }
            lSR2 = this.maximize(lSR.language, lSR.script, "", true);
            if (lSR2.isEquivalentTo(lSR)) {
                return new LSR(lSR.language, lSR.script, "", 0);
            }
        } else {
            lSR2 = this.maximize(lSR.language, lSR.script, "", true);
            if (lSR2.isEquivalentTo(lSR)) {
                return new LSR(lSR.language, lSR.script, "", 0);
            }
            lSR2 = this.maximize(lSR.language, "", lSR.region, true);
            if (lSR2.isEquivalentTo(lSR)) {
                return new LSR(lSR.language, "", lSR.region, 0);
            }
        }
        return new LSR(lSR.language, lSR.script, lSR.region, 0);
    }

    private Map<String, LSR> getTable() {
        TreeMap<String, LSR> treeMap = new TreeMap<String, LSR>();
        StringBuilder stringBuilder = new StringBuilder();
        for (BytesTrie.Entry entry : this.trie) {
            stringBuilder.setLength(0);
            int n2 = entry.bytesLength();
            int n3 = 0;
            while (n3 < n2) {
                byte by2;
                if ((by2 = entry.byteAt(n3++)) == 42) {
                    stringBuilder.append("*-");
                    continue;
                }
                if (by2 >= 0) {
                    stringBuilder.append((char)by2);
                    continue;
                }
                stringBuilder.append((char)(by2 & 0x7F)).append('-');
            }
            assert (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) == '-');
            stringBuilder.setLength(stringBuilder.length() - 1);
            treeMap.put(stringBuilder.toString(), this.lsrs[entry.value]);
        }
        return treeMap;
    }

    public String toString() {
        return this.getTable().toString();
    }

    public static final class Data {
        public final Map<String, String> languageAliases;
        public final Map<String, String> regionAliases;
        public final byte[] trie;
        public final LSR[] lsrs;

        public Data(Map<String, String> map, Map<String, String> map2, byte[] byArray, LSR[] lSRArray) {
            this.languageAliases = map;
            this.regionAliases = map2;
            this.trie = byArray;
            this.lsrs = lSRArray;
        }

        private static UResource.Value getValue(UResource.Table table, String string, UResource.Value value) {
            if (!table.findValue(string, value)) {
                throw new MissingResourceException("langInfo.res missing data", "", "likely/" + string);
            }
            return value;
        }

        public static Data load() throws MissingResourceException {
            Map<String, String> map;
            Object object;
            ICUResourceBundle iCUResourceBundle = ICUResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "langInfo", ICUResourceBundle.ICU_DATA_CLASS_LOADER, ICUResourceBundle.OpenType.DIRECT);
            UResource.Value value = iCUResourceBundle.getValueWithFallback("likely");
            UResource.Table table = value.getTable();
            if (table.findValue("languageAliases", value)) {
                object = value.getStringArray();
                map = new HashMap(((String[])object).length / 2);
                for (int i2 = 0; i2 < ((String[])object).length; i2 += 2) {
                    map.put(object[i2], object[i2 + 1]);
                }
            } else {
                map = Collections.emptyMap();
            }
            if (table.findValue("regionAliases", value)) {
                String[] stringArray = value.getStringArray();
                object = new HashMap(stringArray.length / 2);
                for (int i3 = 0; i3 < stringArray.length; i3 += 2) {
                    object.put(stringArray[i3], stringArray[i3 + 1]);
                }
            } else {
                object = Collections.emptyMap();
            }
            ByteBuffer byteBuffer = Data.getValue(table, "trie", value).getBinary();
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            String[] stringArray = Data.getValue(table, "m49", value).getStringArray();
            LSR[] lSRArray = LSR.decodeInts(Data.getValue(table, "lsrnum", value).getIntVector(), stringArray);
            return new Data(map, (Map<String, String>)object, byArray, lSRArray);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || !this.getClass().equals(object.getClass())) {
                return false;
            }
            Data data = (Data)object;
            return this.languageAliases.equals(data.languageAliases) && this.regionAliases.equals(data.regionAliases) && Arrays.equals(this.trie, data.trie) && Arrays.equals(this.lsrs, data.lsrs);
        }

        public int hashCode() {
            return 1;
        }
    }
}

