/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.locale;

import java.util.List;
import java.util.Objects;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UScript;

public final class LSR {
    public static final int REGION_INDEX_LIMIT = 1677;
    public static final int EXPLICIT_LSR = 7;
    public static final int EXPLICIT_LANGUAGE = 4;
    public static final int EXPLICIT_SCRIPT = 2;
    public static final int EXPLICIT_REGION = 1;
    public static final int IMPLICIT_LSR = 0;
    public static final int DONT_CARE_FLAGS = 0;
    public static final boolean DEBUG_OUTPUT = false;
    public final String language;
    public final String script;
    public final String region;
    final int regionIndex;
    public final int flags;

    public LSR(String string, String string2, String string3, int n2) {
        this.language = string;
        this.script = string2;
        this.region = string3;
        this.regionIndex = LSR.indexForRegion(string3);
        this.flags = n2;
    }

    public static final int indexForRegion(String string) {
        if (string.length() == 2) {
            int n2 = string.charAt(0) - 65;
            if (n2 < 0 || 25 < n2) {
                return 0;
            }
            int n3 = string.charAt(1) - 65;
            if (n3 < 0 || 25 < n3) {
                return 0;
            }
            return 26 * n2 + n3 + 1001;
        }
        if (string.length() == 3) {
            int n4 = string.charAt(0) - 48;
            if (n4 < 0 || 9 < n4) {
                return 0;
            }
            int n5 = string.charAt(1) - 48;
            if (n5 < 0 || 9 < n5) {
                return 0;
            }
            int n6 = string.charAt(2) - 48;
            if (n6 < 0 || 9 < n6) {
                return 0;
            }
            return (10 * n4 + n5) * 10 + n6 + 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.language);
        if (!this.script.isEmpty()) {
            stringBuilder.append('-').append(this.script);
        }
        if (!this.region.isEmpty()) {
            stringBuilder.append('-').append(this.region);
        }
        return stringBuilder.toString();
    }

    public boolean isEquivalentTo(LSR lSR) {
        return this.language.equals(lSR.language) && this.script.equals(lSR.script) && this.region.equals(lSR.region);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) return true;
        if (object == null) return false;
        if (object.getClass() != this.getClass()) return false;
        LSR lSR = (LSR)object;
        if (!this.language.equals(lSR.language)) return false;
        if (!this.script.equals(lSR.script)) return false;
        if (!this.region.equals(lSR.region)) return false;
        if (this.flags != lSR.flags) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.language, this.script, this.region, this.flags);
    }

    private int encodeLanguageToInt() {
        assert (this.language.length() >= 2);
        assert (this.language.length() <= 3);
        assert (this.language.charAt(0) >= 'a');
        assert (this.language.charAt(0) <= 'z');
        assert (this.language.charAt(1) >= 'a');
        assert (this.language.charAt(1) <= 'z');
        assert (this.language.length() == 2 || this.language.charAt(2) >= 'a');
        assert (this.language.length() == 2 || this.language.charAt(2) <= 'z');
        return this.language.charAt(0) - 97 + 1 + 27 * (this.language.charAt(1) - 97 + 1) + (this.language.length() == 2 ? 0 : 729 * (this.language.charAt(2) - 97 + 1));
    }

    private int encodeScriptToInt() {
        int n2 = UScript.getCodeFromName(this.script);
        assert (n2 != -1);
        return n2;
    }

    private int encodeRegionToInt(List<String> list) {
        assert (this.region.length() >= 2);
        assert (this.region.length() <= 3);
        if (this.region.length() == 3) {
            int n2 = list.indexOf(this.region);
            assert (n2 >= 0);
            if (n2 < 0) {
                throw new IllegalStateException("Please add '" + this.region + "' to M49 in LocaleDistanceMapper.java");
            }
            return n2;
        }
        assert (this.region.charAt(0) >= 'A');
        assert (this.region.charAt(0) <= 'Z');
        assert (this.region.charAt(1) >= 'A');
        assert (this.region.charAt(1) <= 'Z');
        return this.region.charAt(0) - 65 + 1 + 27 * (this.region.charAt(1) - 65 + 1);
    }

    public int encodeToIntForResource(List<String> list) {
        return this.encodeLanguageToInt() + 19683 * this.encodeRegionToInt(list) | this.encodeScriptToInt() << 24;
    }

    private static String toLanguage(int n2) {
        if (n2 == 0) {
            return "";
        }
        if (n2 == 1) {
            return "skip";
        }
        n2 &= 0xFFFFFF;
        StringBuilder stringBuilder = new StringBuilder(3);
        stringBuilder.append((char)(97 + ((n2 %= 19683) % 27 - 1)));
        stringBuilder.append((char)(97 + (n2 / 27 % 27 - 1)));
        if (n2 / 729 != 0) {
            stringBuilder.append((char)(97 + (n2 / 729 - 1)));
        }
        return stringBuilder.toString();
    }

    private static String toScript(int n2) {
        if (n2 == 0) {
            return "";
        }
        if (n2 == 1) {
            return "script";
        }
        n2 = n2 >> 24 & 0xFF;
        return UScript.getShortName(n2);
    }

    private static String toRegion(int n2, String[] stringArray) {
        if (n2 == 0 || n2 == 1) {
            return "";
        }
        n2 &= 0xFFFFFF;
        n2 /= 19683;
        if ((n2 %= 729) < 27) {
            return stringArray[n2];
        }
        StringBuilder stringBuilder = new StringBuilder(3);
        stringBuilder.append((char)(65 + (n2 % 27 - 1)));
        stringBuilder.append((char)(65 + (n2 / 27 % 27 - 1)));
        return stringBuilder.toString();
    }

    public static LSR[] decodeInts(int[] nArray, String[] stringArray) {
        LSR[] lSRArray = new LSR[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            lSRArray[i2] = new LSR(LSR.toLanguage(n2), LSR.toScript(n2), LSR.toRegion(n2, stringArray), 0);
        }
        return lSRArray;
    }
}

