/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.impl;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.impl.RecordReader;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;

public class XMLRecordReader
implements RecordReader {
    private Reader r;
    private List<String> nameStack;
    private boolean atTag;
    private String tag;

    public XMLRecordReader(Reader reader) {
        this.r = reader;
        this.nameStack = new ArrayList<String>();
        if (this.getTag().startsWith("?xml")) {
            this.advance();
        }
        if (this.getTag().startsWith("!--")) {
            this.advance();
        }
    }

    @Override
    public boolean open(String string) {
        if (this.getTag().equals(string)) {
            this.nameStack.add(string);
            this.advance();
            return true;
        }
        return false;
    }

    @Override
    public boolean close() {
        int n2 = this.nameStack.size() - 1;
        String string = this.nameStack.get(n2);
        if (this.getTag().equals("/" + string)) {
            this.nameStack.remove(n2);
            this.advance();
            return true;
        }
        return false;
    }

    @Override
    public boolean bool(String string) {
        String string2 = this.string(string);
        if (string2 != null) {
            return "true".equals(string2);
        }
        return false;
    }

    @Override
    public boolean[] boolArray(String string) {
        String[] stringArray = this.stringArray(string);
        if (stringArray != null) {
            boolean[] blArray = new boolean[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                blArray[i2] = "true".equals(stringArray[i2]);
            }
            return blArray;
        }
        return null;
    }

    @Override
    public char character(String string) {
        String string2 = this.string(string);
        if (string2 != null) {
            return string2.charAt(0);
        }
        return '\uffff';
    }

    @Override
    public char[] characterArray(String string) {
        String[] stringArray = this.stringArray(string);
        if (stringArray != null) {
            char[] cArray = new char[stringArray.length];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                cArray[i2] = stringArray[i2].charAt(0);
            }
            return cArray;
        }
        return null;
    }

    @Override
    public byte namedIndex(String string, String[] stringArray) {
        String string2 = this.string(string);
        if (string2 != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!string2.equals(stringArray[i2])) continue;
                return (byte)i2;
            }
        }
        return -1;
    }

    @Override
    public byte[] namedIndexArray(String string, String[] stringArray) {
        String[] stringArray2 = this.stringArray(string);
        if (stringArray2 != null) {
            byte[] byArray = new byte[stringArray2.length];
            block0: for (int i2 = 0; i2 < stringArray2.length; ++i2) {
                String string2 = stringArray2[i2];
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    if (!stringArray[i3].equals(string2)) continue;
                    byArray[i2] = (byte)i3;
                    continue block0;
                }
                byArray[i2] = -1;
            }
            return byArray;
        }
        return null;
    }

    @Override
    public String string(String string) {
        if (this.match(string)) {
            String string2 = this.readData();
            if (this.match("/" + string)) {
                return string2;
            }
        }
        return null;
    }

    @Override
    public String[] stringArray(String string) {
        if (this.match(string + "List")) {
            String string2;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (null != (string2 = this.string(string))) {
                if ("Null".equals(string2)) {
                    string2 = null;
                }
                arrayList.add(string2);
            }
            if (this.match("/" + string + "List")) {
                return arrayList.toArray(new String[arrayList.size()]);
            }
        }
        return null;
    }

    @Override
    public String[][] stringTable(String string) {
        if (this.match(string + "Table")) {
            String[] stringArray;
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            while (null != (stringArray = this.stringArray(string))) {
                arrayList.add(stringArray);
            }
            if (this.match("/" + string + "Table")) {
                return (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
            }
        }
        return null;
    }

    private boolean match(String string) {
        if (this.getTag().equals(string)) {
            this.advance();
            return true;
        }
        return false;
    }

    private String getTag() {
        if (this.tag == null) {
            this.tag = this.readNextTag();
        }
        return this.tag;
    }

    private void advance() {
        this.tag = null;
    }

    private String readData() {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        while (true) {
            if ((n2 = this.readChar()) == -1 || n2 == 60) break;
            if (n2 == 38) {
                StringBuilder stringBuilder2;
                n2 = this.readChar();
                if (n2 == 35) {
                    stringBuilder2 = new StringBuilder();
                    int n3 = 10;
                    n2 = this.readChar();
                    if (n2 == 120) {
                        n3 = 16;
                        n2 = this.readChar();
                    }
                    while (n2 != 59 && n2 != -1) {
                        stringBuilder2.append((char)n2);
                        n2 = this.readChar();
                    }
                    try {
                        int n4 = Integer.parseInt(stringBuilder2.toString(), n3);
                        n2 = (char)n4;
                    }
                    catch (NumberFormatException numberFormatException) {
                        System.err.println("numbuf: " + stringBuilder2.toString() + " radix: " + n3);
                        throw numberFormatException;
                    }
                } else {
                    stringBuilder2 = new StringBuilder();
                    while (n2 != 59 && n2 != -1) {
                        stringBuilder2.append((char)n2);
                        n2 = this.readChar();
                    }
                    String string = stringBuilder2.toString();
                    if (string.equals("lt")) {
                        n2 = 60;
                    } else if (string.equals("gt")) {
                        n2 = 62;
                    } else if (string.equals("quot")) {
                        n2 = 34;
                    } else if (string.equals("apos")) {
                        n2 = 39;
                    } else if (string.equals("amp")) {
                        n2 = 38;
                    } else {
                        System.err.println("unrecognized character entity: '" + string + "'");
                        continue;
                    }
                }
            }
            if (UCharacter.isWhitespace(n2)) {
                if (bl2) continue;
                n2 = 32;
                bl2 = true;
            } else {
                bl2 = false;
            }
            stringBuilder.append((char)n2);
        }
        this.atTag = n2 == 60;
        return stringBuilder.toString();
    }

    private String readNextTag() {
        int n2 = 0;
        while (!this.atTag) {
            n2 = this.readChar();
            if (n2 == 60 || n2 == -1) {
                if (n2 != 60) break;
                this.atTag = true;
                break;
            }
            if (UCharacter.isWhitespace(n2)) continue;
            System.err.println("Unexpected non-whitespace character " + Integer.toHexString(n2));
            break;
        }
        if (this.atTag) {
            this.atTag = false;
            StringBuilder stringBuilder = new StringBuilder();
            while ((n2 = this.readChar()) != 62 && n2 != -1) {
                stringBuilder.append((char)n2);
            }
            return stringBuilder.toString();
        }
        return null;
    }

    int readChar() {
        try {
            return this.r.read();
        }
        catch (IOException iOException) {
            return -1;
        }
    }
}

