/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.impl;

import java.util.Arrays;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.TimeUnit;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.impl.DataRecord;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.impl.Utils;

public class PeriodFormatterData {
    final DataRecord dr;
    String localeName;
    public static boolean trace = false;
    private static final int FORM_PLURAL = 0;
    private static final int FORM_SINGULAR = 1;
    private static final int FORM_DUAL = 2;
    private static final int FORM_PAUCAL = 3;
    private static final int FORM_SINGULAR_SPELLED = 4;
    private static final int FORM_SINGULAR_NO_OMIT = 5;
    private static final int FORM_HALF_SPELLED = 6;

    public PeriodFormatterData(String string, DataRecord dataRecord) {
        this.dr = dataRecord;
        this.localeName = string;
        if (string == null) {
            throw new NullPointerException("localename is null");
        }
        if (dataRecord == null) {
            throw new NullPointerException("data record is null");
        }
    }

    public int pluralization() {
        return this.dr.pl;
    }

    public boolean allowZero() {
        return this.dr.allowZero;
    }

    public boolean weeksAloneOnly() {
        return this.dr.weeksAloneOnly;
    }

    public int useMilliseconds() {
        return this.dr.useMilliseconds;
    }

    public boolean appendPrefix(int n2, int n3, StringBuffer stringBuffer) {
        String string;
        int n4;
        DataRecord.ScopeData scopeData;
        if (this.dr.scopeData != null && (scopeData = this.dr.scopeData[n4 = n2 * 3 + n3]) != null && (string = scopeData.prefix) != null) {
            stringBuffer.append(string);
            return scopeData.requiresDigitPrefix;
        }
        return false;
    }

    public void appendSuffix(int n2, int n3, StringBuffer stringBuffer) {
        String string;
        int n4;
        DataRecord.ScopeData scopeData;
        if (this.dr.scopeData != null && (scopeData = this.dr.scopeData[n4 = n2 * 3 + n3]) != null && (string = scopeData.suffix) != null) {
            if (trace) {
                System.out.println("appendSuffix '" + string + "'");
            }
            stringBuffer.append(string);
        }
    }

    public boolean appendUnit(TimeUnit timeUnit, int n2, int n3, int n4, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, StringBuffer stringBuffer) {
        int n5 = timeUnit.ordinal();
        boolean bl7 = false;
        if (this.dr.requiresSkipMarker != null && this.dr.requiresSkipMarker[n5] && this.dr.skippedUnitMarker != null) {
            if (!bl6 && bl5) {
                stringBuffer.append(this.dr.skippedUnitMarker);
            }
            bl7 = true;
        }
        if (n4 != 0) {
            String[] stringArray;
            boolean bl8 = n4 == 1;
            String[] stringArray2 = stringArray = bl8 ? this.dr.mediumNames : this.dr.shortNames;
            if (stringArray == null || stringArray[n5] == null) {
                String[] stringArray3 = stringArray = bl8 ? this.dr.shortNames : this.dr.mediumNames;
            }
            if (stringArray != null && stringArray[n5] != null) {
                this.appendCount(timeUnit, false, false, n2, n3, bl2, stringArray[n5], bl5, stringBuffer);
                return false;
            }
        }
        if (n3 == 2 && this.dr.halfSupport != null) {
            switch (this.dr.halfSupport[n5]) {
                case 0: {
                    break;
                }
                case 2: {
                    if (n2 > 1000) break;
                }
                case 1: {
                    n2 = n2 / 500 * 500;
                    n3 = 3;
                }
            }
        }
        String string = null;
        int n6 = this.computeForm(timeUnit, n2, n3, bl4 && bl5);
        if (n6 == 4) {
            if (this.dr.singularNames == null) {
                n6 = 1;
                string = this.dr.pluralNames[n5][n6];
            } else {
                string = this.dr.singularNames[n5];
            }
        } else if (n6 == 5) {
            string = this.dr.pluralNames[n5][1];
        } else if (n6 == 6) {
            string = this.dr.halfNames[n5];
        } else {
            try {
                string = this.dr.pluralNames[n5][n6];
            }
            catch (NullPointerException nullPointerException) {
                System.out.println("Null Pointer in PeriodFormatterData[" + this.localeName + "].au px: " + n5 + " form: " + n6 + " pn: " + Arrays.toString((Object[])this.dr.pluralNames));
                throw nullPointerException;
            }
        }
        if (string == null) {
            n6 = 0;
            string = this.dr.pluralNames[n5][n6];
        }
        boolean bl9 = n6 == 4 || n6 == 6 || this.dr.omitSingularCount && n6 == 1 || this.dr.omitDualCount && n6 == 2;
        int n7 = this.appendCount(timeUnit, bl9, bl3, n2, n3, bl2, string, bl5, stringBuffer);
        if (bl5 && n7 >= 0) {
            String string2 = null;
            if (this.dr.rqdSuffixes != null && n7 < this.dr.rqdSuffixes.length) {
                string2 = this.dr.rqdSuffixes[n7];
            }
            if (string2 == null && this.dr.optSuffixes != null && n7 < this.dr.optSuffixes.length) {
                string2 = this.dr.optSuffixes[n7];
            }
            if (string2 != null) {
                stringBuffer.append(string2);
            }
        }
        return bl7;
    }

    public int appendCount(TimeUnit timeUnit, boolean bl2, boolean bl3, int n2, int n3, boolean bl4, String string, boolean bl5, StringBuffer stringBuffer) {
        String string2;
        if (n3 == 2 && this.dr.halves == null) {
            n3 = 0;
        }
        if (!bl2 && bl3 && this.dr.digitPrefix != null) {
            stringBuffer.append(this.dr.digitPrefix);
        }
        int n4 = timeUnit.ordinal();
        block0 : switch (n3) {
            case 0: {
                if (bl2) break;
                this.appendInteger(n2 / 1000, 1, 10, stringBuffer);
                break;
            }
            case 1: {
                int n5 = n2 / 1000;
                if (timeUnit == TimeUnit.MINUTE && (this.dr.fiveMinutes != null || this.dr.fifteenMinutes != null) && n5 != 0 && n5 % 5 == 0) {
                    if (this.dr.fifteenMinutes != null && (n5 == 15 || n5 == 45)) {
                        int n6 = n5 = n5 == 15 ? 1 : 3;
                        if (!bl2) {
                            this.appendInteger(n5, 1, 10, stringBuffer);
                        }
                        string = this.dr.fifteenMinutes;
                        n4 = 8;
                        break;
                    }
                    if (this.dr.fiveMinutes != null) {
                        n5 /= 5;
                        if (!bl2) {
                            this.appendInteger(n5, 1, 10, stringBuffer);
                        }
                        string = this.dr.fiveMinutes;
                        n4 = 9;
                        break;
                    }
                }
                if (bl2) break;
                this.appendInteger(n5, 1, 10, stringBuffer);
                break;
            }
            case 2: {
                int n7;
                int n5 = n2 / 500;
                if (n5 != 1 && !bl2) {
                    this.appendCountValue(n2, 1, 0, stringBuffer);
                }
                if ((n5 & 1) != 1) break;
                if (n5 == 1 && this.dr.halfNames != null && this.dr.halfNames[n4] != null) {
                    stringBuffer.append(string);
                    return bl5 ? n4 : -1;
                }
                int n8 = n7 = n5 == 1 ? 0 : 1;
                if (this.dr.genders != null && this.dr.halves.length > 2 && this.dr.genders[n4] == 1) {
                    n7 += 2;
                }
                byte by2 = this.dr.halfPlacements == null ? (byte)0 : this.dr.halfPlacements[n7 & 1];
                String string3 = this.dr.halves[n7];
                String string4 = this.dr.measures == null ? null : this.dr.measures[n4];
                switch (by2) {
                    case 0: {
                        stringBuffer.append(string3);
                        break block0;
                    }
                    case 1: {
                        if (string4 != null) {
                            stringBuffer.append(string4);
                            stringBuffer.append(string3);
                            if (bl4 && !bl2) {
                                stringBuffer.append(this.dr.countSep);
                            }
                        } else {
                            stringBuffer.append(string);
                            stringBuffer.append(string3);
                            return bl5 ? n4 : -1;
                        }
                        stringBuffer.append(string);
                        return -1;
                    }
                    case 2: {
                        if (string4 != null) {
                            stringBuffer.append(string4);
                        }
                        if (bl4 && !bl2) {
                            stringBuffer.append(this.dr.countSep);
                        }
                        stringBuffer.append(string);
                        stringBuffer.append(string3);
                        return bl5 ? n4 : -1;
                    }
                }
                break;
            }
            default: {
                int n5 = 1;
                switch (n3) {
                    case 4: {
                        n5 = 2;
                        break;
                    }
                    case 5: {
                        n5 = 3;
                        break;
                    }
                }
                if (bl2) break;
                this.appendCountValue(n2, 1, n5, stringBuffer);
            }
        }
        if (!bl2 && bl4) {
            stringBuffer.append(this.dr.countSep);
        }
        if (!bl2 && this.dr.measures != null && n4 < this.dr.measures.length && (string2 = this.dr.measures[n4]) != null) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(string);
        return bl5 ? n4 : -1;
    }

    public void appendCountValue(int n2, int n3, int n4, StringBuffer stringBuffer) {
        int n5 = n2 / 1000;
        if (n4 == 0) {
            this.appendInteger(n5, n3, 10, stringBuffer);
            return;
        }
        if (this.dr.requiresDigitSeparator && stringBuffer.length() > 0) {
            stringBuffer.append(' ');
        }
        this.appendDigits(n5, n3, 10, stringBuffer);
        int n6 = n2 % 1000;
        if (n4 == 1) {
            n6 /= 100;
        } else if (n4 == 2) {
            n6 /= 10;
        }
        stringBuffer.append(this.dr.decimalSep);
        this.appendDigits(n6, n4, n4, stringBuffer);
        if (this.dr.requiresDigitSeparator) {
            stringBuffer.append(' ');
        }
    }

    public void appendInteger(int n2, int n3, int n4, StringBuffer stringBuffer) {
        String string;
        if (this.dr.numberNames != null && n2 < this.dr.numberNames.length && (string = this.dr.numberNames[n2]) != null) {
            stringBuffer.append(string);
            return;
        }
        if (this.dr.requiresDigitSeparator && stringBuffer.length() > 0) {
            stringBuffer.append(' ');
        }
        switch (this.dr.numberSystem) {
            case 0: {
                this.appendDigits(n2, n3, n4, stringBuffer);
                break;
            }
            case 1: {
                stringBuffer.append(Utils.chineseNumber(n2, Utils.ChineseDigits.TRADITIONAL));
                break;
            }
            case 2: {
                stringBuffer.append(Utils.chineseNumber(n2, Utils.ChineseDigits.SIMPLIFIED));
                break;
            }
            case 3: {
                stringBuffer.append(Utils.chineseNumber(n2, Utils.ChineseDigits.KOREAN));
            }
        }
        if (this.dr.requiresDigitSeparator) {
            stringBuffer.append(' ');
        }
    }

    public void appendDigits(long l2, int n2, int n3, StringBuffer stringBuffer) {
        char[] cArray = new char[n3];
        int n4 = n3;
        while (n4 > 0 && l2 > 0L) {
            cArray[--n4] = (char)((long)this.dr.zero + l2 % 10L);
            l2 /= 10L;
        }
        int n5 = n3 - n2;
        while (n4 > n5) {
            cArray[--n4] = this.dr.zero;
        }
        stringBuffer.append(cArray, n4, n3 - n4);
    }

    public void appendSkippedUnit(StringBuffer stringBuffer) {
        if (this.dr.skippedUnitMarker != null) {
            stringBuffer.append(this.dr.skippedUnitMarker);
        }
    }

    public boolean appendUnitSeparator(TimeUnit timeUnit, boolean bl2, boolean bl3, boolean bl4, StringBuffer stringBuffer) {
        if (bl2 && this.dr.unitSep != null || this.dr.shortUnitSep != null) {
            if (bl2 && this.dr.unitSep != null) {
                int n2 = (bl3 ? 2 : 0) + (bl4 ? 1 : 0);
                stringBuffer.append(this.dr.unitSep[n2]);
                return this.dr.unitSepRequiresDP != null && this.dr.unitSepRequiresDP[n2];
            }
            stringBuffer.append(this.dr.shortUnitSep);
        }
        return false;
    }

    private int computeForm(TimeUnit timeUnit, int n2, int n3, boolean bl2) {
        int n4;
        if (trace) {
            System.err.println("pfd.cf unit: " + timeUnit + " count: " + n2 + " cv: " + n3 + " dr.pl: " + this.dr.pl);
            Thread.dumpStack();
        }
        if (this.dr.pl == 0) {
            return 0;
        }
        int n5 = n2 / 1000;
        block0 : switch (n3) {
            case 0: 
            case 1: {
                break;
            }
            case 2: {
                switch (this.dr.fractionHandling) {
                    case 0: {
                        return 0;
                    }
                    case 1: 
                    case 2: {
                        n4 = n2 / 500;
                        if (n4 == 1) {
                            if (this.dr.halfNames != null && this.dr.halfNames[timeUnit.ordinal()] != null) {
                                return 6;
                            }
                            return 5;
                        }
                        if ((n4 & 1) != 1) break block0;
                        if (this.dr.pl == 5 && n4 > 21) {
                            return 5;
                        }
                        if (n4 != 3 || this.dr.pl != 1 || this.dr.fractionHandling == 2) break block0;
                        return 0;
                    }
                    case 3: {
                        n4 = n2 / 500;
                        if (n4 != 1 && n4 != 3) break block0;
                        return 3;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            default: {
                switch (this.dr.decimalHandling) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return 5;
                    }
                    case 2: {
                        if (n2 >= 1000) break;
                        return 5;
                    }
                    case 3: {
                        if (this.dr.pl != 3) break;
                        return 3;
                    }
                }
                return 0;
            }
        }
        if (trace && n2 == 0) {
            System.err.println("EZeroHandling = " + this.dr.zeroHandling);
        }
        if (n2 == 0 && this.dr.zeroHandling == 1) {
            return 4;
        }
        n4 = 0;
        switch (this.dr.pl) {
            case 0: {
                break;
            }
            case 1: {
                if (n5 != 1) break;
                n4 = 4;
                break;
            }
            case 2: {
                if (n5 == 2) {
                    n4 = 2;
                    break;
                }
                if (n5 != 1) break;
                n4 = 1;
                break;
            }
            case 3: {
                int n6 = n5;
                if ((n6 %= 100) > 20) {
                    n6 %= 10;
                }
                if (n6 == 1) {
                    n4 = 1;
                    break;
                }
                if (n6 <= 1 || n6 >= 5) break;
                n4 = 3;
                break;
            }
            case 4: {
                if (n5 == 2) {
                    n4 = 2;
                    break;
                }
                if (n5 == 1) {
                    if (bl2) {
                        n4 = 4;
                        break;
                    }
                    n4 = 1;
                    break;
                }
                if (timeUnit != TimeUnit.YEAR || n5 <= 11) break;
                n4 = 5;
                break;
            }
            case 5: {
                if (n5 == 2) {
                    n4 = 2;
                    break;
                }
                if (n5 == 1) {
                    n4 = 1;
                    break;
                }
                if (n5 <= 10) break;
                n4 = 5;
                break;
            }
            default: {
                System.err.println("dr.pl is " + this.dr.pl);
                throw new IllegalStateException();
            }
        }
        return n4;
    }
}

