/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.BasicPeriodBuilderFactory;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.Period;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.PeriodBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.PeriodBuilderImpl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.TimeUnit;

class MultiUnitBuilder
extends PeriodBuilderImpl {
    private int nPeriods;

    MultiUnitBuilder(int n2, BasicPeriodBuilderFactory.Settings settings) {
        super(settings);
        this.nPeriods = n2;
    }

    public static MultiUnitBuilder get(int n2, BasicPeriodBuilderFactory.Settings settings) {
        if (n2 > 0 && settings != null) {
            return new MultiUnitBuilder(n2, settings);
        }
        return null;
    }

    @Override
    protected PeriodBuilder withSettings(BasicPeriodBuilderFactory.Settings settings) {
        return MultiUnitBuilder.get(this.nPeriods, settings);
    }

    @Override
    protected Period handleCreate(long l2, long l3, boolean bl2) {
        Period period = null;
        int n2 = 0;
        short s2 = this.settings.effectiveSet();
        for (int i2 = 0; i2 < TimeUnit.units.length; ++i2) {
            if (0 == (s2 & 1 << i2)) continue;
            TimeUnit timeUnit = TimeUnit.units[i2];
            if (n2 == this.nPeriods) break;
            long l4 = this.approximateDurationOf(timeUnit);
            if (l2 < l4 && n2 <= 0) continue;
            double d2 = (double)l2 / (double)l4;
            if (++n2 < this.nPeriods) {
                d2 = Math.floor(d2);
                l2 -= (long)(d2 * (double)l4);
            }
            period = period == null ? Period.at((float)d2, timeUnit).inPast(bl2) : period.and((float)d2, timeUnit);
        }
        return period;
    }
}

