/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration;

import java.util.Locale;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.BasicPeriodFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.BasicPeriodFormatterService;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.PeriodFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.PeriodFormatterFactory;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.impl.PeriodFormatterData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.impl.PeriodFormatterDataService;

public class BasicPeriodFormatterFactory
implements PeriodFormatterFactory {
    private final PeriodFormatterDataService ds;
    private PeriodFormatterData data;
    private Customizations customizations;
    private boolean customizationsInUse;
    private String localeName;

    BasicPeriodFormatterFactory(PeriodFormatterDataService periodFormatterDataService) {
        this.ds = periodFormatterDataService;
        this.customizations = new Customizations();
        this.localeName = Locale.getDefault().toString();
    }

    public static BasicPeriodFormatterFactory getDefault() {
        return (BasicPeriodFormatterFactory)BasicPeriodFormatterService.getInstance().newPeriodFormatterFactory();
    }

    @Override
    public PeriodFormatterFactory setLocale(String string) {
        this.data = null;
        this.localeName = string;
        return this;
    }

    @Override
    public PeriodFormatterFactory setDisplayLimit(boolean bl2) {
        this.updateCustomizations().displayLimit = bl2;
        return this;
    }

    public boolean getDisplayLimit() {
        return this.customizations.displayLimit;
    }

    @Override
    public PeriodFormatterFactory setDisplayPastFuture(boolean bl2) {
        this.updateCustomizations().displayDirection = bl2;
        return this;
    }

    public boolean getDisplayPastFuture() {
        return this.customizations.displayDirection;
    }

    @Override
    public PeriodFormatterFactory setSeparatorVariant(int n2) {
        this.updateCustomizations().separatorVariant = (byte)n2;
        return this;
    }

    public int getSeparatorVariant() {
        return this.customizations.separatorVariant;
    }

    @Override
    public PeriodFormatterFactory setUnitVariant(int n2) {
        this.updateCustomizations().unitVariant = (byte)n2;
        return this;
    }

    public int getUnitVariant() {
        return this.customizations.unitVariant;
    }

    @Override
    public PeriodFormatterFactory setCountVariant(int n2) {
        this.updateCustomizations().countVariant = (byte)n2;
        return this;
    }

    public int getCountVariant() {
        return this.customizations.countVariant;
    }

    @Override
    public PeriodFormatter getFormatter() {
        this.customizationsInUse = true;
        return new BasicPeriodFormatter(this, this.localeName, this.getData(), this.customizations);
    }

    private Customizations updateCustomizations() {
        if (this.customizationsInUse) {
            this.customizations = this.customizations.copy();
            this.customizationsInUse = false;
        }
        return this.customizations;
    }

    PeriodFormatterData getData() {
        if (this.data == null) {
            this.data = this.ds.get(this.localeName);
        }
        return this.data;
    }

    PeriodFormatterData getData(String string) {
        return this.ds.get(string);
    }

    static class Customizations {
        boolean displayLimit = true;
        boolean displayDirection = true;
        byte separatorVariant = (byte)2;
        byte unitVariant = 0;
        byte countVariant = 0;

        Customizations() {
        }

        public Customizations copy() {
            Customizations customizations = new Customizations();
            customizations.displayLimit = this.displayLimit;
            customizations.displayDirection = this.displayDirection;
            customizations.separatorVariant = this.separatorVariant;
            customizations.unitVariant = this.unitVariant;
            customizations.countVariant = this.countVariant;
            return customizations;
        }
    }
}

