/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration;

import java.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.FixedUnitBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.MultiUnitBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.OneOrTwoUnitBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.Period;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.PeriodBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.PeriodBuilderFactory;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.SingleUnitBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.TimeUnit;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.impl.PeriodFormatterData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.impl.PeriodFormatterDataService;

class BasicPeriodBuilderFactory
implements PeriodBuilderFactory {
    private PeriodFormatterDataService ds;
    private Settings settings;
    private static final short allBits = 255;

    BasicPeriodBuilderFactory(PeriodFormatterDataService periodFormatterDataService) {
        this.ds = periodFormatterDataService;
        this.settings = new Settings();
    }

    static long approximateDurationOf(TimeUnit timeUnit) {
        return TimeUnit.approxDurations[timeUnit.ordinal];
    }

    @Override
    public PeriodBuilderFactory setAvailableUnitRange(TimeUnit timeUnit, TimeUnit timeUnit2) {
        int n2 = 0;
        for (int i2 = timeUnit2.ordinal; i2 <= timeUnit.ordinal; ++i2) {
            n2 |= 1 << i2;
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("range " + timeUnit + " to " + timeUnit2 + " is empty");
        }
        this.settings = this.settings.setUnits(n2);
        return this;
    }

    @Override
    public PeriodBuilderFactory setUnitIsAvailable(TimeUnit timeUnit, boolean bl2) {
        int n2 = this.settings.uset;
        n2 = bl2 ? (n2 |= 1 << timeUnit.ordinal) : (n2 &= ~(1 << timeUnit.ordinal));
        this.settings = this.settings.setUnits(n2);
        return this;
    }

    @Override
    public PeriodBuilderFactory setMaxLimit(float f2) {
        this.settings = this.settings.setMaxLimit(f2);
        return this;
    }

    @Override
    public PeriodBuilderFactory setMinLimit(float f2) {
        this.settings = this.settings.setMinLimit(f2);
        return this;
    }

    @Override
    public PeriodBuilderFactory setAllowZero(boolean bl2) {
        this.settings = this.settings.setAllowZero(bl2);
        return this;
    }

    @Override
    public PeriodBuilderFactory setWeeksAloneOnly(boolean bl2) {
        this.settings = this.settings.setWeeksAloneOnly(bl2);
        return this;
    }

    @Override
    public PeriodBuilderFactory setAllowMilliseconds(boolean bl2) {
        this.settings = this.settings.setAllowMilliseconds(bl2);
        return this;
    }

    @Override
    public PeriodBuilderFactory setLocale(String string) {
        this.settings = this.settings.setLocale(string);
        return this;
    }

    @Override
    public PeriodBuilderFactory setTimeZone(TimeZone timeZone) {
        return this;
    }

    private Settings getSettings() {
        if (this.settings.effectiveSet() == 0) {
            return null;
        }
        return this.settings.setInUse();
    }

    @Override
    public PeriodBuilder getFixedUnitBuilder(TimeUnit timeUnit) {
        return FixedUnitBuilder.get(timeUnit, this.getSettings());
    }

    @Override
    public PeriodBuilder getSingleUnitBuilder() {
        return SingleUnitBuilder.get(this.getSettings());
    }

    @Override
    public PeriodBuilder getOneOrTwoUnitBuilder() {
        return OneOrTwoUnitBuilder.get(this.getSettings());
    }

    @Override
    public PeriodBuilder getMultiUnitBuilder(int n2) {
        return MultiUnitBuilder.get(n2, this.getSettings());
    }

    class Settings {
        boolean inUse;
        short uset = (short)255;
        TimeUnit maxUnit = TimeUnit.YEAR;
        TimeUnit minUnit = TimeUnit.MILLISECOND;
        int maxLimit;
        int minLimit;
        boolean allowZero = true;
        boolean weeksAloneOnly;
        boolean allowMillis = true;

        Settings() {
        }

        Settings setUnits(int n2) {
            if (this.uset == n2) {
                return this;
            }
            Settings settings = this.inUse ? this.copy() : this;
            settings.uset = (short)n2;
            if ((n2 & 0xFF) == 255) {
                settings.uset = (short)255;
                settings.maxUnit = TimeUnit.YEAR;
                settings.minUnit = TimeUnit.MILLISECOND;
            } else {
                int n3 = -1;
                for (int i2 = 0; i2 < TimeUnit.units.length; ++i2) {
                    if (0 == (n2 & 1 << i2)) continue;
                    if (n3 == -1) {
                        settings.maxUnit = TimeUnit.units[i2];
                    }
                    n3 = i2;
                }
                if (n3 == -1) {
                    settings.maxUnit = null;
                    settings.minUnit = null;
                } else {
                    settings.minUnit = TimeUnit.units[n3];
                }
            }
            return settings;
        }

        short effectiveSet() {
            if (this.allowMillis) {
                return this.uset;
            }
            return (short)(this.uset & ~(1 << TimeUnit.MILLISECOND.ordinal));
        }

        TimeUnit effectiveMinUnit() {
            if (this.allowMillis || this.minUnit != TimeUnit.MILLISECOND) {
                return this.minUnit;
            }
            int n2 = TimeUnit.units.length - 1;
            while (--n2 >= 0) {
                if (0 == (this.uset & 1 << n2)) continue;
                return TimeUnit.units[n2];
            }
            return TimeUnit.SECOND;
        }

        Settings setMaxLimit(float f2) {
            int n2;
            int n3 = n2 = f2 <= 0.0f ? 0 : (int)(f2 * 1000.0f);
            if (f2 == (float)n2) {
                return this;
            }
            Settings settings = this.inUse ? this.copy() : this;
            settings.maxLimit = n2;
            return settings;
        }

        Settings setMinLimit(float f2) {
            int n2;
            int n3 = n2 = f2 <= 0.0f ? 0 : (int)(f2 * 1000.0f);
            if (f2 == (float)n2) {
                return this;
            }
            Settings settings = this.inUse ? this.copy() : this;
            settings.minLimit = n2;
            return settings;
        }

        Settings setAllowZero(boolean bl2) {
            if (this.allowZero == bl2) {
                return this;
            }
            Settings settings = this.inUse ? this.copy() : this;
            settings.allowZero = bl2;
            return settings;
        }

        Settings setWeeksAloneOnly(boolean bl2) {
            if (this.weeksAloneOnly == bl2) {
                return this;
            }
            Settings settings = this.inUse ? this.copy() : this;
            settings.weeksAloneOnly = bl2;
            return settings;
        }

        Settings setAllowMilliseconds(boolean bl2) {
            if (this.allowMillis == bl2) {
                return this;
            }
            Settings settings = this.inUse ? this.copy() : this;
            settings.allowMillis = bl2;
            return settings;
        }

        Settings setLocale(String string) {
            PeriodFormatterData periodFormatterData = BasicPeriodBuilderFactory.this.ds.get(string);
            return this.setAllowZero(periodFormatterData.allowZero()).setWeeksAloneOnly(periodFormatterData.weeksAloneOnly()).setAllowMilliseconds(periodFormatterData.useMilliseconds() != 1);
        }

        Settings setInUse() {
            this.inUse = true;
            return this;
        }

        Period createLimited(long l2, boolean bl2) {
            long l3;
            if (this.maxLimit > 0 && l2 * 1000L > (long)this.maxLimit * (l3 = BasicPeriodBuilderFactory.approximateDurationOf(this.maxUnit))) {
                return Period.moreThan((float)this.maxLimit / 1000.0f, this.maxUnit).inPast(bl2);
            }
            if (this.minLimit > 0) {
                long l4;
                TimeUnit timeUnit = this.effectiveMinUnit();
                long l5 = BasicPeriodBuilderFactory.approximateDurationOf(timeUnit);
                long l6 = l4 = timeUnit == this.minUnit ? (long)this.minLimit : Math.max(1000L, BasicPeriodBuilderFactory.approximateDurationOf(this.minUnit) * (long)this.minLimit / l5);
                if (l2 * 1000L < l4 * l5) {
                    return Period.lessThan((float)l4 / 1000.0f, timeUnit).inPast(bl2);
                }
            }
            return null;
        }

        public Settings copy() {
            Settings settings = new Settings();
            settings.inUse = this.inUse;
            settings.uset = this.uset;
            settings.maxUnit = this.maxUnit;
            settings.minUnit = this.minUnit;
            settings.maxLimit = this.maxLimit;
            settings.minLimit = this.minLimit;
            settings.allowZero = this.allowZero;
            settings.weeksAloneOnly = this.weeksAloneOnly;
            settings.allowMillis = this.allowMillis;
            return settings;
        }
    }
}

