/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration;

import java.util.Date;
import java.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.DateFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.DurationFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.Period;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.PeriodBuilder;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.PeriodFormatter;

class BasicDurationFormatter
implements DurationFormatter {
    private PeriodFormatter formatter;
    private PeriodBuilder builder;
    private DateFormatter fallback;
    private long fallbackLimit;
    private String localeName;
    private TimeZone timeZone;

    public BasicDurationFormatter(PeriodFormatter periodFormatter, PeriodBuilder periodBuilder, DateFormatter dateFormatter, long l2) {
        this.formatter = periodFormatter;
        this.builder = periodBuilder;
        this.fallback = dateFormatter;
        this.fallbackLimit = l2 < 0L ? 0L : l2;
    }

    protected BasicDurationFormatter(PeriodFormatter periodFormatter, PeriodBuilder periodBuilder, DateFormatter dateFormatter, long l2, String string, TimeZone timeZone) {
        this.formatter = periodFormatter;
        this.builder = periodBuilder;
        this.fallback = dateFormatter;
        this.fallbackLimit = l2;
        this.localeName = string;
        this.timeZone = timeZone;
    }

    @Override
    public String formatDurationFromNowTo(Date date) {
        long l2 = System.currentTimeMillis();
        long l3 = date.getTime() - l2;
        return this.formatDurationFrom(l3, l2);
    }

    @Override
    public String formatDurationFromNow(long l2) {
        return this.formatDurationFrom(l2, System.currentTimeMillis());
    }

    @Override
    public String formatDurationFrom(long l2, long l3) {
        String string = this.doFallback(l2, l3);
        if (string == null) {
            Period period = this.doBuild(l2, l3);
            string = this.doFormat(period);
        }
        return string;
    }

    @Override
    public DurationFormatter withLocale(String string) {
        if (!string.equals(this.localeName)) {
            PeriodFormatter periodFormatter = this.formatter.withLocale(string);
            PeriodBuilder periodBuilder = this.builder.withLocale(string);
            DateFormatter dateFormatter = this.fallback == null ? null : this.fallback.withLocale(string);
            return new BasicDurationFormatter(periodFormatter, periodBuilder, dateFormatter, this.fallbackLimit, string, this.timeZone);
        }
        return this;
    }

    @Override
    public DurationFormatter withTimeZone(TimeZone timeZone) {
        if (!timeZone.equals(this.timeZone)) {
            PeriodBuilder periodBuilder = this.builder.withTimeZone(timeZone);
            DateFormatter dateFormatter = this.fallback == null ? null : this.fallback.withTimeZone(timeZone);
            return new BasicDurationFormatter(this.formatter, periodBuilder, dateFormatter, this.fallbackLimit, this.localeName, timeZone);
        }
        return this;
    }

    protected String doFallback(long l2, long l3) {
        if (this.fallback != null && this.fallbackLimit > 0L && Math.abs(l2) >= this.fallbackLimit) {
            return this.fallback.format(l3 + l2);
        }
        return null;
    }

    protected Period doBuild(long l2, long l3) {
        return this.builder.createWithReferenceDate(l2, l3);
    }

    protected String doFormat(Period period) {
        if (!period.isSet()) {
            throw new IllegalArgumentException("period is not set");
        }
        return this.formatter.format(period);
    }
}

