/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration;

import java.text.FieldPosition;
import java.util.Date;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.BasicPeriodFormatterService;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.DurationFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.Period;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.PeriodFormatter;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.PeriodFormatterService;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.duration.TimeUnit;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.DurationFormat;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;

public class BasicDurationFormat
extends DurationFormat {
    private static final long serialVersionUID = -3146984141909457700L;
    transient DurationFormatter formatter;
    transient PeriodFormatter pformatter;
    transient PeriodFormatterService pfs = BasicPeriodFormatterService.getInstance();

    public static BasicDurationFormat getInstance(ULocale uLocale) {
        return new BasicDurationFormat(uLocale);
    }

    @Override
    public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Long) {
            String string = this.formatDurationFromNow((Long)object);
            return stringBuffer.append(string);
        }
        if (object instanceof Date) {
            String string = this.formatDurationFromNowTo((Date)object);
            return stringBuffer.append(string);
        }
        if (object instanceof Duration) {
            String string = this.formatDuration(object);
            return stringBuffer.append(string);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Duration");
    }

    public BasicDurationFormat() {
        this.formatter = this.pfs.newDurationFormatterFactory().getFormatter();
        this.pformatter = this.pfs.newPeriodFormatterFactory().setDisplayPastFuture(false).getFormatter();
    }

    public BasicDurationFormat(ULocale uLocale) {
        super(uLocale);
        this.formatter = this.pfs.newDurationFormatterFactory().setLocale(uLocale.getName()).getFormatter();
        this.pformatter = this.pfs.newPeriodFormatterFactory().setDisplayPastFuture(false).setLocale(uLocale.getName()).getFormatter();
    }

    @Override
    public String formatDurationFrom(long l2, long l3) {
        return this.formatter.formatDurationFrom(l2, l3);
    }

    @Override
    public String formatDurationFromNow(long l2) {
        return this.formatter.formatDurationFromNow(l2);
    }

    @Override
    public String formatDurationFromNowTo(Date date) {
        return this.formatter.formatDurationFromNowTo(date);
    }

    public String formatDuration(Object object) {
        DatatypeConstants.Field[] fieldArray = new DatatypeConstants.Field[]{DatatypeConstants.YEARS, DatatypeConstants.MONTHS, DatatypeConstants.DAYS, DatatypeConstants.HOURS, DatatypeConstants.MINUTES, DatatypeConstants.SECONDS};
        TimeUnit[] timeUnitArray = new TimeUnit[]{TimeUnit.YEAR, TimeUnit.MONTH, TimeUnit.DAY, TimeUnit.HOUR, TimeUnit.MINUTE, TimeUnit.SECOND};
        Duration duration = (Duration)object;
        Period period = null;
        Duration duration2 = duration;
        boolean bl2 = false;
        if (duration.getSign() < 0) {
            duration2 = duration.negate();
            bl2 = true;
        }
        boolean bl3 = false;
        for (int i2 = 0; i2 < fieldArray.length; ++i2) {
            double d2;
            double d3;
            double d4;
            Number number;
            if (!duration2.isSet(fieldArray[i2]) || (number = duration2.getField(fieldArray[i2])).intValue() == 0 && !bl3) continue;
            bl3 = true;
            float f2 = number.floatValue();
            TimeUnit timeUnit = null;
            float f3 = 0.0f;
            if (timeUnitArray[i2] == TimeUnit.SECOND && (d4 = ((d3 = (double)f2) - (d2 = Math.floor(f2))) * 1000.0) > 0.0) {
                timeUnit = TimeUnit.MILLISECOND;
                f3 = (float)d4;
                f2 = (float)d2;
            }
            period = period == null ? Period.at(f2, timeUnitArray[i2]) : period.and(f2, timeUnitArray[i2]);
            if (timeUnit == null) continue;
            period = period.and(f3, timeUnit);
        }
        if (period == null) {
            return this.formatDurationFromNow(0L);
        }
        period = bl2 ? period.inPast() : period.inFuture();
        return this.pformatter.format(period);
    }
}

