/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.data;

import java.io.IOException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.data.ResourceReader;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;

public class TokenIterator {
    private ResourceReader reader;
    private String line;
    private StringBuffer buf;
    private boolean done;
    private int pos;
    private int lastpos;

    public TokenIterator(ResourceReader resourceReader) {
        this.reader = resourceReader;
        this.line = null;
        this.done = false;
        this.buf = new StringBuffer();
        this.lastpos = -1;
        this.pos = -1;
    }

    public String next() throws IOException {
        if (this.done) {
            return null;
        }
        while (true) {
            if (this.line == null) {
                this.line = this.reader.readLineSkippingComments();
                if (this.line == null) {
                    this.done = true;
                    return null;
                }
                this.pos = 0;
            }
            this.buf.setLength(0);
            this.lastpos = this.pos;
            this.pos = this.nextToken(this.pos);
            if (this.pos >= 0) break;
            this.line = null;
        }
        return this.buf.toString();
    }

    public int getLineNumber() {
        return this.reader.getLineNumber();
    }

    public String describePosition() {
        return this.reader.describePosition() + ':' + (this.lastpos + 1);
    }

    private int nextToken(int n2) {
        if ((n2 = PatternProps.skipWhiteSpace(this.line, n2)) == this.line.length()) {
            return -1;
        }
        int n3 = n2;
        char c2 = this.line.charAt(n2++);
        char c3 = '\u0000';
        switch (c2) {
            case '\"': 
            case '\'': {
                c3 = c2;
                break;
            }
            case '#': {
                return -1;
            }
            default: {
                this.buf.append(c2);
            }
        }
        while (n2 < this.line.length()) {
            c2 = this.line.charAt(n2);
            if (c2 == '\\') {
                int n4 = Utility.unescapeAndLengthAt(this.line, n2 + 1);
                if (n4 < 0) {
                    throw new RuntimeException("Invalid escape at " + this.reader.describePosition() + ':' + n2);
                }
                UTF16.append(this.buf, Utility.cpFromCodePointAndLength(n4));
                n2 += 1 + Utility.lengthFromCodePointAndLength(n4);
                continue;
            }
            if (c3 != '\u0000' && c2 == c3 || c3 == '\u0000' && PatternProps.isWhiteSpace(c2)) {
                return ++n2;
            }
            if (c3 == '\u0000' && c2 == '#') {
                return n2;
            }
            this.buf.append(c2);
            ++n2;
        }
        if (c3 != '\u0000') {
            throw new RuntimeException("Unterminated quote at " + this.reader.describePosition() + ':' + n3);
        }
        return n2;
    }
}

