/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationIterator;

public class UTF16CollationIterator
extends CollationIterator {
    protected CharSequence seq;
    protected int start;
    protected int pos;
    protected int limit;

    public UTF16CollationIterator(CollationData collationData) {
        super(collationData);
    }

    public UTF16CollationIterator(CollationData collationData, boolean bl2, CharSequence charSequence, int n2) {
        super(collationData, bl2);
        this.seq = charSequence;
        this.start = 0;
        this.pos = n2;
        this.limit = charSequence.length();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        UTF16CollationIterator uTF16CollationIterator = (UTF16CollationIterator)object;
        return this.pos - this.start == uTF16CollationIterator.pos - uTF16CollationIterator.start;
    }

    @Override
    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    @Override
    public void resetToOffset(int n2) {
        this.reset();
        this.pos = this.start + n2;
    }

    @Override
    public int getOffset() {
        return this.pos - this.start;
    }

    public void setText(boolean bl2, CharSequence charSequence, int n2) {
        this.reset(bl2);
        this.seq = charSequence;
        this.start = 0;
        this.pos = n2;
        this.limit = charSequence.length();
    }

    @Override
    public int nextCodePoint() {
        char c2;
        char c3;
        if (this.pos == this.limit) {
            return -1;
        }
        if (Character.isHighSurrogate(c3 = this.seq.charAt(this.pos++)) && this.pos != this.limit && Character.isLowSurrogate(c2 = this.seq.charAt(this.pos))) {
            ++this.pos;
            return Character.toCodePoint(c3, c2);
        }
        return c3;
    }

    @Override
    public int previousCodePoint() {
        char c2;
        char c3;
        if (this.pos == this.start) {
            return -1;
        }
        if (Character.isLowSurrogate(c3 = this.seq.charAt(--this.pos)) && this.pos != this.start && Character.isHighSurrogate(c2 = this.seq.charAt(this.pos - 1))) {
            --this.pos;
            return Character.toCodePoint(c2, c3);
        }
        return c3;
    }

    @Override
    protected long handleNextCE32() {
        if (this.pos == this.limit) {
            return -4294967104L;
        }
        char c2 = this.seq.charAt(this.pos++);
        return this.makeCodePointAndCE32Pair(c2, this.trie.getFromU16SingleLead(c2));
    }

    @Override
    protected char handleGetTrailSurrogate() {
        if (this.pos == this.limit) {
            return '\u0000';
        }
        char c2 = this.seq.charAt(this.pos);
        if (Character.isLowSurrogate(c2)) {
            ++this.pos;
        }
        return c2;
    }

    @Override
    protected void forwardNumCodePoints(int n2) {
        while (n2 > 0 && this.pos != this.limit) {
            char c2 = this.seq.charAt(this.pos++);
            --n2;
            if (!Character.isHighSurrogate(c2) || this.pos == this.limit || !Character.isLowSurrogate(this.seq.charAt(this.pos))) continue;
            ++this.pos;
        }
    }

    @Override
    protected void backwardNumCodePoints(int n2) {
        while (n2 > 0 && this.pos != this.start) {
            char c2 = this.seq.charAt(--this.pos);
            --n2;
            if (!Character.isLowSurrogate(c2) || this.pos == this.start || !Character.isHighSurrogate(this.seq.charAt(this.pos - 1))) continue;
            --this.pos;
        }
    }
}

