/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import java.util.concurrent.atomic.AtomicInteger;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUCloneNotSupportedException;

public class SharedObject
implements Cloneable {
    private AtomicInteger refCount = new AtomicInteger();

    public SharedObject clone() {
        SharedObject sharedObject;
        try {
            sharedObject = (SharedObject)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new ICUCloneNotSupportedException(cloneNotSupportedException);
        }
        sharedObject.refCount = new AtomicInteger();
        return sharedObject;
    }

    public final void addRef() {
        this.refCount.incrementAndGet();
    }

    public final void removeRef() {
        this.refCount.decrementAndGet();
    }

    public final int getRefCount() {
        return this.refCount.get();
    }

    public final void deleteIfZeroRefCount() {
    }

    public static final class Reference<T extends SharedObject>
    implements Cloneable {
        private T ref;

        public Reference(T t2) {
            this.ref = t2;
            if (t2 != null) {
                ((SharedObject)t2).addRef();
            }
        }

        public Reference<T> clone() {
            Reference reference;
            try {
                reference = (Reference)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new ICUCloneNotSupportedException(cloneNotSupportedException);
            }
            if (this.ref != null) {
                ((SharedObject)this.ref).addRef();
            }
            return reference;
        }

        public T readOnly() {
            return this.ref;
        }

        public T copyOnWrite() {
            T t2 = this.ref;
            if (((SharedObject)t2).getRefCount() <= 1) {
                return t2;
            }
            SharedObject sharedObject = ((SharedObject)t2).clone();
            ((SharedObject)t2).removeRef();
            this.ref = sharedObject;
            sharedObject.addRef();
            return (T)sharedObject;
        }

        public void clear() {
            if (this.ref != null) {
                ((SharedObject)this.ref).removeRef();
                this.ref = null;
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.clear();
        }
    }
}

