/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Normalizer2Impl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationFCD;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.UTF16CollationIterator;

public final class FCDUTF16CollationIterator
extends UTF16CollationIterator {
    private CharSequence rawSeq;
    private static final int rawStart = 0;
    private int segmentStart;
    private int segmentLimit;
    private int rawLimit;
    private final Normalizer2Impl nfcImpl;
    private StringBuilder normalized;
    private int checkDir;

    public FCDUTF16CollationIterator(CollationData collationData) {
        super(collationData);
        this.nfcImpl = collationData.nfcImpl;
    }

    public FCDUTF16CollationIterator(CollationData collationData, boolean bl2, CharSequence charSequence, int n2) {
        super(collationData, bl2, charSequence, n2);
        this.rawSeq = charSequence;
        this.segmentStart = n2;
        this.rawLimit = charSequence.length();
        this.nfcImpl = collationData.nfcImpl;
        this.checkDir = 1;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof CollationIterator && ((CollationIterator)this).equals(object) && object instanceof FCDUTF16CollationIterator)) {
            return false;
        }
        FCDUTF16CollationIterator fCDUTF16CollationIterator = (FCDUTF16CollationIterator)object;
        if (this.checkDir != fCDUTF16CollationIterator.checkDir) {
            return false;
        }
        if (this.checkDir == 0 && this.seq == this.rawSeq != (fCDUTF16CollationIterator.seq == fCDUTF16CollationIterator.rawSeq)) {
            return false;
        }
        if (this.checkDir != 0 || this.seq == this.rawSeq) {
            return this.pos - 0 == fCDUTF16CollationIterator.pos - 0;
        }
        return this.segmentStart - 0 == fCDUTF16CollationIterator.segmentStart - 0 && this.pos - this.start == fCDUTF16CollationIterator.pos - fCDUTF16CollationIterator.start;
    }

    @Override
    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 42;
    }

    @Override
    public void resetToOffset(int n2) {
        this.reset();
        this.seq = this.rawSeq;
        this.segmentStart = this.pos = 0 + n2;
        this.start = this.pos;
        this.limit = this.rawLimit;
        this.checkDir = 1;
    }

    @Override
    public int getOffset() {
        if (this.checkDir != 0 || this.seq == this.rawSeq) {
            return this.pos - 0;
        }
        if (this.pos == this.start) {
            return this.segmentStart - 0;
        }
        return this.segmentLimit - 0;
    }

    @Override
    public void setText(boolean bl2, CharSequence charSequence, int n2) {
        super.setText(bl2, charSequence, n2);
        this.rawSeq = charSequence;
        this.segmentStart = n2;
        this.rawLimit = this.limit = charSequence.length();
        this.checkDir = 1;
    }

    @Override
    public int nextCodePoint() {
        char c2;
        char c3;
        while (true) {
            if (this.checkDir > 0) {
                if (this.pos == this.limit) {
                    return -1;
                }
                if (!CollationFCD.hasTccc(c3 = this.seq.charAt(this.pos++)) || !CollationFCD.maybeTibetanCompositeVowel(c3) && (this.pos == this.limit || !CollationFCD.hasLccc(this.seq.charAt(this.pos)))) break;
                --this.pos;
                this.nextSegment();
                c3 = this.seq.charAt(this.pos++);
                break;
            }
            if (this.checkDir == 0 && this.pos != this.limit) {
                c3 = this.seq.charAt(this.pos++);
                break;
            }
            this.switchToForward();
        }
        if (Character.isHighSurrogate(c3) && this.pos != this.limit && Character.isLowSurrogate(c2 = this.seq.charAt(this.pos))) {
            ++this.pos;
            return Character.toCodePoint(c3, c2);
        }
        return c3;
    }

    @Override
    public int previousCodePoint() {
        char c2;
        char c3;
        while (true) {
            if (this.checkDir < 0) {
                if (this.pos == this.start) {
                    return -1;
                }
                if (!CollationFCD.hasLccc(c3 = this.seq.charAt(--this.pos)) || !CollationFCD.maybeTibetanCompositeVowel(c3) && (this.pos == this.start || !CollationFCD.hasTccc(this.seq.charAt(this.pos - 1)))) break;
                ++this.pos;
                this.previousSegment();
                c3 = this.seq.charAt(--this.pos);
                break;
            }
            if (this.checkDir == 0 && this.pos != this.start) {
                c3 = this.seq.charAt(--this.pos);
                break;
            }
            this.switchToBackward();
        }
        if (Character.isLowSurrogate(c3) && this.pos != this.start && Character.isHighSurrogate(c2 = this.seq.charAt(this.pos - 1))) {
            --this.pos;
            return Character.toCodePoint(c2, c3);
        }
        return c3;
    }

    @Override
    protected long handleNextCE32() {
        char c2;
        while (true) {
            if (this.checkDir > 0) {
                if (this.pos == this.limit) {
                    return -4294967104L;
                }
                if (!CollationFCD.hasTccc(c2 = this.seq.charAt(this.pos++)) || !CollationFCD.maybeTibetanCompositeVowel(c2) && (this.pos == this.limit || !CollationFCD.hasLccc(this.seq.charAt(this.pos)))) break;
                --this.pos;
                this.nextSegment();
                c2 = this.seq.charAt(this.pos++);
                break;
            }
            if (this.checkDir == 0 && this.pos != this.limit) {
                c2 = this.seq.charAt(this.pos++);
                break;
            }
            this.switchToForward();
        }
        return this.makeCodePointAndCE32Pair(c2, this.trie.getFromU16SingleLead(c2));
    }

    @Override
    protected void forwardNumCodePoints(int n2) {
        while (n2 > 0 && this.nextCodePoint() >= 0) {
            --n2;
        }
    }

    @Override
    protected void backwardNumCodePoints(int n2) {
        while (n2 > 0 && this.previousCodePoint() >= 0) {
            --n2;
        }
    }

    private void switchToForward() {
        assert (this.checkDir < 0 && this.seq == this.rawSeq || this.checkDir == 0 && this.pos == this.limit);
        if (this.checkDir < 0) {
            this.start = this.segmentStart = this.pos;
            if (this.pos == this.segmentLimit) {
                this.limit = this.rawLimit;
                this.checkDir = 1;
            } else {
                this.checkDir = 0;
            }
        } else {
            if (this.seq != this.rawSeq) {
                this.seq = this.rawSeq;
                this.start = this.segmentStart = this.segmentLimit;
                this.pos = this.segmentStart;
            }
            this.limit = this.rawLimit;
            this.checkDir = 1;
        }
    }

    private void nextSegment() {
        block6: {
            assert (this.checkDir > 0 && this.seq == this.rawSeq && this.pos != this.limit);
            int n2 = this.pos;
            int n3 = 0;
            do {
                int n4 = n2;
                int n5 = Character.codePointAt(this.seq, n2);
                n2 += Character.charCount(n5);
                int n6 = this.nfcImpl.getFCD16(n5);
                int n7 = n6 >> 8;
                if (n7 == 0 && n4 != this.pos) {
                    this.limit = this.segmentLimit = n4;
                    break block6;
                }
                if (n7 != 0 && (n3 > n7 || CollationFCD.isFCD16OfTibetanCompositeVowel(n6))) {
                    do {
                        n4 = n2;
                        if (n2 == this.rawLimit) break;
                        n5 = Character.codePointAt(this.seq, n2);
                        n2 += Character.charCount(n5);
                    } while (this.nfcImpl.getFCD16(n5) > 255);
                    this.normalize(this.pos, n4);
                    this.pos = this.start;
                    break block6;
                }
                n3 = n6 & 0xFF;
            } while (n2 != this.rawLimit && n3 != 0);
            this.limit = this.segmentLimit = n2;
        }
        assert (this.pos != this.limit);
        this.checkDir = 0;
    }

    private void switchToBackward() {
        assert (this.checkDir > 0 && this.seq == this.rawSeq || this.checkDir == 0 && this.pos == this.start);
        if (this.checkDir > 0) {
            this.limit = this.segmentLimit = this.pos;
            if (this.pos == this.segmentStart) {
                this.start = 0;
                this.checkDir = -1;
            } else {
                this.checkDir = 0;
            }
        } else {
            if (this.seq != this.rawSeq) {
                this.seq = this.rawSeq;
                this.limit = this.segmentLimit = this.segmentStart;
                this.pos = this.segmentLimit;
            }
            this.start = 0;
            this.checkDir = -1;
        }
    }

    private void previousSegment() {
        block6: {
            assert (this.checkDir < 0 && this.seq == this.rawSeq && this.pos != this.start);
            int n2 = this.pos;
            int n3 = 0;
            do {
                int n4 = n2;
                int n5 = Character.codePointBefore(this.seq, n2);
                n2 -= Character.charCount(n5);
                int n6 = this.nfcImpl.getFCD16(n5);
                int n7 = n6 & 0xFF;
                if (n7 == 0 && n4 != this.pos) {
                    this.start = this.segmentStart = n4;
                    break block6;
                }
                if (n7 != 0 && (n3 != 0 && n7 > n3 || CollationFCD.isFCD16OfTibetanCompositeVowel(n6))) {
                    do {
                        n4 = n2;
                        if (n6 <= 255 || n2 == 0) break;
                        n5 = Character.codePointBefore(this.seq, n2);
                        n2 -= Character.charCount(n5);
                    } while ((n6 = this.nfcImpl.getFCD16(n5)) != 0);
                    this.normalize(n4, this.pos);
                    this.pos = this.limit;
                    break block6;
                }
                n3 = n6 >> 8;
            } while (n2 != 0 && n3 != 0);
            this.start = this.segmentStart = n2;
        }
        assert (this.pos != this.start);
        this.checkDir = 0;
    }

    private void normalize(int n2, int n3) {
        if (this.normalized == null) {
            this.normalized = new StringBuilder();
        }
        this.nfcImpl.decompose(this.rawSeq, n2, n3, this.normalized, n3 - n2);
        this.segmentStart = n2;
        this.segmentLimit = n3;
        this.seq = this.normalized;
        this.start = 0;
        this.limit = this.start + this.normalized.length();
    }
}

