/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Normalizer2Impl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationFCD;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.IterCollationIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UCharacterIterator;

public final class FCDIterCollationIterator
extends IterCollationIterator {
    private State state = State.ITER_CHECK_FWD;
    private int start;
    private int pos;
    private int limit;
    private final Normalizer2Impl nfcImpl;
    private StringBuilder s;
    private StringBuilder normalized;

    public FCDIterCollationIterator(CollationData collationData, boolean bl2, UCharacterIterator uCharacterIterator, int n2) {
        super(collationData, bl2, uCharacterIterator);
        this.start = n2;
        this.nfcImpl = collationData.nfcImpl;
    }

    @Override
    public void resetToOffset(int n2) {
        super.resetToOffset(n2);
        this.start = n2;
        this.state = State.ITER_CHECK_FWD;
    }

    @Override
    public int getOffset() {
        if (this.state.compareTo(State.ITER_CHECK_BWD) <= 0) {
            return this.iter.getIndex();
        }
        if (this.state == State.ITER_IN_FCD_SEGMENT) {
            return this.pos;
        }
        if (this.pos == 0) {
            return this.start;
        }
        return this.limit;
    }

    @Override
    public int nextCodePoint() {
        while (true) {
            int n2;
            if (this.state == State.ITER_CHECK_FWD) {
                n2 = this.iter.next();
                if (n2 < 0) {
                    return n2;
                }
                if (CollationFCD.hasTccc(n2) && (CollationFCD.maybeTibetanCompositeVowel(n2) || CollationFCD.hasLccc(this.iter.current()))) {
                    this.iter.previous();
                    if (this.nextSegment()) continue;
                    return -1;
                }
                if (FCDIterCollationIterator.isLeadSurrogate(n2)) {
                    int n3 = this.iter.next();
                    if (FCDIterCollationIterator.isTrailSurrogate(n3)) {
                        return Character.toCodePoint((char)n2, (char)n3);
                    }
                    if (n3 >= 0) {
                        this.iter.previous();
                    }
                }
                return n2;
            }
            if (this.state == State.ITER_IN_FCD_SEGMENT && this.pos != this.limit) {
                n2 = this.iter.nextCodePoint();
                this.pos += Character.charCount(n2);
                assert (n2 >= 0);
                return n2;
            }
            if (this.state.compareTo(State.IN_NORM_ITER_AT_LIMIT) >= 0 && this.pos != this.normalized.length()) {
                n2 = this.normalized.codePointAt(this.pos);
                this.pos += Character.charCount(n2);
                return n2;
            }
            this.switchToForward();
        }
    }

    @Override
    public int previousCodePoint() {
        while (true) {
            int n2;
            if (this.state == State.ITER_CHECK_BWD) {
                n2 = this.iter.previous();
                if (n2 < 0) {
                    this.pos = 0;
                    this.start = 0;
                    this.state = State.ITER_IN_FCD_SEGMENT;
                    return -1;
                }
                if (CollationFCD.hasLccc(n2)) {
                    int n3 = -1;
                    if (CollationFCD.maybeTibetanCompositeVowel(n2) || CollationFCD.hasTccc(n3 = this.iter.previous())) {
                        this.iter.next();
                        if (n3 >= 0) {
                            this.iter.next();
                        }
                        if (this.previousSegment()) continue;
                        return -1;
                    }
                    if (FCDIterCollationIterator.isTrailSurrogate(n2)) {
                        if (n3 < 0) {
                            n3 = this.iter.previous();
                        }
                        if (FCDIterCollationIterator.isLeadSurrogate(n3)) {
                            return Character.toCodePoint((char)n3, (char)n2);
                        }
                    }
                    if (n3 >= 0) {
                        this.iter.next();
                    }
                }
                return n2;
            }
            if (this.state == State.ITER_IN_FCD_SEGMENT && this.pos != this.start) {
                n2 = this.iter.previousCodePoint();
                this.pos -= Character.charCount(n2);
                assert (n2 >= 0);
                return n2;
            }
            if (this.state.compareTo(State.IN_NORM_ITER_AT_LIMIT) >= 0 && this.pos != 0) {
                n2 = this.normalized.codePointBefore(this.pos);
                this.pos -= Character.charCount(n2);
                return n2;
            }
            this.switchToBackward();
        }
    }

    @Override
    protected long handleNextCE32() {
        int n2;
        while (true) {
            if (this.state == State.ITER_CHECK_FWD) {
                n2 = this.iter.next();
                if (n2 < 0) {
                    return -4294967104L;
                }
                if (!CollationFCD.hasTccc(n2) || !CollationFCD.maybeTibetanCompositeVowel(n2) && !CollationFCD.hasLccc(this.iter.current())) break;
                this.iter.previous();
                if (this.nextSegment()) continue;
                n2 = -1;
                return 192L;
            }
            if (this.state == State.ITER_IN_FCD_SEGMENT && this.pos != this.limit) {
                n2 = this.iter.next();
                ++this.pos;
                assert (n2 >= 0);
                break;
            }
            if (this.state.compareTo(State.IN_NORM_ITER_AT_LIMIT) >= 0 && this.pos != this.normalized.length()) {
                n2 = this.normalized.charAt(this.pos++);
                break;
            }
            this.switchToForward();
        }
        return this.makeCodePointAndCE32Pair(n2, this.trie.getFromU16SingleLead((char)n2));
    }

    @Override
    protected char handleGetTrailSurrogate() {
        if (this.state.compareTo(State.ITER_IN_FCD_SEGMENT) <= 0) {
            int n2 = this.iter.next();
            if (FCDIterCollationIterator.isTrailSurrogate(n2)) {
                if (this.state == State.ITER_IN_FCD_SEGMENT) {
                    ++this.pos;
                }
            } else if (n2 >= 0) {
                this.iter.previous();
            }
            return (char)n2;
        }
        assert (this.pos < this.normalized.length());
        char c2 = this.normalized.charAt(this.pos);
        if (Character.isLowSurrogate(c2)) {
            ++this.pos;
        }
        return c2;
    }

    @Override
    protected void forwardNumCodePoints(int n2) {
        while (n2 > 0 && this.nextCodePoint() >= 0) {
            --n2;
        }
    }

    @Override
    protected void backwardNumCodePoints(int n2) {
        while (n2 > 0 && this.previousCodePoint() >= 0) {
            --n2;
        }
    }

    private void switchToForward() {
        assert (this.state == State.ITER_CHECK_BWD || this.state == State.ITER_IN_FCD_SEGMENT && this.pos == this.limit || this.state.compareTo(State.IN_NORM_ITER_AT_LIMIT) >= 0 && this.pos == this.normalized.length());
        if (this.state == State.ITER_CHECK_BWD) {
            this.start = this.pos = this.iter.getIndex();
            this.state = this.pos == this.limit ? State.ITER_CHECK_FWD : State.ITER_IN_FCD_SEGMENT;
        } else {
            if (this.state != State.ITER_IN_FCD_SEGMENT) {
                if (this.state == State.IN_NORM_ITER_AT_START) {
                    this.iter.moveIndex(this.limit - this.start);
                }
                this.start = this.limit;
            }
            this.state = State.ITER_CHECK_FWD;
        }
    }

    private boolean nextSegment() {
        int n2;
        assert (this.state == State.ITER_CHECK_FWD);
        this.pos = this.iter.getIndex();
        if (this.s == null) {
            this.s = new StringBuilder();
        } else {
            this.s.setLength(0);
        }
        int n3 = 0;
        while ((n2 = this.iter.nextCodePoint()) >= 0) {
            int n4 = this.nfcImpl.getFCD16(n2);
            int n5 = n4 >> 8;
            if (n5 == 0 && this.s.length() != 0) {
                this.iter.previousCodePoint();
                break;
            }
            this.s.appendCodePoint(n2);
            if (n5 != 0 && (n3 > n5 || CollationFCD.isFCD16OfTibetanCompositeVowel(n4))) {
                while ((n2 = this.iter.nextCodePoint()) >= 0) {
                    if (this.nfcImpl.getFCD16(n2) <= 255) {
                        this.iter.previousCodePoint();
                        break;
                    }
                    this.s.appendCodePoint(n2);
                }
                this.normalize(this.s);
                this.start = this.pos;
                this.limit = this.pos + this.s.length();
                this.state = State.IN_NORM_ITER_AT_LIMIT;
                this.pos = 0;
                return true;
            }
            n3 = n4 & 0xFF;
            if (n3 != 0) continue;
            break;
        }
        this.limit = this.pos + this.s.length();
        assert (this.pos != this.limit);
        this.iter.moveIndex(-this.s.length());
        this.state = State.ITER_IN_FCD_SEGMENT;
        return true;
    }

    private void switchToBackward() {
        assert (this.state == State.ITER_CHECK_FWD || this.state == State.ITER_IN_FCD_SEGMENT && this.pos == this.start || this.state.compareTo(State.IN_NORM_ITER_AT_LIMIT) >= 0 && this.pos == 0);
        if (this.state == State.ITER_CHECK_FWD) {
            this.limit = this.pos = this.iter.getIndex();
            this.state = this.pos == this.start ? State.ITER_CHECK_BWD : State.ITER_IN_FCD_SEGMENT;
        } else {
            if (this.state != State.ITER_IN_FCD_SEGMENT) {
                if (this.state == State.IN_NORM_ITER_AT_LIMIT) {
                    this.iter.moveIndex(this.start - this.limit);
                }
                this.limit = this.start;
            }
            this.state = State.ITER_CHECK_BWD;
        }
    }

    private boolean previousSegment() {
        int n2;
        assert (this.state == State.ITER_CHECK_BWD);
        this.pos = this.iter.getIndex();
        if (this.s == null) {
            this.s = new StringBuilder();
        } else {
            this.s.setLength(0);
        }
        int n3 = 0;
        while ((n2 = this.iter.previousCodePoint()) >= 0) {
            int n4 = this.nfcImpl.getFCD16(n2);
            int n5 = n4 & 0xFF;
            if (n5 == 0 && this.s.length() != 0) {
                this.iter.nextCodePoint();
                break;
            }
            this.s.appendCodePoint(n2);
            if (n5 != 0 && (n3 != 0 && n5 > n3 || CollationFCD.isFCD16OfTibetanCompositeVowel(n4))) {
                while (n4 > 255 && (n2 = this.iter.previousCodePoint()) >= 0) {
                    n4 = this.nfcImpl.getFCD16(n2);
                    if (n4 == 0) {
                        this.iter.nextCodePoint();
                        break;
                    }
                    this.s.appendCodePoint(n2);
                }
                this.s.reverse();
                this.normalize(this.s);
                this.limit = this.pos;
                this.start = this.pos - this.s.length();
                this.state = State.IN_NORM_ITER_AT_START;
                this.pos = this.normalized.length();
                return true;
            }
            n3 = n4 >> 8;
            if (n3 != 0) continue;
            break;
        }
        this.start = this.pos - this.s.length();
        assert (this.pos != this.start);
        this.iter.moveIndex(this.s.length());
        this.state = State.ITER_IN_FCD_SEGMENT;
        return true;
    }

    private void normalize(CharSequence charSequence) {
        if (this.normalized == null) {
            this.normalized = new StringBuilder();
        }
        this.nfcImpl.decompose(charSequence, this.normalized);
    }

    private static enum State {
        ITER_CHECK_FWD,
        ITER_CHECK_BWD,
        ITER_IN_FCD_SEGMENT,
        IN_NORM_ITER_AT_LIMIT,
        IN_NORM_ITER_AT_START;

    }
}

