/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import java.util.Map;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Norm2AllModes;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Normalizer2Impl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2_32;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationSettings;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.SharedObject;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ULocale;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.VersionInfo;

public final class CollationTailoring {
    public CollationData data;
    public SharedObject.Reference<CollationSettings> settings;
    private String rules;
    private UResourceBundle rulesResource;
    public ULocale actualLocale = ULocale.ROOT;
    public int version = 0;
    CollationData ownedData;
    Trie2_32 trie;
    UnicodeSet unsafeBackwardSet;
    public Map<Integer, Integer> maxExpansions;

    CollationTailoring(SharedObject.Reference<CollationSettings> reference) {
        if (reference != null) {
            assert (reference.readOnly().reorderCodes.length == 0);
            assert (reference.readOnly().reorderTable == null);
            assert (reference.readOnly().minHighNoReorder == 0L);
            this.settings = reference.clone();
        } else {
            this.settings = new SharedObject.Reference<CollationSettings>(new CollationSettings());
        }
    }

    void ensureOwnedData() {
        if (this.ownedData == null) {
            Normalizer2Impl normalizer2Impl = Norm2AllModes.getNFCInstance().impl;
            this.ownedData = new CollationData(normalizer2Impl);
        }
        this.data = this.ownedData;
    }

    void setRules(String string) {
        assert (this.rules == null && this.rulesResource == null);
        this.rules = string;
    }

    void setRulesResource(UResourceBundle uResourceBundle) {
        assert (this.rules == null && this.rulesResource == null);
        this.rulesResource = uResourceBundle;
    }

    public String getRules() {
        if (this.rules != null) {
            return this.rules;
        }
        if (this.rulesResource != null) {
            return this.rulesResource.getString();
        }
        return "";
    }

    static VersionInfo makeBaseVersion(VersionInfo versionInfo) {
        return VersionInfo.getInstance(VersionInfo.UCOL_BUILDER_VERSION.getMajor(), (versionInfo.getMajor() << 3) + versionInfo.getMinor(), versionInfo.getMilli() << 6, 0);
    }

    void setVersion(int n2, int n3) {
        int n4 = n3 >> 16 & 0xFF00;
        int n5 = n3 >> 16 & 0xFF;
        int n6 = n3 >> 8 & 0xFF;
        int n7 = n3 & 0xFF;
        this.version = VersionInfo.UCOL_BUILDER_VERSION.getMajor() << 24 | n2 & 0xFFC000 | n4 + (n4 >> 6) & 0x3F00 | (n5 << 3) + (n5 >> 5) + n6 + (n7 << 4) + (n7 >> 4) & 0xFF;
    }

    int getUCAVersion() {
        return this.version >> 12 & 0xFF0 | this.version >> 14 & 3;
    }
}

