/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.Collation;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationFastLatin;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.UVector64;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.CharsTrie;

final class CollationFastLatinBuilder {
    private static final int NUM_SPECIAL_GROUPS = 4;
    private static final long CONTRACTION_FLAG = 0x80000000L;
    private long ce0 = 0L;
    private long ce1 = 0L;
    private long[][] charCEs = new long[448][2];
    private UVector64 contractionCEs;
    private UVector64 uniqueCEs;
    private char[] miniCEs = null;
    long[] lastSpecialPrimaries = new long[4];
    private long firstDigitPrimary = 0L;
    private long firstLatinPrimary = 0L;
    private long lastLatinPrimary = 0L;
    private long firstShortPrimary = 0L;
    private boolean shortPrimaryOverflow = false;
    private StringBuilder result = new StringBuilder();
    private int headerLength = 0;

    private static final int compareInt64AsUnsigned(long l2, long l3) {
        if ((l2 += Long.MIN_VALUE) < (l3 += Long.MIN_VALUE)) {
            return -1;
        }
        if (l2 > l3) {
            return 1;
        }
        return 0;
    }

    private static final int binarySearch(long[] lArray, int n2, long l2) {
        if (n2 == 0) {
            return -1;
        }
        int n3 = 0;
        int n4;
        int n5;
        while ((n5 = CollationFastLatinBuilder.compareInt64AsUnsigned(l2, lArray[n4 = (int)(((long)n3 + (long)n2) / 2L)])) != 0) {
            if (n5 < 0) {
                if (n4 == n3) {
                    return ~n3;
                }
                n2 = n4;
                continue;
            }
            if (n4 == n3) {
                return ~(n3 + 1);
            }
            n3 = n4;
        }
        return n4;
    }

    CollationFastLatinBuilder() {
        this.contractionCEs = new UVector64();
        this.uniqueCEs = new UVector64();
    }

    boolean forData(CollationData collationData) {
        boolean bl2;
        if (this.result.length() != 0) {
            throw new IllegalStateException("attempt to reuse a CollationFastLatinBuilder");
        }
        if (!this.loadGroups(collationData)) {
            return false;
        }
        this.firstShortPrimary = this.firstDigitPrimary;
        this.getCEs(collationData);
        this.encodeUniqueCEs();
        if (this.shortPrimaryOverflow) {
            this.firstShortPrimary = this.firstLatinPrimary;
            this.resetCEs();
            this.getCEs(collationData);
            this.encodeUniqueCEs();
        }
        boolean bl3 = bl2 = !this.shortPrimaryOverflow;
        if (bl2) {
            this.encodeCharCEs();
            this.encodeContractions();
        }
        this.contractionCEs.removeAllElements();
        this.uniqueCEs.removeAllElements();
        return bl2;
    }

    char[] getHeader() {
        char[] cArray = new char[this.headerLength];
        this.result.getChars(0, this.headerLength, cArray, 0);
        return cArray;
    }

    char[] getTable() {
        char[] cArray = new char[this.result.length() - this.headerLength];
        this.result.getChars(this.headerLength, this.result.length(), cArray, 0);
        return cArray;
    }

    private boolean loadGroups(CollationData collationData) {
        this.headerLength = 5;
        int n2 = 0x200 | this.headerLength;
        this.result.append((char)n2);
        for (int i2 = 0; i2 < 4; ++i2) {
            this.lastSpecialPrimaries[i2] = collationData.getLastPrimaryForGroup(4096 + i2);
            if (this.lastSpecialPrimaries[i2] == 0L) {
                return false;
            }
            this.result.append(0);
        }
        this.firstDigitPrimary = collationData.getFirstPrimaryForGroup(4100);
        this.firstLatinPrimary = collationData.getFirstPrimaryForGroup(25);
        this.lastLatinPrimary = collationData.getLastPrimaryForGroup(25);
        return this.firstDigitPrimary != 0L && this.firstLatinPrimary != 0L;
    }

    private boolean inSameGroup(long l2, long l3) {
        if (l2 >= this.firstShortPrimary) {
            return l3 >= this.firstShortPrimary;
        }
        if (l3 >= this.firstShortPrimary) {
            return false;
        }
        long l4 = this.lastSpecialPrimaries[3];
        if (l2 > l4) {
            return l3 > l4;
        }
        if (l3 > l4) {
            return false;
        }
        assert (l2 != 0L && l3 != 0L);
        int n2 = 0;
        long l5;
        while (l2 > (l5 = this.lastSpecialPrimaries[n2])) {
            if (l3 <= l5) {
                return false;
            }
            ++n2;
        }
        return l3 <= l5;
    }

    private void resetCEs() {
        this.contractionCEs.removeAllElements();
        this.uniqueCEs.removeAllElements();
        this.shortPrimaryOverflow = false;
        this.result.setLength(this.headerLength);
    }

    private void getCEs(CollationData collationData) {
        int n2 = 0;
        int n3 = 0;
        while (true) {
            CollationData collationData2;
            if (n3 == 384) {
                n3 = 8192;
            } else if (n3 == 8256) break;
            int n4 = collationData.getCE32(n3);
            if (n4 == 192) {
                collationData2 = collationData.base;
                n4 = collationData2.getCE32(n3);
            } else {
                collationData2 = collationData;
            }
            if (this.getCEsFromCE32(collationData2, n3, n4)) {
                this.charCEs[n2][0] = this.ce0;
                this.charCEs[n2][1] = this.ce1;
                this.addUniqueCE(this.ce0);
                this.addUniqueCE(this.ce1);
            } else {
                this.ce0 = 0x101000100L;
                this.charCEs[n2][0] = 0x101000100L;
                this.ce1 = 0L;
                this.charCEs[n2][1] = 0L;
            }
            if (n3 == 0 && !CollationFastLatinBuilder.isContractionCharCE(this.ce0)) {
                assert (this.contractionCEs.isEmpty());
                this.addContractionEntry(511, this.ce0, this.ce1);
                this.charCEs[0][0] = 0x180000000L;
                this.charCEs[0][1] = 0L;
            }
            ++n2;
            n3 = (char)(n3 + 1);
        }
        this.contractionCEs.addElement(511L);
    }

    private boolean getCEsFromCE32(CollationData collationData, int n2, int n3) {
        int n4;
        n3 = collationData.getFinalCE32(n3);
        this.ce1 = 0L;
        if (Collation.isSimpleOrLongCE32(n3)) {
            this.ce0 = Collation.ceFromCE32(n3);
        } else {
            switch (Collation.tagFromCE32(n3)) {
                case 4: {
                    this.ce0 = Collation.latinCE0FromCE32(n3);
                    this.ce1 = Collation.latinCE1FromCE32(n3);
                    break;
                }
                case 5: {
                    int n5 = Collation.indexFromCE32(n3);
                    int n6 = Collation.lengthFromCE32(n3);
                    if (n6 <= 2) {
                        this.ce0 = Collation.ceFromCE32(collationData.ce32s[n5]);
                        if (n6 != 2) break;
                        this.ce1 = Collation.ceFromCE32(collationData.ce32s[n5 + 1]);
                        break;
                    }
                    return false;
                }
                case 6: {
                    int n5 = Collation.indexFromCE32(n3);
                    int n7 = Collation.lengthFromCE32(n3);
                    if (n7 <= 2) {
                        this.ce0 = collationData.ces[n5];
                        if (n7 != 2) break;
                        this.ce1 = collationData.ces[n5 + 1];
                        break;
                    }
                    return false;
                }
                case 9: {
                    assert (n2 >= 0);
                    return this.getCEsFromContractionCE32(collationData, n3);
                }
                case 14: {
                    assert (n2 >= 0);
                    this.ce0 = collationData.getCEFromOffsetCE32(n2, n3);
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (this.ce0 == 0L) {
            return this.ce1 == 0L;
        }
        long l2 = this.ce0 >>> 32;
        if (l2 == 0L) {
            return false;
        }
        if (l2 > this.lastLatinPrimary) {
            return false;
        }
        int n8 = (int)this.ce0;
        if (l2 < this.firstShortPrimary && (n4 = n8 & 0xFFFFC000) != 0x5000000) {
            return false;
        }
        if ((n8 & 0x3F3F) < 1280) {
            return false;
        }
        if (this.ce1 != 0L) {
            int n9;
            long l3 = this.ce1 >>> 32;
            if (l3 == 0L ? l2 < this.firstShortPrimary : !this.inSameGroup(l2, l3)) {
                return false;
            }
            int n10 = (int)this.ce1;
            if (n10 >>> 16 == 0) {
                return false;
            }
            if (l3 != 0L && l3 < this.firstShortPrimary && (n9 = n10 & 0xFFFFC000) != 0x5000000) {
                return false;
            }
            if ((n8 & 0x3F3F) < 1280) {
                return false;
            }
        }
        return ((this.ce0 | this.ce1) & 0xC0L) == 0L;
    }

    private boolean getCEsFromContractionCE32(CollationData collationData, int n2) {
        int n3 = Collation.indexFromCE32(n2);
        n2 = collationData.getCE32FromContexts(n3);
        assert (!Collation.isContractionCE32(n2));
        int n4 = this.contractionCEs.size();
        if (this.getCEsFromCE32(collationData, -1, n2)) {
            this.addContractionEntry(511, this.ce0, this.ce1);
        } else {
            this.addContractionEntry(511, 0x101000100L, 0L);
        }
        int n5 = -1;
        boolean bl2 = false;
        CharsTrie.Iterator iterator = CharsTrie.iterator(collationData.contexts, n3 + 2, 0);
        while (iterator.hasNext()) {
            CharsTrie.Entry entry = iterator.next();
            CharSequence charSequence = entry.chars;
            int n6 = CollationFastLatin.getCharIndex(charSequence.charAt(0));
            if (n6 < 0) continue;
            if (n6 == n5) {
                if (!bl2) continue;
                this.addContractionEntry(n6, 0x101000100L, 0L);
                bl2 = false;
                continue;
            }
            if (bl2) {
                this.addContractionEntry(n5, this.ce0, this.ce1);
            }
            n2 = entry.value;
            if (charSequence.length() == 1 && this.getCEsFromCE32(collationData, -1, n2)) {
                bl2 = true;
            } else {
                this.addContractionEntry(n6, 0x101000100L, 0L);
                bl2 = false;
            }
            n5 = n6;
        }
        if (bl2) {
            this.addContractionEntry(n5, this.ce0, this.ce1);
        }
        this.ce0 = 0x180000000L | (long)n4;
        this.ce1 = 0L;
        return true;
    }

    private void addContractionEntry(int n2, long l2, long l3) {
        this.contractionCEs.addElement(n2);
        this.contractionCEs.addElement(l2);
        this.contractionCEs.addElement(l3);
        this.addUniqueCE(l2);
        this.addUniqueCE(l3);
    }

    private void addUniqueCE(long l2) {
        if (l2 == 0L || l2 >>> 32 == 1L) {
            return;
        }
        int n2 = CollationFastLatinBuilder.binarySearch(this.uniqueCEs.getBuffer(), this.uniqueCEs.size(), l2 &= 0xFFFFFFFFFFFF3FFFL);
        if (n2 < 0) {
            this.uniqueCEs.insertElementAt(l2, ~n2);
        }
    }

    private int getMiniCE(long l2) {
        int n2 = CollationFastLatinBuilder.binarySearch(this.uniqueCEs.getBuffer(), this.uniqueCEs.size(), l2 &= 0xFFFFFFFFFFFF3FFFL);
        assert (n2 >= 0);
        return this.miniCEs[n2];
    }

    /*
     * Unable to fully structure code
     */
    private void encodeUniqueCEs() {
        this.miniCEs = new char[this.uniqueCEs.size()];
        var1_1 = 0;
        var2_2 = this.lastSpecialPrimaries[var1_1];
        if (!CollationFastLatinBuilder.$assertionsDisabled && (int)this.uniqueCEs.elementAti(0) >>> 16 == 0) {
            throw new AssertionError();
        }
        var4_3 = 0L;
        var6_4 = 0;
        var7_5 = 0;
        var8_6 = 0;
        var9_7 = 0;
        for (var10_8 = 0; var10_8 < this.uniqueCEs.size(); ++var10_8) {
            block34: {
                block36: {
                    block35: {
                        block33: {
                            var11_9 = this.uniqueCEs.elementAti(var10_8);
                            var13_10 = var11_9 >>> 32;
                            if (var13_10 == var4_3) break block33;
                            while (var13_10 > var2_2) {
                                if (!CollationFastLatinBuilder.$assertionsDisabled && var7_5 > 4088) {
                                    throw new AssertionError();
                                }
                                this.result.setCharAt(1 + var1_1, (char)var7_5);
                                if (++var1_1 < 4) {
                                    var2_2 = this.lastSpecialPrimaries[var1_1];
                                    continue;
                                }
                                var2_2 = 0xFFFFFFFFL;
                                break;
                            }
                            if (var13_10 >= this.firstShortPrimary) ** GOTO lbl33
                            if (var7_5 == 0) {
                                var7_5 = 3072;
                            } else if (var7_5 < 4088) {
                                var7_5 += 8;
                            } else {
                                this.miniCEs[var10_8] = '\u0001';
                                continue;
lbl33:
                                // 1 sources

                                if (var7_5 < 4096) {
                                    var7_5 = 4096;
                                } else if (var7_5 < 63488) {
                                    var7_5 += 1024;
                                } else {
                                    this.shortPrimaryOverflow = true;
                                    this.miniCEs[var10_8] = '\u0001';
                                    continue;
                                }
                            }
                            var4_3 = var13_10;
                            var6_4 = 1280;
                            var8_6 = 160;
                            var9_7 = 0;
                        }
                        if ((var16_12 = (var15_11 = (int)var11_9) >>> 16) == var6_4) break block34;
                        if (var7_5 != 0) break block35;
                        if (var8_6 == 0) {
                            var8_6 = 384;
                        } else if (var8_6 < 992) {
                            var8_6 += 32;
                        } else {
                            this.miniCEs[var10_8] = '\u0001';
                            continue;
                        }
                        var6_4 = var16_12;
                        var9_7 = 0;
                        break block36;
                    }
                    if (var16_12 >= 1280) ** GOTO lbl70
                    if (var8_6 == 160) {
                        var8_6 = 0;
                    } else if (var8_6 < 128) {
                        var8_6 += 32;
                    } else {
                        this.miniCEs[var10_8] = '\u0001';
                        continue;
lbl70:
                        // 1 sources

                        if (var16_12 == 1280) {
                            var8_6 = 160;
                        } else if (var8_6 < 192) {
                            var8_6 = 192;
                        } else if (var8_6 < 352) {
                            var8_6 += 32;
                        } else {
                            this.miniCEs[var10_8] = '\u0001';
                            continue;
                        }
                    }
                }
                var6_4 = var16_12;
                var9_7 = 0;
            }
            if (!CollationFastLatinBuilder.$assertionsDisabled && (var15_11 & 49152) != 0) {
                throw new AssertionError();
            }
            var17_13 = var15_11 & 16191;
            if (var17_13 > 1280) {
                if (var9_7 < 7) {
                    ++var9_7;
                } else {
                    this.miniCEs[var10_8] = '\u0001';
                    continue;
                }
            }
            if (3072 <= var7_5 && var7_5 <= 4088) {
                if (!CollationFastLatinBuilder.$assertionsDisabled && var8_6 != 160) {
                    throw new AssertionError();
                }
                this.miniCEs[var10_8] = (char)(var7_5 | var9_7);
                continue;
            }
            this.miniCEs[var10_8] = (char)(var7_5 | var8_6 | var9_7);
        }
    }

    private void encodeCharCEs() {
        int n2;
        int n3 = this.result.length();
        for (n2 = 0; n2 < 448; ++n2) {
            this.result.append(0);
        }
        n2 = this.result.length();
        for (int i2 = 0; i2 < 448; ++i2) {
            long l2 = this.charCEs[i2][0];
            if (CollationFastLatinBuilder.isContractionCharCE(l2)) continue;
            int n4 = this.encodeTwoCEs(l2, this.charCEs[i2][1]);
            if (n4 >>> 16 > 0) {
                int n5 = this.result.length() - n2;
                if (n5 > 1023) {
                    n4 = 1;
                } else {
                    this.result.append((char)(n4 >> 16)).append((char)n4);
                    n4 = 0x800 | n5;
                }
            }
            this.result.setCharAt(n3 + i2, (char)n4);
        }
    }

    private void encodeContractions() {
        int n2 = this.headerLength + 448;
        int n3 = this.result.length();
        for (int i2 = 0; i2 < 448; ++i2) {
            long l2;
            long l3 = this.charCEs[i2][0];
            if (!CollationFastLatinBuilder.isContractionCharCE(l3)) continue;
            int n4 = this.result.length() - n2;
            if (n4 > 1023) {
                this.result.setCharAt(this.headerLength + i2, '\u0001');
                continue;
            }
            boolean bl2 = true;
            int n5 = (int)l3 & Integer.MAX_VALUE;
            while ((l2 = this.contractionCEs.elementAti(n5)) != 511L || bl2) {
                long l4;
                long l5 = this.contractionCEs.elementAti(n5 + 1);
                int n6 = this.encodeTwoCEs(l5, l4 = this.contractionCEs.elementAti(n5 + 2));
                if (n6 == 1) {
                    this.result.append((char)(l2 | 0x200L));
                } else if (n6 >>> 16 == 0) {
                    this.result.append((char)(l2 | 0x400L));
                    this.result.append((char)n6);
                } else {
                    this.result.append((char)(l2 | 0x600L));
                    this.result.append((char)(n6 >> 16)).append((char)n6);
                }
                bl2 = false;
                n5 += 3;
            }
            this.result.setCharAt(this.headerLength + i2, (char)(0x400 | n4));
        }
        if (this.result.length() > n3) {
            this.result.append('\u01ff');
        }
    }

    private int encodeTwoCEs(long l2, long l3) {
        int n2;
        if (l2 == 0L) {
            return 0;
        }
        if (l2 == 0x101000100L) {
            return 1;
        }
        assert (l2 >>> 32 != 1L);
        int n3 = this.getMiniCE(l2);
        if (n3 == 1) {
            return n3;
        }
        if (n3 >= 4096) {
            n2 = ((int)l2 & 0xC000) >> 11;
            n3 |= (n2 += 8);
        }
        if (l3 == 0L) {
            return n3;
        }
        n2 = this.getMiniCE(l3);
        if (n2 == 1) {
            return n2;
        }
        int n4 = (int)l3 & 0xC000;
        if (n3 >= 4096 && (n3 & 0x3E0) == 160) {
            int n5 = n2 & 0x3E0;
            int n6 = n2 & 7;
            if (n5 >= 384 && n4 == 0 && n6 == 0) {
                return n3 & 0xFFFFFC1F | n5;
            }
        }
        if (n2 <= 992 || 4096 <= n2) {
            n4 = (n4 >> 11) + 8;
            n2 |= n4;
        }
        return n3 << 16 | n2;
    }

    private static boolean isContractionCharCE(long l2) {
        return l2 >>> 32 == 1L && l2 != 0x101000100L;
    }
}

