/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.Arrays;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUBinary;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2_32;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.USerializedSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationData;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationFastLatin;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationSettings;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.CollationTailoring;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUException;

final class CollationDataReader {
    static final int IX_INDEXES_LENGTH = 0;
    static final int IX_OPTIONS = 1;
    static final int IX_RESERVED2 = 2;
    static final int IX_RESERVED3 = 3;
    static final int IX_JAMO_CE32S_START = 4;
    static final int IX_REORDER_CODES_OFFSET = 5;
    static final int IX_REORDER_TABLE_OFFSET = 6;
    static final int IX_TRIE_OFFSET = 7;
    static final int IX_RESERVED8_OFFSET = 8;
    static final int IX_CES_OFFSET = 9;
    static final int IX_RESERVED10_OFFSET = 10;
    static final int IX_CE32S_OFFSET = 11;
    static final int IX_ROOT_ELEMENTS_OFFSET = 12;
    static final int IX_CONTEXTS_OFFSET = 13;
    static final int IX_UNSAFE_BWD_OFFSET = 14;
    static final int IX_FAST_LATIN_TABLE_OFFSET = 15;
    static final int IX_SCRIPTS_OFFSET = 16;
    static final int IX_COMPRESSIBLE_BYTES_OFFSET = 17;
    static final int IX_RESERVED18_OFFSET = 18;
    static final int IX_TOTAL_SIZE = 19;
    private static final IsAcceptable IS_ACCEPTABLE = new IsAcceptable();
    private static final int DATA_FORMAT = 1430482796;

    static void read(CollationTailoring collationTailoring, ByteBuffer byteBuffer, CollationTailoring collationTailoring2) throws IOException {
        int n2;
        int n3;
        int[] nArray;
        int n4;
        int n5;
        int n6;
        collationTailoring2.version = ICUBinary.readHeader(byteBuffer, 1430482796, IS_ACCEPTABLE);
        if (collationTailoring != null && collationTailoring.getUCAVersion() != collationTailoring2.getUCAVersion()) {
            throw new ICUException("Tailoring UCA version differs from base data UCA version");
        }
        int n7 = byteBuffer.remaining();
        if (n7 < 8) {
            throw new ICUException("not enough bytes");
        }
        int n8 = byteBuffer.getInt();
        if (n8 < 2 || n7 < n8 * 4) {
            throw new ICUException("not enough indexes");
        }
        int[] nArray2 = new int[20];
        nArray2[0] = n8;
        for (n6 = 1; n6 < n8 && n6 < nArray2.length; ++n6) {
            nArray2[n6] = byteBuffer.getInt();
        }
        for (n6 = n8; n6 < nArray2.length; ++n6) {
            nArray2[n6] = -1;
        }
        if (n8 > nArray2.length) {
            ICUBinary.skipBytes(byteBuffer, (n8 - nArray2.length) * 4);
        }
        if (n7 < (n5 = n8 > 19 ? nArray2[19] : (n8 > 5 ? nArray2[n8 - 1] : 0))) {
            throw new ICUException("not enough bytes");
        }
        CollationData collationData = collationTailoring == null ? null : collationTailoring.data;
        n6 = 5;
        int n9 = nArray2[n6];
        n5 = nArray2[n6 + 1] - n9;
        if (n5 >= 4) {
            int n10;
            if (collationData == null) {
                throw new ICUException("Collation base data must not reorder scripts");
            }
            n4 = n5 / 4;
            nArray = ICUBinary.getInts(byteBuffer, n4, n5 & 3);
            for (n10 = 0; n10 < n4 && (nArray[n4 - n10 - 1] & 0xFFFF0000) != 0; ++n10) {
            }
            assert (n10 < n4);
            n4 -= n10;
        } else {
            nArray = new int[]{};
            n4 = 0;
            ICUBinary.skipBytes(byteBuffer, n5);
        }
        byte[] byArray = null;
        n6 = 6;
        n9 = nArray2[n6];
        n5 = nArray2[n6 + 1] - n9;
        if (n5 >= 256) {
            if (n4 == 0) {
                throw new ICUException("Reordering table without reordering codes");
            }
            byArray = new byte[256];
            byteBuffer.get(byArray);
            n5 -= 256;
        }
        ICUBinary.skipBytes(byteBuffer, n5);
        if (collationData != null && collationData.numericPrimary != ((long)nArray2[1] & 0xFF000000L)) {
            throw new ICUException("Tailoring numeric primary weight differs from base data");
        }
        CollationData collationData2 = null;
        n6 = 7;
        n9 = nArray2[n6];
        n5 = nArray2[n6 + 1] - n9;
        if (n5 >= 8) {
            collationTailoring2.ensureOwnedData();
            collationData2 = collationTailoring2.ownedData;
            collationData2.base = collationData;
            collationData2.numericPrimary = (long)nArray2[1] & 0xFF000000L;
            collationData2.trie = collationTailoring2.trie = Trie2_32.createFromSerialized(byteBuffer);
            n3 = collationData2.trie.getSerializedLength();
            if (n3 > n5) {
                throw new ICUException("Not enough bytes for the mappings trie");
            }
            n5 -= n3;
        } else if (collationData != null) {
            collationTailoring2.data = collationData;
        } else {
            throw new ICUException("Missing collation data mappings");
        }
        ICUBinary.skipBytes(byteBuffer, n5);
        n6 = 8;
        n9 = nArray2[n6];
        n5 = nArray2[n6 + 1] - n9;
        ICUBinary.skipBytes(byteBuffer, n5);
        n6 = 9;
        n9 = nArray2[n6];
        n5 = nArray2[n6 + 1] - n9;
        if (n5 >= 8) {
            if (collationData2 == null) {
                throw new ICUException("Tailored ces without tailored trie");
            }
            collationData2.ces = ICUBinary.getLongs(byteBuffer, n5 / 8, n5 & 7);
        } else {
            ICUBinary.skipBytes(byteBuffer, n5);
        }
        n6 = 10;
        n9 = nArray2[n6];
        n5 = nArray2[n6 + 1] - n9;
        ICUBinary.skipBytes(byteBuffer, n5);
        n6 = 11;
        n9 = nArray2[n6];
        n5 = nArray2[n6 + 1] - n9;
        if (n5 >= 4) {
            if (collationData2 == null) {
                throw new ICUException("Tailored ce32s without tailored trie");
            }
            collationData2.ce32s = ICUBinary.getInts(byteBuffer, n5 / 4, n5 & 3);
        } else {
            ICUBinary.skipBytes(byteBuffer, n5);
        }
        n3 = nArray2[4];
        if (n3 >= 0) {
            if (collationData2 == null || collationData2.ce32s == null) {
                throw new ICUException("JamoCE32sStart index into non-existent ce32s[]");
            }
            collationData2.jamoCE32s = new int[67];
            System.arraycopy(collationData2.ce32s, n3, collationData2.jamoCE32s, 0, 67);
        } else if (collationData2 != null) {
            if (collationData != null) {
                collationData2.jamoCE32s = collationData.jamoCE32s;
            } else {
                throw new ICUException("Missing Jamo CE32s for Hangul processing");
            }
        }
        n6 = 12;
        n9 = nArray2[n6];
        n5 = nArray2[n6 + 1] - n9;
        if (n5 >= 4) {
            int n11 = n5 / 4;
            if (collationData2 == null) {
                throw new ICUException("Root elements but no mappings");
            }
            if (n11 <= 4) {
                throw new ICUException("Root elements array too short");
            }
            collationData2.rootElements = new long[n11];
            for (int i2 = 0; i2 < n11; ++i2) {
                collationData2.rootElements[i2] = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            }
            long l2 = collationData2.rootElements[3];
            if (l2 != 0x5000500L) {
                throw new ICUException("Common sec/ter weights in base data differ from the hardcoded value");
            }
            long l3 = collationData2.rootElements[4];
            if (l3 >>> 24 < 69L) {
                throw new ICUException("[fixed last secondary common byte] is too low");
            }
            n5 &= 3;
        }
        ICUBinary.skipBytes(byteBuffer, n5);
        n6 = 13;
        n9 = nArray2[n6];
        n5 = nArray2[n6 + 1] - n9;
        if (n5 >= 2) {
            if (collationData2 == null) {
                throw new ICUException("Tailored contexts without tailored trie");
            }
            collationData2.contexts = ICUBinary.getString(byteBuffer, n5 / 2, n5 & 1);
        } else {
            ICUBinary.skipBytes(byteBuffer, n5);
        }
        n6 = 14;
        n9 = nArray2[n6];
        n5 = nArray2[n6 + 1] - n9;
        if (n5 >= 2) {
            int n12;
            if (collationData2 == null) {
                throw new ICUException("Unsafe-backward-set but no mappings");
            }
            if (collationData == null) {
                collationTailoring2.unsafeBackwardSet = new UnicodeSet(56320, 57343);
                collationData2.nfcImpl.addLcccChars(collationTailoring2.unsafeBackwardSet);
            } else {
                collationTailoring2.unsafeBackwardSet = collationData.unsafeBackwardSet.cloneAsThawed();
            }
            USerializedSet uSerializedSet = new USerializedSet();
            char[] cArray = ICUBinary.getChars(byteBuffer, n5 / 2, n5 & 1);
            n5 = 0;
            uSerializedSet.getSet(cArray, 0);
            n2 = uSerializedSet.countRanges();
            int[] nArray3 = new int[2];
            for (n12 = 0; n12 < n2; ++n12) {
                uSerializedSet.getRange(n12, nArray3);
                collationTailoring2.unsafeBackwardSet.add(nArray3[0], nArray3[1]);
            }
            n12 = 65536;
            int n13 = 55296;
            while (n13 < 56320) {
                if (!collationTailoring2.unsafeBackwardSet.containsNone(n12, n12 + 1023)) {
                    collationTailoring2.unsafeBackwardSet.add(n13);
                }
                ++n13;
                n12 += 1024;
            }
            collationTailoring2.unsafeBackwardSet.freeze();
            collationData2.unsafeBackwardSet = collationTailoring2.unsafeBackwardSet;
        } else if (collationData2 != null) {
            if (collationData != null) {
                collationData2.unsafeBackwardSet = collationData.unsafeBackwardSet;
            } else {
                throw new ICUException("Missing unsafe-backward-set");
            }
        }
        ICUBinary.skipBytes(byteBuffer, n5);
        n6 = 15;
        n9 = nArray2[n6];
        n5 = nArray2[n6 + 1] - n9;
        if (collationData2 != null) {
            collationData2.fastLatinTable = null;
            collationData2.fastLatinTableHeader = null;
            if ((nArray2[1] >> 16 & 0xFF) == 2) {
                if (n5 >= 2) {
                    char c2 = byteBuffer.getChar();
                    int n14 = c2 & 0xFF;
                    collationData2.fastLatinTableHeader = new char[n14];
                    collationData2.fastLatinTableHeader[0] = c2;
                    for (n2 = 1; n2 < n14; ++n2) {
                        collationData2.fastLatinTableHeader[n2] = byteBuffer.getChar();
                    }
                    n2 = n5 / 2 - n14;
                    collationData2.fastLatinTable = ICUBinary.getChars(byteBuffer, n2, n5 & 1);
                    n5 = 0;
                    if (c2 >> 8 != 2) {
                        throw new ICUException("Fast-Latin table version differs from version in data header");
                    }
                } else if (collationData != null) {
                    collationData2.fastLatinTable = collationData.fastLatinTable;
                    collationData2.fastLatinTableHeader = collationData.fastLatinTableHeader;
                }
            }
        }
        ICUBinary.skipBytes(byteBuffer, n5);
        n6 = 16;
        n9 = nArray2[n6];
        n5 = nArray2[n6 + 1] - n9;
        if (n5 >= 2) {
            if (collationData2 == null) {
                throw new ICUException("Script order data but no mappings");
            }
            int n15 = n5 / 2;
            CharBuffer charBuffer = byteBuffer.asCharBuffer();
            collationData2.numScripts = charBuffer.get();
            n2 = n15 - (1 + collationData2.numScripts + 16);
            if (n2 <= 2) {
                throw new ICUException("Script order data too short");
            }
            collationData2.scriptsIndex = new char[collationData2.numScripts + 16];
            charBuffer.get(collationData2.scriptsIndex);
            collationData2.scriptStarts = new char[n2];
            charBuffer.get(collationData2.scriptStarts);
            if (collationData2.scriptStarts[0] != '\u0000' || collationData2.scriptStarts[1] != '\u0300' || collationData2.scriptStarts[n2 - 1] != '\uff00') {
                throw new ICUException("Script order data not valid");
            }
        } else if (collationData2 != null && collationData != null) {
            collationData2.numScripts = collationData.numScripts;
            collationData2.scriptsIndex = collationData.scriptsIndex;
            collationData2.scriptStarts = collationData.scriptStarts;
        }
        ICUBinary.skipBytes(byteBuffer, n5);
        n6 = 17;
        n9 = nArray2[n6];
        n5 = nArray2[n6 + 1] - n9;
        if (n5 >= 256) {
            if (collationData2 == null) {
                throw new ICUException("Data for compressible primary lead bytes but no mappings");
            }
            collationData2.compressibleBytes = new boolean[256];
            for (int i3 = 0; i3 < 256; ++i3) {
                collationData2.compressibleBytes[i3] = byteBuffer.get() != 0;
            }
            n5 -= 256;
        } else if (collationData2 != null) {
            if (collationData != null) {
                collationData2.compressibleBytes = collationData.compressibleBytes;
            } else {
                throw new ICUException("Missing data for compressible primary lead bytes");
            }
        }
        ICUBinary.skipBytes(byteBuffer, n5);
        n6 = 18;
        n9 = nArray2[n6];
        n5 = nArray2[n6 + 1] - n9;
        ICUBinary.skipBytes(byteBuffer, n5);
        CollationSettings collationSettings = collationTailoring2.settings.readOnly();
        int n16 = nArray2[1] & 0xFFFF;
        char[] cArray = new char[384];
        int n17 = CollationFastLatin.getOptions(collationTailoring2.data, collationSettings, cArray);
        if (n16 == collationSettings.options && collationSettings.variableTop != 0L && Arrays.equals(nArray, collationSettings.reorderCodes) && n17 == collationSettings.fastLatinOptions && (n17 < 0 || Arrays.equals(cArray, collationSettings.fastLatinPrimaries))) {
            return;
        }
        CollationSettings collationSettings2 = collationTailoring2.settings.copyOnWrite();
        collationSettings2.options = n16;
        collationSettings2.variableTop = collationTailoring2.data.getLastPrimaryForGroup(4096 + collationSettings2.getMaxVariable());
        if (collationSettings2.variableTop == 0L) {
            throw new ICUException("The maxVariable could not be mapped to a variableTop");
        }
        if (n4 != 0) {
            collationSettings2.aliasReordering(collationData, nArray, n4, byArray);
        }
        collationSettings2.fastLatinOptions = CollationFastLatin.getOptions(collationTailoring2.data, collationSettings2, collationSettings2.fastLatinPrimaries);
    }

    private CollationDataReader() {
    }

    private static final class IsAcceptable
    implements ICUBinary.Authenticate {
        private IsAcceptable() {
        }

        @Override
        public boolean isDataVersionAcceptable(byte[] byArray) {
            return byArray[0] == 5;
        }
    }
}

