/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll;

import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Normalizer2Impl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Trie2_32;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.Collation;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.coll.UVector32;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUException;

public final class CollationData {
    static final int REORDER_RESERVED_BEFORE_LATIN = 4110;
    static final int REORDER_RESERVED_AFTER_LATIN = 4111;
    static final int MAX_NUM_SPECIAL_REORDER_CODES = 8;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    static final int JAMO_CE32S_LENGTH = 67;
    Trie2_32 trie;
    int[] ce32s;
    long[] ces;
    String contexts;
    public CollationData base;
    int[] jamoCE32s = new int[67];
    public Normalizer2Impl nfcImpl;
    long numericPrimary = 0x12000000L;
    public boolean[] compressibleBytes;
    UnicodeSet unsafeBackwardSet;
    public char[] fastLatinTable;
    char[] fastLatinTableHeader;
    int numScripts;
    char[] scriptsIndex;
    char[] scriptStarts;
    public long[] rootElements;

    CollationData(Normalizer2Impl normalizer2Impl) {
        this.nfcImpl = normalizer2Impl;
    }

    public int getCE32(int n2) {
        return this.trie.get(n2);
    }

    int getCE32FromSupplementary(int n2) {
        return this.trie.get(n2);
    }

    boolean isDigit(int n2) {
        return n2 < 1632 ? n2 <= 57 && 48 <= n2 : Collation.hasCE32Tag(this.getCE32(n2), 10);
    }

    public boolean isUnsafeBackward(int n2, boolean bl2) {
        return this.unsafeBackwardSet.contains(n2) || bl2 && this.isDigit(n2);
    }

    public boolean isCompressibleLeadByte(int n2) {
        return this.compressibleBytes[n2];
    }

    public boolean isCompressiblePrimary(long l2) {
        return this.isCompressibleLeadByte((int)l2 >>> 24);
    }

    int getCE32FromContexts(int n2) {
        return this.contexts.charAt(n2) << 16 | this.contexts.charAt(n2 + 1);
    }

    int getIndirectCE32(int n2) {
        assert (Collation.isSpecialCE32(n2));
        int n3 = Collation.tagFromCE32(n2);
        if (n3 == 10) {
            n2 = this.ce32s[Collation.indexFromCE32(n2)];
        } else if (n3 == 13) {
            n2 = -1;
        } else if (n3 == 11) {
            n2 = this.ce32s[0];
        }
        return n2;
    }

    int getFinalCE32(int n2) {
        if (Collation.isSpecialCE32(n2)) {
            n2 = this.getIndirectCE32(n2);
        }
        return n2;
    }

    long getCEFromOffsetCE32(int n2, int n3) {
        long l2 = this.ces[Collation.indexFromCE32(n3)];
        return Collation.makeCE(Collation.getThreeBytePrimaryForOffsetData(n2, l2));
    }

    long getSingleCE(int n2) {
        CollationData collationData;
        int n3 = this.getCE32(n2);
        if (n3 == 192) {
            collationData = this.base;
            n3 = this.base.getCE32(n2);
        } else {
            collationData = this;
        }
        while (Collation.isSpecialCE32(n3)) {
            switch (Collation.tagFromCE32(n3)) {
                case 4: 
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: {
                    throw new UnsupportedOperationException(String.format("there is not exactly one collation element for U+%04X (CE32 0x%08x)", n2, n3));
                }
                case 0: 
                case 3: {
                    throw new AssertionError((Object)String.format("unexpected CE32 tag for U+%04X (CE32 0x%08x)", n2, n3));
                }
                case 1: {
                    return Collation.ceFromLongPrimaryCE32(n3);
                }
                case 2: {
                    return Collation.ceFromLongSecondaryCE32(n3);
                }
                case 5: {
                    if (Collation.lengthFromCE32(n3) == 1) {
                        n3 = collationData.ce32s[Collation.indexFromCE32(n3)];
                        break;
                    }
                    throw new UnsupportedOperationException(String.format("there is not exactly one collation element for U+%04X (CE32 0x%08x)", n2, n3));
                }
                case 6: {
                    if (Collation.lengthFromCE32(n3) == 1) {
                        return collationData.ces[Collation.indexFromCE32(n3)];
                    }
                    throw new UnsupportedOperationException(String.format("there is not exactly one collation element for U+%04X (CE32 0x%08x)", n2, n3));
                }
                case 10: {
                    n3 = collationData.ce32s[Collation.indexFromCE32(n3)];
                    break;
                }
                case 11: {
                    assert (n2 == 0);
                    n3 = collationData.ce32s[0];
                    break;
                }
                case 14: {
                    return collationData.getCEFromOffsetCE32(n2, n3);
                }
                case 15: {
                    return Collation.unassignedCEFromCodePoint(n2);
                }
            }
        }
        return Collation.ceFromSimpleCE32(n3);
    }

    int getFCD16(int n2) {
        return this.nfcImpl.getFCD16(n2);
    }

    long getFirstPrimaryForGroup(int n2) {
        int n3 = this.getScriptIndex(n2);
        return n3 == 0 ? 0L : (long)this.scriptStarts[n3] << 16;
    }

    public long getLastPrimaryForGroup(int n2) {
        int n3 = this.getScriptIndex(n2);
        if (n3 == 0) {
            return 0L;
        }
        long l2 = this.scriptStarts[n3 + 1];
        return (l2 << 16) - 1L;
    }

    public int getGroupForPrimary(long l2) {
        int n2;
        if ((l2 >>= 16) < (long)this.scriptStarts[1] || (long)this.scriptStarts[this.scriptStarts.length - 1] <= l2) {
            return -1;
        }
        char c2 = '\u0001';
        while (l2 >= (long)this.scriptStarts[c2 + 1]) {
            ++c2;
        }
        for (n2 = 0; n2 < this.numScripts; ++n2) {
            if (this.scriptsIndex[n2] != c2) continue;
            return n2;
        }
        for (n2 = 0; n2 < 8; ++n2) {
            if (this.scriptsIndex[this.numScripts + n2] != c2) continue;
            return 4096 + n2;
        }
        return -1;
    }

    private int getScriptIndex(int n2) {
        if (n2 < 0) {
            return 0;
        }
        if (n2 < this.numScripts) {
            return this.scriptsIndex[n2];
        }
        if (n2 < 4096) {
            return 0;
        }
        if ((n2 -= 4096) < 8) {
            return this.scriptsIndex[this.numScripts + n2];
        }
        return 0;
    }

    public int[] getEquivalentScripts(int n2) {
        int n3 = this.getScriptIndex(n2);
        if (n3 == 0) {
            return EMPTY_INT_ARRAY;
        }
        if (n2 >= 4096) {
            return new int[]{n2};
        }
        int n4 = 0;
        for (int i2 = 0; i2 < this.numScripts; ++i2) {
            if (this.scriptsIndex[i2] != n3) continue;
            ++n4;
        }
        int[] nArray = new int[n4];
        if (n4 == 1) {
            nArray[0] = n2;
            return nArray;
        }
        n4 = 0;
        for (int i3 = 0; i3 < this.numScripts; ++i3) {
            if (this.scriptsIndex[i3] != n3) continue;
            nArray[n4++] = i3;
        }
        return nArray;
    }

    void makeReorderRanges(int[] nArray, UVector32 uVector32) {
        this.makeReorderRanges(nArray, false, uVector32);
    }

    private void makeReorderRanges(int[] nArray, boolean bl2, UVector32 uVector32) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        uVector32.removeAllElements();
        int n7 = nArray.length;
        if (n7 == 0 || n7 == 1 && nArray[0] == 103) {
            return;
        }
        short[] sArray = new short[this.scriptStarts.length - 1];
        int n8 = this.scriptsIndex[this.numScripts + 4110 - 4096];
        if (n8 != 0) {
            sArray[n8] = 255;
        }
        if ((n8 = this.scriptsIndex[this.numScripts + 4111 - 4096]) != 0) {
            sArray[n8] = 255;
        }
        assert (this.scriptStarts.length >= 2);
        assert (this.scriptStarts[0] == '\u0000');
        n8 = this.scriptStarts[1];
        assert (n8 == 768);
        int n9 = this.scriptStarts[this.scriptStarts.length - 1];
        assert (n9 == 65280);
        int n10 = 0;
        for (n6 = 0; n6 < n7; ++n6) {
            n5 = nArray[n6] - 4096;
            if (0 > n5 || n5 >= 8) continue;
            n10 |= 1 << n5;
        }
        for (n6 = 0; n6 < 8; ++n6) {
            n5 = this.scriptsIndex[this.numScripts + n6];
            if (n5 == 0 || (n10 & 1 << n6) != 0) continue;
            n8 = this.addLowScriptRange(sArray, n5, n8);
        }
        n6 = 0;
        if (n10 == 0 && nArray[0] == 25 && !bl2) {
            n5 = this.scriptsIndex[25];
            assert (n5 != 0);
            n4 = this.scriptStarts[n5];
            assert (n8 <= n4);
            n6 = n4 - n8;
            n8 = n4;
        }
        n5 = 0;
        n4 = 0;
        while (n4 < n7) {
            if ((n3 = nArray[n4++]) == 103) {
                n5 = 1;
                while (n4 < n7) {
                    if ((n3 = nArray[--n7]) == 103) {
                        throw new IllegalArgumentException("setReorderCodes(): duplicate UScript.UNKNOWN");
                    }
                    if (n3 == -1) {
                        throw new IllegalArgumentException("setReorderCodes(): UScript.DEFAULT together with other scripts");
                    }
                    n2 = this.getScriptIndex(n3);
                    if (n2 == 0) continue;
                    if (sArray[n2] != 0) {
                        throw new IllegalArgumentException("setReorderCodes(): duplicate or equivalent script " + CollationData.scriptCodeString(n3));
                    }
                    n9 = this.addHighScriptRange(sArray, n2, n9);
                }
                break;
            }
            if (n3 == -1) {
                throw new IllegalArgumentException("setReorderCodes(): UScript.DEFAULT together with other scripts");
            }
            n2 = this.getScriptIndex(n3);
            if (n2 == 0) continue;
            if (sArray[n2] != 0) {
                throw new IllegalArgumentException("setReorderCodes(): duplicate or equivalent script " + CollationData.scriptCodeString(n3));
            }
            n8 = this.addLowScriptRange(sArray, n2, n8);
        }
        for (n4 = 1; n4 < this.scriptStarts.length - 1; ++n4) {
            n3 = sArray[n4];
            if (n3 != 0) continue;
            n2 = this.scriptStarts[n4];
            if (n5 == 0 && n2 > n8) {
                n8 = n2;
            }
            n8 = this.addLowScriptRange(sArray, n4, n8);
        }
        if (n8 > n9) {
            if (n8 - (n6 & 0xFF00) <= n9) {
                this.makeReorderRanges(nArray, true, uVector32);
                return;
            }
            throw new ICUException("setReorderCodes(): reordering too many partial-primary-lead-byte scripts");
        }
        n4 = 0;
        n3 = 1;
        while (true) {
            short s2;
            n2 = n4;
            while (n3 < this.scriptStarts.length - 1 && ((s2 = sArray[n3]) == 255 || (n2 = s2 - (this.scriptStarts[n3] >> 8)) == n4)) {
                ++n3;
            }
            if (n4 != 0 || n3 < this.scriptStarts.length - 1) {
                uVector32.addElement(this.scriptStarts[n3] << 16 | n4 & 0xFFFF);
            }
            if (n3 == this.scriptStarts.length - 1) break;
            n4 = n2;
            ++n3;
        }
    }

    private int addLowScriptRange(short[] sArray, int n2, int n3) {
        char c2 = this.scriptStarts[n2];
        if ((c2 & 0xFF) < (n3 & 0xFF)) {
            n3 += 256;
        }
        sArray[n2] = (short)(n3 >> 8);
        char c3 = this.scriptStarts[n2 + 1];
        n3 = (n3 & 0xFF00) + ((c3 & 0xFF00) - (c2 & 0xFF00)) | c3 & 0xFF;
        return n3;
    }

    private int addHighScriptRange(short[] sArray, int n2, int n3) {
        char c2 = this.scriptStarts[n2 + 1];
        if ((c2 & 0xFF) > (n3 & 0xFF)) {
            n3 -= 256;
        }
        char c3 = this.scriptStarts[n2];
        n3 = (n3 & 0xFF00) - ((c2 & 0xFF00) - (c3 & 0xFF00)) | c3 & 0xFF;
        sArray[n2] = (short)(n3 >> 8);
        return n3;
    }

    private static String scriptCodeString(int n2) {
        return n2 < 4096 ? Integer.toString(n2) : "0x" + Integer.toHexString(n2);
    }
}

