/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.CharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.DictionaryBreakEngine;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UScript;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.BreakIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public class LSTMBreakEngine
extends DictionaryBreakEngine {
    private static final byte MIN_WORD = 2;
    private static final byte MIN_WORD_SPAN = 4;
    private final LSTMData fData;
    private int fScript;
    private final Vectorizer fVectorizer;

    private static float[][] make2DArray(int[] nArray, int n2, int n3, int n4) {
        byte[] byArray = new byte[4];
        float[][] fArray = new float[n3][n4];
        for (int i2 = 0; i2 < n3; ++i2) {
            for (int i3 = 0; i3 < n4; ++i3) {
                int n5 = nArray[n2++];
                byArray[0] = (byte)(n5 >> 24);
                byArray[1] = (byte)(n5 >> 16);
                byArray[2] = (byte)(n5 >> 8);
                byArray[3] = (byte)n5;
                fArray[i2][i3] = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN).getFloat();
            }
        }
        return fArray;
    }

    private static float[] make1DArray(int[] nArray, int n2, int n3) {
        byte[] byArray = new byte[4];
        float[] fArray = new float[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = nArray[n2++];
            byArray[0] = (byte)(n4 >> 24);
            byArray[1] = (byte)(n4 >> 16);
            byArray[2] = (byte)(n4 >> 8);
            byArray[3] = (byte)n4;
            fArray[i2] = ByteBuffer.wrap(byArray).order(ByteOrder.BIG_ENDIAN).getFloat();
        }
        return fArray;
    }

    private Vectorizer makeVectorizer(LSTMData lSTMData) {
        switch (lSTMData.fType) {
            case CODE_POINTS: {
                return new CodePointsVectorizer(lSTMData.fDict);
            }
            case GRAPHEME_CLUSTER: {
                return new GraphemeClusterVectorizer(lSTMData.fDict);
            }
        }
        return null;
    }

    public LSTMBreakEngine(int n2, UnicodeSet unicodeSet, LSTMData lSTMData) {
        this.setCharacters(unicodeSet);
        this.fScript = n2;
        this.fData = lSTMData;
        this.fVectorizer = this.makeVectorizer(this.fData);
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    @Override
    public boolean handles(int n2) {
        return this.fScript == UCharacter.getIntPropertyValue(n2, 4106);
    }

    private static void addDotProductTo(float[] fArray, float[][] fArray2, float[] fArray3) {
        assert (fArray.length == fArray2.length);
        assert (fArray2[0].length == fArray3.length);
        for (int i2 = 0; i2 < fArray3.length; ++i2) {
            for (int i3 = 0; i3 < fArray.length; ++i3) {
                int n2 = i2;
                fArray3[n2] = fArray3[n2] + fArray[i3] * fArray2[i3][i2];
            }
        }
    }

    private static void addTo(float[] fArray, float[] fArray2) {
        assert (fArray.length == fArray2.length);
        for (int i2 = 0; i2 < fArray2.length; ++i2) {
            int n2 = i2;
            fArray2[n2] = fArray2[n2] + fArray[i2];
        }
    }

    private static void hadamardProductTo(float[] fArray, float[] fArray2) {
        assert (fArray.length == fArray2.length);
        for (int i2 = 0; i2 < fArray2.length; ++i2) {
            int n2 = i2;
            fArray2[n2] = fArray2[n2] * fArray[i2];
        }
    }

    private static void addHadamardProductTo(float[] fArray, float[] fArray2, float[] fArray3) {
        assert (fArray.length == fArray3.length);
        assert (fArray2.length == fArray3.length);
        for (int i2 = 0; i2 < fArray3.length; ++i2) {
            int n2 = i2;
            fArray3[n2] = fArray3[n2] + fArray[i2] * fArray2[i2];
        }
    }

    private static void sigmoid(float[] fArray, int n2, int n3) {
        assert (n2 < fArray.length);
        assert (n2 + n3 <= fArray.length);
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            fArray[i2] = (float)(1.0 / (1.0 + Math.exp(-fArray[i2])));
        }
    }

    private static void tanh(float[] fArray, int n2, int n3) {
        assert (n2 < fArray.length);
        assert (n2 + n3 <= fArray.length);
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            fArray[i2] = (float)Math.tanh(fArray[i2]);
        }
    }

    private static int maxIndex(float[] fArray) {
        int n2 = 0;
        float f2 = fArray[0];
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            if (!(fArray[i2] > f2)) continue;
            f2 = fArray[i2];
            n2 = i2;
        }
        return n2;
    }

    private float[] compute(float[][] fArray, float[][] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6) {
        float[] fArray7 = Arrays.copyOf(fArray3, fArray3.length);
        LSTMBreakEngine.addDotProductTo(fArray4, fArray, fArray7);
        float[] fArray8 = new float[fArray3.length];
        LSTMBreakEngine.addDotProductTo(fArray5, fArray2, fArray7);
        int n2 = fArray3.length / 4;
        LSTMBreakEngine.sigmoid(fArray7, 0 * n2, n2);
        LSTMBreakEngine.sigmoid(fArray7, 1 * n2, n2);
        LSTMBreakEngine.tanh(fArray7, 2 * n2, n2);
        LSTMBreakEngine.sigmoid(fArray7, 3 * n2, n2);
        LSTMBreakEngine.hadamardProductTo(Arrays.copyOfRange(fArray7, n2, 2 * n2), fArray6);
        LSTMBreakEngine.addHadamardProductTo(Arrays.copyOf(fArray7, n2), Arrays.copyOfRange(fArray7, 2 * n2, 3 * n2), fArray6);
        fArray5 = Arrays.copyOf(fArray6, fArray6.length);
        LSTMBreakEngine.tanh(fArray5, 0, fArray5.length);
        LSTMBreakEngine.hadamardProductTo(Arrays.copyOfRange(fArray7, 3 * n2, 4 * n2), fArray5);
        return fArray5;
    }

    @Override
    public int divideUpDictionaryRange(CharacterIterator characterIterator, int n2, int n3, DictionaryBreakEngine.DequeI dequeI, boolean bl2) {
        int n4 = dequeI.size();
        if (n3 - n2 < 4) {
            return 0;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n3 - n2);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(n3 - n2);
        this.fVectorizer.vectorize(characterIterator, n2, n3, arrayList, arrayList2);
        int n5 = arrayList2.size();
        int n6 = this.fData.fForwardU.length;
        float[] fArray = new float[n6];
        float[][] fArray2 = new float[n5][n6];
        for (int i2 = n5 - 1; i2 >= 0; --i2) {
            if (i2 != n5 - 1) {
                fArray2[i2] = Arrays.copyOf(fArray2[i2 + 1], n6);
            }
            fArray2[i2] = this.compute(this.fData.fBackwardW, this.fData.fBackwardU, this.fData.fBackwardB, this.fData.fEmbedding[(Integer)arrayList2.get(i2)], fArray2[i2], fArray);
        }
        fArray = new float[n6];
        float[] fArray3 = new float[n6];
        float[] fArray4 = new float[2 * n6];
        for (int i3 = 0; i3 < n5; ++i3) {
            fArray3 = this.compute(this.fData.fForwardW, this.fData.fForwardU, this.fData.fForwardB, this.fData.fEmbedding[(Integer)arrayList2.get(i3)], fArray3, fArray);
            System.arraycopy(fArray3, 0, fArray4, 0, n6);
            System.arraycopy(fArray2[i3], 0, fArray4, n6, n6);
            float[] fArray5 = Arrays.copyOf(this.fData.fOutputB, this.fData.fOutputB.length);
            LSTMBreakEngine.addDotProductTo(fArray4, this.fData.fOutputW, fArray5);
            int n7 = LSTMBreakEngine.maxIndex(fArray5);
            if (n7 != LSTMClass.BEGIN.ordinal() && n7 != LSTMClass.SINGLE.ordinal() || i3 == 0) continue;
            dequeI.push((Integer)arrayList.get(i3));
        }
        return dequeI.size() - n4;
    }

    public static LSTMData createData(UResourceBundle uResourceBundle) {
        return new LSTMData(uResourceBundle);
    }

    private static String defaultLSTM(int n2) {
        ICUResourceBundle iCUResourceBundle = (ICUResourceBundle)UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/brkitr");
        return iCUResourceBundle.getStringWithFallback("lstm/" + UScript.getShortName(n2));
    }

    public static LSTMData createData(int n2) {
        if (n2 != 23 && n2 != 24 && n2 != 28 && n2 != 38) {
            return null;
        }
        String string = LSTMBreakEngine.defaultLSTM(n2);
        string = string.substring(0, string.indexOf("."));
        UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b/brkitr", string, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        return LSTMBreakEngine.createData(uResourceBundle);
    }

    public static LSTMBreakEngine create(int n2, LSTMData lSTMData) {
        String string = "[[:" + UScript.getShortName(n2) + ":]&[:LineBreak=SA:]]";
        UnicodeSet unicodeSet = new UnicodeSet();
        unicodeSet.applyPattern(string);
        unicodeSet.compact();
        return new LSTMBreakEngine(n2, unicodeSet, lSTMData);
    }

    class GraphemeClusterVectorizer
    extends Vectorizer {
        public GraphemeClusterVectorizer(Map<String, Integer> map) {
            super(map);
        }

        private String substring(CharacterIterator characterIterator, int n2, int n3) {
            int n4 = characterIterator.getIndex();
            characterIterator.setIndex(n2);
            StringBuilder stringBuilder = new StringBuilder();
            char c2 = characterIterator.current();
            while (c2 != '\uffff' && characterIterator.getIndex() < n3) {
                stringBuilder.append(c2);
                c2 = characterIterator.next();
            }
            characterIterator.setIndex(n4);
            return stringBuilder.toString();
        }

        @Override
        public void vectorize(CharacterIterator characterIterator, int n2, int n3, List<Integer> list, List<Integer> list2) {
            BreakIterator breakIterator = BreakIterator.getCharacterInstance();
            breakIterator.setText(characterIterator);
            int n4 = breakIterator.next(n2);
            int n5 = breakIterator.next();
            while (n5 != -1 && n5 <= n3) {
                list.add(n4);
                String string = this.substring(characterIterator, n4, n5);
                int n6 = this.getIndex(string);
                list2.add(n6);
                n4 = n5;
                n5 = breakIterator.next();
            }
        }
    }

    class CodePointsVectorizer
    extends Vectorizer {
        public CodePointsVectorizer(Map<String, Integer> map) {
            super(map);
        }

        @Override
        public void vectorize(CharacterIterator characterIterator, int n2, int n3, List<Integer> list, List<Integer> list2) {
            characterIterator.setIndex(n2);
            char c2 = characterIterator.current();
            while (c2 != '\uffff' && characterIterator.getIndex() < n3) {
                list.add(characterIterator.getIndex());
                list2.add(this.getIndex(String.valueOf(c2)));
                c2 = characterIterator.next();
            }
        }
    }

    abstract class Vectorizer {
        private Map<String, Integer> fDict;

        public Vectorizer(Map<String, Integer> map) {
            this.fDict = map;
        }

        public abstract void vectorize(CharacterIterator var1, int var2, int var3, List<Integer> var4, List<Integer> var5);

        protected int getIndex(String string) {
            Integer n2 = this.fDict.get(string);
            return n2 == null ? this.fDict.size() : n2.intValue();
        }
    }

    public static class LSTMData {
        public EmbeddingType fType;
        public String fName;
        public Map<String, Integer> fDict;
        public float[][] fEmbedding;
        public float[][] fForwardW;
        public float[][] fForwardU;
        public float[] fForwardB;
        public float[][] fBackwardW;
        public float[][] fBackwardU;
        public float[] fBackwardB;
        public float[][] fOutputW;
        public float[] fOutputB;

        private LSTMData() {
        }

        public LSTMData(UResourceBundle uResourceBundle) {
            int n2 = uResourceBundle.get("embeddings").getInt();
            int n3 = uResourceBundle.get("hunits").getInt();
            this.fType = EmbeddingType.UNKNOWN;
            this.fName = uResourceBundle.get("model").getString();
            String string = uResourceBundle.get("type").getString();
            if (string.equals("codepoints")) {
                this.fType = EmbeddingType.CODE_POINTS;
            } else if (string.equals("graphclust")) {
                this.fType = EmbeddingType.GRAPHEME_CLUSTER;
            }
            String[] stringArray = uResourceBundle.get("dict").getStringArray();
            int[] nArray = uResourceBundle.get("data").getIntVector();
            int n4 = nArray.length;
            int n5 = stringArray.length;
            this.fDict = new HashMap<String, Integer>(n5 + 1);
            int n6 = 0;
            for (String string2 : stringArray) {
                this.fDict.put(string2, n6++);
            }
            int n7 = (n5 + 1) * n2;
            int n8 = n2 * 4 * n3;
            int n9 = n3 * 4 * n3;
            int n10 = 4 * n3;
            int n11 = n8;
            int n12 = n9;
            int n13 = n10;
            int n14 = 2 * n3 * 4;
            int n15 = 4;
            assert (n4 == n7 + n8 + n9 + n10 + n11 + n12 + n13 + n14 + n15);
            int n16 = 0;
            this.fEmbedding = LSTMBreakEngine.make2DArray(nArray, n16, n5 + 1, n2);
            this.fForwardW = LSTMBreakEngine.make2DArray(nArray, n16 += n7, n2, 4 * n3);
            this.fForwardU = LSTMBreakEngine.make2DArray(nArray, n16 += n8, n3, 4 * n3);
            this.fForwardB = LSTMBreakEngine.make1DArray(nArray, n16 += n9, 4 * n3);
            this.fBackwardW = LSTMBreakEngine.make2DArray(nArray, n16 += n10, n2, 4 * n3);
            this.fBackwardU = LSTMBreakEngine.make2DArray(nArray, n16 += n11, n3, 4 * n3);
            this.fBackwardB = LSTMBreakEngine.make1DArray(nArray, n16 += n12, 4 * n3);
            this.fOutputW = LSTMBreakEngine.make2DArray(nArray, n16 += n13, 2 * n3, 4);
            this.fOutputB = LSTMBreakEngine.make1DArray(nArray, n16 += n14, 4);
        }
    }

    public static enum LSTMClass {
        BEGIN,
        INSIDE,
        END,
        SINGLE;

    }

    public static enum EmbeddingType {
        UNKNOWN,
        CODE_POINTS,
        GRAPHEME_CLUSTER;

    }
}

