/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter;

import java.text.CharacterIterator;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.CharacterIteration;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.DictionaryMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.breakiter.LanguageBreakEngine;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;

public abstract class DictionaryBreakEngine
implements LanguageBreakEngine {
    UnicodeSet fSet = new UnicodeSet();

    @Override
    public boolean handles(int n2) {
        return this.fSet.contains(n2);
    }

    @Override
    public int findBreaks(CharacterIterator characterIterator, int n2, int n3, DequeI dequeI, boolean bl2) {
        int n4;
        int n5 = 0;
        int n6 = characterIterator.getIndex();
        int n7 = CharacterIteration.current32(characterIterator);
        while ((n4 = characterIterator.getIndex()) < n3 && this.fSet.contains(n7)) {
            CharacterIteration.next32(characterIterator);
            n7 = CharacterIteration.current32(characterIterator);
        }
        int n8 = n6;
        int n9 = n4;
        n5 = this.divideUpDictionaryRange(characterIterator, n8, n9, dequeI, bl2);
        characterIterator.setIndex(n4);
        return n5;
    }

    void setCharacters(UnicodeSet unicodeSet) {
        this.fSet = new UnicodeSet(unicodeSet);
        this.fSet.compact();
    }

    abstract int divideUpDictionaryRange(CharacterIterator var1, int var2, int var3, DequeI var4, boolean var5);

    public static class DequeI
    implements Cloneable {
        private int[] data = new int[50];
        private int lastIdx = 4;
        private int firstIdx = 4;

        public Object clone() throws CloneNotSupportedException {
            DequeI dequeI = (DequeI)super.clone();
            dequeI.data = (int[])this.data.clone();
            return dequeI;
        }

        public int size() {
            return this.firstIdx - this.lastIdx;
        }

        public boolean isEmpty() {
            return this.size() == 0;
        }

        private void grow() {
            int[] nArray = new int[this.data.length * 2];
            System.arraycopy(this.data, 0, nArray, 0, this.data.length);
            this.data = nArray;
        }

        public void offer(int n2) {
            assert (this.lastIdx > 0);
            this.data[--this.lastIdx] = n2;
        }

        public void push(int n2) {
            if (this.firstIdx >= this.data.length) {
                this.grow();
            }
            this.data[this.firstIdx++] = n2;
        }

        public int pop() {
            assert (this.size() > 0);
            return this.data[--this.firstIdx];
        }

        public int peek() {
            assert (this.size() > 0);
            return this.data[this.firstIdx - 1];
        }

        int peekLast() {
            assert (this.size() > 0);
            return this.data[this.lastIdx];
        }

        int pollLast() {
            assert (this.size() > 0);
            return this.data[this.lastIdx++];
        }

        boolean contains(int n2) {
            for (int i2 = this.lastIdx; i2 < this.firstIdx; ++i2) {
                if (this.data[i2] != n2) continue;
                return true;
            }
            return false;
        }

        public int elementAt(int n2) {
            assert (n2 < this.size());
            return this.data[this.lastIdx + n2];
        }

        public void removeAllElements() {
            this.firstIdx = 4;
            this.lastIdx = 4;
        }
    }

    static class PossibleWord {
        private static final int POSSIBLE_WORD_LIST_MAX = 20;
        private int[] lengths = new int[20];
        private int[] count = new int[1];
        private int prefix;
        private int offset = -1;
        private int mark;
        private int current;

        public int candidates(CharacterIterator characterIterator, DictionaryMatcher dictionaryMatcher, int n2) {
            int n3 = characterIterator.getIndex();
            if (n3 != this.offset) {
                this.offset = n3;
                this.prefix = dictionaryMatcher.matches(characterIterator, n2 - n3, this.lengths, this.count, this.lengths.length);
                if (this.count[0] <= 0) {
                    characterIterator.setIndex(n3);
                }
            }
            if (this.count[0] > 0) {
                characterIterator.setIndex(n3 + this.lengths[this.count[0] - 1]);
            }
            this.mark = this.current = this.count[0] - 1;
            return this.count[0];
        }

        public int acceptMarked(CharacterIterator characterIterator) {
            characterIterator.setIndex(this.offset + this.lengths[this.mark]);
            return this.lengths[this.mark];
        }

        public boolean backUp(CharacterIterator characterIterator) {
            if (this.current > 0) {
                characterIterator.setIndex(this.offset + this.lengths[--this.current]);
                return true;
            }
            return false;
        }

        public int longestPrefix() {
            return this.prefix;
        }

        public void markCurrent() {
            this.mark = this.current;
        }
    }
}

