/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.lang.ref.SoftReference;
import java.util.Collections;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.ICUResourceBundle;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.OlsonTimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SimpleCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.SoftCache;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Output;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.SimpleTimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.TimeZone;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.UResourceBundle;

public final class ZoneMeta {
    private static final boolean ASSERT = false;
    private static final String ZONEINFORESNAME = "zoneinfo64";
    private static final String kREGIONS = "Regions";
    private static final String kZONES = "Zones";
    private static final String kNAMES = "Names";
    private static final String kGMT_ID = "GMT";
    private static final String kCUSTOM_TZ_PREFIX = "GMT";
    private static final String kWorld = "001";
    private static SoftReference<Set<String>> REF_SYSTEM_ZONES;
    private static SoftReference<Set<String>> REF_CANONICAL_SYSTEM_ZONES;
    private static SoftReference<Set<String>> REF_CANONICAL_SYSTEM_LOCATION_ZONES;
    private static String[] ZONEIDS;
    private static ICUCache<String, String> CANONICAL_ID_CACHE;
    private static ICUCache<String, String> REGION_CACHE;
    private static ICUCache<String, Boolean> SINGLE_COUNTRY_CACHE;
    private static final SystemTimeZoneCache SYSTEM_ZONE_CACHE;
    private static final int kMAX_CUSTOM_HOUR = 23;
    private static final int kMAX_CUSTOM_MIN = 59;
    private static final int kMAX_CUSTOM_SEC = 59;
    private static final CustomTimeZoneCache CUSTOM_ZONE_CACHE;

    private static synchronized Set<String> getSystemZIDs() {
        Set<String> set = null;
        if (REF_SYSTEM_ZONES != null) {
            set = REF_SYSTEM_ZONES.get();
        }
        if (set == null) {
            String[] stringArray;
            TreeSet<String> treeSet = new TreeSet<String>();
            for (String string : stringArray = ZoneMeta.getZoneIDs()) {
                if (string.equals("Etc/Unknown")) continue;
                treeSet.add(string);
            }
            set = Collections.unmodifiableSet(treeSet);
            REF_SYSTEM_ZONES = new SoftReference<Set<String>>(set);
        }
        return set;
    }

    private static synchronized Set<String> getCanonicalSystemZIDs() {
        Set<String> set = null;
        if (REF_CANONICAL_SYSTEM_ZONES != null) {
            set = REF_CANONICAL_SYSTEM_ZONES.get();
        }
        if (set == null) {
            String[] stringArray;
            TreeSet<String> treeSet = new TreeSet<String>();
            for (String string : stringArray = ZoneMeta.getZoneIDs()) {
                String string2;
                if (string.equals("Etc/Unknown") || !string.equals(string2 = ZoneMeta.getCanonicalCLDRID(string))) continue;
                treeSet.add(string);
            }
            set = Collections.unmodifiableSet(treeSet);
            REF_CANONICAL_SYSTEM_ZONES = new SoftReference<Set<String>>(set);
        }
        return set;
    }

    private static synchronized Set<String> getCanonicalSystemLocationZIDs() {
        Set<String> set = null;
        if (REF_CANONICAL_SYSTEM_LOCATION_ZONES != null) {
            set = REF_CANONICAL_SYSTEM_LOCATION_ZONES.get();
        }
        if (set == null) {
            String[] stringArray;
            TreeSet<String> treeSet = new TreeSet<String>();
            for (String string : stringArray = ZoneMeta.getZoneIDs()) {
                String string2;
                String string3;
                if (string.equals("Etc/Unknown") || !string.equals(string3 = ZoneMeta.getCanonicalCLDRID(string)) || (string2 = ZoneMeta.getRegion(string)) == null || string2.equals(kWorld)) continue;
                treeSet.add(string);
            }
            set = Collections.unmodifiableSet(treeSet);
            REF_CANONICAL_SYSTEM_LOCATION_ZONES = new SoftReference<Set<String>>(set);
        }
        return set;
    }

    public static Set<String> getAvailableIDs(TimeZone.SystemTimeZoneType systemTimeZoneType, String string, Integer n2) {
        Set<String> set = null;
        switch (systemTimeZoneType) {
            case ANY: {
                set = ZoneMeta.getSystemZIDs();
                break;
            }
            case CANONICAL: {
                set = ZoneMeta.getCanonicalSystemZIDs();
                break;
            }
            case CANONICAL_LOCATION: {
                set = ZoneMeta.getCanonicalSystemLocationZIDs();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SystemTimeZoneType");
            }
        }
        if (string == null && n2 == null) {
            return set;
        }
        if (string != null) {
            string = string.toUpperCase(Locale.ENGLISH);
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string2 : set) {
            Object object;
            if (string != null && !string.equals(object = ZoneMeta.getRegion(string2)) || n2 != null && ((object = ZoneMeta.getSystemTimeZone(string2)) == null || !n2.equals(((TimeZone)object).getRawOffset()))) continue;
            treeSet.add(string2);
        }
        if (treeSet.isEmpty()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(treeSet);
    }

    public static synchronized int countEquivalentIDs(String string) {
        int n2 = 0;
        UResourceBundle uResourceBundle = ZoneMeta.openOlsonResource(null, string);
        if (uResourceBundle != null) {
            try {
                UResourceBundle uResourceBundle2 = uResourceBundle.get("links");
                int[] nArray = uResourceBundle2.getIntVector();
                n2 = nArray.length;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return n2;
    }

    public static synchronized String getEquivalentID(String string, int n2) {
        UResourceBundle uResourceBundle;
        Object object = "";
        if (n2 >= 0 && (uResourceBundle = ZoneMeta.openOlsonResource(null, string)) != null) {
            Object object2;
            int n3 = -1;
            try {
                object2 = uResourceBundle.get("links");
                int[] nArray = ((UResourceBundle)object2).getIntVector();
                if (n2 < nArray.length) {
                    n3 = nArray[n2];
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (n3 >= 0 && (object2 = ZoneMeta.getZoneID(n3)) != null) {
                object = object2;
            }
        }
        return object;
    }

    private static synchronized String[] getZoneIDs() {
        if (ZONEIDS == null) {
            try {
                UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", ZONEINFORESNAME, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                ZONEIDS = uResourceBundle.getStringArray(kNAMES);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        if (ZONEIDS == null) {
            ZONEIDS = new String[0];
        }
        return ZONEIDS;
    }

    private static String getZoneID(int n2) {
        String[] stringArray;
        if (n2 >= 0 && n2 < (stringArray = ZoneMeta.getZoneIDs()).length) {
            return stringArray[n2];
        }
        return null;
    }

    private static int getZoneIndex(String string) {
        int n2 = -1;
        String[] stringArray = ZoneMeta.getZoneIDs();
        if (stringArray.length > 0) {
            int n3;
            int n4 = 0;
            int n5 = stringArray.length;
            int n6 = Integer.MAX_VALUE;
            while (n6 != (n3 = (n4 + n5) / 2)) {
                n6 = n3;
                int n7 = string.compareTo(stringArray[n3]);
                if (n7 == 0) {
                    n2 = n3;
                    break;
                }
                if (n7 < 0) {
                    n5 = n3;
                    continue;
                }
                n4 = n3;
            }
        }
        return n2;
    }

    public static String getCanonicalCLDRID(TimeZone timeZone) {
        if (timeZone instanceof OlsonTimeZone) {
            return ((OlsonTimeZone)timeZone).getCanonicalID();
        }
        return ZoneMeta.getCanonicalCLDRID(timeZone.getID());
    }

    public static String getCanonicalCLDRID(String string) {
        String string2 = CANONICAL_ID_CACHE.get(string);
        if (string2 == null) {
            string2 = ZoneMeta.findCLDRCanonicalID(string);
            if (string2 == null) {
                try {
                    int n2 = ZoneMeta.getZoneIndex(string);
                    if (n2 >= 0) {
                        UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", ZONEINFORESNAME, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                        UResourceBundle uResourceBundle2 = uResourceBundle.get(kZONES);
                        UResourceBundle uResourceBundle3 = uResourceBundle2.get(n2);
                        if (uResourceBundle3.getType() == 7) {
                            string = ZoneMeta.getZoneID(uResourceBundle3.getInt());
                            string2 = ZoneMeta.findCLDRCanonicalID(string);
                        }
                        if (string2 == null) {
                            string2 = string;
                        }
                    }
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (string2 != null) {
                CANONICAL_ID_CACHE.put(string, string2);
            }
        }
        return string2;
    }

    private static String findCLDRCanonicalID(String string) {
        String string2 = null;
        String string3 = string.replace('/', ':');
        try {
            UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "keyTypeData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle uResourceBundle2 = uResourceBundle.get("typeMap");
            UResourceBundle uResourceBundle3 = uResourceBundle2.get("timezone");
            try {
                uResourceBundle3.get(string3);
                string2 = string;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (string2 == null) {
                UResourceBundle uResourceBundle4 = uResourceBundle.get("typeAlias");
                UResourceBundle uResourceBundle5 = uResourceBundle4.get("timezone");
                string2 = uResourceBundle5.getString(string3);
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    public static String getIanaID(String string) {
        String string2 = ZoneMeta.getCanonicalCLDRID(string);
        if (string2 == null) {
            return null;
        }
        UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "keyTypeData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
        UResourceBundle uResourceBundle2 = uResourceBundle.get("ianaMap");
        UResourceBundle uResourceBundle3 = uResourceBundle2.get("timezone");
        try {
            return uResourceBundle3.getString(string2.replace('/', ':'));
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    public static String getRegion(String string) {
        int n2;
        String string2 = REGION_CACHE.get(string);
        if (string2 == null && (n2 = ZoneMeta.getZoneIndex(string)) >= 0) {
            try {
                UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", ZONEINFORESNAME, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                UResourceBundle uResourceBundle2 = uResourceBundle.get(kREGIONS);
                if (n2 < uResourceBundle2.getSize()) {
                    string2 = uResourceBundle2.getString(n2);
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            if (string2 != null) {
                REGION_CACHE.put(string, string2);
            }
        }
        return string2;
    }

    public static String getCanonicalCountry(String string) {
        String string2 = ZoneMeta.getRegion(string);
        if (string2 != null && string2.equals(kWorld)) {
            string2 = null;
        }
        return string2;
    }

    public static String getCanonicalCountry(String string, Output<Boolean> output) {
        Object object;
        output.value = Boolean.FALSE;
        String string2 = ZoneMeta.getRegion(string);
        if (string2 != null && string2.equals(kWorld)) {
            return null;
        }
        Boolean bl2 = SINGLE_COUNTRY_CACHE.get(string);
        if (bl2 == null) {
            object = TimeZone.getAvailableIDs(TimeZone.SystemTimeZoneType.CANONICAL_LOCATION, string2, null);
            assert (object.size() >= 1);
            bl2 = object.size() <= 1;
            SINGLE_COUNTRY_CACHE.put(string, bl2);
        }
        if (bl2.booleanValue()) {
            output.value = Boolean.TRUE;
        } else {
            try {
                object = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "metaZones");
                UResourceBundle uResourceBundle = ((UResourceBundle)object).get("primaryZones");
                String string3 = uResourceBundle.getString(string2);
                if (string.equals(string3)) {
                    output.value = Boolean.TRUE;
                } else {
                    String string4 = ZoneMeta.getCanonicalCLDRID(string);
                    if (string4 != null && string4.equals(string3)) {
                        output.value = Boolean.TRUE;
                    }
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return string2;
    }

    public static UResourceBundle openOlsonResource(UResourceBundle uResourceBundle, String string) {
        UResourceBundle uResourceBundle2 = null;
        int n2 = ZoneMeta.getZoneIndex(string);
        if (n2 >= 0) {
            try {
                UResourceBundle uResourceBundle3;
                UResourceBundle uResourceBundle4;
                if (uResourceBundle == null) {
                    uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", ZONEINFORESNAME, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                }
                if ((uResourceBundle4 = (uResourceBundle3 = uResourceBundle.get(kZONES)).get(n2)).getType() == 7) {
                    uResourceBundle4 = uResourceBundle3.get(uResourceBundle4.getInt());
                }
                uResourceBundle2 = uResourceBundle4;
            }
            catch (MissingResourceException missingResourceException) {
                uResourceBundle2 = null;
            }
        }
        return uResourceBundle2;
    }

    public static OlsonTimeZone getSystemTimeZone(String string) {
        return (OlsonTimeZone)SYSTEM_ZONE_CACHE.getInstance(string, string);
    }

    public static SimpleTimeZone getCustomTimeZone(String string) {
        int[] nArray = new int[4];
        if (ZoneMeta.parseCustomID(string, nArray)) {
            Integer n2 = nArray[0] * (nArray[1] | nArray[2] << 5 | nArray[3] << 11);
            return (SimpleTimeZone)CUSTOM_ZONE_CACHE.getInstance(n2, nArray);
        }
        return null;
    }

    public static String getCustomID(String string) {
        int[] nArray = new int[4];
        if (ZoneMeta.parseCustomID(string, nArray)) {
            return ZoneMeta.formatCustomID(nArray[1], nArray[2], nArray[3], nArray[0] < 0);
        }
        return null;
    }

    static boolean parseCustomID(String string, int[] nArray) {
        if (string != null && string.length() > "GMT".length() && string.substring(0, 3).equalsIgnoreCase("GMT")) {
            int n2 = 1;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int[] nArray2 = new int[]{"GMT".length()};
            if (string.charAt(nArray2[0]) == '-') {
                n2 = -1;
            } else if (string.charAt(nArray2[0]) != '+') {
                return false;
            }
            nArray2[0] = nArray2[0] + 1;
            int n6 = nArray2[0];
            n3 = Utility.parseNumber(string, nArray2, 10);
            if (nArray2[0] == string.length()) {
                int n7 = nArray2[0] - n6;
                switch (n7) {
                    case 1: 
                    case 2: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        n4 = n3 % 100;
                        n3 /= 100;
                        break;
                    }
                    case 5: 
                    case 6: {
                        n5 = n3 % 100;
                        n4 = n3 / 100 % 100;
                        n3 /= 10000;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            } else {
                if (nArray2[0] - n6 < 1 || nArray2[0] - n6 > 2 || string.charAt(nArray2[0]) != ':') {
                    return false;
                }
                nArray2[0] = nArray2[0] + 1;
                if (string.length() == nArray2[0]) {
                    return false;
                }
                n6 = nArray2[0];
                n4 = Utility.parseNumber(string, nArray2, 10);
                if (nArray2[0] - n6 != 2) {
                    return false;
                }
                if (string.length() > nArray2[0]) {
                    if (string.charAt(nArray2[0]) != ':') {
                        return false;
                    }
                    nArray2[0] = nArray2[0] + 1;
                    n6 = nArray2[0];
                    n5 = Utility.parseNumber(string, nArray2, 10);
                    if (nArray2[0] - n6 != 2 || string.length() > nArray2[0]) {
                        return false;
                    }
                }
            }
            if (n3 <= 23 && n4 <= 59 && n5 <= 59) {
                if (nArray != null) {
                    if (nArray.length >= 1) {
                        nArray[0] = n2;
                    }
                    if (nArray.length >= 2) {
                        nArray[1] = n3;
                    }
                    if (nArray.length >= 3) {
                        nArray[2] = n4;
                    }
                    if (nArray.length >= 4) {
                        nArray[3] = n5;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static SimpleTimeZone getCustomTimeZone(int n2) {
        boolean bl2 = false;
        int n3 = n2;
        if (n2 < 0) {
            bl2 = true;
            n3 = -n2;
        }
        int n4 = (n3 /= 1000) % 60;
        int n5 = (n3 /= 60) % 60;
        int n6 = n3 / 60;
        String string = ZoneMeta.formatCustomID(n6, n5, n4, bl2);
        return new SimpleTimeZone(n2, string);
    }

    static String formatCustomID(int n2, int n3, int n4, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder("GMT");
        if (n2 != 0 || n3 != 0) {
            if (bl2) {
                stringBuilder.append('-');
            } else {
                stringBuilder.append('+');
            }
            if (n2 < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n2);
            stringBuilder.append(':');
            if (n3 < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n3);
            if (n4 != 0) {
                stringBuilder.append(':');
                if (n4 < 10) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(n4);
            }
        }
        return stringBuilder.toString();
    }

    public static String getShortID(TimeZone timeZone) {
        String string = null;
        string = timeZone instanceof OlsonTimeZone ? ((OlsonTimeZone)timeZone).getCanonicalID() : ZoneMeta.getCanonicalCLDRID(timeZone.getID());
        if (string == null) {
            return null;
        }
        return ZoneMeta.getShortIDFromCanonical(string);
    }

    public static String getShortID(String string) {
        String string2 = ZoneMeta.getCanonicalCLDRID(string);
        if (string2 == null) {
            return null;
        }
        return ZoneMeta.getShortIDFromCanonical(string2);
    }

    private static String getShortIDFromCanonical(String string) {
        String string2 = null;
        String string3 = string.replace('/', ':');
        try {
            UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", "keyTypeData", ICUResourceBundle.ICU_DATA_CLASS_LOADER);
            UResourceBundle uResourceBundle2 = uResourceBundle.get("typeMap");
            UResourceBundle uResourceBundle3 = uResourceBundle2.get("timezone");
            string2 = uResourceBundle3.getString(string3);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    static {
        ZONEIDS = null;
        CANONICAL_ID_CACHE = new SimpleCache<String, String>();
        REGION_CACHE = new SimpleCache<String, String>();
        SINGLE_COUNTRY_CACHE = new SimpleCache<String, Boolean>();
        SYSTEM_ZONE_CACHE = new SystemTimeZoneCache();
        CUSTOM_ZONE_CACHE = new CustomTimeZoneCache();
    }

    private static class CustomTimeZoneCache
    extends SoftCache<Integer, SimpleTimeZone, int[]> {
        private CustomTimeZoneCache() {
        }

        @Override
        protected SimpleTimeZone createInstance(Integer n2, int[] nArray) {
            assert (nArray.length == 4);
            assert (nArray[0] == 1 || nArray[0] == -1);
            assert (nArray[1] >= 0 && nArray[1] <= 23);
            assert (nArray[2] >= 0 && nArray[2] <= 59);
            assert (nArray[3] >= 0 && nArray[3] <= 59);
            String string = ZoneMeta.formatCustomID(nArray[1], nArray[2], nArray[3], nArray[0] < 0);
            int n3 = nArray[0] * ((nArray[1] * 60 + nArray[2]) * 60 + nArray[3]) * 1000;
            SimpleTimeZone simpleTimeZone = new SimpleTimeZone(n3, string);
            simpleTimeZone.freeze();
            return simpleTimeZone;
        }
    }

    private static class SystemTimeZoneCache
    extends SoftCache<String, OlsonTimeZone, String> {
        private SystemTimeZoneCache() {
        }

        @Override
        protected OlsonTimeZone createInstance(String string, String string2) {
            OlsonTimeZone olsonTimeZone = null;
            try {
                UResourceBundle uResourceBundle = UResourceBundle.getBundleInstance("macromedia/jdbc/db2/externals/com/ibm/icu/impl/data/icudt75b", ZoneMeta.ZONEINFORESNAME, ICUResourceBundle.ICU_DATA_CLASS_LOADER);
                UResourceBundle uResourceBundle2 = ZoneMeta.openOlsonResource(uResourceBundle, string2);
                if (uResourceBundle2 != null) {
                    olsonTimeZone = new OlsonTimeZone(uResourceBundle, uResourceBundle2, string2);
                    olsonTimeZone.freeze();
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
            return olsonTimeZone;
        }
    }
}

