/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.IllegalIcuArgumentException;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.PatternProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Replaceable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeMatcher;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUUncheckedIOException;

public final class Utility {
    private static final char APOSTROPHE = '\'';
    private static final char BACKSLASH = '\\';
    private static final int MAGIC_UNSIGNED = Integer.MIN_VALUE;
    private static final char ESCAPE = '\ua5a5';
    static final byte ESCAPE_BYTE = -91;
    public static String LINE_SEPARATOR = System.getProperty("line.separator");
    static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final char[] UNESCAPE_MAP = new char[]{'a', '\u0007', 'b', '\b', 'e', '\u001b', 'f', '\f', 'n', '\n', 'r', '\r', 't', '\t', 'v', '\u000b'};
    static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    public static final boolean arrayEquals(Object[] objectArray, Object object) {
        if (objectArray == null) {
            return object == null;
        }
        if (!(object instanceof Object[])) {
            return false;
        }
        Object[] objectArray2 = (Object[])object;
        return objectArray.length == objectArray2.length && Utility.arrayRegionMatches(objectArray, 0, objectArray2, 0, objectArray.length);
    }

    public static final boolean arrayEquals(int[] nArray, Object object) {
        if (nArray == null) {
            return object == null;
        }
        if (!(object instanceof int[])) {
            return false;
        }
        int[] nArray2 = (int[])object;
        return nArray.length == nArray2.length && Utility.arrayRegionMatches(nArray, 0, nArray2, 0, nArray.length);
    }

    public static final boolean arrayEquals(double[] dArray, Object object) {
        if (dArray == null) {
            return object == null;
        }
        if (!(object instanceof double[])) {
            return false;
        }
        double[] dArray2 = (double[])object;
        return dArray.length == dArray2.length && Utility.arrayRegionMatches(dArray, 0, dArray2, 0, dArray.length);
    }

    public static final boolean arrayEquals(byte[] byArray, Object object) {
        if (byArray == null) {
            return object == null;
        }
        if (!(object instanceof byte[])) {
            return false;
        }
        byte[] byArray2 = (byte[])object;
        return byArray.length == byArray2.length && Utility.arrayRegionMatches(byArray, 0, byArray2, 0, byArray.length);
    }

    public static final boolean arrayEquals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        if (object instanceof Object[]) {
            return Utility.arrayEquals((Object[])object, object2);
        }
        if (object instanceof int[]) {
            return Utility.arrayEquals((int[])object, object2);
        }
        if (object instanceof double[]) {
            return Utility.arrayEquals((double[])object, object2);
        }
        if (object instanceof byte[]) {
            return Utility.arrayEquals((byte[])object, object2);
        }
        return object.equals(object2);
    }

    public static final boolean arrayRegionMatches(Object[] objectArray, int n2, Object[] objectArray2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n3 - n2;
        for (int i2 = n2; i2 < n5; ++i2) {
            if (Utility.arrayEquals(objectArray[i2], objectArray2[i2 + n6])) continue;
            return false;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(char[] cArray, int n2, char[] cArray2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n3 - n2;
        for (int i2 = n2; i2 < n5; ++i2) {
            if (cArray[i2] == cArray2[i2 + n6]) continue;
            return false;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(int[] nArray, int n2, int[] nArray2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n3 - n2;
        for (int i2 = n2; i2 < n5; ++i2) {
            if (nArray[i2] == nArray2[i2 + n6]) continue;
            return false;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(double[] dArray, int n2, double[] dArray2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n3 - n2;
        for (int i2 = n2; i2 < n5; ++i2) {
            if (dArray[i2] == dArray2[i2 + n6]) continue;
            return false;
        }
        return true;
    }

    public static final boolean arrayRegionMatches(byte[] byArray, int n2, byte[] byArray2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n3 - n2;
        for (int i2 = n2; i2 < n5; ++i2) {
            if (byArray[i2] == byArray2[i2 + n6]) continue;
            return false;
        }
        return true;
    }

    public static final boolean sameObjects(Object object, Object object2) {
        return object == object2;
    }

    public static <T extends Comparable<T>> int checkCompare(T t2, T t3) {
        return t2 == null ? (t3 == null ? 0 : -1) : (t3 == null ? 1 : t2.compareTo(t3));
    }

    public static int checkHash(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    public static final String arrayToRLEString(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Utility.appendInt(stringBuilder, nArray.length);
        int n2 = nArray[0];
        int n3 = 1;
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            int n4 = nArray[i2];
            if (n4 == n2 && n3 < 65535) {
                ++n3;
                continue;
            }
            Utility.encodeRun(stringBuilder, n2, n3);
            n2 = n4;
            n3 = 1;
        }
        Utility.encodeRun(stringBuilder, n2, n3);
        return stringBuilder.toString();
    }

    public static final String arrayToRLEString(short[] sArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)(sArray.length >> 16));
        stringBuilder.append((char)sArray.length);
        short s2 = sArray[0];
        int n2 = 1;
        for (int i2 = 1; i2 < sArray.length; ++i2) {
            short s3 = sArray[i2];
            if (s3 == s2 && n2 < 65535) {
                ++n2;
                continue;
            }
            Utility.encodeRun(stringBuilder, s2, n2);
            s2 = s3;
            n2 = 1;
        }
        Utility.encodeRun(stringBuilder, s2, n2);
        return stringBuilder.toString();
    }

    public static final String arrayToRLEString(char[] cArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)(cArray.length >> 16));
        stringBuilder.append((char)cArray.length);
        char c2 = cArray[0];
        int n2 = 1;
        for (int i2 = 1; i2 < cArray.length; ++i2) {
            char c3 = cArray[i2];
            if (c3 == c2 && n2 < 65535) {
                ++n2;
                continue;
            }
            Utility.encodeRun(stringBuilder, (short)c2, n2);
            c2 = c3;
            n2 = 1;
        }
        Utility.encodeRun(stringBuilder, (short)c2, n2);
        return stringBuilder.toString();
    }

    public static final String arrayToRLEString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((char)(byArray.length >> 16));
        stringBuilder.append((char)byArray.length);
        byte by2 = byArray[0];
        int n2 = 1;
        byte[] byArray2 = new byte[2];
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            byte by3 = byArray[i2];
            if (by3 == by2 && n2 < 255) {
                ++n2;
                continue;
            }
            Utility.encodeRun(stringBuilder, by2, n2, byArray2);
            by2 = by3;
            n2 = 1;
        }
        Utility.encodeRun(stringBuilder, by2, n2, byArray2);
        if (byArray2[0] != 0) {
            Utility.appendEncodedByte(stringBuilder, (byte)0, byArray2);
        }
        return stringBuilder.toString();
    }

    private static final <T extends Appendable> void encodeRun(T t2, int n2, int n3) {
        if (n3 < 4) {
            for (int i2 = 0; i2 < n3; ++i2) {
                if (n2 == 42405) {
                    Utility.appendInt(t2, n2);
                }
                Utility.appendInt(t2, n2);
            }
        } else {
            if (n3 == 42405) {
                if (n2 == 42405) {
                    Utility.appendInt(t2, 42405);
                }
                Utility.appendInt(t2, n2);
                --n3;
            }
            Utility.appendInt(t2, 42405);
            Utility.appendInt(t2, n3);
            Utility.appendInt(t2, n2);
        }
    }

    private static final <T extends Appendable> void appendInt(T t2, int n2) {
        try {
            t2.append((char)(n2 >>> 16));
            t2.append((char)(n2 & 0xFFFF));
        }
        catch (IOException iOException) {
            throw new IllegalIcuArgumentException(iOException);
        }
    }

    private static final <T extends Appendable> void encodeRun(T t2, short s2, int n2) {
        try {
            char c2 = (char)s2;
            if (n2 < 4) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (c2 == '\ua5a5') {
                        t2.append('\ua5a5');
                    }
                    t2.append(c2);
                }
            } else {
                if (n2 == 42405) {
                    if (c2 == '\ua5a5') {
                        t2.append('\ua5a5');
                    }
                    t2.append(c2);
                    --n2;
                }
                t2.append('\ua5a5');
                t2.append((char)n2);
                t2.append(c2);
            }
        }
        catch (IOException iOException) {
            throw new IllegalIcuArgumentException(iOException);
        }
    }

    private static final <T extends Appendable> void encodeRun(T t2, byte by2, int n2, byte[] byArray) {
        if (n2 < 4) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (by2 == -91) {
                    Utility.appendEncodedByte(t2, (byte)-91, byArray);
                }
                Utility.appendEncodedByte(t2, by2, byArray);
            }
        } else {
            if ((byte)n2 == -91) {
                if (by2 == -91) {
                    Utility.appendEncodedByte(t2, (byte)-91, byArray);
                }
                Utility.appendEncodedByte(t2, by2, byArray);
                --n2;
            }
            Utility.appendEncodedByte(t2, (byte)-91, byArray);
            Utility.appendEncodedByte(t2, (byte)n2, byArray);
            Utility.appendEncodedByte(t2, by2, byArray);
        }
    }

    private static final <T extends Appendable> void appendEncodedByte(T t2, byte by2, byte[] byArray) {
        try {
            if (byArray[0] != 0) {
                char c2 = (char)(byArray[1] << 8 | by2 & 0xFF);
                t2.append(c2);
                byArray[0] = 0;
            } else {
                byArray[0] = 1;
                byArray[1] = by2;
            }
        }
        catch (IOException iOException) {
            throw new IllegalIcuArgumentException(iOException);
        }
    }

    public static final int[] RLEStringToIntArray(String string) {
        int n2 = Utility.getInt(string, 0);
        int[] nArray = new int[n2];
        int n3 = 0;
        int n4 = 1;
        int n5 = string.length() / 2;
        while (n3 < n2 && n4 < n5) {
            int n6;
            if ((n6 = Utility.getInt(string, n4++)) == 42405) {
                if ((n6 = Utility.getInt(string, n4++)) == 42405) {
                    nArray[n3++] = n6;
                    continue;
                }
                int n7 = n6;
                int n8 = Utility.getInt(string, n4++);
                for (int i2 = 0; i2 < n7; ++i2) {
                    nArray[n3++] = n8;
                }
                continue;
            }
            nArray[n3++] = n6;
        }
        if (n3 != n2 || n4 != n5) {
            throw new IllegalStateException("Bad run-length encoded int array");
        }
        return nArray;
    }

    static final int getInt(String string, int n2) {
        return string.charAt(2 * n2) << 16 | string.charAt(2 * n2 + 1);
    }

    public static final short[] RLEStringToShortArray(String string) {
        int n2 = string.charAt(0) << 16 | string.charAt(1);
        short[] sArray = new short[n2];
        int n3 = 0;
        for (int i2 = 2; i2 < string.length(); ++i2) {
            int n4 = string.charAt(i2);
            if (n4 == 42405) {
                if ((n4 = string.charAt(++i2)) == 42405) {
                    sArray[n3++] = (short)n4;
                    continue;
                }
                int n5 = n4;
                short s2 = (short)string.charAt(++i2);
                for (int i3 = 0; i3 < n5; ++i3) {
                    sArray[n3++] = s2;
                }
                continue;
            }
            sArray[n3++] = (short)n4;
        }
        if (n3 != n2) {
            throw new IllegalStateException("Bad run-length encoded short array");
        }
        return sArray;
    }

    public static final char[] RLEStringToCharArray(String string) {
        int n2 = string.charAt(0) << 16 | string.charAt(1);
        char[] cArray = new char[n2];
        int n3 = 0;
        for (int i2 = 2; i2 < string.length(); ++i2) {
            int n4 = string.charAt(i2);
            if (n4 == 42405) {
                if ((n4 = string.charAt(++i2)) == 42405) {
                    cArray[n3++] = n4;
                    continue;
                }
                int n5 = n4;
                char c2 = string.charAt(++i2);
                for (int i3 = 0; i3 < n5; ++i3) {
                    cArray[n3++] = c2;
                }
                continue;
            }
            cArray[n3++] = n4;
        }
        if (n3 != n2) {
            throw new IllegalStateException("Bad run-length encoded short array");
        }
        return cArray;
    }

    public static final byte[] RLEStringToByteArray(String string) {
        int n2 = string.charAt(0) << 16 | string.charAt(1);
        byte[] byArray = new byte[n2];
        boolean bl2 = true;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 2;
        int n7 = 0;
        while (n7 < n2) {
            int n8;
            if (bl2) {
                n3 = string.charAt(n6++);
                n8 = (byte)(n3 >> 8);
                bl2 = false;
            } else {
                n8 = n3 & 0xFF;
                bl2 = true;
            }
            switch (n4) {
                case 0: {
                    if (n8 == -91) {
                        n4 = 1;
                        break;
                    }
                    byArray[n7++] = n8;
                    break;
                }
                case 1: {
                    if (n8 == -91) {
                        byArray[n7++] = -91;
                        n4 = 0;
                        break;
                    }
                    n5 = n8;
                    if (n5 < 0) {
                        n5 += 256;
                    }
                    n4 = 2;
                    break;
                }
                case 2: {
                    for (int i2 = 0; i2 < n5; ++i2) {
                        byArray[n7++] = n8;
                    }
                    n4 = 0;
                }
            }
        }
        if (n4 != 0) {
            throw new IllegalStateException("Bad run-length encoded byte array");
        }
        if (n6 != string.length()) {
            throw new IllegalStateException("Excess data in RLE byte array string");
        }
        return byArray;
    }

    public static final String formatForSource(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n2 < string.length()) {
            if (n2 > 0) {
                stringBuilder.append('+').append(LINE_SEPARATOR);
            }
            stringBuilder.append("        \"");
            int n3 = 11;
            while (n2 < string.length() && n3 < 80) {
                char c2;
                if ((c2 = string.charAt(n2++)) < ' ' || c2 == '\"' || c2 == '\\') {
                    if (c2 == '\n') {
                        stringBuilder.append("\\n");
                        n3 += 2;
                        continue;
                    }
                    if (c2 == '\t') {
                        stringBuilder.append("\\t");
                        n3 += 2;
                        continue;
                    }
                    if (c2 == '\r') {
                        stringBuilder.append("\\r");
                        n3 += 2;
                        continue;
                    }
                    stringBuilder.append('\\');
                    stringBuilder.append(HEX_DIGIT[(c2 & 0x1C0) >> 6]);
                    stringBuilder.append(HEX_DIGIT[(c2 & 0x38) >> 3]);
                    stringBuilder.append(HEX_DIGIT[c2 & 7]);
                    n3 += 4;
                    continue;
                }
                if (c2 <= '~') {
                    stringBuilder.append(c2);
                    ++n3;
                    continue;
                }
                stringBuilder.append("\\u");
                stringBuilder.append(HEX_DIGIT[(c2 & 0xF000) >> 12]);
                stringBuilder.append(HEX_DIGIT[(c2 & 0xF00) >> 8]);
                stringBuilder.append(HEX_DIGIT[(c2 & 0xF0) >> 4]);
                stringBuilder.append(HEX_DIGIT[c2 & 0xF]);
                n3 += 6;
            }
            stringBuilder.append('\"');
        }
        return stringBuilder.toString();
    }

    public static final String format1ForSource(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"");
        int n2 = 0;
        while (n2 < string.length()) {
            char c2;
            if ((c2 = string.charAt(n2++)) < ' ' || c2 == '\"' || c2 == '\\') {
                if (c2 == '\n') {
                    stringBuilder.append("\\n");
                    continue;
                }
                if (c2 == '\t') {
                    stringBuilder.append("\\t");
                    continue;
                }
                if (c2 == '\r') {
                    stringBuilder.append("\\r");
                    continue;
                }
                stringBuilder.append('\\');
                stringBuilder.append(HEX_DIGIT[(c2 & 0x1C0) >> 6]);
                stringBuilder.append(HEX_DIGIT[(c2 & 0x38) >> 3]);
                stringBuilder.append(HEX_DIGIT[c2 & 7]);
                continue;
            }
            if (c2 <= '~') {
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append("\\u");
            stringBuilder.append(HEX_DIGIT[(c2 & 0xF000) >> 12]);
            stringBuilder.append(HEX_DIGIT[(c2 & 0xF00) >> 8]);
            stringBuilder.append(HEX_DIGIT[(c2 & 0xF0) >> 4]);
            stringBuilder.append(HEX_DIGIT[c2 & 0xF]);
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }

    public static final String escape(String string) {
        int n2;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < string.length(); i2 += UTF16.getCharCount(n2)) {
            n2 = Character.codePointAt(string, i2);
            if (n2 >= 32 && n2 <= 127) {
                if (n2 == 92) {
                    stringBuilder.append("\\\\");
                    continue;
                }
                stringBuilder.append((char)n2);
                continue;
            }
            boolean bl2 = n2 <= 65535;
            stringBuilder.append(bl2 ? "\\u" : "\\U");
            stringBuilder.append(Utility.hex(n2, bl2 ? 4 : 8));
        }
        return stringBuilder.toString();
    }

    private static final int _digit8(int n2) {
        if (n2 >= 48 && n2 <= 55) {
            return n2 - 48;
        }
        return -1;
    }

    private static final int _digit16(int n2) {
        if (n2 >= 48 && n2 <= 57) {
            return n2 - 48;
        }
        if (n2 >= 65 && n2 <= 70) {
            return n2 - 55;
        }
        if (n2 >= 97 && n2 <= 102) {
            return n2 - 87;
        }
        return -1;
    }

    public static int unescapeAndLengthAt(CharSequence charSequence, int n2) {
        return Utility.unescapeAndLengthAt(charSequence, n2, charSequence.length());
    }

    private static int unescapeAndLengthAt(CharSequence charSequence, int n2, int n3) {
        int n4;
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 4;
        boolean bl2 = false;
        if (n2 < 0 || n2 >= n3) {
            return -1;
        }
        int n11 = n2;
        int n12 = charSequence.charAt(n2++);
        switch (n12) {
            case 117: {
                n9 = 4;
                n8 = 4;
                break;
            }
            case 85: {
                n9 = 8;
                n8 = 8;
                break;
            }
            case 120: {
                n8 = 1;
                if (n2 < n3 && charSequence.charAt(n2) == '{') {
                    ++n2;
                    bl2 = true;
                    n9 = 8;
                    break;
                }
                n9 = 2;
                break;
            }
            default: {
                n5 = Utility._digit8(n12);
                if (n5 < 0) break;
                n8 = 1;
                n9 = 3;
                n7 = 1;
                n10 = 3;
                n6 = n5;
            }
        }
        if (n8 != 0) {
            while (n2 < n3 && n7 < n9) {
                n12 = charSequence.charAt(n2);
                int n13 = n5 = n10 == 3 ? Utility._digit8(n12) : Utility._digit16(n12);
                if (n5 < 0) break;
                n6 = n6 << n10 | n5;
                ++n2;
                ++n7;
            }
            if (n7 < n8) {
                return -1;
            }
            if (bl2) {
                if (n12 != 125) {
                    return -1;
                }
                ++n2;
            }
            if (n6 < 0 || n6 >= 0x110000) {
                return -1;
            }
            if (n2 < n3 && UTF16.isLeadSurrogate(n6)) {
                int n14 = n2 + 1;
                n12 = charSequence.charAt(n2);
                if (n12 == 92 && n14 < n3) {
                    int n15;
                    int n16 = n14 + 11;
                    if (n16 > n3) {
                        n16 = n3;
                    }
                    if ((n15 = Utility.unescapeAndLengthAt(charSequence, n14, n16)) >= 0) {
                        n12 = n15 >> 8;
                        n14 += n15 & 0xFF;
                    }
                }
                if (UTF16.isTrailSurrogate(n12)) {
                    n2 = n14;
                    n6 = UCharacter.toCodePoint(n6, n12);
                }
            }
            return Utility.codePointAndLength(n6, n11, n2);
        }
        for (n4 = 0; n4 < UNESCAPE_MAP.length; n4 += 2) {
            if (n12 == UNESCAPE_MAP[n4]) {
                return Utility.codePointAndLength(UNESCAPE_MAP[n4 + 1], n11, n2);
            }
            if (n12 < UNESCAPE_MAP[n4]) break;
        }
        if (n12 == 99 && n2 < n3) {
            n12 = Character.codePointAt(charSequence, n2);
            return Utility.codePointAndLength(n12 & 0x1F, n11, n2 + Character.charCount(n12));
        }
        if (UTF16.isLeadSurrogate(n12) && n2 < n3 && UTF16.isTrailSurrogate(n4 = (int)charSequence.charAt(n2))) {
            ++n2;
            n12 = UCharacter.toCodePoint(n12, n4);
        }
        return Utility.codePointAndLength(n12, n11, n2);
    }

    private static int codePointAndLength(int n2, int n3) {
        assert (0 <= n2 && n2 <= 0x10FFFF);
        assert (0 <= n3 && n3 <= 255);
        return n2 << 8 | n3;
    }

    private static int codePointAndLength(int n2, int n3, int n4) {
        return Utility.codePointAndLength(n2, n4 - n3);
    }

    public static int cpFromCodePointAndLength(int n2) {
        assert (n2 >= 0);
        return n2 >> 8;
    }

    public static int lengthFromCodePointAndLength(int n2) {
        assert (n2 >= 0);
        return n2 & 0xFF;
    }

    public static String unescape(CharSequence charSequence) {
        StringBuilder stringBuilder = null;
        int n2 = 0;
        while (n2 < charSequence.length()) {
            char c2;
            if ((c2 = charSequence.charAt(n2++)) == '\\') {
                int n3;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(charSequence.length()).append(charSequence, 0, n2 - 1);
                }
                if ((n3 = Utility.unescapeAndLengthAt(charSequence, n2)) < 0) {
                    throw new IllegalArgumentException("Invalid escape sequence " + charSequence.subSequence(n2 - 1, Math.min(n2 + 9, charSequence.length())));
                }
                stringBuilder.appendCodePoint(n3 >> 8);
                n2 += n3 & 0xFF;
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c2);
        }
        if (stringBuilder == null) {
            return charSequence.toString();
        }
        return stringBuilder.toString();
    }

    public static String unescapeLeniently(CharSequence charSequence) {
        StringBuilder stringBuilder = null;
        int n2 = 0;
        while (n2 < charSequence.length()) {
            char c2;
            if ((c2 = charSequence.charAt(n2++)) == '\\') {
                int n3;
                if (stringBuilder == null) {
                    stringBuilder = new StringBuilder(charSequence.length()).append(charSequence, 0, n2 - 1);
                }
                if ((n3 = Utility.unescapeAndLengthAt(charSequence, n2)) < 0) {
                    stringBuilder.append(c2);
                    continue;
                }
                stringBuilder.appendCodePoint(n3 >> 8);
                n2 += n3 & 0xFF;
                continue;
            }
            if (stringBuilder == null) continue;
            stringBuilder.append(c2);
        }
        if (stringBuilder == null) {
            return charSequence.toString();
        }
        return stringBuilder.toString();
    }

    public static String hex(long l2) {
        return Utility.hex(l2, 4);
    }

    public static String hex(long l2, int n2) {
        String string;
        boolean bl2;
        if (l2 == Long.MIN_VALUE) {
            return "-8000000000000000";
        }
        boolean bl3 = bl2 = l2 < 0L;
        if (bl2) {
            l2 = -l2;
        }
        if ((string = Long.toString(l2, 16).toUpperCase(Locale.ENGLISH)).length() < n2) {
            string = "0000000000000000".substring(string.length(), n2) + string;
        }
        if (bl2) {
            return '-' + string;
        }
        return string;
    }

    public static String hex(CharSequence charSequence) {
        return Utility.hex(charSequence, 4, ",", true, new StringBuilder()).toString();
    }

    public static <S extends CharSequence, U extends CharSequence, T extends Appendable> T hex(S s2, int n2, U u2, boolean bl2, T t2) {
        try {
            if (bl2) {
                int n3;
                for (int i2 = 0; i2 < s2.length(); i2 += UTF16.getCharCount(n3)) {
                    n3 = Character.codePointAt(s2, i2);
                    if (i2 != 0) {
                        t2.append(u2);
                    }
                    t2.append(Utility.hex(n3, n2));
                }
            } else {
                for (int i3 = 0; i3 < s2.length(); ++i3) {
                    if (i3 != 0) {
                        t2.append(u2);
                    }
                    t2.append(Utility.hex(s2.charAt(i3), n2));
                }
            }
            return t2;
        }
        catch (IOException iOException) {
            throw new IllegalIcuArgumentException(iOException);
        }
    }

    public static String hex(byte[] byArray, int n2, int n3, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = n2; i2 < n3; ++i2) {
            if (i2 != 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(Utility.hex(byArray[i2]));
        }
        return stringBuilder.toString();
    }

    public static <S extends CharSequence> String hex(S s2, int n2, S s3) {
        return Utility.hex(s2, n2, s3, true, new StringBuilder()).toString();
    }

    public static void split(String string, char c2, String[] stringArray) {
        int n2;
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) != c2) continue;
            stringArray[n4++] = string.substring(n3, n2);
            n3 = n2 + 1;
        }
        stringArray[n4++] = string.substring(n3, n2);
        while (n4 < stringArray.length) {
            stringArray[n4++] = "";
        }
    }

    public static String[] split(String string, char c2) {
        int n2;
        int n3 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) != c2) continue;
            arrayList.add(string.substring(n3, n2));
            n3 = n2 + 1;
        }
        arrayList.add(string.substring(n3, n2));
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static int lookup(String string, String[] stringArray) {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!string.equals(stringArray[i2])) continue;
            return i2;
        }
        return -1;
    }

    public static boolean parseChar(String string, int[] nArray, char c2) {
        int n2 = nArray[0];
        nArray[0] = PatternProps.skipWhiteSpace(string, nArray[0]);
        if (nArray[0] == string.length() || string.charAt(nArray[0]) != c2) {
            nArray[0] = n2;
            return false;
        }
        nArray[0] = nArray[0] + 1;
        return true;
    }

    public static int parsePattern(String string, int n2, int n3, String string2, int[] nArray) {
        int[] nArray2 = new int[1];
        int n4 = 0;
        block5: for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            switch (c2) {
                case ' ': {
                    char c3;
                    if (n2 >= n3) {
                        return -1;
                    }
                    if (!PatternProps.isWhiteSpace(c3 = string.charAt(n2++))) {
                        return -1;
                    }
                }
                case '~': {
                    n2 = PatternProps.skipWhiteSpace(string, n2);
                    continue block5;
                }
                case '#': {
                    nArray2[0] = n2;
                    nArray[n4++] = Utility.parseInteger(string, nArray2, n3);
                    if (nArray2[0] == n2) {
                        return -1;
                    }
                    n2 = nArray2[0];
                    continue block5;
                }
                default: {
                    char c3;
                    if (n2 >= n3) {
                        return -1;
                    }
                    if ((c3 = (char)UCharacter.toLowerCase(string.charAt(n2++))) == c2) continue block5;
                    return -1;
                }
            }
        }
        return n2;
    }

    public static int parsePattern(String string, Replaceable replaceable, int n2, int n3) {
        int n4 = 0;
        if (n4 == string.length()) {
            return n2;
        }
        int n5 = Character.codePointAt(string, n4);
        while (n2 < n3) {
            int n6 = replaceable.char32At(n2);
            if (n5 == 126) {
                if (PatternProps.isWhiteSpace(n6)) {
                    n2 += UTF16.getCharCount(n6);
                    continue;
                }
                if (++n4 == string.length()) {
                    return n2;
                }
            } else if (n6 == n5) {
                int n7 = UTF16.getCharCount(n6);
                n2 += n7;
                if ((n4 += n7) == string.length()) {
                    return n2;
                }
            } else {
                return -1;
            }
            n5 = UTF16.charAt(string, n4);
        }
        return -1;
    }

    public static int parseInteger(String string, int[] nArray, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = nArray[0];
        int n6 = 10;
        if (string.regionMatches(true, n5, "0x", 0, 2)) {
            n5 += 2;
            n6 = 16;
        } else if (n5 < n2 && string.charAt(n5) == '0') {
            ++n5;
            n3 = 1;
            n6 = 8;
        }
        while (n5 < n2) {
            int n7;
            if ((n7 = UCharacter.digit(string.charAt(n5++), n6)) < 0) {
                --n5;
                break;
            }
            ++n3;
            int n8 = n4 * n6 + n7;
            if (n8 <= n4) {
                return 0;
            }
            n4 = n8;
        }
        if (n3 > 0) {
            nArray[0] = n5;
        }
        return n4;
    }

    public static String parseUnicodeIdentifier(String string, int[] nArray) {
        int n2;
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        for (n2 = nArray[0]; n2 < string.length(); n2 += UTF16.getCharCount(n3)) {
            n3 = Character.codePointAt(string, n2);
            if (stringBuilder.length() == 0) {
                if (UCharacter.isUnicodeIdentifierStart(n3)) {
                    stringBuilder.appendCodePoint(n3);
                    continue;
                }
                return null;
            }
            if (!UCharacter.isUnicodeIdentifierPart(n3)) break;
            stringBuilder.appendCodePoint(n3);
        }
        nArray[0] = n2;
        return stringBuilder.toString();
    }

    private static <T extends Appendable> void recursiveAppendNumber(T t2, int n2, int n3, int n4) {
        try {
            int n5 = n2 % n3;
            if (n2 >= n3 || n4 > 1) {
                Utility.recursiveAppendNumber(t2, n2 / n3, n3, n4 - 1);
            }
            t2.append(DIGITS[n5]);
        }
        catch (IOException iOException) {
            throw new IllegalIcuArgumentException(iOException);
        }
    }

    public static <T extends Appendable> T appendNumber(T t2, int n2, int n3, int n4) {
        try {
            if (n3 < 2 || n3 > 36) {
                throw new IllegalArgumentException("Illegal radix " + n3);
            }
            int n5 = n2;
            if (n2 < 0) {
                n5 = -n2;
                t2.append("-");
            }
            Utility.recursiveAppendNumber(t2, n5, n3, n4);
            return t2;
        }
        catch (IOException iOException) {
            throw new IllegalIcuArgumentException(iOException);
        }
    }

    public static int parseNumber(String string, int[] nArray, int n2) {
        int n3;
        int n4;
        int n5;
        int n6 = 0;
        for (n5 = nArray[0]; n5 < string.length() && (n4 = UCharacter.digit(n3 = Character.codePointAt(string, n5), n2)) >= 0; ++n5) {
            if ((n6 = n2 * n6 + n4) >= 0) continue;
            return -1;
        }
        if (n5 == nArray[0]) {
            return -1;
        }
        nArray[0] = n5;
        return n6;
    }

    public static boolean isUnprintable(int n2) {
        return n2 < 32 || n2 > 126;
    }

    public static boolean shouldAlwaysBeEscaped(int n2) {
        if (n2 < 32) {
            return true;
        }
        if (n2 <= 126) {
            return false;
        }
        if (n2 <= 159) {
            return true;
        }
        if (n2 < 55296) {
            return false;
        }
        if (n2 <= 57343 || 64976 <= n2 && n2 <= 65007 || (n2 & 0xFFFE) == 65534) {
            return true;
        }
        return n2 > 0x10FFFF;
    }

    public static <T extends Appendable> boolean escapeUnprintable(T t2, int n2) {
        if (Utility.isUnprintable(n2)) {
            Utility.escape(t2, n2);
            return true;
        }
        return false;
    }

    public static <T extends Appendable> T escape(T t2, int n2) {
        try {
            t2.append('\\');
            if ((n2 & 0xFFFF0000) != 0) {
                t2.append('U');
                t2.append(DIGITS[0xF & n2 >> 28]);
                t2.append(DIGITS[0xF & n2 >> 24]);
                t2.append(DIGITS[0xF & n2 >> 20]);
                t2.append(DIGITS[0xF & n2 >> 16]);
            } else {
                t2.append('u');
            }
            t2.append(DIGITS[0xF & n2 >> 12]);
            t2.append(DIGITS[0xF & n2 >> 8]);
            t2.append(DIGITS[0xF & n2 >> 4]);
            t2.append(DIGITS[0xF & n2]);
            return t2;
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    public static int quotedIndexOf(String string, int n2, int n3, String string2) {
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '\\') {
                ++i2;
                continue;
            }
            if (c2 == '\'') {
                while (++i2 < n3 && string.charAt(i2) != '\'') {
                }
                continue;
            }
            if (string2.indexOf(c2) < 0) continue;
            return i2;
        }
        return -1;
    }

    public static void appendToRule(StringBuffer stringBuffer, int n2, boolean bl2, boolean bl3, StringBuffer stringBuffer2) {
        if (bl2 || bl3 && Utility.isUnprintable(n2)) {
            int n3;
            if (stringBuffer2.length() > 0) {
                while (stringBuffer2.length() >= 2 && stringBuffer2.charAt(0) == '\'' && stringBuffer2.charAt(1) == '\'') {
                    stringBuffer.append('\\').append('\'');
                    stringBuffer2.delete(0, 2);
                }
                n3 = 0;
                while (stringBuffer2.length() >= 2 && stringBuffer2.charAt(stringBuffer2.length() - 2) == '\'' && stringBuffer2.charAt(stringBuffer2.length() - 1) == '\'') {
                    stringBuffer2.setLength(stringBuffer2.length() - 2);
                    ++n3;
                }
                if (stringBuffer2.length() > 0) {
                    stringBuffer.append('\'');
                    stringBuffer.append(stringBuffer2);
                    stringBuffer.append('\'');
                    stringBuffer2.setLength(0);
                }
                while (n3-- > 0) {
                    stringBuffer.append('\\').append('\'');
                }
            }
            if (n2 != -1) {
                if (n2 == 32) {
                    n3 = stringBuffer.length();
                    if (n3 > 0 && stringBuffer.charAt(n3 - 1) != ' ') {
                        stringBuffer.append(' ');
                    }
                } else if (!bl3 || !Utility.escapeUnprintable(stringBuffer, n2)) {
                    stringBuffer.appendCodePoint(n2);
                }
            }
        } else if (stringBuffer2.length() == 0 && (n2 == 39 || n2 == 92)) {
            stringBuffer.append('\\').append((char)n2);
        } else if (!(stringBuffer2.length() <= 0 && (n2 < 33 || n2 > 126 || n2 >= 48 && n2 <= 57 || n2 >= 65 && n2 <= 90 || n2 >= 97 && n2 <= 122) && !PatternProps.isWhiteSpace(n2))) {
            stringBuffer2.appendCodePoint(n2);
            if (n2 == 39) {
                stringBuffer2.append((char)n2);
            }
        } else {
            stringBuffer.appendCodePoint(n2);
        }
    }

    public static void appendToRule(StringBuffer stringBuffer, String string, boolean bl2, boolean bl3, StringBuffer stringBuffer2) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            Utility.appendToRule(stringBuffer, string.charAt(i2), bl2, bl3, stringBuffer2);
        }
    }

    public static void appendToRule(StringBuffer stringBuffer, UnicodeMatcher unicodeMatcher, boolean bl2, StringBuffer stringBuffer2) {
        if (unicodeMatcher != null) {
            Utility.appendToRule(stringBuffer, unicodeMatcher.toPattern(bl2), true, bl2, stringBuffer2);
        }
    }

    public static final int compareUnsigned(int n2, int n3) {
        if ((n2 -= Integer.MIN_VALUE) < (n3 -= Integer.MIN_VALUE)) {
            return -1;
        }
        if (n2 > n3) {
            return 1;
        }
        return 0;
    }

    public static final byte highBit(int n2) {
        if (n2 <= 0) {
            return -1;
        }
        byte by2 = 0;
        if (n2 >= 65536) {
            n2 >>= 16;
            by2 = (byte)(by2 + 16);
        }
        if (n2 >= 256) {
            n2 >>= 8;
            by2 = (byte)(by2 + 8);
        }
        if (n2 >= 16) {
            n2 >>= 4;
            by2 = (byte)(by2 + 4);
        }
        if (n2 >= 4) {
            n2 >>= 2;
            by2 = (byte)(by2 + 2);
        }
        if (n2 >= 2) {
            n2 >>= 1;
            by2 = (byte)(by2 + 1);
        }
        return by2;
    }

    public static String valueOf(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder(nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            stringBuilder.appendCodePoint(nArray[i2]);
        }
        return stringBuilder.toString();
    }

    public static String repeat(String string, int n2) {
        if (n2 <= 0) {
            return "";
        }
        if (n2 == 1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String[] splitString(String string, String string2) {
        return string.split("\\Q" + string2 + "\\E");
    }

    public static String[] splitWhitespace(String string) {
        return string.split("\\s+");
    }

    public static String fromHex(String string, int n2, String string2) {
        return Utility.fromHex(string, n2, Pattern.compile(string2 != null ? string2 : "\\s+"));
    }

    public static String fromHex(String string, int n2, Pattern pattern) {
        String[] stringArray;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : stringArray = pattern.split(string)) {
            if (string2.length() < n2) {
                throw new IllegalArgumentException("code point too short: " + string2);
            }
            int n3 = Integer.parseInt(string2, 16);
            stringBuilder.appendCodePoint(n3);
        }
        return stringBuilder.toString();
    }

    public static int addExact(int n2, int n3) {
        int n4 = n2 + n3;
        if (((n2 ^ n4) & (n3 ^ n4)) < 0) {
            throw new ArithmeticException("integer overflow");
        }
        return n4;
    }

    public static boolean charSequenceEquals(CharSequence charSequence, CharSequence charSequence2) {
        if (charSequence == charSequence2) {
            return true;
        }
        if (charSequence == null || charSequence2 == null) {
            return false;
        }
        if (charSequence.length() != charSequence2.length()) {
            return false;
        }
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            if (charSequence.charAt(i2) == charSequence2.charAt(i2)) continue;
            return false;
        }
        return true;
    }

    public static int charSequenceHashCode(CharSequence charSequence) {
        int n2 = 0;
        for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            n2 = n2 * 31 + charSequence.charAt(i2);
        }
        return n2;
    }

    public static <A extends Appendable> A appendTo(CharSequence charSequence, A a2) {
        try {
            a2.append(charSequence);
            return a2;
        }
        catch (IOException iOException) {
            throw new ICUUncheckedIOException(iOException);
        }
    }

    public static String joinStrings(CharSequence charSequence, Iterable<? extends CharSequence> iterable) {
        if (charSequence == null || iterable == null) {
            throw new NullPointerException("Delimiter or elements is null");
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<? extends CharSequence> iterator = iterable.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            CharSequence charSequence2 = iterator.next();
            if (charSequence2 == null) continue;
            if (!bl2) {
                stringBuilder.append(charSequence);
            } else {
                bl2 = false;
            }
            stringBuilder.append(charSequence2);
        }
        return stringBuilder.toString();
    }
}

