/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.util.ArrayList;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Utility;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UTF16;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.OutputInt;

public class UnicodeSetStringSpan {
    public static final int WITH_COUNT = 64;
    public static final int FWD = 32;
    public static final int BACK = 16;
    public static final int CONTAINED = 2;
    public static final int NOT_CONTAINED = 1;
    public static final int ALL = 127;
    public static final int FWD_UTF16_CONTAINED = 34;
    public static final int FWD_UTF16_NOT_CONTAINED = 33;
    public static final int BACK_UTF16_CONTAINED = 18;
    public static final int BACK_UTF16_NOT_CONTAINED = 17;
    static final short ALL_CP_CONTAINED = 255;
    static final short LONG_SPAN = 254;
    private UnicodeSet spanSet;
    private UnicodeSet spanNotSet;
    private ArrayList<String> strings;
    private short[] spanLengths;
    private final int maxLength16;
    private boolean someRelevant;
    private boolean all;
    private OffsetList offsets;

    public UnicodeSetStringSpan(UnicodeSet unicodeSet, ArrayList<String> arrayList, int n2) {
        int n3;
        int n4;
        this.spanSet = new UnicodeSet(0, 0x10FFFF);
        this.strings = arrayList;
        this.all = n2 == 127;
        this.spanSet.retainAll(unicodeSet);
        if (0 != (n2 & 1)) {
            this.spanNotSet = this.spanSet;
        }
        this.offsets = new OffsetList();
        int n5 = this.strings.size();
        int n6 = 0;
        this.someRelevant = false;
        int n7 = 0;
        while (n7 < n5) {
            String string = this.strings.get(n7);
            n4 = string.length();
            if (n4 == 0) {
                this.strings.remove(n7);
                --n5;
                continue;
            }
            n3 = this.spanSet.span(string, UnicodeSet.SpanCondition.CONTAINED);
            if (n3 < n4) {
                this.someRelevant = true;
            }
            if (n4 > n6) {
                n6 = n4;
            }
            ++n7;
        }
        this.maxLength16 = n6;
        if (!this.someRelevant && (n2 & 0x40) == 0) {
            return;
        }
        if (this.all) {
            this.spanSet.freeze();
        }
        n4 = this.all ? n5 * 2 : n5;
        this.spanLengths = new short[n4];
        int n8 = this.all ? n5 : 0;
        for (n7 = 0; n7 < n5; ++n7) {
            String string = this.strings.get(n7);
            int n9 = string.length();
            n3 = this.spanSet.span(string, UnicodeSet.SpanCondition.CONTAINED);
            if (n3 < n9) {
                int n10;
                if (0 != (n2 & 2)) {
                    if (0 != (n2 & 0x20)) {
                        this.spanLengths[n7] = UnicodeSetStringSpan.makeSpanLengthByte(n3);
                    }
                    if (0 != (n2 & 0x10)) {
                        n3 = n9 - this.spanSet.spanBack(string, n9, UnicodeSet.SpanCondition.CONTAINED);
                        this.spanLengths[n8 + n7] = UnicodeSetStringSpan.makeSpanLengthByte(n3);
                    }
                } else {
                    this.spanLengths[n8 + n7] = 0;
                    this.spanLengths[n7] = 0;
                }
                if (0 == (n2 & 1)) continue;
                if (0 != (n2 & 0x20)) {
                    n10 = string.codePointAt(0);
                    this.addToSpanNotSet(n10);
                }
                if (0 == (n2 & 0x10)) continue;
                n10 = string.codePointBefore(n9);
                this.addToSpanNotSet(n10);
                continue;
            }
            if (this.all) {
                this.spanLengths[n8 + n7] = 255;
                this.spanLengths[n7] = 255;
                continue;
            }
            this.spanLengths[n7] = 255;
        }
        if (this.all) {
            this.spanNotSet.freeze();
        }
    }

    public UnicodeSetStringSpan(UnicodeSetStringSpan unicodeSetStringSpan, ArrayList<String> arrayList) {
        this.spanSet = unicodeSetStringSpan.spanSet;
        this.strings = arrayList;
        this.maxLength16 = unicodeSetStringSpan.maxLength16;
        this.someRelevant = unicodeSetStringSpan.someRelevant;
        this.all = true;
        this.spanNotSet = Utility.sameObjects(unicodeSetStringSpan.spanNotSet, unicodeSetStringSpan.spanSet) ? this.spanSet : (UnicodeSet)unicodeSetStringSpan.spanNotSet.clone();
        this.offsets = new OffsetList();
        this.spanLengths = (short[])unicodeSetStringSpan.spanLengths.clone();
    }

    public boolean needsStringSpanUTF16() {
        return this.someRelevant;
    }

    public boolean contains(int n2) {
        return this.spanSet.contains(n2);
    }

    private void addToSpanNotSet(int n2) {
        if (Utility.sameObjects(this.spanNotSet, null) || Utility.sameObjects(this.spanNotSet, this.spanSet)) {
            if (this.spanSet.contains(n2)) {
                return;
            }
            this.spanNotSet = this.spanSet.cloneAsThawed();
        }
        this.spanNotSet.add(n2);
    }

    public int span(CharSequence charSequence, int n2, UnicodeSet.SpanCondition spanCondition) {
        if (spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED) {
            return this.spanNot(charSequence, n2, null);
        }
        int n3 = this.spanSet.span(charSequence, n2, UnicodeSet.SpanCondition.CONTAINED);
        if (n3 == charSequence.length()) {
            return n3;
        }
        return this.spanWithStrings(charSequence, n2, n3, spanCondition);
    }

    private synchronized int spanWithStrings(CharSequence charSequence, int n2, int n3, UnicodeSet.SpanCondition spanCondition) {
        int n4 = 0;
        if (spanCondition == UnicodeSet.SpanCondition.CONTAINED) {
            n4 = this.maxLength16;
        }
        this.offsets.setMaxLength(n4);
        int n5 = charSequence.length();
        int n6 = n3;
        int n7 = n5 - n3;
        int n8 = n3 - n2;
        int n9 = this.strings.size();
        while (true) {
            int n10;
            int n11;
            int n12;
            if (spanCondition == UnicodeSet.SpanCondition.CONTAINED) {
                block1: for (n12 = 0; n12 < n9; ++n12) {
                    n11 = this.spanLengths[n12];
                    if (n11 == 255) continue;
                    String string = this.strings.get(n12);
                    n10 = string.length();
                    if (n11 >= 254) {
                        n11 = n10;
                        n11 = string.offsetByCodePoints(n11, -1);
                    }
                    if (n11 > n8) {
                        n11 = n8;
                    }
                    for (int i2 = n10 - n11; i2 <= n7; ++i2) {
                        if (!this.offsets.containsOffset(i2) && UnicodeSetStringSpan.matches16CPB(charSequence, n6 - n11, n5, string, n10)) {
                            if (i2 == n7) {
                                return n5;
                            }
                            this.offsets.addOffset(i2);
                        }
                        if (n11 == 0) continue block1;
                        --n11;
                    }
                }
            } else {
                n11 = 0;
                int n13 = 0;
                block3: for (n12 = 0; n12 < n9; ++n12) {
                    n10 = this.spanLengths[n12];
                    String string = this.strings.get(n12);
                    int n14 = string.length();
                    if (n10 >= 254) {
                        n10 = n14;
                    }
                    if (n10 > n8) {
                        n10 = n8;
                    }
                    for (int i3 = n14 - n10; i3 <= n7 && n10 >= n13; --n10, ++i3) {
                        if (n10 <= n13 && i3 <= n11 || !UnicodeSetStringSpan.matches16CPB(charSequence, n6 - n10, n5, string, n14)) continue;
                        n11 = i3;
                        n13 = n10;
                        continue block3;
                    }
                }
                if (n11 != 0 || n13 != 0) {
                    n6 += n11;
                    if ((n7 -= n11) == 0) {
                        return n5;
                    }
                    n8 = 0;
                    continue;
                }
            }
            if (n8 != 0 || n6 == 0) {
                if (this.offsets.isEmpty()) {
                    return n6;
                }
            } else {
                if (this.offsets.isEmpty()) {
                    n3 = this.spanSet.span(charSequence, n6, UnicodeSet.SpanCondition.CONTAINED);
                    n8 = n3 - n6;
                    if (n8 == n7 || n8 == 0) {
                        return n3;
                    }
                    n6 += n8;
                    n7 -= n8;
                    continue;
                }
                n8 = UnicodeSetStringSpan.spanOne(this.spanSet, charSequence, n6, n7);
                if (n8 > 0) {
                    if (n8 == n7) {
                        return n5;
                    }
                    n6 += n8;
                    n7 -= n8;
                    this.offsets.shift(n8);
                    n8 = 0;
                    continue;
                }
            }
            n11 = this.offsets.popMinimum(null);
            n6 += n11;
            n7 -= n11;
            n8 = 0;
        }
    }

    public int spanAndCount(CharSequence charSequence, int n2, UnicodeSet.SpanCondition spanCondition, OutputInt outputInt) {
        int n3;
        if (spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED) {
            return this.spanNot(charSequence, n2, outputInt);
        }
        if (spanCondition == UnicodeSet.SpanCondition.CONTAINED) {
            return this.spanContainedAndCount(charSequence, n2, outputInt);
        }
        int n4 = this.strings.size();
        int n5 = charSequence.length();
        int n6 = n2;
        int n7 = 0;
        for (int i2 = n5 - n2; i2 != 0; i2 -= n3) {
            int n8 = UnicodeSetStringSpan.spanOne(this.spanSet, charSequence, n6, i2);
            n3 = n8 > 0 ? n8 : 0;
            for (int i3 = 0; i3 < n4; ++i3) {
                String string = this.strings.get(i3);
                int n9 = string.length();
                if (n3 >= n9 || n9 > i2 || !UnicodeSetStringSpan.matches16CPB(charSequence, n6, n5, string, n9)) continue;
                n3 = n9;
            }
            if (n3 == 0) {
                outputInt.value = n7;
                return n6;
            }
            ++n7;
            n6 += n3;
        }
        outputInt.value = n7;
        return n6;
    }

    private synchronized int spanContainedAndCount(CharSequence charSequence, int n2, OutputInt outputInt) {
        int n3;
        this.offsets.setMaxLength(this.maxLength16);
        int n4 = this.strings.size();
        int n5 = charSequence.length();
        int n6 = n2;
        int n7 = 0;
        for (int i2 = n5 - n2; i2 != 0; i2 -= n3) {
            int n8 = UnicodeSetStringSpan.spanOne(this.spanSet, charSequence, n6, i2);
            if (n8 > 0) {
                this.offsets.addOffsetAndCount(n8, n7 + 1);
            }
            for (n3 = 0; n3 < n4; ++n3) {
                String string = this.strings.get(n3);
                int n9 = string.length();
                if (n9 > i2 || this.offsets.hasCountAtOffset(n9, n7 + 1) || !UnicodeSetStringSpan.matches16CPB(charSequence, n6, n5, string, n9)) continue;
                this.offsets.addOffsetAndCount(n9, n7 + 1);
            }
            if (this.offsets.isEmpty()) {
                outputInt.value = n7;
                return n6;
            }
            n3 = this.offsets.popMinimum(outputInt);
            n7 = outputInt.value;
            n6 += n3;
        }
        outputInt.value = n7;
        return n6;
    }

    public synchronized int spanBack(CharSequence charSequence, int n2, UnicodeSet.SpanCondition spanCondition) {
        if (spanCondition == UnicodeSet.SpanCondition.NOT_CONTAINED) {
            return this.spanNotBack(charSequence, n2);
        }
        int n3 = this.spanSet.spanBack(charSequence, n2, UnicodeSet.SpanCondition.CONTAINED);
        if (n3 == 0) {
            return 0;
        }
        int n4 = n2 - n3;
        int n5 = 0;
        if (spanCondition == UnicodeSet.SpanCondition.CONTAINED) {
            n5 = this.maxLength16;
        }
        this.offsets.setMaxLength(n5);
        int n6 = this.strings.size();
        int n7 = 0;
        if (this.all) {
            n7 = n6;
        }
        while (true) {
            int n8;
            int n9;
            int n10;
            if (spanCondition == UnicodeSet.SpanCondition.CONTAINED) {
                block1: for (n10 = 0; n10 < n6; ++n10) {
                    int n11;
                    n9 = this.spanLengths[n7 + n10];
                    if (n9 == 255) continue;
                    String string = this.strings.get(n10);
                    n8 = string.length();
                    if (n9 >= 254) {
                        n9 = n8;
                        n11 = 0;
                        n11 = string.offsetByCodePoints(0, 1);
                        n9 -= n11;
                    }
                    if (n9 > n4) {
                        n9 = n4;
                    }
                    for (n11 = n8 - n9; n11 <= n3; ++n11) {
                        if (!this.offsets.containsOffset(n11) && UnicodeSetStringSpan.matches16CPB(charSequence, n3 - n11, n2, string, n8)) {
                            if (n11 == n3) {
                                return 0;
                            }
                            this.offsets.addOffset(n11);
                        }
                        if (n9 == 0) continue block1;
                        --n9;
                    }
                }
            } else {
                n9 = 0;
                int n12 = 0;
                block3: for (n10 = 0; n10 < n6; ++n10) {
                    n8 = this.spanLengths[n7 + n10];
                    String string = this.strings.get(n10);
                    int n13 = string.length();
                    if (n8 >= 254) {
                        n8 = n13;
                    }
                    if (n8 > n4) {
                        n8 = n4;
                    }
                    for (int i2 = n13 - n8; i2 <= n3 && n8 >= n12; --n8, ++i2) {
                        if (n8 <= n12 && i2 <= n9 || !UnicodeSetStringSpan.matches16CPB(charSequence, n3 - i2, n2, string, n13)) continue;
                        n9 = i2;
                        n12 = n8;
                        continue block3;
                    }
                }
                if (n9 != 0 || n12 != 0) {
                    if ((n3 -= n9) == 0) {
                        return 0;
                    }
                    n4 = 0;
                    continue;
                }
            }
            if (n4 != 0 || n3 == n2) {
                if (this.offsets.isEmpty()) {
                    return n3;
                }
            } else {
                if (this.offsets.isEmpty()) {
                    n9 = n3;
                    n3 = this.spanSet.spanBack(charSequence, n9, UnicodeSet.SpanCondition.CONTAINED);
                    n4 = n9 - n3;
                    if (n3 != 0 && n4 != 0) continue;
                    return n3;
                }
                n4 = UnicodeSetStringSpan.spanOneBack(this.spanSet, charSequence, n3);
                if (n4 > 0) {
                    if (n4 == n3) {
                        return 0;
                    }
                    n3 -= n4;
                    this.offsets.shift(n4);
                    n4 = 0;
                    continue;
                }
            }
            n3 -= this.offsets.popMinimum(null);
            n4 = 0;
        }
    }

    private int spanNot(CharSequence charSequence, int n2, OutputInt outputInt) {
        int n3;
        int n4 = charSequence.length();
        int n5 = n2;
        int n6 = n4 - n2;
        int n7 = this.strings.size();
        int n8 = 0;
        do {
            int n9;
            if (outputInt == null) {
                n9 = this.spanNotSet.span(charSequence, n5, UnicodeSet.SpanCondition.NOT_CONTAINED);
            } else {
                n9 = this.spanNotSet.spanAndCount(charSequence, n5, UnicodeSet.SpanCondition.NOT_CONTAINED, outputInt);
                outputInt.value = n8 += outputInt.value;
            }
            if (n9 == n4) {
                return n4;
            }
            n5 = n9;
            n6 = n4 - n9;
            n3 = UnicodeSetStringSpan.spanOne(this.spanSet, charSequence, n5, n6);
            if (n3 > 0) {
                return n5;
            }
            for (int i2 = 0; i2 < n7; ++i2) {
                String string;
                int n10;
                if (this.spanLengths[i2] == 255 || (n10 = (string = this.strings.get(i2)).length()) > n6 || !UnicodeSetStringSpan.matches16CPB(charSequence, n5, n4, string, n10)) continue;
                return n5;
            }
            n5 -= n3;
            ++n8;
        } while ((n6 += n3) != 0);
        if (outputInt != null) {
            outputInt.value = n8;
        }
        return n4;
    }

    private int spanNotBack(CharSequence charSequence, int n2) {
        int n3;
        int n4 = n2;
        int n5 = this.strings.size();
        do {
            if ((n4 = this.spanNotSet.spanBack(charSequence, n4, UnicodeSet.SpanCondition.NOT_CONTAINED)) == 0) {
                return 0;
            }
            n3 = UnicodeSetStringSpan.spanOneBack(this.spanSet, charSequence, n4);
            if (n3 > 0) {
                return n4;
            }
            for (int i2 = 0; i2 < n5; ++i2) {
                String string;
                int n6;
                if (this.spanLengths[i2] == 255 || (n6 = (string = this.strings.get(i2)).length()) > n4 || !UnicodeSetStringSpan.matches16CPB(charSequence, n4 - n6, n2, string, n6)) continue;
                return n4;
            }
        } while ((n4 += n3) != 0);
        return 0;
    }

    static short makeSpanLengthByte(int n2) {
        return (short)(n2 < 254 ? (int)n2 : 254);
    }

    private static boolean matches16(CharSequence charSequence, int n2, String string, int n3) {
        int n4 = n2 + n3;
        while (n3-- > 0) {
            if (charSequence.charAt(--n4) == string.charAt(n3)) continue;
            return false;
        }
        return true;
    }

    static boolean matches16CPB(CharSequence charSequence, int n2, int n3, String string, int n4) {
        return !(!UnicodeSetStringSpan.matches16(charSequence, n2, string, n4) || 0 < n2 && Character.isHighSurrogate(charSequence.charAt(n2 - 1)) && Character.isLowSurrogate(charSequence.charAt(n2)) || n2 + n4 < n3 && Character.isHighSurrogate(charSequence.charAt(n2 + n4 - 1)) && Character.isLowSurrogate(charSequence.charAt(n2 + n4)));
    }

    static int spanOne(UnicodeSet unicodeSet, CharSequence charSequence, int n2, int n3) {
        char c2;
        char c3 = charSequence.charAt(n2);
        if (c3 >= '\ud800' && c3 <= '\udbff' && n3 >= 2 && UTF16.isTrailSurrogate(c2 = charSequence.charAt(n2 + 1))) {
            int n4 = Character.toCodePoint(c3, c2);
            return unicodeSet.contains(n4) ? 2 : -2;
        }
        return unicodeSet.contains(c3) ? 1 : -1;
    }

    static int spanOneBack(UnicodeSet unicodeSet, CharSequence charSequence, int n2) {
        char c2;
        char c3 = charSequence.charAt(n2 - 1);
        if (c3 >= '\udc00' && c3 <= '\udfff' && n2 >= 2 && UTF16.isLeadSurrogate(c2 = charSequence.charAt(n2 - 2))) {
            int n3 = Character.toCodePoint(c2, c3);
            return unicodeSet.contains(n3) ? 2 : -2;
        }
        return unicodeSet.contains(c3) ? 1 : -1;
    }

    private static final class OffsetList {
        private int[] list = new int[16];
        private int length;
        private int start;

        public void setMaxLength(int n2) {
            if (n2 > this.list.length) {
                this.list = new int[n2];
            }
            this.clear();
        }

        public void clear() {
            int n2 = this.list.length;
            while (n2-- > 0) {
                this.list[n2] = 0;
            }
            this.length = 0;
            this.start = 0;
        }

        public boolean isEmpty() {
            return this.length == 0;
        }

        public void shift(int n2) {
            int n3 = this.start + n2;
            if (n3 >= this.list.length) {
                n3 -= this.list.length;
            }
            if (this.list[n3] != 0) {
                this.list[n3] = 0;
                --this.length;
            }
            this.start = n3;
        }

        public void addOffset(int n2) {
            int n3 = this.start + n2;
            if (n3 >= this.list.length) {
                n3 -= this.list.length;
            }
            assert (this.list[n3] == 0);
            this.list[n3] = 1;
            ++this.length;
        }

        public void addOffsetAndCount(int n2, int n3) {
            assert (n3 > 0);
            int n4 = this.start + n2;
            if (n4 >= this.list.length) {
                n4 -= this.list.length;
            }
            if (this.list[n4] == 0) {
                this.list[n4] = n3;
                ++this.length;
            } else if (n3 < this.list[n4]) {
                this.list[n4] = n3;
            }
        }

        public boolean containsOffset(int n2) {
            int n3 = this.start + n2;
            if (n3 >= this.list.length) {
                n3 -= this.list.length;
            }
            return this.list[n3] != 0;
        }

        public boolean hasCountAtOffset(int n2, int n3) {
            int n4;
            int n5 = this.start + n2;
            if (n5 >= this.list.length) {
                n5 -= this.list.length;
            }
            return (n4 = this.list[n5]) != 0 && n4 <= n3;
        }

        public int popMinimum(OutputInt outputInt) {
            int n2;
            int n3 = this.start;
            while (++n3 < this.list.length) {
                n2 = this.list[n3];
                if (n2 == 0) continue;
                this.list[n3] = 0;
                --this.length;
                int n4 = n3 - this.start;
                this.start = n3;
                if (outputInt != null) {
                    outputInt.value = n2;
                }
                return n4;
            }
            int n5 = this.list.length - this.start;
            n3 = 0;
            while ((n2 = this.list[n3]) == 0) {
                ++n3;
            }
            this.list[n3] = 0;
            --this.length;
            this.start = n3;
            if (outputInt != null) {
                outputInt.value = n2;
            }
            return n5 + n3;
        }
    }
}

