/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.StringTransform;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.SymbolTable;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.UnicodeSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.Freezable;

public class UnicodeRegex
implements StringTransform,
Freezable<UnicodeRegex>,
Cloneable {
    private static final Pattern SUPP_ESCAPE = Pattern.compile("\\\\U00([0-9a-fA-F]{6})");
    private SymbolTable symbolTable;
    private static final UnicodeRegex STANDARD = new UnicodeRegex();
    private String bnfCommentString = "#";
    private String bnfVariableInfix = "=";
    private String bnfLineSeparator = "\n";
    private Comparator<Object> LongestFirst = new Comparator<Object>(){

        @Override
        public int compare(Object object, Object object2) {
            int n2;
            String string = object.toString();
            String string2 = object2.toString();
            int n3 = string.length();
            if (n3 != (n2 = string2.length())) {
                return n2 - n3;
            }
            return string.compareTo(string2);
        }
    };

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public UnicodeRegex setSymbolTable(SymbolTable symbolTable) {
        this.symbolTable = symbolTable;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public String transform(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        UnicodeSet unicodeSet = new UnicodeSet();
        ParsePosition parsePosition = new ParsePosition(0);
        int n2 = 0;
        int n3 = 0;
        while (true) {
            block13: {
                if (n3 >= string.length()) {
                    return stringBuilder.toString();
                }
                char c2 = string.charAt(n3);
                switch (n2) {
                    case 0: {
                        if (c2 == '\\') {
                            if (UnicodeSet.resemblesPattern(string, n3)) {
                                n3 = this.processSet(string, n3, stringBuilder, unicodeSet, parsePosition);
                                break block13;
                            } else {
                                n2 = 1;
                                break;
                            }
                        }
                        if (c2 != '[' || !UnicodeSet.resemblesPattern(string, n3)) break;
                        n3 = this.processSet(string, n3, stringBuilder, unicodeSet, parsePosition);
                        break block13;
                    }
                    case 1: {
                        if (c2 == 'Q') {
                            n2 = 2;
                            break;
                        }
                        n2 = 0;
                        break;
                    }
                    case 2: {
                        if (c2 != '\\') break;
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        if (c2 == 'E') {
                            n2 = 0;
                            break;
                        }
                        if (c2 == '\\') break;
                        n2 = 2;
                    }
                }
                stringBuilder.append(c2);
            }
            ++n3;
        }
    }

    public static String fix(String string) {
        return STANDARD.transform(string);
    }

    public static Pattern compile(String string) {
        return Pattern.compile(STANDARD.transform(string));
    }

    public static Pattern compile(String string, int n2) {
        return Pattern.compile(STANDARD.transform(string), n2);
    }

    public String compileBnf(String string) {
        return this.compileBnf(Arrays.asList(string.split("\\r\\n?|\\n")));
    }

    public String compileBnf(List<String> list) {
        Map<String, String> map = this.getVariables(list);
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(map.keySet());
        for (int i2 = 0; i2 < 2; ++i2) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                for (Map.Entry<String, String> entry2 : map.entrySet()) {
                    String string3;
                    String string4 = entry2.getKey();
                    String string5 = entry2.getValue();
                    if (string.equals(string4) || (string3 = string5.replace(string, string2)).equals(string5)) continue;
                    linkedHashSet.remove(string);
                    map.put(string4, string3);
                }
            }
        }
        if (linkedHashSet.size() != 1) {
            throw new IllegalArgumentException("Not a single root: " + linkedHashSet);
        }
        return map.get(linkedHashSet.iterator().next());
    }

    public String getBnfCommentString() {
        return this.bnfCommentString;
    }

    public void setBnfCommentString(String string) {
        this.bnfCommentString = string;
    }

    public String getBnfVariableInfix() {
        return this.bnfVariableInfix;
    }

    public void setBnfVariableInfix(String string) {
        this.bnfVariableInfix = string;
    }

    public String getBnfLineSeparator() {
        return this.bnfLineSeparator;
    }

    public void setBnfLineSeparator(String string) {
        this.bnfLineSeparator = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> appendLines(List<String> list, String string, String string2) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(string);){
            List<String> list2 = UnicodeRegex.appendLines(list, fileInputStream, string2);
            return list2;
        }
    }

    public static List<String> appendLines(List<String> list, InputStream inputStream, String string) throws UnsupportedEncodingException, IOException {
        String string2;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string == null ? "UTF-8" : string));
        while ((string2 = bufferedReader.readLine()) != null) {
            list.add(string2);
        }
        return list;
    }

    @Override
    public UnicodeRegex cloneAsThawed() {
        try {
            return (UnicodeRegex)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public UnicodeRegex freeze() {
        return this;
    }

    @Override
    public boolean isFrozen() {
        return true;
    }

    private int processSet(String string, int n2, StringBuilder stringBuilder, UnicodeSet unicodeSet, ParsePosition parsePosition) {
        try {
            parsePosition.setIndex(n2);
            UnicodeSet unicodeSet2 = unicodeSet.clear().applyPattern(string, parsePosition, this.symbolTable, 0);
            unicodeSet2.complement().complement();
            String string2 = unicodeSet2.toPattern(false);
            if (string2.contains("\\U")) {
                string2 = SUPP_ESCAPE.matcher(string2).replaceAll("\\\\x{$1}");
            }
            stringBuilder.append(string2);
            n2 = parsePosition.getIndex() - 1;
            return n2;
        }
        catch (Exception exception) {
            throw (IllegalArgumentException)new IllegalArgumentException("Error in " + string).initCause(exception);
        }
    }

    private Map<String, String> getVariables(List<String> list) {
        TreeMap<Object, String> treeMap = new TreeMap<Object, String>(this.LongestFirst);
        String string = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        for (String string2 : list) {
            int n3;
            String string3;
            String string4;
            int n4;
            ++n2;
            if (string2.length() == 0) continue;
            if (string2.charAt(0) == '\ufeff') {
                string2 = string2.substring(1);
            }
            if (this.bnfCommentString != null && (n4 = string2.indexOf(this.bnfCommentString)) >= 0) {
                string2 = string2.substring(0, n4);
            }
            if ((string4 = string2.trim()).length() == 0 || (string3 = string2).trim().length() == 0) continue;
            boolean bl2 = string4.endsWith(";");
            if (bl2) {
                string3 = string3.substring(0, string3.lastIndexOf(59));
            }
            if ((n3 = string3.indexOf(this.bnfVariableInfix)) >= 0) {
                if (string != null) {
                    throw new IllegalArgumentException("Missing ';' before " + n2 + ") " + string2);
                }
                string = string3.substring(0, n3).trim();
                if (treeMap.containsKey(string)) {
                    throw new IllegalArgumentException("Duplicate variable definition in " + string2);
                }
                stringBuffer.append(string3.substring(n3 + 1).trim());
            } else {
                if (string == null) {
                    throw new IllegalArgumentException("Missing '=' at " + n2 + ") " + string2);
                }
                stringBuffer.append(this.bnfLineSeparator).append(string3);
            }
            if (!bl2) continue;
            treeMap.put(string, stringBuffer.toString());
            string = null;
            stringBuffer.setLength(0);
        }
        if (string != null) {
            throw new IllegalArgumentException("Missing ';' at end");
        }
        return treeMap;
    }
}

