/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

import java.util.EnumSet;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Normalizer2Impl;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.Punycode;
import macromedia.jdbc.db2.externals.com.ibm.icu.impl.UBiDiProps;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UCharacter;
import macromedia.jdbc.db2.externals.com.ibm.icu.lang.UScript;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.IDNA;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.Normalizer2;
import macromedia.jdbc.db2.externals.com.ibm.icu.text.StringPrepParseException;
import macromedia.jdbc.db2.externals.com.ibm.icu.util.ICUException;

public final class UTS46
extends IDNA {
    private static final Normalizer2 uts46Norm2 = Normalizer2.getInstance(null, "uts46", Normalizer2.Mode.COMPOSE);
    final int options;
    private static final EnumSet<IDNA.Error> severeErrors = EnumSet.of(IDNA.Error.LEADING_COMBINING_MARK, IDNA.Error.DISALLOWED, IDNA.Error.PUNYCODE, IDNA.Error.LABEL_HAS_DOT, IDNA.Error.INVALID_ACE_LABEL);
    private static final byte[] asciiData = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1};
    private static final int L_MASK = UTS46.U_MASK(0);
    private static final int R_AL_MASK = UTS46.U_MASK(1) | UTS46.U_MASK(13);
    private static final int L_R_AL_MASK = L_MASK | R_AL_MASK;
    private static final int R_AL_AN_MASK = R_AL_MASK | UTS46.U_MASK(5);
    private static final int EN_AN_MASK = UTS46.U_MASK(2) | UTS46.U_MASK(5);
    private static final int R_AL_EN_AN_MASK = R_AL_MASK | EN_AN_MASK;
    private static final int L_EN_MASK = L_MASK | UTS46.U_MASK(2);
    private static final int ES_CS_ET_ON_BN_NSM_MASK = UTS46.U_MASK(3) | UTS46.U_MASK(6) | UTS46.U_MASK(4) | UTS46.U_MASK(10) | UTS46.U_MASK(18) | UTS46.U_MASK(17);
    private static final int L_EN_ES_CS_ET_ON_BN_NSM_MASK = L_EN_MASK | ES_CS_ET_ON_BN_NSM_MASK;
    private static final int R_AL_AN_EN_ES_CS_ET_ON_BN_NSM_MASK = R_AL_MASK | EN_AN_MASK | ES_CS_ET_ON_BN_NSM_MASK;
    private static int U_GC_M_MASK = UTS46.U_MASK(6) | UTS46.U_MASK(7) | UTS46.U_MASK(8);

    public UTS46(int n2) {
        this.options = n2;
    }

    @Override
    public StringBuilder labelToASCII(CharSequence charSequence, StringBuilder stringBuilder, IDNA.Info info) {
        return this.process(charSequence, true, true, stringBuilder, info);
    }

    @Override
    public StringBuilder labelToUnicode(CharSequence charSequence, StringBuilder stringBuilder, IDNA.Info info) {
        return this.process(charSequence, true, false, stringBuilder, info);
    }

    @Override
    public StringBuilder nameToASCII(CharSequence charSequence, StringBuilder stringBuilder, IDNA.Info info) {
        this.process(charSequence, false, true, stringBuilder, info);
        if (stringBuilder.length() >= 254 && !info.getErrors().contains((Object)IDNA.Error.DOMAIN_NAME_TOO_LONG) && UTS46.isASCIIString(stringBuilder) && (stringBuilder.length() > 254 || stringBuilder.charAt(253) != '.')) {
            UTS46.addError(info, IDNA.Error.DOMAIN_NAME_TOO_LONG);
        }
        return stringBuilder;
    }

    @Override
    public StringBuilder nameToUnicode(CharSequence charSequence, StringBuilder stringBuilder, IDNA.Info info) {
        return this.process(charSequence, false, false, stringBuilder, info);
    }

    private static boolean isASCIIString(CharSequence charSequence) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (charSequence.charAt(i2) <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private StringBuilder process(CharSequence charSequence, boolean bl2, boolean bl3, StringBuilder stringBuilder, IDNA.Info info) {
        if (stringBuilder == charSequence) {
            throw new IllegalArgumentException();
        }
        stringBuilder.delete(0, Integer.MAX_VALUE);
        UTS46.resetInfo(info);
        int n2 = charSequence.length();
        if (n2 == 0) {
            UTS46.addError(info, IDNA.Error.EMPTY_LABEL);
            return stringBuilder;
        }
        boolean bl4 = (this.options & 2) != 0;
        int n3 = 0;
        int n4 = 0;
        while (true) {
            if (n4 == n2) {
                if (bl3) {
                    if (n4 - n3 > 63) {
                        UTS46.addLabelError(info, IDNA.Error.LABEL_TOO_LONG);
                    }
                    if (!(bl2 || n4 < 254 || n4 <= 254 && n3 >= n4)) {
                        UTS46.addError(info, IDNA.Error.DOMAIN_NAME_TOO_LONG);
                    }
                }
                UTS46.promoteAndResetLabelErrors(info);
                return stringBuilder;
            }
            char c2 = charSequence.charAt(n4);
            if (c2 > '\u007f') break;
            byte by2 = asciiData[c2];
            if (by2 > 0) {
                stringBuilder.append((char)(c2 + 32));
            } else {
                if (by2 < 0 && bl4) break;
                stringBuilder.append(c2);
                if (c2 == '-') {
                    if (n4 == n3 + 3 && charSequence.charAt(n4 - 1) == '-') {
                        ++n4;
                        break;
                    }
                    if (n4 == n3) {
                        UTS46.addLabelError(info, IDNA.Error.LEADING_HYPHEN);
                    }
                    if (n4 + 1 == n2 || charSequence.charAt(n4 + 1) == '.') {
                        UTS46.addLabelError(info, IDNA.Error.TRAILING_HYPHEN);
                    }
                } else if (c2 == '.') {
                    if (bl2) {
                        ++n4;
                        break;
                    }
                    if (n4 == n3) {
                        UTS46.addLabelError(info, IDNA.Error.EMPTY_LABEL);
                    }
                    if (bl3 && n4 - n3 > 63) {
                        UTS46.addLabelError(info, IDNA.Error.LABEL_TOO_LONG);
                    }
                    UTS46.promoteAndResetLabelErrors(info);
                    n3 = n4 + 1;
                }
            }
            ++n4;
        }
        UTS46.promoteAndResetLabelErrors(info);
        this.processUnicode(charSequence, n3, n4, bl2, bl3, stringBuilder, info);
        if (UTS46.isBiDi(info) && !UTS46.hasCertainErrors(info, severeErrors) && (!UTS46.isOkBiDi(info) || n3 > 0 && !UTS46.isASCIIOkBiDi(stringBuilder, n3))) {
            UTS46.addError(info, IDNA.Error.BIDI);
        }
        return stringBuilder;
    }

    private StringBuilder processUnicode(CharSequence charSequence, int n2, int n3, boolean bl2, boolean bl3, StringBuilder stringBuilder, IDNA.Info info) {
        if (n3 == 0) {
            uts46Norm2.normalize(charSequence, stringBuilder);
        } else {
            uts46Norm2.normalizeSecondAndAppend(stringBuilder, charSequence.subSequence(n3, charSequence.length()));
        }
        boolean bl4 = bl3 ? (this.options & 0x10) == 0 : (this.options & 0x20) == 0;
        int n4 = stringBuilder.length();
        int n5 = n2;
        while (n5 < n4) {
            char c2 = stringBuilder.charAt(n5);
            if (c2 == '.' && !bl2) {
                int n6 = n5 - n2;
                int n7 = this.processLabel(stringBuilder, n2, n6, bl3, info);
                UTS46.promoteAndResetLabelErrors(info);
                n4 += n7 - n6;
                n5 = n2 += n7 + 1;
                continue;
            }
            if (c2 >= '\u00df') {
                if (c2 <= '\u200d' && (c2 == '\u00df' || c2 == '\u03c2' || c2 >= '\u200c')) {
                    UTS46.setTransitionalDifferent(info);
                    if (bl4) {
                        n4 = this.mapDevChars(stringBuilder, n2, n5);
                        bl4 = false;
                        continue;
                    }
                } else if (Character.isSurrogate(c2) && (Normalizer2Impl.UTF16Plus.isSurrogateLead(c2) ? n5 + 1 == n4 || !Character.isLowSurrogate(stringBuilder.charAt(n5 + 1)) : n5 == n2 || !Character.isHighSurrogate(stringBuilder.charAt(n5 - 1)))) {
                    UTS46.addLabelError(info, IDNA.Error.DISALLOWED);
                    stringBuilder.setCharAt(n5, '\ufffd');
                }
            }
            ++n5;
        }
        if (0 == n2 || n2 < n5) {
            this.processLabel(stringBuilder, n2, n5 - n2, bl3, info);
            UTS46.promoteAndResetLabelErrors(info);
        }
        return stringBuilder;
    }

    private int mapDevChars(StringBuilder stringBuilder, int n2, int n3) {
        int n4 = stringBuilder.length();
        boolean bl2 = false;
        int n5 = n3;
        block5: while (n5 < n4) {
            char c2 = stringBuilder.charAt(n5);
            switch (c2) {
                case '\u00df': {
                    bl2 = true;
                    stringBuilder.setCharAt(n5++, 's');
                    stringBuilder.insert(n5++, 's');
                    ++n4;
                    continue block5;
                }
                case '\u03c2': {
                    bl2 = true;
                    stringBuilder.setCharAt(n5++, '\u03c3');
                    continue block5;
                }
                case '\u200c': 
                case '\u200d': {
                    bl2 = true;
                    stringBuilder.delete(n5, n5 + 1);
                    --n4;
                    continue block5;
                }
            }
            ++n5;
        }
        if (bl2) {
            String string = uts46Norm2.normalize(stringBuilder.subSequence(n2, stringBuilder.length()));
            stringBuilder.replace(n2, Integer.MAX_VALUE, string);
            return stringBuilder.length();
        }
        return n4;
    }

    private static int replaceLabel(StringBuilder stringBuilder, int n2, int n3, CharSequence charSequence, int n4) {
        if (charSequence != stringBuilder) {
            stringBuilder.delete(n2, n2 + n3).insert(n2, charSequence);
        }
        return n4;
    }

    private int processLabel(StringBuilder stringBuilder, int n2, int n3, boolean bl2, IDNA.Info info) {
        int n4;
        boolean bl3;
        StringBuilder stringBuilder2;
        int n5;
        boolean bl4;
        int n6 = n2;
        int n7 = n3;
        if (n3 >= 4 && stringBuilder.charAt(n2) == 'x' && stringBuilder.charAt(n2 + 1) == 'n' && stringBuilder.charAt(n2 + 2) == '-' && stringBuilder.charAt(n2 + 3) == '-') {
            StringBuilder stringBuilder3;
            if (n3 == 4 || n3 > 5 && stringBuilder.charAt(n2 + n3 - 1) == '-') {
                UTS46.addLabelError(info, IDNA.Error.INVALID_ACE_LABEL);
                return this.markBadACELabel(stringBuilder, n2, n3, bl2, info);
            }
            bl4 = true;
            try {
                stringBuilder3 = Punycode.decode(stringBuilder.subSequence(n2 + 4, n2 + n3), null);
            }
            catch (StringPrepParseException stringPrepParseException) {
                UTS46.addLabelError(info, IDNA.Error.PUNYCODE);
                return this.markBadACELabel(stringBuilder, n2, n3, bl2, info);
            }
            n5 = uts46Norm2.isNormalized(stringBuilder3) ? 1 : 0;
            if (n5 == 0) {
                UTS46.addLabelError(info, IDNA.Error.INVALID_ACE_LABEL);
                return this.markBadACELabel(stringBuilder, n2, n3, bl2, info);
            }
            stringBuilder2 = stringBuilder3;
            n2 = 0;
            n3 = stringBuilder3.length();
        } else {
            bl4 = false;
            stringBuilder2 = stringBuilder;
        }
        if (n3 == 0) {
            UTS46.addLabelError(info, IDNA.Error.EMPTY_LABEL);
            return UTS46.replaceLabel(stringBuilder, n6, n7, stringBuilder2, n3);
        }
        if (n3 >= 4 && stringBuilder2.charAt(n2 + 2) == '-' && stringBuilder2.charAt(n2 + 3) == '-') {
            UTS46.addLabelError(info, IDNA.Error.HYPHEN_3_4);
        }
        if (stringBuilder2.charAt(n2) == '-') {
            UTS46.addLabelError(info, IDNA.Error.LEADING_HYPHEN);
        }
        if (stringBuilder2.charAt(n2 + n3 - 1) == '-') {
            UTS46.addLabelError(info, IDNA.Error.TRAILING_HYPHEN);
        }
        n5 = n2;
        int n8 = n2 + n3;
        char c2 = '\u0000';
        boolean bl5 = bl3 = (this.options & 2) != 0;
        do {
            if ((n4 = stringBuilder2.charAt(n5)) <= 127) {
                if (n4 == 46) {
                    UTS46.addLabelError(info, IDNA.Error.LABEL_HAS_DOT);
                    stringBuilder2.setCharAt(n5, '\ufffd');
                    continue;
                }
                if (!bl3 || asciiData[n4] >= 0) continue;
                UTS46.addLabelError(info, IDNA.Error.DISALLOWED);
                stringBuilder2.setCharAt(n5, '\ufffd');
                continue;
            }
            c2 = (char)(c2 | n4);
            if (n4 != 65533) continue;
            UTS46.addLabelError(info, IDNA.Error.DISALLOWED);
        } while (++n5 < n8);
        n4 = stringBuilder2.codePointAt(n2);
        if ((UTS46.U_GET_GC_MASK(n4) & U_GC_M_MASK) != 0) {
            UTS46.addLabelError(info, IDNA.Error.LEADING_COMBINING_MARK);
            stringBuilder2.setCharAt(n2, '\ufffd');
            if (n4 > 65535) {
                stringBuilder2.deleteCharAt(n2 + 1);
                --n3;
                if (stringBuilder2 == stringBuilder) {
                    --n7;
                }
            }
        }
        if (!UTS46.hasCertainLabelErrors(info, severeErrors)) {
            if ((this.options & 4) != 0 && (!UTS46.isBiDi(info) || UTS46.isOkBiDi(info))) {
                this.checkLabelBiDi(stringBuilder2, n2, n3, info);
            }
            if ((this.options & 8) != 0 && (c2 & 0x200C) == 8204 && !this.isLabelOkContextJ(stringBuilder2, n2, n3)) {
                UTS46.addLabelError(info, IDNA.Error.CONTEXTJ);
            }
            if ((this.options & 0x40) != 0 && c2 >= '\u00b7') {
                this.checkLabelContextO(stringBuilder2, n2, n3, info);
            }
            if (bl2) {
                if (bl4) {
                    if (n7 > 63) {
                        UTS46.addLabelError(info, IDNA.Error.LABEL_TOO_LONG);
                    }
                    return n7;
                }
                if (c2 >= '\u0080') {
                    StringBuilder stringBuilder4;
                    try {
                        stringBuilder4 = Punycode.encode(stringBuilder2.subSequence(n2, n2 + n3), null);
                    }
                    catch (StringPrepParseException stringPrepParseException) {
                        throw new ICUException(stringPrepParseException);
                    }
                    stringBuilder4.insert(0, "xn--");
                    if (stringBuilder4.length() > 63) {
                        UTS46.addLabelError(info, IDNA.Error.LABEL_TOO_LONG);
                    }
                    return UTS46.replaceLabel(stringBuilder, n6, n7, stringBuilder4, stringBuilder4.length());
                }
                if (n3 > 63) {
                    UTS46.addLabelError(info, IDNA.Error.LABEL_TOO_LONG);
                }
            }
        } else if (bl4) {
            UTS46.addLabelError(info, IDNA.Error.INVALID_ACE_LABEL);
            return this.markBadACELabel(stringBuilder, n6, n7, bl2, info);
        }
        return UTS46.replaceLabel(stringBuilder, n6, n7, stringBuilder2, n3);
    }

    private int markBadACELabel(StringBuilder stringBuilder, int n2, int n3, boolean bl2, IDNA.Info info) {
        boolean bl3 = (this.options & 2) != 0;
        boolean bl4 = true;
        boolean bl5 = true;
        int n4 = n2 + n3;
        for (int i2 = n2 + 4; i2 < n4; ++i2) {
            char c2 = stringBuilder.charAt(i2);
            if (c2 <= '\u007f') {
                if (c2 == '.') {
                    UTS46.addLabelError(info, IDNA.Error.LABEL_HAS_DOT);
                    stringBuilder.setCharAt(i2, '\ufffd');
                    bl5 = false;
                    bl4 = false;
                    continue;
                }
                if (asciiData[c2] >= 0) continue;
                bl5 = false;
                if (!bl3) continue;
                stringBuilder.setCharAt(i2, '\ufffd');
                bl4 = false;
                continue;
            }
            bl5 = false;
            bl4 = false;
        }
        if (bl5) {
            stringBuilder.insert(n2 + n3, '\ufffd');
            ++n3;
        } else if (bl2 && bl4 && n3 > 63) {
            UTS46.addLabelError(info, IDNA.Error.LABEL_TOO_LONG);
        }
        return n3;
    }

    private void checkLabelBiDi(CharSequence charSequence, int n2, int n3, IDNA.Info info) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        block11: {
            n9 = n2;
            n8 = Character.codePointAt(charSequence, n9);
            n9 += Character.charCount(n8);
            n7 = UTS46.U_MASK(UBiDiProps.INSTANCE.getClass(n8));
            if ((n7 & ~L_R_AL_MASK) != 0) {
                UTS46.setNotOkBiDi(info);
            }
            n6 = n2 + n3;
            do {
                if (n9 >= n6) {
                    n4 = n7;
                    break block11;
                }
                n8 = Character.codePointBefore(charSequence, n6);
                n6 -= Character.charCount(n8);
            } while ((n5 = UBiDiProps.INSTANCE.getClass(n8)) == 17);
            n4 = UTS46.U_MASK(n5);
        }
        if ((n7 & L_MASK) != 0 ? (n4 & ~L_EN_MASK) != 0 : (n4 & ~R_AL_EN_AN_MASK) != 0) {
            UTS46.setNotOkBiDi(info);
        }
        n5 = n7 | n4;
        while (n9 < n6) {
            n8 = Character.codePointAt(charSequence, n9);
            n9 += Character.charCount(n8);
            n5 |= UTS46.U_MASK(UBiDiProps.INSTANCE.getClass(n8));
        }
        if ((n7 & L_MASK) != 0) {
            if ((n5 & ~L_EN_ES_CS_ET_ON_BN_NSM_MASK) != 0) {
                UTS46.setNotOkBiDi(info);
            }
        } else {
            if ((n5 & ~R_AL_AN_EN_ES_CS_ET_ON_BN_NSM_MASK) != 0) {
                UTS46.setNotOkBiDi(info);
            }
            if ((n5 & EN_AN_MASK) == EN_AN_MASK) {
                UTS46.setNotOkBiDi(info);
            }
        }
        if ((n5 & R_AL_AN_MASK) != 0) {
            UTS46.setBiDi(info);
        }
    }

    private static boolean isASCIIOkBiDi(CharSequence charSequence, int n2) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = charSequence.charAt(i2);
            if (c2 == '.') {
                if (!(i2 <= n3 || 'a' <= (c2 = charSequence.charAt(i2 - 1)) && c2 <= 'z' || '0' <= c2 && c2 <= '9')) {
                    return false;
                }
                n3 = i2 + 1;
                continue;
            }
            if (!(i2 == n3 ? 'a' > c2 || c2 > 'z' : c2 <= ' ' && (c2 >= '\u001c' || '\t' <= c2 && c2 <= '\r'))) continue;
            return false;
        }
        return true;
    }

    private boolean isLabelOkContextJ(CharSequence charSequence, int n2, int n3) {
        int n4 = n2 + n3;
        for (int i2 = n2; i2 < n4; ++i2) {
            int n5;
            if (charSequence.charAt(i2) == '\u200c') {
                int n6;
                if (i2 == n2) {
                    return false;
                }
                int n7 = i2;
                n5 = Character.codePointBefore(charSequence, n7);
                n7 -= Character.charCount(n5);
                if (uts46Norm2.getCombiningClass(n5) == 9) continue;
                while ((n6 = UBiDiProps.INSTANCE.getJoiningType(n5)) == 5) {
                    if (n7 == 0) {
                        return false;
                    }
                    n5 = Character.codePointBefore(charSequence, n7);
                    n7 -= Character.charCount(n5);
                }
                if (n6 != 3 && n6 != 2) {
                    return false;
                }
                n7 = i2 + 1;
                do {
                    if (n7 == n4) {
                        return false;
                    }
                    n5 = Character.codePointAt(charSequence, n7);
                    n7 += Character.charCount(n5);
                } while ((n6 = UBiDiProps.INSTANCE.getJoiningType(n5)) == 5);
                if (n6 == 4 || n6 == 2) continue;
                return false;
            }
            if (charSequence.charAt(i2) != '\u200d') continue;
            if (i2 == n2) {
                return false;
            }
            n5 = Character.codePointBefore(charSequence, i2);
            if (uts46Norm2.getCombiningClass(n5) == 9) continue;
            return false;
        }
        return true;
    }

    private void checkLabelContextO(CharSequence charSequence, int n2, int n3, IDNA.Info info) {
        int n4 = n2 + n3 - 1;
        int n5 = 0;
        block0: for (int i2 = n2; i2 <= n4; ++i2) {
            int n6 = charSequence.charAt(i2);
            if (n6 < 183) continue;
            if (n6 <= 1785) {
                if (n6 == 183) {
                    if (n2 < i2 && charSequence.charAt(i2 - 1) == 'l' && i2 < n4 && charSequence.charAt(i2 + 1) == 'l') continue;
                    UTS46.addLabelError(info, IDNA.Error.CONTEXTO_PUNCTUATION);
                    continue;
                }
                if (n6 == 885) {
                    if (i2 < n4 && 14 == UScript.getScript(Character.codePointAt(charSequence, i2 + 1))) continue;
                    UTS46.addLabelError(info, IDNA.Error.CONTEXTO_PUNCTUATION);
                    continue;
                }
                if (n6 == 1523 || n6 == 1524) {
                    if (n2 < i2 && 19 == UScript.getScript(Character.codePointBefore(charSequence, i2))) continue;
                    UTS46.addLabelError(info, IDNA.Error.CONTEXTO_PUNCTUATION);
                    continue;
                }
                if (1632 > n6) continue;
                if (n6 <= 1641) {
                    if (n5 > 0) {
                        UTS46.addLabelError(info, IDNA.Error.CONTEXTO_DIGITS);
                    }
                    n5 = -1;
                    continue;
                }
                if (1776 > n6) continue;
                if (n5 < 0) {
                    UTS46.addLabelError(info, IDNA.Error.CONTEXTO_DIGITS);
                }
                n5 = 1;
                continue;
            }
            if (n6 != 12539) continue;
            int n7 = n2;
            while (true) {
                if (n7 > n4) {
                    UTS46.addLabelError(info, IDNA.Error.CONTEXTO_PUNCTUATION);
                    continue block0;
                }
                n6 = Character.codePointAt(charSequence, n7);
                int n8 = UScript.getScript(n6);
                if (n8 == 20 || n8 == 22 || n8 == 17) continue block0;
                n7 += Character.charCount(n6);
            }
        }
    }

    private static int U_MASK(int n2) {
        return 1 << n2;
    }

    private static int U_GET_GC_MASK(int n2) {
        return 1 << UCharacter.getType(n2);
    }
}

