/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.db2.externals.com.ibm.icu.impl;

public final class USerializedSet {
    private char[] array = new char[8];
    private int arrayOffset;
    private int bmpLength;
    private int length;

    public final boolean getSet(char[] cArray, int n2) {
        this.array = null;
        this.length = 0;
        this.bmpLength = 0;
        this.arrayOffset = 0;
        this.length = cArray[n2++];
        if ((this.length & 0x8000) != 0) {
            this.length &= Short.MAX_VALUE;
            if (cArray.length < n2 + 1 + this.length) {
                this.length = 0;
                throw new IndexOutOfBoundsException();
            }
            this.bmpLength = cArray[n2++];
        } else {
            if (cArray.length < n2 + this.length) {
                this.length = 0;
                throw new IndexOutOfBoundsException();
            }
            this.bmpLength = this.length;
        }
        this.array = new char[this.length];
        System.arraycopy(cArray, n2, this.array, 0, this.length);
        return true;
    }

    public final void setToOne(int n2) {
        if (0x10FFFF < n2) {
            return;
        }
        if (n2 < 65535) {
            this.length = 2;
            this.bmpLength = 2;
            this.array[0] = (char)n2;
            this.array[1] = (char)(n2 + 1);
        } else if (n2 == 65535) {
            this.bmpLength = 1;
            this.length = 3;
            this.array[0] = 65535;
            this.array[1] = '\u0001';
            this.array[2] = '\u0000';
        } else if (n2 < 0x10FFFF) {
            this.bmpLength = 0;
            this.length = 4;
            this.array[0] = (char)(n2 >> 16);
            this.array[1] = (char)n2;
            this.array[2] = (char)(++n2 >> 16);
            this.array[3] = (char)n2;
        } else {
            this.bmpLength = 0;
            this.length = 2;
            this.array[0] = 16;
            this.array[1] = 65535;
        }
    }

    public final boolean getRange(int n2, int[] nArray) {
        if (n2 < 0) {
            return false;
        }
        if (this.array == null) {
            this.array = new char[8];
        }
        if (nArray == null || nArray.length < 2) {
            throw new IllegalArgumentException();
        }
        if ((n2 *= 2) < this.bmpLength) {
            nArray[0] = this.array[n2++];
            nArray[1] = n2 < this.bmpLength ? this.array[n2] - '\u0001' : (n2 < this.length ? (this.array[n2] << 16 | this.array[n2 + 1]) - 1 : 0x10FFFF);
            return true;
        }
        n2 -= this.bmpLength;
        int n3 = this.length - this.bmpLength;
        if ((n2 *= 2) < n3) {
            int n4 = this.arrayOffset + this.bmpLength;
            nArray[0] = this.array[n4 + n2] << 16 | this.array[n4 + n2 + 1];
            nArray[1] = (n2 += 2) < n3 ? (this.array[n4 + n2] << 16 | this.array[n4 + n2 + 1]) - 1 : 0x10FFFF;
            return true;
        }
        return false;
    }

    public final boolean contains(int n2) {
        int n3;
        if (n2 > 0x10FFFF) {
            return false;
        }
        if (n2 <= 65535) {
            int n4;
            for (n4 = 0; n4 < this.bmpLength && (char)n2 >= this.array[n4]; ++n4) {
            }
            return (n4 & 1) != 0;
        }
        char c2 = (char)(n2 >> 16);
        char c3 = (char)n2;
        for (n3 = this.bmpLength; n3 < this.length && (c2 > this.array[n3] || c2 == this.array[n3] && c3 >= this.array[n3 + 1]); n3 += 2) {
        }
        return (n3 + this.bmpLength & 2) != 0;
    }

    public final int countRanges() {
        return (this.bmpLength + (this.length - this.bmpLength) / 2 + 1) / 2;
    }
}

